#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2019 BetaRays <array@dotslashplay.it>
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Tooth and Tail
# send your bug reports to bugs@dotslashplay.it
###

script_version=20251019.3

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='tooth-and-tail'
GAME_NAME='Tooth and Tail'

## This DRM-free archive is no longer available for sale from Humble Bundle.
ARCHIVE_BASE_0_NAME='toothandtail_linux.zip'
ARCHIVE_BASE_0_MD5='5a01a61889e795b538d3db288a6f519d'
ARCHIVE_BASE_0_VERSION='1.6.1.1-humble1'
ARCHIVE_BASE_0_SIZE='586332'

CONTENT_PATH_DEFAULT='Release'
CONTENT_LIBS_LIBS_FILES='
libfmod.so.10
libfmodstudio.so.10
libmojoshader.so
libtheorafile.so'
CONTENT_LIBS_LIBS64_RELATIVE_PATH='lib64'
CONTENT_LIBS_LIBS64_FILES="$CONTENT_LIBS_LIBS_FILES"
CONTENT_LIBS_LIBS32_RELATIVE_PATH='lib'
CONTENT_LIBS_LIBS32_FILES="$CONTENT_LIBS_LIBS_FILES"
CONTENT_GAME_MAIN_FILES='
content
ToothAndTail.exe
ToothAndTail.exe.config
fr/ToothAndTail.resources.dll
FNA.dll
FNA.dll.config
Glide.dll
Newtonsoft.Json.dll'

APP_MAIN_EXE='ToothAndTail.exe'
APP_MAIN_ICON='ToothAndTail.exe'

PACKAGES_LIST='
PKG_MAIN
PKG_LIBS64
PKG_LIBS32'

PKG_MAIN_DEPENDENCIES_SIBLINGS='
PKG_LIBS'
PKG_MAIN_DEPENDENCIES_LIBRARIES='
libopenal.so.1
libSDL2-2.0.so.0
libSDL2_image-2.0.so.0'
PKG_MAIN_DEPENDENCIES_MONO_LIBRARIES='
mscorlib.dll
Mono.Posix.dll
Mono.Security.dll
System.dll
System.Configuration.dll
System.Core.dll
System.Data.dll
System.Drawing.dll
System.Net.dll
System.Net.Http.dll
System.Runtime.Serialization.dll
System.Security.dll
System.Windows.Forms.dll
System.Xml.dll
System.Xml.Linq.dll'

PKG_LIBS_ID="${GAME_ID}-libs"
PKG_LIBS64_ARCH='64'
PKG_LIBS32_ARCH='32'
PKG_LIBS_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libm.so.6
libogg.so.0
libpthread.so.0
librt.so.1
libstdc++.so.6
libtheoradec.so.1
libvorbis.so.0'

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Extract game data.

archive_extraction_default

# Include game data.

content_inclusion_icons
content_inclusion_default

# Write launchers.

## Some shipped libraries expect an executable stack.
game_exec_line() {
	cat <<- 'EOF'
	GLIBC_TUNABLES=glibc.rtld.execstack=2 mono ToothAndTail.exe "$@"
	EOF
}

launchers_generation

# Build packages.

packages_generation
print_instructions

# Clean up.

working_directory_cleanup

exit 0
