/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.smithwaterman;

import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import java.util.ArrayList;
import java.util.LinkedList;
import org.broadinstitute.gatk.utils.Utils;
import org.broadinstitute.gatk.utils.sam.AlignmentUtils;
import org.broadinstitute.gatk.utils.smithwaterman.Parameters;
import org.broadinstitute.gatk.utils.smithwaterman.SWPairwiseAlignment;
import org.broadinstitute.gatk.utils.smithwaterman.SWParameterSet;

public final class GlobalEdgeGreedySWPairwiseAlignment
extends SWPairwiseAlignment {
    private static final boolean DEBUG_MODE = false;

    public GlobalEdgeGreedySWPairwiseAlignment(byte[] reference, byte[] alternate, Parameters parameters) {
        super(reference, alternate, parameters);
    }

    public GlobalEdgeGreedySWPairwiseAlignment(byte[] reference, byte[] alternate, SWParameterSet namedParameters) {
        this(reference, alternate, namedParameters.parameters);
    }

    public GlobalEdgeGreedySWPairwiseAlignment(byte[] reference, byte[] alternate) {
        this(reference, alternate, SWParameterSet.ORIGINAL_DEFAULT);
    }

    @Override
    protected void align(byte[] reference, byte[] alternate) {
        if (reference == null || reference.length == 0) {
            throw new IllegalArgumentException("Non-null, non-empty reference sequences are required for the Smith-Waterman calculation");
        }
        if (alternate == null || alternate.length == 0) {
            throw new IllegalArgumentException("Non-null, non-empty alternate sequences are required for the Smith-Waterman calculation");
        }
        int forwardEdgeMatch = Utils.longestCommonPrefix(reference, alternate, Integer.MAX_VALUE);
        if (forwardEdgeMatch == reference.length || forwardEdgeMatch == alternate.length) {
            this.alignmentResult = new SWPairwiseAlignment.SWPairwiseAlignmentResult(this, this.makeCigarForStrictPrefixAndSuffix(reference, alternate, forwardEdgeMatch, 0), 0);
            return;
        }
        int reverseEdgeMatch = Utils.longestCommonSuffix(reference, alternate, Integer.MAX_VALUE);
        if (reverseEdgeMatch == reference.length || reverseEdgeMatch == alternate.length) {
            this.alignmentResult = new SWPairwiseAlignment.SWPairwiseAlignmentResult(this, this.makeCigarForStrictPrefixAndSuffix(reference, alternate, 0, reverseEdgeMatch), 0);
            return;
        }
        int sizeOfRefToAlign = reference.length - forwardEdgeMatch - reverseEdgeMatch;
        int sizeOfAltToAlign = alternate.length - forwardEdgeMatch - reverseEdgeMatch;
        int minSizeToAlign = Math.min(sizeOfRefToAlign, sizeOfAltToAlign);
        if (minSizeToAlign < 0) {
            reverseEdgeMatch += minSizeToAlign;
        }
        if (sizeOfRefToAlign <= 0 || sizeOfAltToAlign <= 0) {
            this.alignmentResult = new SWPairwiseAlignment.SWPairwiseAlignmentResult(this, this.makeCigarForStrictPrefixAndSuffix(reference, alternate, forwardEdgeMatch, reverseEdgeMatch), 0);
            return;
        }
        byte[] refToAlign = Utils.trimArray(reference, forwardEdgeMatch, reverseEdgeMatch);
        byte[] altToAlign = Utils.trimArray(alternate, forwardEdgeMatch, reverseEdgeMatch);
        int[][] sw = new int[sizeOfRefToAlign + 1][sizeOfAltToAlign + 1];
        if (keepScoringMatrix) {
            this.SW = sw;
        }
        int[][] btrack = new int[sizeOfRefToAlign + 1][sizeOfAltToAlign + 1];
        this.calculateMatrix(refToAlign, altToAlign, sw, btrack, SWPairwiseAlignment.OVERHANG_STRATEGY.INDEL);
        this.alignmentResult = this.calculateCigar(forwardEdgeMatch, reverseEdgeMatch, sw, btrack);
    }

    private void debugMatrix(int[][] matrix) {
        for (int i = 0; i < matrix.length; ++i) {
            int[] cur = matrix[i];
            for (int j = 0; j < cur.length; ++j) {
                System.out.print(cur[j] + " ");
            }
            System.out.println();
        }
    }

    private Cigar makeCigarForStrictPrefixAndSuffix(byte[] reference, byte[] alternate, int matchingPrefix, int matchingSuffix) {
        ArrayList<CigarElement> result = new ArrayList<CigarElement>();
        if (reference.length == alternate.length) {
            result.add(this.makeElement(SWPairwiseAlignment.State.MATCH, matchingPrefix + matchingSuffix));
        } else {
            if (matchingPrefix > 0) {
                result.add(this.makeElement(SWPairwiseAlignment.State.MATCH, matchingPrefix));
            }
            if (alternate.length > reference.length) {
                result.add(this.makeElement(SWPairwiseAlignment.State.INSERTION, alternate.length - reference.length));
            } else {
                result.add(this.makeElement(SWPairwiseAlignment.State.DELETION, reference.length - alternate.length));
            }
            if (matchingSuffix > 0) {
                result.add(this.makeElement(SWPairwiseAlignment.State.MATCH, matchingSuffix));
            }
        }
        return new Cigar(result);
    }

    protected SWPairwiseAlignment.SWPairwiseAlignmentResult calculateCigar(int matchingPrefix, int matchingSuffix, int[][] sw, int[][] btrack) {
        SWPairwiseAlignment.SWPairwiseAlignmentResult SW_result = this.calculateCigar(sw, btrack, SWPairwiseAlignment.OVERHANG_STRATEGY.INDEL);
        LinkedList<CigarElement> lce = new LinkedList<CigarElement>(SW_result.cigar.getCigarElements());
        if (matchingPrefix > 0) {
            lce.addFirst(this.makeElement(SWPairwiseAlignment.State.MATCH, matchingPrefix));
        }
        if (matchingSuffix > 0) {
            lce.addLast(this.makeElement(SWPairwiseAlignment.State.MATCH, matchingSuffix));
        }
        return new SWPairwiseAlignment.SWPairwiseAlignmentResult(this, AlignmentUtils.consolidateCigar(new Cigar(lce)), 0);
    }
}

