/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import proguard.classfile.Clazz;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.DoubleConstant;
import proguard.classfile.constant.FieldrefConstant;
import proguard.classfile.constant.FloatConstant;
import proguard.classfile.constant.IntegerConstant;
import proguard.classfile.constant.InterfaceMethodrefConstant;
import proguard.classfile.constant.InvokeDynamicConstant;
import proguard.classfile.constant.LongConstant;
import proguard.classfile.constant.MethodHandleConstant;
import proguard.classfile.constant.MethodTypeConstant;
import proguard.classfile.constant.MethodrefConstant;
import proguard.classfile.constant.ModuleConstant;
import proguard.classfile.constant.NameAndTypeConstant;
import proguard.classfile.constant.PackageConstant;
import proguard.classfile.constant.PrimitiveArrayConstant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.Utf8Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.util.SimplifiedVisitor;

public class WildcardConstantFilter
implements ConstantVisitor {
    private static final int WILDCARD = 0x40000000;
    private final ConstantVisitor constantVisitor;
    private final MyWildcardChecker wildcardChecker = new MyWildcardChecker();

    public WildcardConstantFilter(ConstantVisitor constantVisitor) {
        this.constantVisitor = constantVisitor;
    }

    @Override
    public void visitIntegerConstant(Clazz clazz, IntegerConstant integerConstant) {
        this.constantVisitor.visitIntegerConstant(clazz, integerConstant);
    }

    @Override
    public void visitLongConstant(Clazz clazz, LongConstant longConstant) {
        this.constantVisitor.visitLongConstant(clazz, longConstant);
    }

    @Override
    public void visitFloatConstant(Clazz clazz, FloatConstant floatConstant) {
        this.constantVisitor.visitFloatConstant(clazz, floatConstant);
    }

    @Override
    public void visitDoubleConstant(Clazz clazz, DoubleConstant doubleConstant) {
        this.constantVisitor.visitDoubleConstant(clazz, doubleConstant);
    }

    @Override
    public void visitPrimitiveArrayConstant(Clazz clazz, PrimitiveArrayConstant primitiveArrayConstant) {
        this.constantVisitor.visitPrimitiveArrayConstant(clazz, primitiveArrayConstant);
    }

    @Override
    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        if (!this.containsWildcard(clazz, stringConstant)) {
            this.constantVisitor.visitStringConstant(clazz, stringConstant);
        }
    }

    @Override
    public void visitUtf8Constant(Clazz clazz, Utf8Constant utf8Constant) {
        this.constantVisitor.visitUtf8Constant(clazz, utf8Constant);
    }

    @Override
    public void visitInvokeDynamicConstant(Clazz clazz, InvokeDynamicConstant invokeDynamicConstant) {
        if (!this.containsWildcard(clazz, invokeDynamicConstant)) {
            this.constantVisitor.visitInvokeDynamicConstant(clazz, invokeDynamicConstant);
        }
    }

    @Override
    public void visitMethodHandleConstant(Clazz clazz, MethodHandleConstant methodHandleConstant) {
        this.constantVisitor.visitMethodHandleConstant(clazz, methodHandleConstant);
    }

    @Override
    public void visitFieldrefConstant(Clazz clazz, FieldrefConstant fieldrefConstant) {
        if (!this.containsWildcard(clazz, fieldrefConstant)) {
            this.constantVisitor.visitFieldrefConstant(clazz, fieldrefConstant);
        }
    }

    @Override
    public void visitInterfaceMethodrefConstant(Clazz clazz, InterfaceMethodrefConstant interfaceMethodrefConstant) {
        if (!this.containsWildcard(clazz, interfaceMethodrefConstant)) {
            this.constantVisitor.visitInterfaceMethodrefConstant(clazz, interfaceMethodrefConstant);
        }
    }

    @Override
    public void visitMethodrefConstant(Clazz clazz, MethodrefConstant methodrefConstant) {
        if (!this.containsWildcard(clazz, methodrefConstant)) {
            this.constantVisitor.visitMethodrefConstant(clazz, methodrefConstant);
        }
    }

    @Override
    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        if (!this.containsWildcard(clazz, classConstant)) {
            this.constantVisitor.visitClassConstant(clazz, classConstant);
        }
    }

    @Override
    public void visitMethodTypeConstant(Clazz clazz, MethodTypeConstant methodTypeConstant) {
        if (!this.containsWildcard(clazz, methodTypeConstant)) {
            this.constantVisitor.visitMethodTypeConstant(clazz, methodTypeConstant);
        }
    }

    @Override
    public void visitNameAndTypeConstant(Clazz clazz, NameAndTypeConstant nameAndTypeConstant) {
        if (!this.containsWildcard(clazz, nameAndTypeConstant)) {
            this.constantVisitor.visitNameAndTypeConstant(clazz, nameAndTypeConstant);
        }
    }

    @Override
    public void visitModuleConstant(Clazz clazz, ModuleConstant moduleConstant) {
        if (!this.containsWildcard(clazz, moduleConstant)) {
            this.constantVisitor.visitModuleConstant(clazz, moduleConstant);
        }
    }

    @Override
    public void visitPackageConstant(Clazz clazz, PackageConstant packageConstant) {
        if (!this.containsWildcard(clazz, packageConstant)) {
            this.constantVisitor.visitPackageConstant(clazz, packageConstant);
        }
    }

    private boolean containsWildcard(Clazz clazz, Constant constant) {
        this.wildcardChecker.containsWildcard = false;
        constant.accept(clazz, this.wildcardChecker);
        return this.wildcardChecker.containsWildcard;
    }

    private static class MyWildcardChecker
    extends SimplifiedVisitor
    implements ConstantVisitor {
        public boolean containsWildcard;

        private MyWildcardChecker() {
        }

        @Override
        public void visitAnyConstant(Clazz clazz, Constant constant) {
        }

        @Override
        public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
            if (stringConstant.u2stringIndex >= 0x40000000) {
                this.containsWildcard = true;
            }
        }

        @Override
        public void visitInvokeDynamicConstant(Clazz clazz, InvokeDynamicConstant invokeDynamicConstant) {
            if (invokeDynamicConstant.u2nameAndTypeIndex >= 0x40000000) {
                this.containsWildcard = true;
            } else {
                clazz.constantPoolEntryAccept(invokeDynamicConstant.u2nameAndTypeIndex, this);
            }
        }

        @Override
        public void visitAnyRefConstant(Clazz clazz, RefConstant refConstant) {
            if (refConstant.u2classIndex >= 0x40000000 || refConstant.u2nameAndTypeIndex >= 0x40000000) {
                this.containsWildcard = true;
            } else {
                clazz.constantPoolEntryAccept(refConstant.u2classIndex, this);
                clazz.constantPoolEntryAccept(refConstant.u2nameAndTypeIndex, this);
            }
        }

        @Override
        public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
            if (classConstant.u2nameIndex >= 0x40000000) {
                this.containsWildcard = true;
            }
        }

        @Override
        public void visitMethodTypeConstant(Clazz clazz, MethodTypeConstant methodTypeConstant) {
            if (methodTypeConstant.u2descriptorIndex >= 0x40000000) {
                this.containsWildcard = true;
            }
        }

        @Override
        public void visitNameAndTypeConstant(Clazz clazz, NameAndTypeConstant nameAndTypeConstant) {
            if (nameAndTypeConstant.u2nameIndex >= 0x40000000 || nameAndTypeConstant.u2descriptorIndex >= 0x40000000) {
                this.containsWildcard = true;
            }
        }

        @Override
        public void visitModuleConstant(Clazz clazz, ModuleConstant moduleConstant) {
            if (moduleConstant.u2nameIndex >= 0x40000000) {
                this.containsWildcard = true;
            }
        }

        @Override
        public void visitPackageConstant(Clazz clazz, PackageConstant packageConstant) {
            if (packageConstant.u2nameIndex >= 0x40000000) {
                this.containsWildcard = true;
            }
        }
    }
}

