/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.runtime;

import java.io.File;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.broadinstitute.gatk.utils.runtime.StreamLocation;

public class InputStreamSettings {
    private final EnumSet<StreamLocation> streamLocations = EnumSet.noneOf(StreamLocation.class);
    private byte[] inputBuffer;
    private File inputFile;

    public InputStreamSettings() {
    }

    public InputStreamSettings(String inputBuffer) {
        this.setInputBuffer(inputBuffer);
    }

    public InputStreamSettings(File inputFile) {
        this.setInputFile(inputFile);
    }

    public InputStreamSettings(byte[] inputBuffer, File inputFile) {
        this.setInputBuffer(inputBuffer);
        this.setInputFile(inputFile);
    }

    public Set<StreamLocation> getStreamLocations() {
        return Collections.unmodifiableSet(this.streamLocations);
    }

    public byte[] getInputBuffer() {
        return this.inputBuffer;
    }

    public void setInputBuffer(String inputBuffer) {
        if (inputBuffer == null) {
            throw new IllegalArgumentException("inputBuffer cannot be null");
        }
        this.streamLocations.add(StreamLocation.Buffer);
        this.inputBuffer = inputBuffer.getBytes();
    }

    public void setInputBuffer(byte[] inputBuffer) {
        if (inputBuffer == null) {
            throw new IllegalArgumentException("inputBuffer cannot be null");
        }
        this.streamLocations.add(StreamLocation.Buffer);
        this.inputBuffer = inputBuffer;
    }

    public void clearInputBuffer() {
        this.streamLocations.remove((Object)StreamLocation.Buffer);
        this.inputBuffer = null;
    }

    public File getInputFile() {
        return this.inputFile;
    }

    public void setInputFile(File inputFile) {
        if (inputFile == null) {
            throw new IllegalArgumentException("inputFile cannot be null");
        }
        this.streamLocations.add(StreamLocation.File);
        this.inputFile = inputFile;
    }

    public void clearInputFile() {
        this.streamLocations.remove((Object)StreamLocation.File);
        this.inputFile = null;
    }

    public void setInputStandard(boolean inputStandard) {
        if (inputStandard) {
            this.streamLocations.add(StreamLocation.Standard);
        } else {
            this.streamLocations.remove((Object)StreamLocation.Standard);
        }
    }
}

