/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.driver.JTreeLocation;
import org.fest.swing.driver.JTreeMatchingPathQuery;
import org.fest.swing.driver.JTreePathFinder;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;

final class JTreeNodeTextQuery {
    @RunsInEDT
    static String nodeText(final JTree tree, final int row, final JTreeLocation location, final JTreePathFinder pathFinder) {
        return GuiActionRunner.execute(new GuiQuery<String>(){

            @Override
            protected String executeInEDT() {
                TreePath matchingPath = location.pathFor(tree, row);
                return pathFinder.cellReader().valueAt(tree, matchingPath.getLastPathComponent());
            }
        });
    }

    @RunsInEDT
    static String nodeText(final JTree tree, final String path, final JTreePathFinder pathFinder) {
        return GuiActionRunner.execute(new GuiQuery<String>(){

            @Override
            protected String executeInEDT() {
                TreePath matchingPath = JTreeMatchingPathQuery.matchingPathWithRootIfInvisible(tree, path, pathFinder);
                return pathFinder.cellReader().valueAt(tree, matchingPath.getLastPathComponent());
            }
        });
    }

    private JTreeNodeTextQuery() {
    }
}

