#!/bin/sh

echo "srcdir: $srcdir"
echo "scanner: $WAYLAND_SCANNER"
echo "test_data_dir: $TEST_DATA_DIR"
echo "test_output_dir: $TEST_OUTPUT_DIR"
echo "pwd: $PWD"
echo "sed: $SED"

RETCODE=0

hard_fail() {
	echo "$@" "ERROR"
	exit 99
}

fail() {
	echo "$@" "FAIL"
	RETCODE=1
}

mkdir -p "$TEST_OUTPUT_DIR" || hard_fail "setup"

generate_and_compare() {
	echo
	echo "Testing $1 generation: $2 -> $3"

	"$WAYLAND_SCANNER" $1 < "$TEST_DATA_DIR/$2" > "$TEST_OUTPUT_DIR/$3" || \
		hard_fail "$2 -> $3"

	"$SED" -i -e 's/Generated by wayland-scanner [0-9.]*/SCANNER TEST/' \
		"$TEST_OUTPUT_DIR/$3" || hard_fail "$2 -> $3"

	diff -q "$TEST_DATA_DIR/$3" "$TEST_OUTPUT_DIR/$3" && \
		echo "$2 -> $3 PASS" || \
		fail "$2 -> $3"
}

generate_and_compare "code" "example.xml" "example-code.c"
generate_and_compare "client-header" "example.xml" "example-client.h"
generate_and_compare "server-header" "example.xml" "example-server.h"

generate_and_compare "code" "small.xml" "small-code.c"
generate_and_compare "client-header" "small.xml" "small-client.h"
generate_and_compare "server-header" "small.xml" "small-server.h"

generate_and_compare "-c code" "small.xml" "small-code-core.c"
generate_and_compare "-c client-header" "small.xml" "small-client-core.h"
generate_and_compare "-c server-header" "small.xml" "small-server-core.h"

# The existing "code" must produce result identical to "public-code"
generate_and_compare "code" "small.xml" "small-code.c"
generate_and_compare "public-code" "small.xml" "small-code.c"
generate_and_compare "private-code" "small.xml" "small-private-code.c"
exit $RETCODE
