/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.filechooser.FileFilter;
import org.jhotdraw.framework.Drawing;
import org.jhotdraw.util.StorableInput;
import org.jhotdraw.util.StorableOutput;
import org.jhotdraw.util.StorageFormat;

public class StandardStorageFormat
implements StorageFormat {
    private FileFilter myFileFilter;
    private String myFileExtension;
    private String myFileDescription;

    public StandardStorageFormat() {
        this.setFileExtension(this.createFileExtension());
        this.setFileDescription(this.createFileDescription());
        this.setFileFilter(this.createFileFilter());
    }

    protected String createFileExtension() {
        this.myFileExtension = "draw";
        return "draw";
    }

    public void setFileExtension(String string) {
        this.myFileExtension = string;
    }

    public String getFileExtension() {
        return this.myFileExtension;
    }

    public String createFileDescription() {
        return "Internal Format (" + this.getFileExtension() + ")";
    }

    public void setFileDescription(String string) {
        this.myFileDescription = string;
    }

    public String getFileDescription() {
        return this.myFileDescription;
    }

    protected FileFilter createFileFilter() {
        return new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                return file.getName().endsWith("." + StandardStorageFormat.this.getFileExtension());
            }

            public String getDescription() {
                return StandardStorageFormat.this.getFileDescription();
            }
        };
    }

    public void setFileFilter(FileFilter fileFilter) {
        this.myFileFilter = fileFilter;
    }

    public FileFilter getFileFilter() {
        return this.myFileFilter;
    }

    public boolean isRestoreFormat() {
        return true;
    }

    public boolean isStoreFormat() {
        return true;
    }

    public String store(String string, Drawing drawing) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(this.adjustFileName(string));
        StorableOutput storableOutput = new StorableOutput(fileOutputStream);
        storableOutput.writeStorable(drawing);
        storableOutput.close();
        return this.adjustFileName(string);
    }

    public Drawing restore(String string) throws IOException {
        if (!this.hasCorrectFileExtension(string)) {
            return null;
        }
        FileInputStream fileInputStream = new FileInputStream(string);
        StorableInput storableInput = new StorableInput(fileInputStream);
        return (Drawing)storableInput.readStorable();
    }

    public boolean equals(Object object) {
        if (object instanceof StandardStorageFormat) {
            return this.getFileExtension().equals(((StandardStorageFormat)object).getFileExtension());
        }
        return false;
    }

    protected String adjustFileName(String string) {
        if (!this.hasCorrectFileExtension(string)) {
            return string + "." + this.getFileExtension();
        }
        return string;
    }

    protected boolean hasCorrectFileExtension(String string) {
        return string.endsWith("." + this.getFileExtension());
    }
}

