/*
 * Decompiled with CFR 0.152.
 */
package com.wombatinvasion.pmwikidraw;

import Acme.JPM.Encoders.GifEncoder;
import com.eteks.filter.Web216ColorsFilter;
import com.wombatinvasion.pmwikidraw.ColorPaletteChangeAttributeCommand;
import com.wombatinvasion.pmwikidraw.CommandButton;
import com.wombatinvasion.pmwikidraw.PaletteCommandButton;
import com.wombatinvasion.pmwikidraw.PmWikiDrawSelectionTool;
import com.wombatinvasion.pmwikidraw.PmWikiDrawingConverter;
import com.wombatinvasion.pmwikidraw.PmWikiDrawingView;
import com.wombatinvasion.pmwikidraw.PmWikiLineStyles;
import com.wombatinvasion.pmwikidraw.PmWikiScribbleTool;
import com.wombatinvasion.pmwikidraw.PmWikiSource;
import com.wombatinvasion.pmwikidraw.ToggleQualityCommand;
import com.wombatinvasion.pmwikidraw.gui.SymbolPackageContainer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.MenuShortcut;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.FilteredImageSource;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import org.jhotdraw.application.DrawApplication;
import org.jhotdraw.contrib.CustomToolBar;
import org.jhotdraw.contrib.DiamondFigure;
import org.jhotdraw.contrib.PolygonTool;
import org.jhotdraw.contrib.SplitConnectionTool;
import org.jhotdraw.contrib.TextAreaFigure;
import org.jhotdraw.contrib.TextAreaTool;
import org.jhotdraw.contrib.TriangleFigure;
import org.jhotdraw.contrib.dnd.DragNDropTool;
import org.jhotdraw.contrib.dnd.JHDDropTargetListener;
import org.jhotdraw.figures.ConnectedTextTool;
import org.jhotdraw.figures.ElbowConnection;
import org.jhotdraw.figures.EllipseFigure;
import org.jhotdraw.figures.GroupCommand;
import org.jhotdraw.figures.InsertImageCommand;
import org.jhotdraw.figures.LineConnection;
import org.jhotdraw.figures.LineFigure;
import org.jhotdraw.figures.RectangleFigure;
import org.jhotdraw.figures.RoundRectangleFigure;
import org.jhotdraw.figures.TextFigure;
import org.jhotdraw.figures.TextTool;
import org.jhotdraw.figures.UngroupCommand;
import org.jhotdraw.framework.Drawing;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.FigureAttributeConstant;
import org.jhotdraw.framework.FigureSelectionListener;
import org.jhotdraw.framework.JHotDrawRuntimeException;
import org.jhotdraw.framework.PointConstrainer;
import org.jhotdraw.framework.Tool;
import org.jhotdraw.samples.javadraw.URLTool;
import org.jhotdraw.standard.AbstractCommand;
import org.jhotdraw.standard.AlignCommand;
import org.jhotdraw.standard.BringToFrontCommand;
import org.jhotdraw.standard.ChangeAttributeCommand;
import org.jhotdraw.standard.ConnectionTool;
import org.jhotdraw.standard.CopyCommand;
import org.jhotdraw.standard.CreationTool;
import org.jhotdraw.standard.CutCommand;
import org.jhotdraw.standard.DeleteCommand;
import org.jhotdraw.standard.DuplicateCommand;
import org.jhotdraw.standard.GridConstrainer;
import org.jhotdraw.standard.PasteCommand;
import org.jhotdraw.standard.SelectAllCommand;
import org.jhotdraw.standard.SendToBackCommand;
import org.jhotdraw.standard.ToggleGridCommand;
import org.jhotdraw.standard.ToolButton;
import org.jhotdraw.util.ColorMap;
import org.jhotdraw.util.Command;
import org.jhotdraw.util.CommandMenu;
import org.jhotdraw.util.PaletteButton;
import org.jhotdraw.util.RedoCommand;
import org.jhotdraw.util.StorableInput;
import org.jhotdraw.util.UndoCommand;
import org.jhotdraw.util.UndoableCommand;
import org.jhotdraw.util.UndoableTool;

public class PmWikiDrawFrame
extends DrawApplication {
    private static String fgSampleImagesPath = "/org/jhotdraw/samples/javadraw/sampleimages";
    private static String fgSampleImagesResourcePath = fgSampleImagesPath + "/";
    private PmWikiSource _pmwikisource;
    private Drawing fDrawing = null;
    private final ResourceBundle menuStrings;
    private final ResourceBundle toolStrings;
    private CustomToolBar toolBar;

    public PmWikiDrawFrame(PmWikiSource pmWikiSource) {
        super("PmWikiDraw - " + pmWikiSource.getPmWikiParameter("drawingname"));
        this._pmwikisource = pmWikiSource;
        Locale locale = Locale.getDefault();
        this.menuStrings = ResourceBundle.getBundle("Menus", locale);
        this.toolStrings = ResourceBundle.getBundle("Tools", locale);
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                if ((keyEvent.getModifiers() & 2) == 2) {
                    switch (n) {
                        case 81: {
                            PmWikiDrawFrame.this.performExitAndDiscard();
                            break;
                        }
                        case 83: {
                            PmWikiDrawFrame.this.performSave();
                            break;
                        }
                        default: {
                            super.keyPressed(keyEvent);
                            break;
                        }
                    }
                } else if ((keyEvent.getModifiers() & 8) == 8) {
                    switch (n) {
                        case 88: {
                            PmWikiDrawFrame.this.performSaveAndExit();
                            break;
                        }
                        default: {
                            super.keyPressed(keyEvent);
                            break;
                        }
                    }
                } else {
                    super.keyPressed(keyEvent);
                }
            }
        });
    }

    private void performSaveAndExit() {
        int n = this._pmwikisource.saveDrawing(this.fDrawing);
        if (n == 0) {
            this.endApp(true);
        } else if (n == 1) {
            JOptionPane.showMessageDialog(this, "I'm sorry, but your password is not recognised.", "Password Failure", 2);
        } else if (n == 2) {
            JOptionPane.showMessageDialog(this, "It appears that someone has modified the drawing whilst you've been working on it.\nIf you save again you will lose the *other* user's changes.(But yours will remain!)", "Concurrent modification!", 2);
        } else {
            System.err.println("Hmmm invalid response from the drwaing save, weird!");
        }
    }

    protected DrawApplication createApplication() {
        return new PmWikiDrawFrame(this._pmwikisource);
    }

    protected DrawingView createDrawingView(Drawing drawing) {
        Dimension dimension = this.getDrawingViewSize();
        PmWikiDrawingView pmWikiDrawingView = new PmWikiDrawingView(this, dimension.width, dimension.height);
        pmWikiDrawingView.setQualityMode(true);
        pmWikiDrawingView.setDrawing(drawing);
        pmWikiDrawingView.setBackground(Color.white);
        pmWikiDrawingView.setConstrainer(new GridConstrainer(10, 10));
        pmWikiDrawingView.addFigureSelectionListener(new FigureSelectionListener(){

            public void figureSelectionChanged(DrawingView drawingView) {
                if (PmWikiDrawFrame.this.view().selectionCount() > 0) {
                    PmWikiDrawFrame.this.toolBar.switchToEditTools();
                    PmWikiDrawFrame.this.toolBar.activateTools();
                } else {
                    PmWikiDrawFrame.this.toolBar.switchToStandardTools();
                    PmWikiDrawFrame.this.toolBar.activateTools();
                }
            }
        });
        JHDDropTargetListener jHDDropTargetListener = new JHDDropTargetListener(this, pmWikiDrawingView);
        return pmWikiDrawingView;
    }

    public void destroy() {
        super.destroy();
    }

    protected void createTools(JToolBar jToolBar) {
        this.toolBar = (CustomToolBar)jToolBar;
        this.toolBar.switchToStandardTools();
        super.createTools(jToolBar);
        Tool tool = new UndoableTool(new TextTool(this, new TextFigure()));
        jToolBar.add(this.createToolButton("/org/jhotdraw/images/TEXT", this.toolStrings.getString("text"), tool));
        tool = new UndoableTool(new ConnectedTextTool(this, new TextFigure()));
        jToolBar.add(this.createToolButton("/org/jhotdraw/images/ATEXT", this.toolStrings.getString("connectedText"), tool));
        tool = new TextAreaTool(this, new TextAreaFigure());
        jToolBar.add(this.createToolButton("/org/jhotdraw/images/TEXTAREA", this.toolStrings.getString("textArea"), tool));
        tool = new URLTool(this);
        jToolBar.add(this.createToolButton("/org/jhotdraw/images/URL", this.toolStrings.getString("url"), tool));
        tool = new UndoableTool(new CreationTool(this, new RectangleFigure()));
        jToolBar.add(this.createToolButton("/org/jhotdraw/images/RECT", this.toolStrings.getString("rectangle"), tool));
        tool = new UndoableTool(new CreationTool(this, new RoundRectangleFigure()));
        jToolBar.add(this.createToolButton("/org/jhotdraw/images/RRECT", this.toolStrings.getString("roundRectangle"), tool));
        tool = new UndoableTool(new CreationTool(this, new EllipseFigure()));
        jToolBar.add(this.createToolButton("/org/jhotdraw/images/ELLIPSE", this.toolStrings.getString("ellipse"), tool));
        tool = new UndoableTool(new PolygonTool(this));
        jToolBar.add(this.createToolButton("/org/jhotdraw/images/POLYGON", this.toolStrings.getString("polygon"), tool));
        tool = new UndoableTool(new CreationTool(this, new TriangleFigure()));
        jToolBar.add(this.createToolButton("/org/jhotdraw/images/TRIANGLE", this.toolStrings.getString("triangle"), tool));
        tool = new UndoableTool(new CreationTool(this, new DiamondFigure()));
        jToolBar.add(this.createToolButton("/org/jhotdraw/images/DIAMOND", this.toolStrings.getString("diamond"), tool));
        tool = new UndoableTool(new CreationTool(this, new LineFigure()));
        jToolBar.add(this.createToolButton("/org/jhotdraw/images/LINE", this.toolStrings.getString("line"), tool));
        tool = new UndoableTool(new PmWikiScribbleTool(this));
        jToolBar.add(this.createToolButton("/org/jhotdraw/images/ASCRIBBL", this.toolStrings.getString("assistedScribble"), tool));
        tool = new UndoableTool(new PmWikiScribbleTool(this, true));
        jToolBar.add(this.createToolButton("/org/jhotdraw/images/SCRIBBL", this.toolStrings.getString("scribble"), tool));
        tool = new UndoableTool(new ConnectionTool(this, new LineConnection()));
        jToolBar.add(this.createToolButton("/org/jhotdraw/images/CONN", this.toolStrings.getString("connection"), tool));
        tool = new UndoableTool(new ConnectionTool(this, new ElbowConnection()));
        jToolBar.add(this.createToolButton("/org/jhotdraw/images/OCONN", this.toolStrings.getString("elbowConnection"), tool));
        LineConnection lineConnection = new LineConnection();
        lineConnection.setStartDecoration(null);
        tool = new UndoableTool(new SplitConnectionTool(this, lineConnection));
        jToolBar.add(this.createToolButton("/org/jhotdraw/images/OCONN", this.toolStrings.getString("splitConnection"), tool));
        tool = new DragNDropTool(this);
        jToolBar.add(new PaletteCommandButton(this, "/org/jhotdraw/images/", this.menuStrings.getString("attributesFillColor"), FigureAttributeConstant.FILL_COLOR, this));
        jToolBar.add(new PaletteCommandButton(this, "/org/jhotdraw/images/", this.menuStrings.getString("attributesPenColor"), FigureAttributeConstant.FRAME_COLOR, this));
        jToolBar.add(new PaletteCommandButton(this, "/org/jhotdraw/images/", this.menuStrings.getString("attributesTextColor"), FigureAttributeConstant.TEXT_COLOR, this));
        this.toolBar.switchToEditTools();
        jToolBar.add(this.createCommandButton("/org/jhotdraw/images/CUT", this.menuStrings.getString("editCut"), new UndoableCommand(new CutCommand(this.menuStrings.getString("editCut"), this))));
        jToolBar.add(this.createCommandButton("/org/jhotdraw/images/COPY", this.menuStrings.getString("editCopy"), new UndoableCommand(new CopyCommand(this.menuStrings.getString("editCopy"), this))));
        jToolBar.add(this.createCommandButton("/org/jhotdraw/images/PASTE", this.menuStrings.getString("editPaste"), new UndoableCommand(new PasteCommand(this.menuStrings.getString("editPaste"), this))));
        jToolBar.add(this.createCommandButton("/org/jhotdraw/images/DUP", this.menuStrings.getString("editDuplicate"), new UndoableCommand(new DuplicateCommand(this.menuStrings.getString("editDuplicate"), this))));
        jToolBar.add(this.createCommandButton("/org/jhotdraw/images/DEL", this.menuStrings.getString("editDelete"), new UndoableCommand(new DeleteCommand(this.menuStrings.getString("editDelete"), this))));
        jToolBar.add(new PaletteCommandButton(this, "/org/jhotdraw/images/", this.menuStrings.getString("attributesFillColor"), FigureAttributeConstant.FILL_COLOR, this));
        jToolBar.add(new PaletteCommandButton(this, "/org/jhotdraw/images/", this.menuStrings.getString("attributesPenColor"), FigureAttributeConstant.FRAME_COLOR, this));
        jToolBar.add(new PaletteCommandButton(this, "/org/jhotdraw/images/", this.menuStrings.getString("attributesTextColor"), FigureAttributeConstant.TEXT_COLOR, this));
        this.toolBar.switchToStandardTools();
        this.toolBar.activateTools();
    }

    protected void createMenus(JMenuBar jMenuBar) {
        this.addMenuIfPossible(jMenuBar, this.createFileMenu());
        this.addMenuIfPossible(jMenuBar, this.createEditMenu());
        this.addMenuIfPossible(jMenuBar, this.createAlignmentMenu());
        this.addMenuIfPossible(jMenuBar, this.createAttributesMenu());
        this.addMenuIfPossible(jMenuBar, this.createImagesMenu());
        this.addMenuIfPossible(jMenuBar, this.createSymbolsMenu());
    }

    private JMenu createSymbolsMenu() {
        Object object;
        final String string = this._pmwikisource.getPmWikiParameter("resourcesurl") + "/symbols/";
        CommandMenu commandMenu = new CommandMenu(this.menuStrings.getString("symbolsMenu"));
        Vector<String> vector = new Vector<String>();
        try {
            URL uRL = new URL(string + "symbols");
            object = uRL.openConnection();
            InputStream inputStream = uRL.openStream();
            if (inputStream == null) {
                throw new JHotDrawRuntimeException("Could not locate symbol index: " + uRL.getFile());
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string2 = bufferedReader.readLine();
            string2 = string2.trim();
            while (string2 != null) {
                if (!string2.startsWith("#") && !string2.equals("")) {
                    vector.add(string2);
                }
                if ((string2 = bufferedReader.readLine()) == null) continue;
                string2 = string2.trim();
            }
            inputStream.close();
        }
        catch (IOException iOException) {
            System.err.println("It seems that the administrator has disabled symbol insertions on this PmWiki, sorry.");
        }
        if (vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                object = (String)vector.get(i);
                commandMenu.add(new AbstractCommand((String)object, this, true, (String)object){
                    private final /* synthetic */ String val$name;
                    {
                        this.val$name = string3;
                    }

                    public void execute() {
                        SymbolPackageContainer symbolPackageContainer = new SymbolPackageContainer(string + this.val$name + ".jar");
                    }
                });
            }
            return commandMenu;
        }
        return null;
    }

    protected JMenu createEditMenu() {
        CommandMenu commandMenu = new CommandMenu(this.menuStrings.getString("editMenu"));
        commandMenu.add(new UndoCommand(this.menuStrings.getString("editUndo"), this));
        commandMenu.add(new RedoCommand(this.menuStrings.getString("editRedo"), this));
        commandMenu.addSeparator();
        commandMenu.add(new UndoableCommand(new SelectAllCommand(this.menuStrings.getString("editSelectAll"), this)), new MenuShortcut(this.menuStrings.getString("editSelectAll").charAt(0)));
        commandMenu.addSeparator();
        commandMenu.add(new UndoableCommand(new CutCommand(this.menuStrings.getString("editCut"), this)), new MenuShortcut(this.menuStrings.getString("editCutShortcut").charAt(0)));
        commandMenu.add(new CopyCommand(this.menuStrings.getString("editCopy"), this), new MenuShortcut(this.menuStrings.getString("editCopyShortcut").charAt(0)));
        commandMenu.add(new UndoableCommand(new PasteCommand(this.menuStrings.getString("editPaste"), this)), new MenuShortcut(this.menuStrings.getString("editPasteShortcut").charAt(0)));
        commandMenu.addSeparator();
        commandMenu.add(new UndoableCommand(new DuplicateCommand(this.menuStrings.getString("editDuplicate"), this)), new MenuShortcut(this.menuStrings.getString("editDuplicateShortcut").charAt(0)));
        commandMenu.add(new UndoableCommand(new DeleteCommand(this.menuStrings.getString("editDelete"), this)));
        commandMenu.addSeparator();
        commandMenu.add(new UndoableCommand(new GroupCommand(this.menuStrings.getString("editGroup"), this)));
        commandMenu.add(new UndoableCommand(new UngroupCommand(this.menuStrings.getString("editUngroup"), this)));
        commandMenu.addSeparator();
        commandMenu.add(new UndoableCommand(new SendToBackCommand(this.menuStrings.getString("editSendToBack"), this)));
        commandMenu.add(new UndoableCommand(new BringToFrontCommand(this.menuStrings.getString("editBringToFront"), this)));
        return commandMenu;
    }

    protected JMenu createAlignmentMenu() {
        CommandMenu commandMenu = new CommandMenu(this.menuStrings.getString("alignMenu"));
        commandMenu.addCheckItem(new ToggleGridCommand(this.menuStrings.getString("alignSnap"), (DrawingEditor)this, new Point(10, 10)), this.view().getConstrainer() != null);
        commandMenu.addSeparator();
        commandMenu.add(new UndoableCommand(new AlignCommand(AlignCommand.Alignment.LEFTS, (DrawingEditor)this)));
        commandMenu.add(new UndoableCommand(new AlignCommand(AlignCommand.Alignment.CENTERS, (DrawingEditor)this)));
        commandMenu.add(new UndoableCommand(new AlignCommand(AlignCommand.Alignment.RIGHTS, (DrawingEditor)this)));
        commandMenu.addSeparator();
        commandMenu.add(new UndoableCommand(new AlignCommand(AlignCommand.Alignment.TOPS, (DrawingEditor)this)));
        commandMenu.add(new UndoableCommand(new AlignCommand(AlignCommand.Alignment.MIDDLES, (DrawingEditor)this)));
        commandMenu.add(new UndoableCommand(new AlignCommand(AlignCommand.Alignment.BOTTOMS, (DrawingEditor)this)));
        return commandMenu;
    }

    protected JMenu createAttributesMenu() {
        JMenu jMenu = new JMenu(this.menuStrings.getString("attributesMenu"));
        jMenu.add(this.createColorMenu(this.menuStrings.getString("attributesFillColor"), FigureAttributeConstant.FILL_COLOR));
        jMenu.add(this.createColorMenu(this.menuStrings.getString("attributesPenColor"), FigureAttributeConstant.FRAME_COLOR));
        jMenu.add(this.createLineWidthMenu());
        jMenu.add(this.createLineStyleMenu());
        jMenu.add(this.createArrowMenu());
        jMenu.addSeparator();
        jMenu.add(this.createFontMenu());
        jMenu.add(this.createFontSizeMenu());
        jMenu.add(this.createFontStyleMenu());
        jMenu.add(this.createColorMenu(this.menuStrings.getString("attributesTextColor"), FigureAttributeConstant.TEXT_COLOR));
        return jMenu;
    }

    protected JMenu createColorMenu(String string, FigureAttributeConstant figureAttributeConstant) {
        CommandMenu commandMenu = new CommandMenu(string);
        for (int i = 0; i < ColorMap.size(); ++i) {
            commandMenu.add(new UndoableCommand(new ChangeAttributeCommand(ColorMap.name(i), figureAttributeConstant, ColorMap.color(i), this)));
        }
        commandMenu.add(new UndoableCommand(new ColorPaletteChangeAttributeCommand("Select...", figureAttributeConstant, this)));
        return commandMenu;
    }

    protected JMenu createArrowMenu() {
        FigureAttributeConstant figureAttributeConstant = FigureAttributeConstant.ARROW_MODE;
        CommandMenu commandMenu = new CommandMenu(this.menuStrings.getString("attributesArrow"));
        commandMenu.add(new UndoableCommand(new ChangeAttributeCommand(this.menuStrings.getString("attributesArrowNone"), figureAttributeConstant, new Integer(0), this)));
        commandMenu.add(new UndoableCommand(new ChangeAttributeCommand(this.menuStrings.getString("attributesArrowStart"), figureAttributeConstant, new Integer(1), this)));
        commandMenu.add(new UndoableCommand(new ChangeAttributeCommand(this.menuStrings.getString("attributesArrowEnd"), figureAttributeConstant, new Integer(2), this)));
        commandMenu.add(new UndoableCommand(new ChangeAttributeCommand(this.menuStrings.getString("attributesArrowBoth"), figureAttributeConstant, new Integer(3), this)));
        return commandMenu;
    }

    protected JMenu createFontStyleMenu() {
        FigureAttributeConstant figureAttributeConstant = FigureAttributeConstant.FONT_STYLE;
        CommandMenu commandMenu = new CommandMenu(this.menuStrings.getString("attributesFontStyle"));
        commandMenu.add(new UndoableCommand(new ChangeAttributeCommand(this.menuStrings.getString("attributesFontStylePlain"), figureAttributeConstant, new Integer(0), this)));
        commandMenu.add(new UndoableCommand(new ChangeAttributeCommand(this.menuStrings.getString("attributesFontStyleItalic"), figureAttributeConstant, new Integer(2), this)));
        commandMenu.add(new UndoableCommand(new ChangeAttributeCommand(this.menuStrings.getString("attributesFontStyleBold"), figureAttributeConstant, new Integer(1), this)));
        return commandMenu;
    }

    protected JMenu createFontSizeMenu() {
        CommandMenu commandMenu = new CommandMenu(this.menuStrings.getString("attributesFontSize"));
        int[] nArray = new int[]{9, 10, 12, 14, 18, 24, 36, 48, 72};
        for (int i = 0; i < nArray.length; ++i) {
            commandMenu.add(new UndoableCommand(new ChangeAttributeCommand(Integer.toString(nArray[i]), FigureAttributeConstant.FONT_SIZE, new Integer(nArray[i]), this)));
        }
        return commandMenu;
    }

    protected JMenu createLineWidthMenu() {
        CommandMenu commandMenu = new CommandMenu(this.menuStrings.getString("attributesPenWidth"));
        commandMenu.add(new UndoableCommand(new ChangeAttributeCommand("1", FigureAttributeConstant.LINE_WIDTH, new Double(1.0), this)));
        commandMenu.add(new UndoableCommand(new ChangeAttributeCommand("1.25", FigureAttributeConstant.LINE_WIDTH, new Double(1.25), this)));
        commandMenu.add(new UndoableCommand(new ChangeAttributeCommand("1.5", FigureAttributeConstant.LINE_WIDTH, new Double(1.5), this)));
        commandMenu.add(new UndoableCommand(new ChangeAttributeCommand("2", FigureAttributeConstant.LINE_WIDTH, new Double(2.0), this)));
        commandMenu.add(new UndoableCommand(new ChangeAttributeCommand("3", FigureAttributeConstant.LINE_WIDTH, new Double(3.0), this)));
        commandMenu.add(new UndoableCommand(new ChangeAttributeCommand("4", FigureAttributeConstant.LINE_WIDTH, new Double(4.0), this)));
        return commandMenu;
    }

    protected JMenu createLineStyleMenu() {
        CommandMenu commandMenu = new CommandMenu(this.menuStrings.getString("attributesPenStyle"));
        List list = PmWikiLineStyles.getLineStyles();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                commandMenu.add(new UndoableCommand(new ChangeAttributeCommand(this.menuStrings.getString(((PmWikiLineStyles)list.get(i)).getName()), FigureAttributeConstant.LINE_STYLE, new Integer(((PmWikiLineStyles)list.get(i)).getId()), this)));
            }
        }
        return commandMenu;
    }

    protected JMenu createFontMenu() {
        CommandMenu commandMenu = new CommandMenu(this.menuStrings.getString("attributesFont"));
        String[] stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        for (int i = 0; i < stringArray.length; ++i) {
            commandMenu.add(new UndoableCommand(new ChangeAttributeCommand(stringArray[i], FigureAttributeConstant.FONT_NAME, stringArray[i], this)));
        }
        return commandMenu;
    }

    protected JMenu createFileMenu() {
        CommandMenu commandMenu = new CommandMenu(this.menuStrings.getString("drawingMenu"));
        AbstractCommand abstractCommand = new AbstractCommand(this.menuStrings.getString("drawingAbout"), this, true){

            public void execute() {
                JOptionPane.showMessageDialog(PmWikiDrawFrame.this, "PmWikiDraw Version: 2.362\nDrawing version: 2", "About PmWikiDraw", 1);
            }
        };
        commandMenu.add(abstractCommand);
        abstractCommand = new AbstractCommand(this.menuStrings.getString("drawingClear"), this, true){

            public void execute() {
                if (PmWikiDrawFrame.this.fDrawing != null) {
                    PmWikiDrawFrame.this.fDrawing.release();
                    PmWikiDrawFrame.this.initDrawing();
                }
            }
        };
        commandMenu.add(abstractCommand, new MenuShortcut(this.menuStrings.getString("drawingClearShortcut").charAt(0)));
        abstractCommand = new AbstractCommand(this.menuStrings.getString("drawingRevert"), this, true){

            public void execute() {
                if (PmWikiDrawFrame.this.fDrawing != null) {
                    PmWikiDrawFrame.this.initDrawing();
                }
                PmWikiDrawFrame.this.loadDrawing("drawingloadpath");
            }
        };
        commandMenu.add(abstractCommand, new MenuShortcut(this.menuStrings.getString("drawingRevertShortcut").charAt(0)));
        commandMenu.addSeparator();
        abstractCommand = new AbstractCommand(this.menuStrings.getString("drawingPrint"), this, true){

            public void execute() {
                PmWikiDrawFrame.this.print();
            }
        };
        commandMenu.add(abstractCommand, new MenuShortcut(this.menuStrings.getString("drawingPrintShortcut").charAt(0)));
        commandMenu.addSeparator();
        commandMenu.addCheckItem(new ToggleQualityCommand(this.menuStrings.getString("drawingHighQuality"), this), ((PmWikiDrawingView)this.view()).getQualityMode());
        commandMenu.addSeparator();
        abstractCommand = new AbstractCommand(this.menuStrings.getString("drawingSave"), this, true){

            public void execute() {
                PmWikiDrawFrame.this.performSave();
            }
        };
        commandMenu.add(abstractCommand, new MenuShortcut(this.menuStrings.getString("drawingSaveShortcut").charAt(0)));
        commandMenu.addSeparator();
        abstractCommand = new AbstractCommand(this.menuStrings.getString("drawingSaveExit"), this, true){

            public void execute() {
                PmWikiDrawFrame.this.performSaveAndExit();
            }
        };
        commandMenu.add(abstractCommand, new MenuShortcut(this.menuStrings.getString("drawingSaveExitShortcut").charAt(0)));
        abstractCommand = new AbstractCommand(this.menuStrings.getString("drawingExitDiscard"), this, true){

            public void execute() {
                PmWikiDrawFrame.this.performExitAndDiscard();
            }
        };
        commandMenu.add(abstractCommand);
        return commandMenu;
    }

    private void performExitAndDiscard() {
        if (JOptionPane.showConfirmDialog(null, "Are you sure you want to discard this drawing?", "Discard and exit", 0, 2) == 0) {
            this.endApp(false);
        }
    }

    private void performSave() {
        int n = this._pmwikisource.saveDrawing(this.fDrawing);
        if (n == 0) {
            this.showStatus("Saved drawing...");
        } else if (n == 1) {
            JOptionPane.showMessageDialog(this, "I'm sorry, but your password is not recognised.", "Password Failure", 2);
        } else if (n == 2) {
            JOptionPane.showMessageDialog(this, "It appears that someone has modified the drawing whilst you've been working on it.\nIf you save again you will lose the *other* user's changes.(But yours will remain!)", "Concurrent modification!", 2);
        } else {
            System.err.println("Hmmm invalid response from the drwaing save, weird!");
        }
    }

    protected void endApp(boolean bl) {
        if (this.closeQuery()) {
            this._pmwikisource.exit(bl);
        }
    }

    protected JMenu createImagesMenu() {
        Object object;
        Object object2;
        Object object3;
        Serializable serializable;
        CommandMenu commandMenu = new CommandMenu(this.menuStrings.getString("imagesMenu"));
        String string = this._pmwikisource.getPmWikiParameter("resourcesurl") + "/images/";
        Vector<Object> vector = new Vector<Object>();
        try {
            serializable = new URL(string + "images");
            URLConnection uRLConnection = ((URL)serializable).openConnection();
            object3 = ((URL)serializable).openStream();
            if (object3 == null) {
                throw new JHotDrawRuntimeException("Could not locate image index: " + ((URL)serializable).getFile());
            }
            object2 = new BufferedReader(new InputStreamReader((InputStream)object3));
            object = ((BufferedReader)object2).readLine();
            object = ((String)object).trim();
            while (object != null) {
                if (!((String)object).startsWith("#") && !((String)object).equals("")) {
                    vector.add(object);
                }
                if ((object = ((BufferedReader)object2).readLine()) == null) continue;
                object = ((String)object).trim();
            }
            ((InputStream)object3).close();
        }
        catch (IOException iOException) {
            System.err.println("It seems that the administrator has disabled image insertions on this PmWiki, sorry.");
        }
        if (vector.size() > 0) {
            serializable = new HashMap();
            for (int i = 0; i < vector.size(); ++i) {
                String string2;
                object3 = (String)vector.get(i);
                object3 = ((String)object3).replace('\\', '/');
                object2 = new StringBuffer("");
                object = new StringTokenizer((String)object3, " ");
                if (((StringTokenizer)object).hasMoreElements()) {
                    while (((StringTokenizer)object).hasMoreElements()) {
                        string2 = (String)((StringTokenizer)object).nextElement();
                        ((StringBuffer)object2).append(string2);
                        if (!((StringTokenizer)object).hasMoreElements()) continue;
                        ((StringBuffer)object2).append("%20");
                    }
                } else {
                    object2 = new StringBuffer((String)object3);
                }
                string2 = string + object2;
                if (((String)object3).indexOf("/") >= 0) {
                    StringTokenizer stringTokenizer = new StringTokenizer((String)object3, "/");
                    String string3 = null;
                    int n = 0;
                    CommandMenu commandMenu2 = commandMenu;
                    StringBuffer stringBuffer = new StringBuffer("");
                    while (stringTokenizer.hasMoreElements()) {
                        string3 = (String)stringTokenizer.nextElement();
                        string3 = string3.replace('_', ' ');
                        if (!stringTokenizer.hasMoreElements()) {
                            commandMenu2.add(new UndoableCommand(new InsertImageCommand(string3, string2, this, this._pmwikisource.getPmWikiParameter("resourcesurl"))));
                            continue;
                        }
                        CommandMenu commandMenu3 = (CommandMenu)((HashMap)serializable).get(stringBuffer + "." + string3);
                        if (commandMenu3 != null) {
                            commandMenu2 = commandMenu3;
                        } else {
                            CommandMenu commandMenu4 = new CommandMenu(string3);
                            commandMenu2.add(commandMenu4);
                            commandMenu2 = commandMenu4;
                            ((HashMap)serializable).put(stringBuffer + "." + string3, commandMenu4);
                        }
                        stringBuffer.append(string3);
                        stringBuffer.append(".");
                        ++n;
                    }
                    continue;
                }
                commandMenu.add(new UndoableCommand(new InsertImageCommand((String)object3, string2, this, this._pmwikisource.getPmWikiParameter("resourcesurl"))));
            }
            return commandMenu;
        }
        return null;
    }

    public char[] convertToGif(Image image) throws IOException {
        System.err.println("converting data to GIF...");
        Graphics graphics = image.getGraphics();
        this.getDesktop().getActiveDrawingView().clearSelection();
        PointConstrainer pointConstrainer = this.view().getConstrainer();
        PmWikiDrawingView pmWikiDrawingView = (PmWikiDrawingView)this.view();
        pmWikiDrawingView.setConstrainer(null);
        boolean bl = pmWikiDrawingView.getQualityMode();
        pmWikiDrawingView.setQualityMode(true);
        pmWikiDrawingView.drawAll(graphics);
        pmWikiDrawingView.setConstrainer(pointConstrainer);
        pmWikiDrawingView.setQualityMode(bl);
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            new GifEncoder(image, (OutputStream)byteArrayOutputStream).encode();
        }
        catch (IOException iOException) {
            System.err.println("GIF uses too many colors, reducing to 216 colors...");
            FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), new Web216ColorsFilter());
            byteArrayOutputStream = new ByteArrayOutputStream();
            new GifEncoder(filteredImageSource, (OutputStream)byteArrayOutputStream).encode();
            System.err.println("Color reduction successful.");
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        int n = byteArrayOutputStream.size();
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = (char)byArray[i];
        }
        System.err.println("conversion to GIF successful.");
        return cArray;
    }

    private void initDrawing() {
        this.fDrawing = this.createDrawing();
        this.view().setDrawing(this.fDrawing);
        this.toolDone();
    }

    protected void loadDrawing(String string) {
        String string2;
        if (string == DrawApplication.fgUntitled) {
            this.getDesktop().getActiveDrawingView().drawing().release();
            this.initDrawing();
            return;
        }
        if (this.fDrawing == null) {
            this.fDrawing = this.view().drawing();
        }
        if ((string2 = this._pmwikisource.getPmWikiParameter(string)) != null) {
            this.readDrawing(string2);
        }
    }

    private void readDrawing(String string) {
        this.toolDone();
        String string2 = this.guessType(string);
        if (string2.equals("storable")) {
            this.readFromStorableInput(string);
        } else if (string2.equals("serialized")) {
            this.readFromObjectInput(string);
        } else {
            this.showStatus("Unknown file type");
        }
    }

    private void readFromStorableInput(String string) {
        try {
            Object object;
            InputStream inputStream = null;
            if (string.startsWith("http")) {
                object = this._pmwikisource.createUrl(string);
                inputStream = ((URL)object).openStream();
            } else {
                inputStream = new FileInputStream(string);
            }
            object = new PmWikiDrawingConverter();
            ((PmWikiDrawingConverter)object).convert(inputStream);
            StorableInput storableInput = new StorableInput(((PmWikiDrawingConverter)object).getConvertedStream());
            this.fDrawing.release();
            this.fDrawing = (Drawing)storableInput.readStorable();
            if (this.fDrawing == null) {
                this.initDrawing();
                this.showStatus("There was a problem with the drawing in " + string);
            } else {
                this.view().setDrawing(this.fDrawing);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.initDrawing();
            this.showStatus("Error:" + exception);
        }
    }

    private void readFromObjectInput(String string) {
        try {
            URL uRL = this._pmwikisource.createUrl(string);
            InputStream inputStream = uRL.openStream();
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            this.fDrawing.release();
            this.fDrawing = (Drawing)objectInputStream.readObject();
            this.view().setDrawing(this.fDrawing);
        }
        catch (IOException iOException) {
            this.initDrawing();
            this.showStatus("Error: " + iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.initDrawing();
            this.showStatus("Class not found: " + classNotFoundException);
        }
    }

    private String guessType(String string) {
        if (string.endsWith(".draw")) {
            return "storable";
        }
        if (string.endsWith(".ser")) {
            return "serialized";
        }
        return "unknown";
    }

    protected JToolBar createToolPalette() {
        CustomToolBar customToolBar = new CustomToolBar();
        customToolBar.setBackground(Color.lightGray);
        return customToolBar;
    }

    protected CommandButton createCommandButton(String string, String string2, Command command) {
        return new CommandButton(this, string, string2, command);
    }

    public void paletteUserSelected(PaletteButton paletteButton) {
        if (paletteButton instanceof ToolButton) {
            super.paletteUserSelected(paletteButton);
        } else {
            CommandButton commandButton = (CommandButton)paletteButton;
        }
    }

    public void paletteUserOver(PaletteButton paletteButton, boolean bl) {
        if (paletteButton instanceof ToolButton) {
            super.paletteUserOver(paletteButton, bl);
        } else {
            CommandButton commandButton = (CommandButton)paletteButton;
            if (bl) {
                this.showStatus(commandButton.name());
            }
        }
    }

    protected void addListeners() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PmWikiDrawFrame.this.endApp(false);
            }
        });
    }

    protected Tool createSelectionTool() {
        return new PmWikiDrawSelectionTool(this);
    }
}

