// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/vision/v1p2beta1/image_annotator.proto

package vision

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import google_longrunning "google.golang.org/genproto/googleapis/longrunning"
import google_protobuf3 "github.com/golang/protobuf/ptypes/timestamp"
import google_rpc "google.golang.org/genproto/googleapis/rpc/status"
import google_type "google.golang.org/genproto/googleapis/type/color"
import google_type1 "google.golang.org/genproto/googleapis/type/latlng"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// A bucketized representation of likelihood, which is intended to give clients
// highly stable results across model upgrades.
type Likelihood int32

const (
	// Unknown likelihood.
	Likelihood_UNKNOWN Likelihood = 0
	// It is very unlikely that the image belongs to the specified vertical.
	Likelihood_VERY_UNLIKELY Likelihood = 1
	// It is unlikely that the image belongs to the specified vertical.
	Likelihood_UNLIKELY Likelihood = 2
	// It is possible that the image belongs to the specified vertical.
	Likelihood_POSSIBLE Likelihood = 3
	// It is likely that the image belongs to the specified vertical.
	Likelihood_LIKELY Likelihood = 4
	// It is very likely that the image belongs to the specified vertical.
	Likelihood_VERY_LIKELY Likelihood = 5
)

var Likelihood_name = map[int32]string{
	0: "UNKNOWN",
	1: "VERY_UNLIKELY",
	2: "UNLIKELY",
	3: "POSSIBLE",
	4: "LIKELY",
	5: "VERY_LIKELY",
}
var Likelihood_value = map[string]int32{
	"UNKNOWN":       0,
	"VERY_UNLIKELY": 1,
	"UNLIKELY":      2,
	"POSSIBLE":      3,
	"LIKELY":        4,
	"VERY_LIKELY":   5,
}

func (x Likelihood) String() string {
	return proto.EnumName(Likelihood_name, int32(x))
}
func (Likelihood) EnumDescriptor() ([]byte, []int) { return fileDescriptor1, []int{0} }

// Type of Google Cloud Vision API feature to be extracted.
type Feature_Type int32

const (
	// Unspecified feature type.
	Feature_TYPE_UNSPECIFIED Feature_Type = 0
	// Run face detection.
	Feature_FACE_DETECTION Feature_Type = 1
	// Run landmark detection.
	Feature_LANDMARK_DETECTION Feature_Type = 2
	// Run logo detection.
	Feature_LOGO_DETECTION Feature_Type = 3
	// Run label detection.
	Feature_LABEL_DETECTION Feature_Type = 4
	// Run text detection / optical character recognition (OCR). Text detection
	// is optimized for areas of text within a larger image; if the image is
	// a document, use `DOCUMENT_TEXT_DETECTION` instead.
	Feature_TEXT_DETECTION Feature_Type = 5
	// Run dense text document OCR. Takes precedence when both
	// `DOCUMENT_TEXT_DETECTION` and `TEXT_DETECTION` are present.
	Feature_DOCUMENT_TEXT_DETECTION Feature_Type = 11
	// Run Safe Search to detect potentially unsafe
	// or undesirable content.
	Feature_SAFE_SEARCH_DETECTION Feature_Type = 6
	// Compute a set of image properties, such as the
	// image's dominant colors.
	Feature_IMAGE_PROPERTIES Feature_Type = 7
	// Run crop hints.
	Feature_CROP_HINTS Feature_Type = 9
	// Run web detection.
	Feature_WEB_DETECTION Feature_Type = 10
)

var Feature_Type_name = map[int32]string{
	0:  "TYPE_UNSPECIFIED",
	1:  "FACE_DETECTION",
	2:  "LANDMARK_DETECTION",
	3:  "LOGO_DETECTION",
	4:  "LABEL_DETECTION",
	5:  "TEXT_DETECTION",
	11: "DOCUMENT_TEXT_DETECTION",
	6:  "SAFE_SEARCH_DETECTION",
	7:  "IMAGE_PROPERTIES",
	9:  "CROP_HINTS",
	10: "WEB_DETECTION",
}
var Feature_Type_value = map[string]int32{
	"TYPE_UNSPECIFIED":        0,
	"FACE_DETECTION":          1,
	"LANDMARK_DETECTION":      2,
	"LOGO_DETECTION":          3,
	"LABEL_DETECTION":         4,
	"TEXT_DETECTION":          5,
	"DOCUMENT_TEXT_DETECTION": 11,
	"SAFE_SEARCH_DETECTION":   6,
	"IMAGE_PROPERTIES":        7,
	"CROP_HINTS":              9,
	"WEB_DETECTION":           10,
}

func (x Feature_Type) String() string {
	return proto.EnumName(Feature_Type_name, int32(x))
}
func (Feature_Type) EnumDescriptor() ([]byte, []int) { return fileDescriptor1, []int{0, 0} }

// Face landmark (feature) type.
// Left and right are defined from the vantage of the viewer of the image
// without considering mirror projections typical of photos. So, `LEFT_EYE`,
// typically, is the person's right eye.
type FaceAnnotation_Landmark_Type int32

const (
	// Unknown face landmark detected. Should not be filled.
	FaceAnnotation_Landmark_UNKNOWN_LANDMARK FaceAnnotation_Landmark_Type = 0
	// Left eye.
	FaceAnnotation_Landmark_LEFT_EYE FaceAnnotation_Landmark_Type = 1
	// Right eye.
	FaceAnnotation_Landmark_RIGHT_EYE FaceAnnotation_Landmark_Type = 2
	// Left of left eyebrow.
	FaceAnnotation_Landmark_LEFT_OF_LEFT_EYEBROW FaceAnnotation_Landmark_Type = 3
	// Right of left eyebrow.
	FaceAnnotation_Landmark_RIGHT_OF_LEFT_EYEBROW FaceAnnotation_Landmark_Type = 4
	// Left of right eyebrow.
	FaceAnnotation_Landmark_LEFT_OF_RIGHT_EYEBROW FaceAnnotation_Landmark_Type = 5
	// Right of right eyebrow.
	FaceAnnotation_Landmark_RIGHT_OF_RIGHT_EYEBROW FaceAnnotation_Landmark_Type = 6
	// Midpoint between eyes.
	FaceAnnotation_Landmark_MIDPOINT_BETWEEN_EYES FaceAnnotation_Landmark_Type = 7
	// Nose tip.
	FaceAnnotation_Landmark_NOSE_TIP FaceAnnotation_Landmark_Type = 8
	// Upper lip.
	FaceAnnotation_Landmark_UPPER_LIP FaceAnnotation_Landmark_Type = 9
	// Lower lip.
	FaceAnnotation_Landmark_LOWER_LIP FaceAnnotation_Landmark_Type = 10
	// Mouth left.
	FaceAnnotation_Landmark_MOUTH_LEFT FaceAnnotation_Landmark_Type = 11
	// Mouth right.
	FaceAnnotation_Landmark_MOUTH_RIGHT FaceAnnotation_Landmark_Type = 12
	// Mouth center.
	FaceAnnotation_Landmark_MOUTH_CENTER FaceAnnotation_Landmark_Type = 13
	// Nose, bottom right.
	FaceAnnotation_Landmark_NOSE_BOTTOM_RIGHT FaceAnnotation_Landmark_Type = 14
	// Nose, bottom left.
	FaceAnnotation_Landmark_NOSE_BOTTOM_LEFT FaceAnnotation_Landmark_Type = 15
	// Nose, bottom center.
	FaceAnnotation_Landmark_NOSE_BOTTOM_CENTER FaceAnnotation_Landmark_Type = 16
	// Left eye, top boundary.
	FaceAnnotation_Landmark_LEFT_EYE_TOP_BOUNDARY FaceAnnotation_Landmark_Type = 17
	// Left eye, right corner.
	FaceAnnotation_Landmark_LEFT_EYE_RIGHT_CORNER FaceAnnotation_Landmark_Type = 18
	// Left eye, bottom boundary.
	FaceAnnotation_Landmark_LEFT_EYE_BOTTOM_BOUNDARY FaceAnnotation_Landmark_Type = 19
	// Left eye, left corner.
	FaceAnnotation_Landmark_LEFT_EYE_LEFT_CORNER FaceAnnotation_Landmark_Type = 20
	// Right eye, top boundary.
	FaceAnnotation_Landmark_RIGHT_EYE_TOP_BOUNDARY FaceAnnotation_Landmark_Type = 21
	// Right eye, right corner.
	FaceAnnotation_Landmark_RIGHT_EYE_RIGHT_CORNER FaceAnnotation_Landmark_Type = 22
	// Right eye, bottom boundary.
	FaceAnnotation_Landmark_RIGHT_EYE_BOTTOM_BOUNDARY FaceAnnotation_Landmark_Type = 23
	// Right eye, left corner.
	FaceAnnotation_Landmark_RIGHT_EYE_LEFT_CORNER FaceAnnotation_Landmark_Type = 24
	// Left eyebrow, upper midpoint.
	FaceAnnotation_Landmark_LEFT_EYEBROW_UPPER_MIDPOINT FaceAnnotation_Landmark_Type = 25
	// Right eyebrow, upper midpoint.
	FaceAnnotation_Landmark_RIGHT_EYEBROW_UPPER_MIDPOINT FaceAnnotation_Landmark_Type = 26
	// Left ear tragion.
	FaceAnnotation_Landmark_LEFT_EAR_TRAGION FaceAnnotation_Landmark_Type = 27
	// Right ear tragion.
	FaceAnnotation_Landmark_RIGHT_EAR_TRAGION FaceAnnotation_Landmark_Type = 28
	// Left eye pupil.
	FaceAnnotation_Landmark_LEFT_EYE_PUPIL FaceAnnotation_Landmark_Type = 29
	// Right eye pupil.
	FaceAnnotation_Landmark_RIGHT_EYE_PUPIL FaceAnnotation_Landmark_Type = 30
	// Forehead glabella.
	FaceAnnotation_Landmark_FOREHEAD_GLABELLA FaceAnnotation_Landmark_Type = 31
	// Chin gnathion.
	FaceAnnotation_Landmark_CHIN_GNATHION FaceAnnotation_Landmark_Type = 32
	// Chin left gonion.
	FaceAnnotation_Landmark_CHIN_LEFT_GONION FaceAnnotation_Landmark_Type = 33
	// Chin right gonion.
	FaceAnnotation_Landmark_CHIN_RIGHT_GONION FaceAnnotation_Landmark_Type = 34
)

var FaceAnnotation_Landmark_Type_name = map[int32]string{
	0:  "UNKNOWN_LANDMARK",
	1:  "LEFT_EYE",
	2:  "RIGHT_EYE",
	3:  "LEFT_OF_LEFT_EYEBROW",
	4:  "RIGHT_OF_LEFT_EYEBROW",
	5:  "LEFT_OF_RIGHT_EYEBROW",
	6:  "RIGHT_OF_RIGHT_EYEBROW",
	7:  "MIDPOINT_BETWEEN_EYES",
	8:  "NOSE_TIP",
	9:  "UPPER_LIP",
	10: "LOWER_LIP",
	11: "MOUTH_LEFT",
	12: "MOUTH_RIGHT",
	13: "MOUTH_CENTER",
	14: "NOSE_BOTTOM_RIGHT",
	15: "NOSE_BOTTOM_LEFT",
	16: "NOSE_BOTTOM_CENTER",
	17: "LEFT_EYE_TOP_BOUNDARY",
	18: "LEFT_EYE_RIGHT_CORNER",
	19: "LEFT_EYE_BOTTOM_BOUNDARY",
	20: "LEFT_EYE_LEFT_CORNER",
	21: "RIGHT_EYE_TOP_BOUNDARY",
	22: "RIGHT_EYE_RIGHT_CORNER",
	23: "RIGHT_EYE_BOTTOM_BOUNDARY",
	24: "RIGHT_EYE_LEFT_CORNER",
	25: "LEFT_EYEBROW_UPPER_MIDPOINT",
	26: "RIGHT_EYEBROW_UPPER_MIDPOINT",
	27: "LEFT_EAR_TRAGION",
	28: "RIGHT_EAR_TRAGION",
	29: "LEFT_EYE_PUPIL",
	30: "RIGHT_EYE_PUPIL",
	31: "FOREHEAD_GLABELLA",
	32: "CHIN_GNATHION",
	33: "CHIN_LEFT_GONION",
	34: "CHIN_RIGHT_GONION",
}
var FaceAnnotation_Landmark_Type_value = map[string]int32{
	"UNKNOWN_LANDMARK":             0,
	"LEFT_EYE":                     1,
	"RIGHT_EYE":                    2,
	"LEFT_OF_LEFT_EYEBROW":         3,
	"RIGHT_OF_LEFT_EYEBROW":        4,
	"LEFT_OF_RIGHT_EYEBROW":        5,
	"RIGHT_OF_RIGHT_EYEBROW":       6,
	"MIDPOINT_BETWEEN_EYES":        7,
	"NOSE_TIP":                     8,
	"UPPER_LIP":                    9,
	"LOWER_LIP":                    10,
	"MOUTH_LEFT":                   11,
	"MOUTH_RIGHT":                  12,
	"MOUTH_CENTER":                 13,
	"NOSE_BOTTOM_RIGHT":            14,
	"NOSE_BOTTOM_LEFT":             15,
	"NOSE_BOTTOM_CENTER":           16,
	"LEFT_EYE_TOP_BOUNDARY":        17,
	"LEFT_EYE_RIGHT_CORNER":        18,
	"LEFT_EYE_BOTTOM_BOUNDARY":     19,
	"LEFT_EYE_LEFT_CORNER":         20,
	"RIGHT_EYE_TOP_BOUNDARY":       21,
	"RIGHT_EYE_RIGHT_CORNER":       22,
	"RIGHT_EYE_BOTTOM_BOUNDARY":    23,
	"RIGHT_EYE_LEFT_CORNER":        24,
	"LEFT_EYEBROW_UPPER_MIDPOINT":  25,
	"RIGHT_EYEBROW_UPPER_MIDPOINT": 26,
	"LEFT_EAR_TRAGION":             27,
	"RIGHT_EAR_TRAGION":            28,
	"LEFT_EYE_PUPIL":               29,
	"RIGHT_EYE_PUPIL":              30,
	"FOREHEAD_GLABELLA":            31,
	"CHIN_GNATHION":                32,
	"CHIN_LEFT_GONION":             33,
	"CHIN_RIGHT_GONION":            34,
}

func (x FaceAnnotation_Landmark_Type) String() string {
	return proto.EnumName(FaceAnnotation_Landmark_Type_name, int32(x))
}
func (FaceAnnotation_Landmark_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor1, []int{3, 0, 0}
}

// Batch operation states.
type OperationMetadata_State int32

const (
	// Invalid.
	OperationMetadata_STATE_UNSPECIFIED OperationMetadata_State = 0
	// Request is received.
	OperationMetadata_CREATED OperationMetadata_State = 1
	// Request is actively being processed.
	OperationMetadata_RUNNING OperationMetadata_State = 2
	// The batch processing is done.
	OperationMetadata_DONE OperationMetadata_State = 3
	// The batch processing was cancelled.
	OperationMetadata_CANCELLED OperationMetadata_State = 4
)

var OperationMetadata_State_name = map[int32]string{
	0: "STATE_UNSPECIFIED",
	1: "CREATED",
	2: "RUNNING",
	3: "DONE",
	4: "CANCELLED",
}
var OperationMetadata_State_value = map[string]int32{
	"STATE_UNSPECIFIED": 0,
	"CREATED":           1,
	"RUNNING":           2,
	"DONE":              3,
	"CANCELLED":         4,
}

func (x OperationMetadata_State) String() string {
	return proto.EnumName(OperationMetadata_State_name, int32(x))
}
func (OperationMetadata_State) EnumDescriptor() ([]byte, []int) { return fileDescriptor1, []int{30, 0} }

// The type of Google Cloud Vision API detection to perform, and the maximum
// number of results to return for that type. Multiple `Feature` objects can
// be specified in the `features` list.
type Feature struct {
	// The feature type.
	Type Feature_Type `protobuf:"varint,1,opt,name=type,enum=google.cloud.vision.v1p2beta1.Feature_Type" json:"type,omitempty"`
	// Maximum number of results of this type. Does not apply to
	// `TEXT_DETECTION`, `DOCUMENT_TEXT_DETECTION`, or `CROP_HINTS`.
	MaxResults int32 `protobuf:"varint,2,opt,name=max_results,json=maxResults" json:"max_results,omitempty"`
	// Model to use for the feature.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest".
	Model string `protobuf:"bytes,3,opt,name=model" json:"model,omitempty"`
}

func (m *Feature) Reset()                    { *m = Feature{} }
func (m *Feature) String() string            { return proto.CompactTextString(m) }
func (*Feature) ProtoMessage()               {}
func (*Feature) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{0} }

func (m *Feature) GetType() Feature_Type {
	if m != nil {
		return m.Type
	}
	return Feature_TYPE_UNSPECIFIED
}

func (m *Feature) GetMaxResults() int32 {
	if m != nil {
		return m.MaxResults
	}
	return 0
}

func (m *Feature) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

// External image source (Google Cloud Storage or web URL image location).
type ImageSource struct {
	// **Use `image_uri` instead.**
	//
	// The Google Cloud Storage  URI of the form
	// `gs://bucket_name/object_name`. Object versioning is not supported. See
	// [Google Cloud Storage Request
	// URIs](https://cloud.google.com/storage/docs/reference-uris) for more info.
	GcsImageUri string `protobuf:"bytes,1,opt,name=gcs_image_uri,json=gcsImageUri" json:"gcs_image_uri,omitempty"`
	// The URI of the source image. Can be either:
	//
	// 1. A Google Cloud Storage URI of the form
	//    `gs://bucket_name/object_name`. Object versioning is not supported. See
	//    [Google Cloud Storage Request
	//    URIs](https://cloud.google.com/storage/docs/reference-uris) for more
	//    info.
	//
	// 2. A publicly-accessible image HTTP/HTTPS URL. When fetching images from
	//    HTTP/HTTPS URLs, Google cannot guarantee that the request will be
	//    completed. Your request may fail if the specified host denies the
	//    request (e.g. due to request throttling or DOS prevention), or if Google
	//    throttles requests to the site for abuse prevention. You should not
	//    depend on externally-hosted images for production applications.
	//
	// When both `gcs_image_uri` and `image_uri` are specified, `image_uri` takes
	// precedence.
	ImageUri string `protobuf:"bytes,2,opt,name=image_uri,json=imageUri" json:"image_uri,omitempty"`
}

func (m *ImageSource) Reset()                    { *m = ImageSource{} }
func (m *ImageSource) String() string            { return proto.CompactTextString(m) }
func (*ImageSource) ProtoMessage()               {}
func (*ImageSource) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{1} }

func (m *ImageSource) GetGcsImageUri() string {
	if m != nil {
		return m.GcsImageUri
	}
	return ""
}

func (m *ImageSource) GetImageUri() string {
	if m != nil {
		return m.ImageUri
	}
	return ""
}

// Client image to perform Google Cloud Vision API tasks over.
type Image struct {
	// Image content, represented as a stream of bytes.
	// Note: As with all `bytes` fields, protobuffers use a pure binary
	// representation, whereas JSON representations use base64.
	Content []byte `protobuf:"bytes,1,opt,name=content,proto3" json:"content,omitempty"`
	// Google Cloud Storage image location, or publicly-accessible image
	// URL. If both `content` and `source` are provided for an image, `content`
	// takes precedence and is used to perform the image annotation request.
	Source *ImageSource `protobuf:"bytes,2,opt,name=source" json:"source,omitempty"`
}

func (m *Image) Reset()                    { *m = Image{} }
func (m *Image) String() string            { return proto.CompactTextString(m) }
func (*Image) ProtoMessage()               {}
func (*Image) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{2} }

func (m *Image) GetContent() []byte {
	if m != nil {
		return m.Content
	}
	return nil
}

func (m *Image) GetSource() *ImageSource {
	if m != nil {
		return m.Source
	}
	return nil
}

// A face annotation object contains the results of face detection.
type FaceAnnotation struct {
	// The bounding polygon around the face. The coordinates of the bounding box
	// are in the original image's scale, as returned in `ImageParams`.
	// The bounding box is computed to "frame" the face in accordance with human
	// expectations. It is based on the landmarker results.
	// Note that one or more x and/or y coordinates may not be generated in the
	// `BoundingPoly` (the polygon will be unbounded) if only a partial face
	// appears in the image to be annotated.
	BoundingPoly *BoundingPoly `protobuf:"bytes,1,opt,name=bounding_poly,json=boundingPoly" json:"bounding_poly,omitempty"`
	// The `fd_bounding_poly` bounding polygon is tighter than the
	// `boundingPoly`, and encloses only the skin part of the face. Typically, it
	// is used to eliminate the face from any image analysis that detects the
	// "amount of skin" visible in an image. It is not based on the
	// landmarker results, only on the initial face detection, hence
	// the <code>fd</code> (face detection) prefix.
	FdBoundingPoly *BoundingPoly `protobuf:"bytes,2,opt,name=fd_bounding_poly,json=fdBoundingPoly" json:"fd_bounding_poly,omitempty"`
	// Detected face landmarks.
	Landmarks []*FaceAnnotation_Landmark `protobuf:"bytes,3,rep,name=landmarks" json:"landmarks,omitempty"`
	// Roll angle, which indicates the amount of clockwise/anti-clockwise rotation
	// of the face relative to the image vertical about the axis perpendicular to
	// the face. Range [-180,180].
	RollAngle float32 `protobuf:"fixed32,4,opt,name=roll_angle,json=rollAngle" json:"roll_angle,omitempty"`
	// Yaw angle, which indicates the leftward/rightward angle that the face is
	// pointing relative to the vertical plane perpendicular to the image. Range
	// [-180,180].
	PanAngle float32 `protobuf:"fixed32,5,opt,name=pan_angle,json=panAngle" json:"pan_angle,omitempty"`
	// Pitch angle, which indicates the upwards/downwards angle that the face is
	// pointing relative to the image's horizontal plane. Range [-180,180].
	TiltAngle float32 `protobuf:"fixed32,6,opt,name=tilt_angle,json=tiltAngle" json:"tilt_angle,omitempty"`
	// Detection confidence. Range [0, 1].
	DetectionConfidence float32 `protobuf:"fixed32,7,opt,name=detection_confidence,json=detectionConfidence" json:"detection_confidence,omitempty"`
	// Face landmarking confidence. Range [0, 1].
	LandmarkingConfidence float32 `protobuf:"fixed32,8,opt,name=landmarking_confidence,json=landmarkingConfidence" json:"landmarking_confidence,omitempty"`
	// Joy likelihood.
	JoyLikelihood Likelihood `protobuf:"varint,9,opt,name=joy_likelihood,json=joyLikelihood,enum=google.cloud.vision.v1p2beta1.Likelihood" json:"joy_likelihood,omitempty"`
	// Sorrow likelihood.
	SorrowLikelihood Likelihood `protobuf:"varint,10,opt,name=sorrow_likelihood,json=sorrowLikelihood,enum=google.cloud.vision.v1p2beta1.Likelihood" json:"sorrow_likelihood,omitempty"`
	// Anger likelihood.
	AngerLikelihood Likelihood `protobuf:"varint,11,opt,name=anger_likelihood,json=angerLikelihood,enum=google.cloud.vision.v1p2beta1.Likelihood" json:"anger_likelihood,omitempty"`
	// Surprise likelihood.
	SurpriseLikelihood Likelihood `protobuf:"varint,12,opt,name=surprise_likelihood,json=surpriseLikelihood,enum=google.cloud.vision.v1p2beta1.Likelihood" json:"surprise_likelihood,omitempty"`
	// Under-exposed likelihood.
	UnderExposedLikelihood Likelihood `protobuf:"varint,13,opt,name=under_exposed_likelihood,json=underExposedLikelihood,enum=google.cloud.vision.v1p2beta1.Likelihood" json:"under_exposed_likelihood,omitempty"`
	// Blurred likelihood.
	BlurredLikelihood Likelihood `protobuf:"varint,14,opt,name=blurred_likelihood,json=blurredLikelihood,enum=google.cloud.vision.v1p2beta1.Likelihood" json:"blurred_likelihood,omitempty"`
	// Headwear likelihood.
	HeadwearLikelihood Likelihood `protobuf:"varint,15,opt,name=headwear_likelihood,json=headwearLikelihood,enum=google.cloud.vision.v1p2beta1.Likelihood" json:"headwear_likelihood,omitempty"`
}

func (m *FaceAnnotation) Reset()                    { *m = FaceAnnotation{} }
func (m *FaceAnnotation) String() string            { return proto.CompactTextString(m) }
func (*FaceAnnotation) ProtoMessage()               {}
func (*FaceAnnotation) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{3} }

func (m *FaceAnnotation) GetBoundingPoly() *BoundingPoly {
	if m != nil {
		return m.BoundingPoly
	}
	return nil
}

func (m *FaceAnnotation) GetFdBoundingPoly() *BoundingPoly {
	if m != nil {
		return m.FdBoundingPoly
	}
	return nil
}

func (m *FaceAnnotation) GetLandmarks() []*FaceAnnotation_Landmark {
	if m != nil {
		return m.Landmarks
	}
	return nil
}

func (m *FaceAnnotation) GetRollAngle() float32 {
	if m != nil {
		return m.RollAngle
	}
	return 0
}

func (m *FaceAnnotation) GetPanAngle() float32 {
	if m != nil {
		return m.PanAngle
	}
	return 0
}

func (m *FaceAnnotation) GetTiltAngle() float32 {
	if m != nil {
		return m.TiltAngle
	}
	return 0
}

func (m *FaceAnnotation) GetDetectionConfidence() float32 {
	if m != nil {
		return m.DetectionConfidence
	}
	return 0
}

func (m *FaceAnnotation) GetLandmarkingConfidence() float32 {
	if m != nil {
		return m.LandmarkingConfidence
	}
	return 0
}

func (m *FaceAnnotation) GetJoyLikelihood() Likelihood {
	if m != nil {
		return m.JoyLikelihood
	}
	return Likelihood_UNKNOWN
}

func (m *FaceAnnotation) GetSorrowLikelihood() Likelihood {
	if m != nil {
		return m.SorrowLikelihood
	}
	return Likelihood_UNKNOWN
}

func (m *FaceAnnotation) GetAngerLikelihood() Likelihood {
	if m != nil {
		return m.AngerLikelihood
	}
	return Likelihood_UNKNOWN
}

func (m *FaceAnnotation) GetSurpriseLikelihood() Likelihood {
	if m != nil {
		return m.SurpriseLikelihood
	}
	return Likelihood_UNKNOWN
}

func (m *FaceAnnotation) GetUnderExposedLikelihood() Likelihood {
	if m != nil {
		return m.UnderExposedLikelihood
	}
	return Likelihood_UNKNOWN
}

func (m *FaceAnnotation) GetBlurredLikelihood() Likelihood {
	if m != nil {
		return m.BlurredLikelihood
	}
	return Likelihood_UNKNOWN
}

func (m *FaceAnnotation) GetHeadwearLikelihood() Likelihood {
	if m != nil {
		return m.HeadwearLikelihood
	}
	return Likelihood_UNKNOWN
}

// A face-specific landmark (for example, a face feature).
type FaceAnnotation_Landmark struct {
	// Face landmark type.
	Type FaceAnnotation_Landmark_Type `protobuf:"varint,3,opt,name=type,enum=google.cloud.vision.v1p2beta1.FaceAnnotation_Landmark_Type" json:"type,omitempty"`
	// Face landmark position.
	Position *Position `protobuf:"bytes,4,opt,name=position" json:"position,omitempty"`
}

func (m *FaceAnnotation_Landmark) Reset()                    { *m = FaceAnnotation_Landmark{} }
func (m *FaceAnnotation_Landmark) String() string            { return proto.CompactTextString(m) }
func (*FaceAnnotation_Landmark) ProtoMessage()               {}
func (*FaceAnnotation_Landmark) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{3, 0} }

func (m *FaceAnnotation_Landmark) GetType() FaceAnnotation_Landmark_Type {
	if m != nil {
		return m.Type
	}
	return FaceAnnotation_Landmark_UNKNOWN_LANDMARK
}

func (m *FaceAnnotation_Landmark) GetPosition() *Position {
	if m != nil {
		return m.Position
	}
	return nil
}

// Detected entity location information.
type LocationInfo struct {
	// lat/long location coordinates.
	LatLng *google_type1.LatLng `protobuf:"bytes,1,opt,name=lat_lng,json=latLng" json:"lat_lng,omitempty"`
}

func (m *LocationInfo) Reset()                    { *m = LocationInfo{} }
func (m *LocationInfo) String() string            { return proto.CompactTextString(m) }
func (*LocationInfo) ProtoMessage()               {}
func (*LocationInfo) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{4} }

func (m *LocationInfo) GetLatLng() *google_type1.LatLng {
	if m != nil {
		return m.LatLng
	}
	return nil
}

// A `Property` consists of a user-supplied name/value pair.
type Property struct {
	// Name of the property.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Value of the property.
	Value string `protobuf:"bytes,2,opt,name=value" json:"value,omitempty"`
	// Value of numeric properties.
	Uint64Value uint64 `protobuf:"varint,3,opt,name=uint64_value,json=uint64Value" json:"uint64_value,omitempty"`
}

func (m *Property) Reset()                    { *m = Property{} }
func (m *Property) String() string            { return proto.CompactTextString(m) }
func (*Property) ProtoMessage()               {}
func (*Property) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{5} }

func (m *Property) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Property) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

func (m *Property) GetUint64Value() uint64 {
	if m != nil {
		return m.Uint64Value
	}
	return 0
}

// Set of detected entity features.
type EntityAnnotation struct {
	// Opaque entity ID. Some IDs may be available in
	// [Google Knowledge Graph Search
	// API](https://developers.google.com/knowledge-graph/).
	Mid string `protobuf:"bytes,1,opt,name=mid" json:"mid,omitempty"`
	// The language code for the locale in which the entity textual
	// `description` is expressed.
	Locale string `protobuf:"bytes,2,opt,name=locale" json:"locale,omitempty"`
	// Entity textual description, expressed in its `locale` language.
	Description string `protobuf:"bytes,3,opt,name=description" json:"description,omitempty"`
	// Overall score of the result. Range [0, 1].
	Score float32 `protobuf:"fixed32,4,opt,name=score" json:"score,omitempty"`
	// **Deprecated. Use `score` instead.**
	// The accuracy of the entity detection in an image.
	// For example, for an image in which the "Eiffel Tower" entity is detected,
	// this field represents the confidence that there is a tower in the query
	// image. Range [0, 1].
	Confidence float32 `protobuf:"fixed32,5,opt,name=confidence" json:"confidence,omitempty"`
	// The relevancy of the ICA (Image Content Annotation) label to the
	// image. For example, the relevancy of "tower" is likely higher to an image
	// containing the detected "Eiffel Tower" than to an image containing a
	// detected distant towering building, even though the confidence that
	// there is a tower in each image may be the same. Range [0, 1].
	Topicality float32 `protobuf:"fixed32,6,opt,name=topicality" json:"topicality,omitempty"`
	// Image region to which this entity belongs. Not produced
	// for `LABEL_DETECTION` features.
	BoundingPoly *BoundingPoly `protobuf:"bytes,7,opt,name=bounding_poly,json=boundingPoly" json:"bounding_poly,omitempty"`
	// The location information for the detected entity. Multiple
	// `LocationInfo` elements can be present because one location may
	// indicate the location of the scene in the image, and another location
	// may indicate the location of the place where the image was taken.
	// Location information is usually present for landmarks.
	Locations []*LocationInfo `protobuf:"bytes,8,rep,name=locations" json:"locations,omitempty"`
	// Some entities may have optional user-supplied `Property` (name/value)
	// fields, such a score or string that qualifies the entity.
	Properties []*Property `protobuf:"bytes,9,rep,name=properties" json:"properties,omitempty"`
}

func (m *EntityAnnotation) Reset()                    { *m = EntityAnnotation{} }
func (m *EntityAnnotation) String() string            { return proto.CompactTextString(m) }
func (*EntityAnnotation) ProtoMessage()               {}
func (*EntityAnnotation) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{6} }

func (m *EntityAnnotation) GetMid() string {
	if m != nil {
		return m.Mid
	}
	return ""
}

func (m *EntityAnnotation) GetLocale() string {
	if m != nil {
		return m.Locale
	}
	return ""
}

func (m *EntityAnnotation) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *EntityAnnotation) GetScore() float32 {
	if m != nil {
		return m.Score
	}
	return 0
}

func (m *EntityAnnotation) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

func (m *EntityAnnotation) GetTopicality() float32 {
	if m != nil {
		return m.Topicality
	}
	return 0
}

func (m *EntityAnnotation) GetBoundingPoly() *BoundingPoly {
	if m != nil {
		return m.BoundingPoly
	}
	return nil
}

func (m *EntityAnnotation) GetLocations() []*LocationInfo {
	if m != nil {
		return m.Locations
	}
	return nil
}

func (m *EntityAnnotation) GetProperties() []*Property {
	if m != nil {
		return m.Properties
	}
	return nil
}

// Set of features pertaining to the image, computed by computer vision
// methods over safe-search verticals (for example, adult, spoof, medical,
// violence).
type SafeSearchAnnotation struct {
	// Represents the adult content likelihood for the image. Adult content may
	// contain elements such as nudity, pornographic images or cartoons, or
	// sexual activities.
	Adult Likelihood `protobuf:"varint,1,opt,name=adult,enum=google.cloud.vision.v1p2beta1.Likelihood" json:"adult,omitempty"`
	// Spoof likelihood. The likelihood that an modification
	// was made to the image's canonical version to make it appear
	// funny or offensive.
	Spoof Likelihood `protobuf:"varint,2,opt,name=spoof,enum=google.cloud.vision.v1p2beta1.Likelihood" json:"spoof,omitempty"`
	// Likelihood that this is a medical image.
	Medical Likelihood `protobuf:"varint,3,opt,name=medical,enum=google.cloud.vision.v1p2beta1.Likelihood" json:"medical,omitempty"`
	// Likelihood that this image contains violent content.
	Violence Likelihood `protobuf:"varint,4,opt,name=violence,enum=google.cloud.vision.v1p2beta1.Likelihood" json:"violence,omitempty"`
	// Likelihood that the request image contains racy content. Racy content may
	// include (but is not limited to) skimpy or sheer clothing, strategically
	// covered nudity, lewd or provocative poses, or close-ups of sensitive
	// body areas.
	Racy Likelihood `protobuf:"varint,9,opt,name=racy,enum=google.cloud.vision.v1p2beta1.Likelihood" json:"racy,omitempty"`
}

func (m *SafeSearchAnnotation) Reset()                    { *m = SafeSearchAnnotation{} }
func (m *SafeSearchAnnotation) String() string            { return proto.CompactTextString(m) }
func (*SafeSearchAnnotation) ProtoMessage()               {}
func (*SafeSearchAnnotation) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{7} }

func (m *SafeSearchAnnotation) GetAdult() Likelihood {
	if m != nil {
		return m.Adult
	}
	return Likelihood_UNKNOWN
}

func (m *SafeSearchAnnotation) GetSpoof() Likelihood {
	if m != nil {
		return m.Spoof
	}
	return Likelihood_UNKNOWN
}

func (m *SafeSearchAnnotation) GetMedical() Likelihood {
	if m != nil {
		return m.Medical
	}
	return Likelihood_UNKNOWN
}

func (m *SafeSearchAnnotation) GetViolence() Likelihood {
	if m != nil {
		return m.Violence
	}
	return Likelihood_UNKNOWN
}

func (m *SafeSearchAnnotation) GetRacy() Likelihood {
	if m != nil {
		return m.Racy
	}
	return Likelihood_UNKNOWN
}

// Rectangle determined by min and max `LatLng` pairs.
type LatLongRect struct {
	// Min lat/long pair.
	MinLatLng *google_type1.LatLng `protobuf:"bytes,1,opt,name=min_lat_lng,json=minLatLng" json:"min_lat_lng,omitempty"`
	// Max lat/long pair.
	MaxLatLng *google_type1.LatLng `protobuf:"bytes,2,opt,name=max_lat_lng,json=maxLatLng" json:"max_lat_lng,omitempty"`
}

func (m *LatLongRect) Reset()                    { *m = LatLongRect{} }
func (m *LatLongRect) String() string            { return proto.CompactTextString(m) }
func (*LatLongRect) ProtoMessage()               {}
func (*LatLongRect) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{8} }

func (m *LatLongRect) GetMinLatLng() *google_type1.LatLng {
	if m != nil {
		return m.MinLatLng
	}
	return nil
}

func (m *LatLongRect) GetMaxLatLng() *google_type1.LatLng {
	if m != nil {
		return m.MaxLatLng
	}
	return nil
}

// Color information consists of RGB channels, score, and the fraction of
// the image that the color occupies in the image.
type ColorInfo struct {
	// RGB components of the color.
	Color *google_type.Color `protobuf:"bytes,1,opt,name=color" json:"color,omitempty"`
	// Image-specific score for this color. Value in range [0, 1].
	Score float32 `protobuf:"fixed32,2,opt,name=score" json:"score,omitempty"`
	// The fraction of pixels the color occupies in the image.
	// Value in range [0, 1].
	PixelFraction float32 `protobuf:"fixed32,3,opt,name=pixel_fraction,json=pixelFraction" json:"pixel_fraction,omitempty"`
}

func (m *ColorInfo) Reset()                    { *m = ColorInfo{} }
func (m *ColorInfo) String() string            { return proto.CompactTextString(m) }
func (*ColorInfo) ProtoMessage()               {}
func (*ColorInfo) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{9} }

func (m *ColorInfo) GetColor() *google_type.Color {
	if m != nil {
		return m.Color
	}
	return nil
}

func (m *ColorInfo) GetScore() float32 {
	if m != nil {
		return m.Score
	}
	return 0
}

func (m *ColorInfo) GetPixelFraction() float32 {
	if m != nil {
		return m.PixelFraction
	}
	return 0
}

// Set of dominant colors and their corresponding scores.
type DominantColorsAnnotation struct {
	// RGB color values with their score and pixel fraction.
	Colors []*ColorInfo `protobuf:"bytes,1,rep,name=colors" json:"colors,omitempty"`
}

func (m *DominantColorsAnnotation) Reset()                    { *m = DominantColorsAnnotation{} }
func (m *DominantColorsAnnotation) String() string            { return proto.CompactTextString(m) }
func (*DominantColorsAnnotation) ProtoMessage()               {}
func (*DominantColorsAnnotation) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{10} }

func (m *DominantColorsAnnotation) GetColors() []*ColorInfo {
	if m != nil {
		return m.Colors
	}
	return nil
}

// Stores image properties, such as dominant colors.
type ImageProperties struct {
	// If present, dominant colors completed successfully.
	DominantColors *DominantColorsAnnotation `protobuf:"bytes,1,opt,name=dominant_colors,json=dominantColors" json:"dominant_colors,omitempty"`
}

func (m *ImageProperties) Reset()                    { *m = ImageProperties{} }
func (m *ImageProperties) String() string            { return proto.CompactTextString(m) }
func (*ImageProperties) ProtoMessage()               {}
func (*ImageProperties) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{11} }

func (m *ImageProperties) GetDominantColors() *DominantColorsAnnotation {
	if m != nil {
		return m.DominantColors
	}
	return nil
}

// Single crop hint that is used to generate a new crop when serving an image.
type CropHint struct {
	// The bounding polygon for the crop region. The coordinates of the bounding
	// box are in the original image's scale, as returned in `ImageParams`.
	BoundingPoly *BoundingPoly `protobuf:"bytes,1,opt,name=bounding_poly,json=boundingPoly" json:"bounding_poly,omitempty"`
	// Confidence of this being a salient region.  Range [0, 1].
	Confidence float32 `protobuf:"fixed32,2,opt,name=confidence" json:"confidence,omitempty"`
	// Fraction of importance of this salient region with respect to the original
	// image.
	ImportanceFraction float32 `protobuf:"fixed32,3,opt,name=importance_fraction,json=importanceFraction" json:"importance_fraction,omitempty"`
}

func (m *CropHint) Reset()                    { *m = CropHint{} }
func (m *CropHint) String() string            { return proto.CompactTextString(m) }
func (*CropHint) ProtoMessage()               {}
func (*CropHint) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{12} }

func (m *CropHint) GetBoundingPoly() *BoundingPoly {
	if m != nil {
		return m.BoundingPoly
	}
	return nil
}

func (m *CropHint) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

func (m *CropHint) GetImportanceFraction() float32 {
	if m != nil {
		return m.ImportanceFraction
	}
	return 0
}

// Set of crop hints that are used to generate new crops when serving images.
type CropHintsAnnotation struct {
	// Crop hint results.
	CropHints []*CropHint `protobuf:"bytes,1,rep,name=crop_hints,json=cropHints" json:"crop_hints,omitempty"`
}

func (m *CropHintsAnnotation) Reset()                    { *m = CropHintsAnnotation{} }
func (m *CropHintsAnnotation) String() string            { return proto.CompactTextString(m) }
func (*CropHintsAnnotation) ProtoMessage()               {}
func (*CropHintsAnnotation) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{13} }

func (m *CropHintsAnnotation) GetCropHints() []*CropHint {
	if m != nil {
		return m.CropHints
	}
	return nil
}

// Parameters for crop hints annotation request.
type CropHintsParams struct {
	// Aspect ratios in floats, representing the ratio of the width to the height
	// of the image. For example, if the desired aspect ratio is 4/3, the
	// corresponding float value should be 1.33333.  If not specified, the
	// best possible crop is returned. The number of provided aspect ratios is
	// limited to a maximum of 16; any aspect ratios provided after the 16th are
	// ignored.
	AspectRatios []float32 `protobuf:"fixed32,1,rep,packed,name=aspect_ratios,json=aspectRatios" json:"aspect_ratios,omitempty"`
}

func (m *CropHintsParams) Reset()                    { *m = CropHintsParams{} }
func (m *CropHintsParams) String() string            { return proto.CompactTextString(m) }
func (*CropHintsParams) ProtoMessage()               {}
func (*CropHintsParams) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{14} }

func (m *CropHintsParams) GetAspectRatios() []float32 {
	if m != nil {
		return m.AspectRatios
	}
	return nil
}

// Parameters for web detection request.
type WebDetectionParams struct {
	// Whether to include results derived from the geo information in the image.
	IncludeGeoResults bool `protobuf:"varint,2,opt,name=include_geo_results,json=includeGeoResults" json:"include_geo_results,omitempty"`
}

func (m *WebDetectionParams) Reset()                    { *m = WebDetectionParams{} }
func (m *WebDetectionParams) String() string            { return proto.CompactTextString(m) }
func (*WebDetectionParams) ProtoMessage()               {}
func (*WebDetectionParams) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{15} }

func (m *WebDetectionParams) GetIncludeGeoResults() bool {
	if m != nil {
		return m.IncludeGeoResults
	}
	return false
}

// Image context and/or feature-specific parameters.
type ImageContext struct {
	// lat/long rectangle that specifies the location of the image.
	LatLongRect *LatLongRect `protobuf:"bytes,1,opt,name=lat_long_rect,json=latLongRect" json:"lat_long_rect,omitempty"`
	// List of languages to use for TEXT_DETECTION. In most cases, an empty value
	// yields the best results since it enables automatic language detection. For
	// languages based on the Latin alphabet, setting `language_hints` is not
	// needed. In rare cases, when the language of the text in the image is known,
	// setting a hint will help get better results (although it will be a
	// significant hindrance if the hint is wrong). Text detection returns an
	// error if one or more of the specified languages is not one of the
	// [supported languages](/vision/docs/languages).
	LanguageHints []string `protobuf:"bytes,2,rep,name=language_hints,json=languageHints" json:"language_hints,omitempty"`
	// Parameters for crop hints annotation request.
	CropHintsParams *CropHintsParams `protobuf:"bytes,4,opt,name=crop_hints_params,json=cropHintsParams" json:"crop_hints_params,omitempty"`
	// Parameters for web detection.
	WebDetectionParams *WebDetectionParams `protobuf:"bytes,6,opt,name=web_detection_params,json=webDetectionParams" json:"web_detection_params,omitempty"`
}

func (m *ImageContext) Reset()                    { *m = ImageContext{} }
func (m *ImageContext) String() string            { return proto.CompactTextString(m) }
func (*ImageContext) ProtoMessage()               {}
func (*ImageContext) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{16} }

func (m *ImageContext) GetLatLongRect() *LatLongRect {
	if m != nil {
		return m.LatLongRect
	}
	return nil
}

func (m *ImageContext) GetLanguageHints() []string {
	if m != nil {
		return m.LanguageHints
	}
	return nil
}

func (m *ImageContext) GetCropHintsParams() *CropHintsParams {
	if m != nil {
		return m.CropHintsParams
	}
	return nil
}

func (m *ImageContext) GetWebDetectionParams() *WebDetectionParams {
	if m != nil {
		return m.WebDetectionParams
	}
	return nil
}

// Request for performing Google Cloud Vision API tasks over a user-provided
// image, with user-requested features.
type AnnotateImageRequest struct {
	// The image to be processed.
	Image *Image `protobuf:"bytes,1,opt,name=image" json:"image,omitempty"`
	// Requested features.
	Features []*Feature `protobuf:"bytes,2,rep,name=features" json:"features,omitempty"`
	// Additional context that may accompany the image.
	ImageContext *ImageContext `protobuf:"bytes,3,opt,name=image_context,json=imageContext" json:"image_context,omitempty"`
}

func (m *AnnotateImageRequest) Reset()                    { *m = AnnotateImageRequest{} }
func (m *AnnotateImageRequest) String() string            { return proto.CompactTextString(m) }
func (*AnnotateImageRequest) ProtoMessage()               {}
func (*AnnotateImageRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{17} }

func (m *AnnotateImageRequest) GetImage() *Image {
	if m != nil {
		return m.Image
	}
	return nil
}

func (m *AnnotateImageRequest) GetFeatures() []*Feature {
	if m != nil {
		return m.Features
	}
	return nil
}

func (m *AnnotateImageRequest) GetImageContext() *ImageContext {
	if m != nil {
		return m.ImageContext
	}
	return nil
}

// If an image was produced from a file (e.g. a PDF), this message gives
// information about the source of that image.
type ImageAnnotationContext struct {
	// The URI of the file used to produce the image.
	Uri string `protobuf:"bytes,1,opt,name=uri" json:"uri,omitempty"`
	// If the file was a PDF or TIFF, this field gives the page number within
	// the file used to produce the image.
	PageNumber int32 `protobuf:"varint,2,opt,name=page_number,json=pageNumber" json:"page_number,omitempty"`
}

func (m *ImageAnnotationContext) Reset()                    { *m = ImageAnnotationContext{} }
func (m *ImageAnnotationContext) String() string            { return proto.CompactTextString(m) }
func (*ImageAnnotationContext) ProtoMessage()               {}
func (*ImageAnnotationContext) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{18} }

func (m *ImageAnnotationContext) GetUri() string {
	if m != nil {
		return m.Uri
	}
	return ""
}

func (m *ImageAnnotationContext) GetPageNumber() int32 {
	if m != nil {
		return m.PageNumber
	}
	return 0
}

// Response to an image annotation request.
type AnnotateImageResponse struct {
	// If present, face detection has completed successfully.
	FaceAnnotations []*FaceAnnotation `protobuf:"bytes,1,rep,name=face_annotations,json=faceAnnotations" json:"face_annotations,omitempty"`
	// If present, landmark detection has completed successfully.
	LandmarkAnnotations []*EntityAnnotation `protobuf:"bytes,2,rep,name=landmark_annotations,json=landmarkAnnotations" json:"landmark_annotations,omitempty"`
	// If present, logo detection has completed successfully.
	LogoAnnotations []*EntityAnnotation `protobuf:"bytes,3,rep,name=logo_annotations,json=logoAnnotations" json:"logo_annotations,omitempty"`
	// If present, label detection has completed successfully.
	LabelAnnotations []*EntityAnnotation `protobuf:"bytes,4,rep,name=label_annotations,json=labelAnnotations" json:"label_annotations,omitempty"`
	// If present, text (OCR) detection has completed successfully.
	TextAnnotations []*EntityAnnotation `protobuf:"bytes,5,rep,name=text_annotations,json=textAnnotations" json:"text_annotations,omitempty"`
	// If present, text (OCR) detection or document (OCR) text detection has
	// completed successfully.
	// This annotation provides the structural hierarchy for the OCR detected
	// text.
	FullTextAnnotation *TextAnnotation `protobuf:"bytes,12,opt,name=full_text_annotation,json=fullTextAnnotation" json:"full_text_annotation,omitempty"`
	// If present, safe-search annotation has completed successfully.
	SafeSearchAnnotation *SafeSearchAnnotation `protobuf:"bytes,6,opt,name=safe_search_annotation,json=safeSearchAnnotation" json:"safe_search_annotation,omitempty"`
	// If present, image properties were extracted successfully.
	ImagePropertiesAnnotation *ImageProperties `protobuf:"bytes,8,opt,name=image_properties_annotation,json=imagePropertiesAnnotation" json:"image_properties_annotation,omitempty"`
	// If present, crop hints have completed successfully.
	CropHintsAnnotation *CropHintsAnnotation `protobuf:"bytes,11,opt,name=crop_hints_annotation,json=cropHintsAnnotation" json:"crop_hints_annotation,omitempty"`
	// If present, web detection has completed successfully.
	WebDetection *WebDetection `protobuf:"bytes,13,opt,name=web_detection,json=webDetection" json:"web_detection,omitempty"`
	// If set, represents the error message for the operation.
	// Note that filled-in image annotations are guaranteed to be
	// correct, even when `error` is set.
	Error *google_rpc.Status `protobuf:"bytes,9,opt,name=error" json:"error,omitempty"`
	// If present, contextual information is needed to understand where this image
	// comes from.
	Context *ImageAnnotationContext `protobuf:"bytes,21,opt,name=context" json:"context,omitempty"`
}

func (m *AnnotateImageResponse) Reset()                    { *m = AnnotateImageResponse{} }
func (m *AnnotateImageResponse) String() string            { return proto.CompactTextString(m) }
func (*AnnotateImageResponse) ProtoMessage()               {}
func (*AnnotateImageResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{19} }

func (m *AnnotateImageResponse) GetFaceAnnotations() []*FaceAnnotation {
	if m != nil {
		return m.FaceAnnotations
	}
	return nil
}

func (m *AnnotateImageResponse) GetLandmarkAnnotations() []*EntityAnnotation {
	if m != nil {
		return m.LandmarkAnnotations
	}
	return nil
}

func (m *AnnotateImageResponse) GetLogoAnnotations() []*EntityAnnotation {
	if m != nil {
		return m.LogoAnnotations
	}
	return nil
}

func (m *AnnotateImageResponse) GetLabelAnnotations() []*EntityAnnotation {
	if m != nil {
		return m.LabelAnnotations
	}
	return nil
}

func (m *AnnotateImageResponse) GetTextAnnotations() []*EntityAnnotation {
	if m != nil {
		return m.TextAnnotations
	}
	return nil
}

func (m *AnnotateImageResponse) GetFullTextAnnotation() *TextAnnotation {
	if m != nil {
		return m.FullTextAnnotation
	}
	return nil
}

func (m *AnnotateImageResponse) GetSafeSearchAnnotation() *SafeSearchAnnotation {
	if m != nil {
		return m.SafeSearchAnnotation
	}
	return nil
}

func (m *AnnotateImageResponse) GetImagePropertiesAnnotation() *ImageProperties {
	if m != nil {
		return m.ImagePropertiesAnnotation
	}
	return nil
}

func (m *AnnotateImageResponse) GetCropHintsAnnotation() *CropHintsAnnotation {
	if m != nil {
		return m.CropHintsAnnotation
	}
	return nil
}

func (m *AnnotateImageResponse) GetWebDetection() *WebDetection {
	if m != nil {
		return m.WebDetection
	}
	return nil
}

func (m *AnnotateImageResponse) GetError() *google_rpc.Status {
	if m != nil {
		return m.Error
	}
	return nil
}

func (m *AnnotateImageResponse) GetContext() *ImageAnnotationContext {
	if m != nil {
		return m.Context
	}
	return nil
}

// Multiple image annotation requests are batched into a single service call.
type BatchAnnotateImagesRequest struct {
	// Individual image annotation requests for this batch.
	Requests []*AnnotateImageRequest `protobuf:"bytes,1,rep,name=requests" json:"requests,omitempty"`
}

func (m *BatchAnnotateImagesRequest) Reset()                    { *m = BatchAnnotateImagesRequest{} }
func (m *BatchAnnotateImagesRequest) String() string            { return proto.CompactTextString(m) }
func (*BatchAnnotateImagesRequest) ProtoMessage()               {}
func (*BatchAnnotateImagesRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{20} }

func (m *BatchAnnotateImagesRequest) GetRequests() []*AnnotateImageRequest {
	if m != nil {
		return m.Requests
	}
	return nil
}

// Response to a batch image annotation request.
type BatchAnnotateImagesResponse struct {
	// Individual responses to image annotation requests within the batch.
	Responses []*AnnotateImageResponse `protobuf:"bytes,1,rep,name=responses" json:"responses,omitempty"`
}

func (m *BatchAnnotateImagesResponse) Reset()                    { *m = BatchAnnotateImagesResponse{} }
func (m *BatchAnnotateImagesResponse) String() string            { return proto.CompactTextString(m) }
func (*BatchAnnotateImagesResponse) ProtoMessage()               {}
func (*BatchAnnotateImagesResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{21} }

func (m *BatchAnnotateImagesResponse) GetResponses() []*AnnotateImageResponse {
	if m != nil {
		return m.Responses
	}
	return nil
}

// An offline file annotation request.
type AsyncAnnotateFileRequest struct {
	// Required. Information about the input file.
	InputConfig *InputConfig `protobuf:"bytes,1,opt,name=input_config,json=inputConfig" json:"input_config,omitempty"`
	// Required. Requested features.
	Features []*Feature `protobuf:"bytes,2,rep,name=features" json:"features,omitempty"`
	// Additional context that may accompany the image(s) in the file.
	ImageContext *ImageContext `protobuf:"bytes,3,opt,name=image_context,json=imageContext" json:"image_context,omitempty"`
	// Required. The desired output location and metadata (e.g. format).
	OutputConfig *OutputConfig `protobuf:"bytes,4,opt,name=output_config,json=outputConfig" json:"output_config,omitempty"`
}

func (m *AsyncAnnotateFileRequest) Reset()                    { *m = AsyncAnnotateFileRequest{} }
func (m *AsyncAnnotateFileRequest) String() string            { return proto.CompactTextString(m) }
func (*AsyncAnnotateFileRequest) ProtoMessage()               {}
func (*AsyncAnnotateFileRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{22} }

func (m *AsyncAnnotateFileRequest) GetInputConfig() *InputConfig {
	if m != nil {
		return m.InputConfig
	}
	return nil
}

func (m *AsyncAnnotateFileRequest) GetFeatures() []*Feature {
	if m != nil {
		return m.Features
	}
	return nil
}

func (m *AsyncAnnotateFileRequest) GetImageContext() *ImageContext {
	if m != nil {
		return m.ImageContext
	}
	return nil
}

func (m *AsyncAnnotateFileRequest) GetOutputConfig() *OutputConfig {
	if m != nil {
		return m.OutputConfig
	}
	return nil
}

// The response for a single offline file annotation request.
type AsyncAnnotateFileResponse struct {
	// The output location and metadata from AsyncAnnotateFileRequest.
	OutputConfig *OutputConfig `protobuf:"bytes,1,opt,name=output_config,json=outputConfig" json:"output_config,omitempty"`
}

func (m *AsyncAnnotateFileResponse) Reset()                    { *m = AsyncAnnotateFileResponse{} }
func (m *AsyncAnnotateFileResponse) String() string            { return proto.CompactTextString(m) }
func (*AsyncAnnotateFileResponse) ProtoMessage()               {}
func (*AsyncAnnotateFileResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{23} }

func (m *AsyncAnnotateFileResponse) GetOutputConfig() *OutputConfig {
	if m != nil {
		return m.OutputConfig
	}
	return nil
}

// Multiple async file annotation requests are batched into a single service
// call.
type AsyncBatchAnnotateFilesRequest struct {
	// Individual async file annotation requests for this batch.
	Requests []*AsyncAnnotateFileRequest `protobuf:"bytes,1,rep,name=requests" json:"requests,omitempty"`
}

func (m *AsyncBatchAnnotateFilesRequest) Reset()                    { *m = AsyncBatchAnnotateFilesRequest{} }
func (m *AsyncBatchAnnotateFilesRequest) String() string            { return proto.CompactTextString(m) }
func (*AsyncBatchAnnotateFilesRequest) ProtoMessage()               {}
func (*AsyncBatchAnnotateFilesRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{24} }

func (m *AsyncBatchAnnotateFilesRequest) GetRequests() []*AsyncAnnotateFileRequest {
	if m != nil {
		return m.Requests
	}
	return nil
}

// Response to an async batch file annotation request.
type AsyncBatchAnnotateFilesResponse struct {
	// The list of file annotation responses, one for each request in
	// AsyncBatchAnnotateFilesRequest.
	Responses []*AsyncAnnotateFileResponse `protobuf:"bytes,1,rep,name=responses" json:"responses,omitempty"`
}

func (m *AsyncBatchAnnotateFilesResponse) Reset()         { *m = AsyncBatchAnnotateFilesResponse{} }
func (m *AsyncBatchAnnotateFilesResponse) String() string { return proto.CompactTextString(m) }
func (*AsyncBatchAnnotateFilesResponse) ProtoMessage()    {}
func (*AsyncBatchAnnotateFilesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor1, []int{25}
}

func (m *AsyncBatchAnnotateFilesResponse) GetResponses() []*AsyncAnnotateFileResponse {
	if m != nil {
		return m.Responses
	}
	return nil
}

// The desired input location and metadata.
type InputConfig struct {
	// The Google Cloud Storage location to read the input from.
	GcsSource *GcsSource `protobuf:"bytes,1,opt,name=gcs_source,json=gcsSource" json:"gcs_source,omitempty"`
	// The type of the file. Currently only "application/pdf" and "image/tiff"
	// are supported. Wildcards are not supported.
	MimeType string `protobuf:"bytes,2,opt,name=mime_type,json=mimeType" json:"mime_type,omitempty"`
}

func (m *InputConfig) Reset()                    { *m = InputConfig{} }
func (m *InputConfig) String() string            { return proto.CompactTextString(m) }
func (*InputConfig) ProtoMessage()               {}
func (*InputConfig) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{26} }

func (m *InputConfig) GetGcsSource() *GcsSource {
	if m != nil {
		return m.GcsSource
	}
	return nil
}

func (m *InputConfig) GetMimeType() string {
	if m != nil {
		return m.MimeType
	}
	return ""
}

// The desired output location and metadata.
type OutputConfig struct {
	// The Google Cloud Storage location to write the output(s) to.
	GcsDestination *GcsDestination `protobuf:"bytes,1,opt,name=gcs_destination,json=gcsDestination" json:"gcs_destination,omitempty"`
	// The max number of response protos to put into each output JSON file on GCS.
	// The valid range is [1, 100]. If not specified, the default value is 20.
	//
	// For example, for one pdf file with 100 pages, 100 response protos will
	// be generated. If `batch_size` = 20, then 5 json files each
	// containing 20 response protos will be written under the prefix
	// `gcs_destination`.`uri`.
	//
	// Currently, batch_size only applies to GcsDestination, with potential future
	// support for other output configurations.
	BatchSize int32 `protobuf:"varint,2,opt,name=batch_size,json=batchSize" json:"batch_size,omitempty"`
}

func (m *OutputConfig) Reset()                    { *m = OutputConfig{} }
func (m *OutputConfig) String() string            { return proto.CompactTextString(m) }
func (*OutputConfig) ProtoMessage()               {}
func (*OutputConfig) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{27} }

func (m *OutputConfig) GetGcsDestination() *GcsDestination {
	if m != nil {
		return m.GcsDestination
	}
	return nil
}

func (m *OutputConfig) GetBatchSize() int32 {
	if m != nil {
		return m.BatchSize
	}
	return 0
}

// The Google Cloud Storage location where the input will be read from.
type GcsSource struct {
	// Google Cloud Storage URI for the input file. This must only be a GCS
	// object. Wildcards are not currently supported.
	Uri string `protobuf:"bytes,1,opt,name=uri" json:"uri,omitempty"`
}

func (m *GcsSource) Reset()                    { *m = GcsSource{} }
func (m *GcsSource) String() string            { return proto.CompactTextString(m) }
func (*GcsSource) ProtoMessage()               {}
func (*GcsSource) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{28} }

func (m *GcsSource) GetUri() string {
	if m != nil {
		return m.Uri
	}
	return ""
}

// The Google Cloud Storage location where the output will be written to.
type GcsDestination struct {
	// Google Cloud Storage URI where the results will be stored. Results will
	// be in JSON format and preceded by its corresponding input URI. This field
	// can either represent a single file, or a prefix for multiple outputs.
	// Prefixes must end in a `/`.
	//
	// Examples:
	//
	// *    File: gs://bucket-name/filename.json
	// *    Prefix: gs://bucket-name/prefix/here/
	// *    File: gs://bucket-name/prefix/here
	//
	// If multiple outputs, each response is still AnnotateFileResponse, each of
	// which contains some subset of the full list of AnnotateImageResponse.
	// Multiple outputs can happen if, for example, the output JSON is too large
	// and overflows into multiple sharded files.
	Uri string `protobuf:"bytes,1,opt,name=uri" json:"uri,omitempty"`
}

func (m *GcsDestination) Reset()                    { *m = GcsDestination{} }
func (m *GcsDestination) String() string            { return proto.CompactTextString(m) }
func (*GcsDestination) ProtoMessage()               {}
func (*GcsDestination) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{29} }

func (m *GcsDestination) GetUri() string {
	if m != nil {
		return m.Uri
	}
	return ""
}

// Contains metadata for the BatchAnnotateImages operation.
type OperationMetadata struct {
	// Current state of the batch operation.
	State OperationMetadata_State `protobuf:"varint,1,opt,name=state,enum=google.cloud.vision.v1p2beta1.OperationMetadata_State" json:"state,omitempty"`
	// The time when the batch request was received.
	CreateTime *google_protobuf3.Timestamp `protobuf:"bytes,5,opt,name=create_time,json=createTime" json:"create_time,omitempty"`
	// The time when the operation result was last updated.
	UpdateTime *google_protobuf3.Timestamp `protobuf:"bytes,6,opt,name=update_time,json=updateTime" json:"update_time,omitempty"`
}

func (m *OperationMetadata) Reset()                    { *m = OperationMetadata{} }
func (m *OperationMetadata) String() string            { return proto.CompactTextString(m) }
func (*OperationMetadata) ProtoMessage()               {}
func (*OperationMetadata) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{30} }

func (m *OperationMetadata) GetState() OperationMetadata_State {
	if m != nil {
		return m.State
	}
	return OperationMetadata_STATE_UNSPECIFIED
}

func (m *OperationMetadata) GetCreateTime() *google_protobuf3.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *OperationMetadata) GetUpdateTime() *google_protobuf3.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

func init() {
	proto.RegisterType((*Feature)(nil), "google.cloud.vision.v1p2beta1.Feature")
	proto.RegisterType((*ImageSource)(nil), "google.cloud.vision.v1p2beta1.ImageSource")
	proto.RegisterType((*Image)(nil), "google.cloud.vision.v1p2beta1.Image")
	proto.RegisterType((*FaceAnnotation)(nil), "google.cloud.vision.v1p2beta1.FaceAnnotation")
	proto.RegisterType((*FaceAnnotation_Landmark)(nil), "google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark")
	proto.RegisterType((*LocationInfo)(nil), "google.cloud.vision.v1p2beta1.LocationInfo")
	proto.RegisterType((*Property)(nil), "google.cloud.vision.v1p2beta1.Property")
	proto.RegisterType((*EntityAnnotation)(nil), "google.cloud.vision.v1p2beta1.EntityAnnotation")
	proto.RegisterType((*SafeSearchAnnotation)(nil), "google.cloud.vision.v1p2beta1.SafeSearchAnnotation")
	proto.RegisterType((*LatLongRect)(nil), "google.cloud.vision.v1p2beta1.LatLongRect")
	proto.RegisterType((*ColorInfo)(nil), "google.cloud.vision.v1p2beta1.ColorInfo")
	proto.RegisterType((*DominantColorsAnnotation)(nil), "google.cloud.vision.v1p2beta1.DominantColorsAnnotation")
	proto.RegisterType((*ImageProperties)(nil), "google.cloud.vision.v1p2beta1.ImageProperties")
	proto.RegisterType((*CropHint)(nil), "google.cloud.vision.v1p2beta1.CropHint")
	proto.RegisterType((*CropHintsAnnotation)(nil), "google.cloud.vision.v1p2beta1.CropHintsAnnotation")
	proto.RegisterType((*CropHintsParams)(nil), "google.cloud.vision.v1p2beta1.CropHintsParams")
	proto.RegisterType((*WebDetectionParams)(nil), "google.cloud.vision.v1p2beta1.WebDetectionParams")
	proto.RegisterType((*ImageContext)(nil), "google.cloud.vision.v1p2beta1.ImageContext")
	proto.RegisterType((*AnnotateImageRequest)(nil), "google.cloud.vision.v1p2beta1.AnnotateImageRequest")
	proto.RegisterType((*ImageAnnotationContext)(nil), "google.cloud.vision.v1p2beta1.ImageAnnotationContext")
	proto.RegisterType((*AnnotateImageResponse)(nil), "google.cloud.vision.v1p2beta1.AnnotateImageResponse")
	proto.RegisterType((*BatchAnnotateImagesRequest)(nil), "google.cloud.vision.v1p2beta1.BatchAnnotateImagesRequest")
	proto.RegisterType((*BatchAnnotateImagesResponse)(nil), "google.cloud.vision.v1p2beta1.BatchAnnotateImagesResponse")
	proto.RegisterType((*AsyncAnnotateFileRequest)(nil), "google.cloud.vision.v1p2beta1.AsyncAnnotateFileRequest")
	proto.RegisterType((*AsyncAnnotateFileResponse)(nil), "google.cloud.vision.v1p2beta1.AsyncAnnotateFileResponse")
	proto.RegisterType((*AsyncBatchAnnotateFilesRequest)(nil), "google.cloud.vision.v1p2beta1.AsyncBatchAnnotateFilesRequest")
	proto.RegisterType((*AsyncBatchAnnotateFilesResponse)(nil), "google.cloud.vision.v1p2beta1.AsyncBatchAnnotateFilesResponse")
	proto.RegisterType((*InputConfig)(nil), "google.cloud.vision.v1p2beta1.InputConfig")
	proto.RegisterType((*OutputConfig)(nil), "google.cloud.vision.v1p2beta1.OutputConfig")
	proto.RegisterType((*GcsSource)(nil), "google.cloud.vision.v1p2beta1.GcsSource")
	proto.RegisterType((*GcsDestination)(nil), "google.cloud.vision.v1p2beta1.GcsDestination")
	proto.RegisterType((*OperationMetadata)(nil), "google.cloud.vision.v1p2beta1.OperationMetadata")
	proto.RegisterEnum("google.cloud.vision.v1p2beta1.Likelihood", Likelihood_name, Likelihood_value)
	proto.RegisterEnum("google.cloud.vision.v1p2beta1.Feature_Type", Feature_Type_name, Feature_Type_value)
	proto.RegisterEnum("google.cloud.vision.v1p2beta1.FaceAnnotation_Landmark_Type", FaceAnnotation_Landmark_Type_name, FaceAnnotation_Landmark_Type_value)
	proto.RegisterEnum("google.cloud.vision.v1p2beta1.OperationMetadata_State", OperationMetadata_State_name, OperationMetadata_State_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for ImageAnnotator service

type ImageAnnotatorClient interface {
	// Run image detection and annotation for a batch of images.
	BatchAnnotateImages(ctx context.Context, in *BatchAnnotateImagesRequest, opts ...grpc.CallOption) (*BatchAnnotateImagesResponse, error)
	// Run async image detection and annotation for a list of generic files (e.g.
	// PDF) which may contain multiple pages and multiple images per page.
	// Progress and results can be retrieved through the
	// `google.longrunning.Operations` interface.
	// `Operation.metadata` contains `OperationMetadata` (metadata).
	// `Operation.response` contains `AsyncBatchAnnotateFilesResponse` (results).
	AsyncBatchAnnotateFiles(ctx context.Context, in *AsyncBatchAnnotateFilesRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
}

type imageAnnotatorClient struct {
	cc *grpc.ClientConn
}

func NewImageAnnotatorClient(cc *grpc.ClientConn) ImageAnnotatorClient {
	return &imageAnnotatorClient{cc}
}

func (c *imageAnnotatorClient) BatchAnnotateImages(ctx context.Context, in *BatchAnnotateImagesRequest, opts ...grpc.CallOption) (*BatchAnnotateImagesResponse, error) {
	out := new(BatchAnnotateImagesResponse)
	err := grpc.Invoke(ctx, "/google.cloud.vision.v1p2beta1.ImageAnnotator/BatchAnnotateImages", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *imageAnnotatorClient) AsyncBatchAnnotateFiles(ctx context.Context, in *AsyncBatchAnnotateFilesRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.cloud.vision.v1p2beta1.ImageAnnotator/AsyncBatchAnnotateFiles", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for ImageAnnotator service

type ImageAnnotatorServer interface {
	// Run image detection and annotation for a batch of images.
	BatchAnnotateImages(context.Context, *BatchAnnotateImagesRequest) (*BatchAnnotateImagesResponse, error)
	// Run async image detection and annotation for a list of generic files (e.g.
	// PDF) which may contain multiple pages and multiple images per page.
	// Progress and results can be retrieved through the
	// `google.longrunning.Operations` interface.
	// `Operation.metadata` contains `OperationMetadata` (metadata).
	// `Operation.response` contains `AsyncBatchAnnotateFilesResponse` (results).
	AsyncBatchAnnotateFiles(context.Context, *AsyncBatchAnnotateFilesRequest) (*google_longrunning.Operation, error)
}

func RegisterImageAnnotatorServer(s *grpc.Server, srv ImageAnnotatorServer) {
	s.RegisterService(&_ImageAnnotator_serviceDesc, srv)
}

func _ImageAnnotator_BatchAnnotateImages_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchAnnotateImagesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImageAnnotatorServer).BatchAnnotateImages(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1p2beta1.ImageAnnotator/BatchAnnotateImages",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImageAnnotatorServer).BatchAnnotateImages(ctx, req.(*BatchAnnotateImagesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ImageAnnotator_AsyncBatchAnnotateFiles_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AsyncBatchAnnotateFilesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImageAnnotatorServer).AsyncBatchAnnotateFiles(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1p2beta1.ImageAnnotator/AsyncBatchAnnotateFiles",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImageAnnotatorServer).AsyncBatchAnnotateFiles(ctx, req.(*AsyncBatchAnnotateFilesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ImageAnnotator_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.vision.v1p2beta1.ImageAnnotator",
	HandlerType: (*ImageAnnotatorServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "BatchAnnotateImages",
			Handler:    _ImageAnnotator_BatchAnnotateImages_Handler,
		},
		{
			MethodName: "AsyncBatchAnnotateFiles",
			Handler:    _ImageAnnotator_AsyncBatchAnnotateFiles_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/vision/v1p2beta1/image_annotator.proto",
}

func init() {
	proto.RegisterFile("google/cloud/vision/v1p2beta1/image_annotator.proto", fileDescriptor1)
}

var fileDescriptor1 = []byte{
	// 2880 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x5a, 0xcf, 0x73, 0xdb, 0xc6,
	0xf5, 0x0f, 0xa9, 0x5f, 0xe4, 0x23, 0x25, 0x41, 0xab, 0x1f, 0xa6, 0x65, 0x2b, 0x56, 0x90, 0x6f,
	0xbe, 0x5f, 0x7d, 0xdd, 0x94, 0x1a, 0xcb, 0x49, 0xda, 0x3a, 0xcd, 0xa4, 0x14, 0x09, 0x49, 0x1c,
	0x53, 0x24, 0xbb, 0x84, 0xec, 0xd8, 0x93, 0x0e, 0x0a, 0x81, 0x4b, 0x1a, 0x09, 0x08, 0x20, 0x00,
	0x68, 0x8b, 0x39, 0x66, 0xa6, 0x7f, 0x41, 0x6f, 0xbd, 0x77, 0x7a, 0x6a, 0x2f, 0xed, 0xdf, 0xd0,
	0x7b, 0xa7, 0x87, 0x5e, 0x7a, 0x6b, 0x0f, 0x3d, 0xf6, 0xd4, 0xe9, 0xf4, 0xd4, 0xd9, 0x1f, 0x00,
	0x17, 0x94, 0x64, 0x8a, 0xce, 0x74, 0xa6, 0x27, 0x62, 0xdf, 0xdb, 0xcf, 0xe7, 0x2d, 0xde, 0xbe,
	0x7d, 0xfb, 0x76, 0x41, 0x78, 0xd8, 0xf7, 0xbc, 0xbe, 0x43, 0xf6, 0x2d, 0xc7, 0x1b, 0x76, 0xf7,
	0x5f, 0xda, 0xa1, 0xed, 0xb9, 0xfb, 0x2f, 0x1f, 0xf8, 0x07, 0xe7, 0x24, 0x32, 0x1f, 0xec, 0xdb,
	0x03, 0xb3, 0x4f, 0x0c, 0xd3, 0x75, 0xbd, 0xc8, 0x8c, 0xbc, 0xa0, 0xec, 0x07, 0x5e, 0xe4, 0xa1,
	0x1d, 0x0e, 0x2a, 0x33, 0x50, 0x99, 0x83, 0xca, 0x09, 0x68, 0xfb, 0xae, 0xe0, 0x34, 0x7d, 0x7b,
	0x5f, 0x40, 0x6d, 0xcf, 0x0d, 0x39, 0x78, 0xfb, 0xfd, 0xd7, 0x5b, 0xec, 0x13, 0x6f, 0x40, 0xa2,
	0x60, 0x24, 0x7a, 0x4f, 0x19, 0x5f, 0x44, 0x2e, 0x22, 0x63, 0x6c, 0x43, 0x80, 0x1e, 0xbc, 0x1e,
	0xf4, 0x8a, 0x9c, 0x1b, 0x5d, 0x12, 0x11, 0x4b, 0x82, 0xbc, 0x2b, 0x20, 0x8e, 0xe7, 0xf6, 0x83,
	0xa1, 0xeb, 0xda, 0x6e, 0x7f, 0xdf, 0xf3, 0x49, 0x90, 0x1a, 0xfa, 0x3d, 0xd1, 0x89, 0xb5, 0xce,
	0x87, 0xbd, 0xfd, 0xc8, 0x1e, 0x90, 0x30, 0x32, 0x07, 0xbe, 0xe8, 0x70, 0x4b, 0x74, 0x08, 0x7c,
	0x6b, 0x3f, 0x8c, 0xcc, 0x68, 0x18, 0x4e, 0x28, 0xa2, 0x91, 0x4f, 0xf6, 0x2d, 0xcf, 0x89, 0x5d,
	0xb9, 0x5d, 0x92, 0x15, 0x8e, 0x19, 0x39, 0x6e, 0x9f, 0x6b, 0xd4, 0x7f, 0x65, 0x61, 0xe9, 0x88,
	0x98, 0xd1, 0x30, 0x20, 0xe8, 0x53, 0x98, 0xa7, 0x1d, 0x4a, 0x99, 0xdd, 0xcc, 0xde, 0xca, 0xc1,
	0x77, 0xca, 0xaf, 0xf5, 0x7f, 0x59, 0xa0, 0xca, 0xfa, 0xc8, 0x27, 0x98, 0x01, 0xd1, 0x3d, 0x28,
	0x0c, 0xcc, 0x0b, 0x23, 0x20, 0xe1, 0xd0, 0x89, 0xc2, 0x52, 0x76, 0x37, 0xb3, 0xb7, 0x80, 0x61,
	0x60, 0x5e, 0x60, 0x2e, 0x41, 0x1b, 0xb0, 0x30, 0xf0, 0xba, 0xc4, 0x29, 0xcd, 0xed, 0x66, 0xf6,
	0xf2, 0x98, 0x37, 0xd4, 0x7f, 0x64, 0x60, 0x9e, 0xb2, 0xa0, 0x0d, 0x50, 0xf4, 0x67, 0x6d, 0xcd,
	0x38, 0x6b, 0x76, 0xda, 0x5a, 0xb5, 0x7e, 0x54, 0xd7, 0x6a, 0xca, 0x5b, 0x08, 0xc1, 0xca, 0x51,
	0xa5, 0xaa, 0x19, 0x35, 0x4d, 0xd7, 0xaa, 0x7a, 0xbd, 0xd5, 0x54, 0x32, 0x68, 0x0b, 0x50, 0xa3,
	0xd2, 0xac, 0x9d, 0x56, 0xf0, 0x63, 0x49, 0x9e, 0xa5, 0x7d, 0x1b, 0xad, 0xe3, 0x96, 0x24, 0x9b,
	0x43, 0xeb, 0xb0, 0xda, 0xa8, 0x1c, 0x6a, 0x0d, 0x49, 0x38, 0x4f, 0x3b, 0xea, 0xda, 0x67, 0xba,
	0x24, 0x5b, 0x40, 0x77, 0xe0, 0x56, 0xad, 0x55, 0x3d, 0x3b, 0xd5, 0x9a, 0xba, 0x31, 0xa1, 0x2c,
	0xa0, 0xdb, 0xb0, 0xd9, 0xa9, 0x1c, 0x69, 0x46, 0x47, 0xab, 0xe0, 0xea, 0x89, 0xa4, 0x5a, 0xa4,
	0xc3, 0xae, 0x9f, 0x56, 0x8e, 0x35, 0xa3, 0x8d, 0x5b, 0x6d, 0x0d, 0xeb, 0x75, 0xad, 0xa3, 0x2c,
	0xa1, 0x15, 0x80, 0x2a, 0x6e, 0xb5, 0x8d, 0x93, 0x7a, 0x53, 0xef, 0x28, 0x79, 0xb4, 0x06, 0xcb,
	0x4f, 0xb5, 0x43, 0x09, 0x08, 0x6a, 0x13, 0x0a, 0x75, 0x1a, 0xfa, 0x1d, 0x6f, 0x18, 0x58, 0x04,
	0xa9, 0xb0, 0xdc, 0xb7, 0x42, 0x83, 0xaf, 0x86, 0x61, 0x60, 0xb3, 0x89, 0xc8, 0xe3, 0x42, 0xdf,
	0x0a, 0x59, 0xb7, 0xb3, 0xc0, 0x46, 0x77, 0x20, 0x3f, 0xd6, 0x67, 0x99, 0x3e, 0x67, 0x0b, 0xa5,
	0x4a, 0x60, 0x81, 0x75, 0x44, 0x25, 0x58, 0xb2, 0x3c, 0x37, 0x22, 0x6e, 0xc4, 0x38, 0x8a, 0x38,
	0x6e, 0xa2, 0x43, 0x58, 0x0c, 0x99, 0x35, 0x06, 0x2e, 0x1c, 0xdc, 0x9f, 0x32, 0xcb, 0xd2, 0xf8,
	0xb0, 0x40, 0xaa, 0xbf, 0x54, 0x60, 0xe5, 0xc8, 0xb4, 0x48, 0x25, 0x59, 0x11, 0xa8, 0x0d, 0xcb,
	0xe7, 0xde, 0xd0, 0xed, 0xda, 0x6e, 0xdf, 0xf0, 0x3d, 0x67, 0xc4, 0xcc, 0x16, 0xa6, 0xc6, 0xd0,
	0xa1, 0xc0, 0xb4, 0x3d, 0x67, 0x84, 0x8b, 0xe7, 0x52, 0x0b, 0x9d, 0x81, 0xd2, 0xeb, 0x1a, 0x69,
	0xd2, 0xec, 0xec, 0xa4, 0x2b, 0xbd, 0xae, 0xdc, 0x46, 0x3a, 0xe4, 0x1d, 0xd3, 0xed, 0x0e, 0xcc,
	0xe0, 0xcb, 0xb0, 0x34, 0xb7, 0x3b, 0xb7, 0x57, 0x38, 0xf8, 0x68, 0x5a, 0xa0, 0xa7, 0x5e, 0xb5,
	0xdc, 0x10, 0x70, 0x3c, 0x26, 0x42, 0x3b, 0x00, 0x81, 0xe7, 0x38, 0x86, 0xe9, 0xf6, 0x1d, 0x52,
	0x9a, 0xdf, 0xcd, 0xec, 0x65, 0x71, 0x9e, 0x4a, 0x2a, 0x54, 0x40, 0x27, 0xcd, 0x37, 0x5d, 0xa1,
	0x5d, 0x60, 0xda, 0x9c, 0x6f, 0xba, 0x5c, 0xb9, 0x03, 0x10, 0xd9, 0x4e, 0x24, 0xb4, 0x8b, 0x1c,
	0x4b, 0x25, 0x5c, 0xfd, 0x00, 0x36, 0x92, 0x2c, 0x62, 0x58, 0x9e, 0xdb, 0xb3, 0xbb, 0xc4, 0xb5,
	0x48, 0x69, 0x89, 0x75, 0x5c, 0x4f, 0x74, 0xd5, 0x44, 0x85, 0x3e, 0x84, 0xad, 0x78, 0x68, 0xd4,
	0x75, 0x12, 0x28, 0xc7, 0x40, 0x9b, 0x92, 0x56, 0x82, 0xb5, 0x61, 0xe5, 0x0b, 0x6f, 0x64, 0x38,
	0xf6, 0x97, 0xc4, 0xb1, 0x5f, 0x78, 0x5e, 0xb7, 0x94, 0x67, 0x89, 0xe0, 0xff, 0xa7, 0xf8, 0xa7,
	0x91, 0x00, 0xf0, 0xf2, 0x17, 0xde, 0x68, 0xdc, 0x44, 0x4f, 0x60, 0x2d, 0xf4, 0x82, 0xc0, 0x7b,
	0x25, 0x93, 0xc2, 0xac, 0xa4, 0x0a, 0xe7, 0x90, 0x78, 0x75, 0x50, 0x4c, 0xb7, 0x4f, 0x02, 0x99,
	0xb6, 0x30, 0x2b, 0xed, 0x2a, 0xa3, 0x90, 0x58, 0x9f, 0xc3, 0x7a, 0x38, 0x0c, 0xfc, 0xc0, 0x0e,
	0x89, 0x4c, 0x5c, 0x9c, 0x95, 0x18, 0xc5, 0x2c, 0x12, 0xb7, 0x05, 0xa5, 0xa1, 0xdb, 0x25, 0x81,
	0x41, 0x2e, 0x7c, 0x2f, 0x24, 0x5d, 0xd9, 0xc0, 0xf2, 0xac, 0x06, 0xb6, 0x18, 0x95, 0xc6, 0x99,
	0x24, 0x23, 0x9f, 0x01, 0x3a, 0x77, 0x86, 0x41, 0x90, 0xa6, 0x5f, 0x99, 0x95, 0x7e, 0x4d, 0x90,
	0xa4, 0x5d, 0xf3, 0x82, 0x98, 0xdd, 0x57, 0xc4, 0x4c, 0xf9, 0x7c, 0x75, 0x66, 0xd7, 0xc4, 0x2c,
	0x63, 0xd9, 0xf6, 0x9f, 0x96, 0x20, 0x17, 0xaf, 0x29, 0xd4, 0x12, 0x5b, 0xd0, 0x1c, 0x63, 0xfe,
	0xf8, 0xcd, 0x56, 0xa6, 0xbc, 0x25, 0x55, 0x21, 0xe7, 0x7b, 0xa1, 0x4d, 0xf5, 0x6c, 0x5d, 0x16,
	0x0e, 0xfe, 0x6f, 0x0a, 0x69, 0x5b, 0x74, 0xc7, 0x09, 0x50, 0xfd, 0xdd, 0xe2, 0x78, 0x83, 0x3a,
	0x6b, 0x3e, 0x6e, 0xb6, 0x9e, 0x36, 0x8d, 0x78, 0xfb, 0x51, 0xde, 0x42, 0x45, 0xc8, 0x35, 0xb4,
	0x23, 0xdd, 0xd0, 0x9e, 0x69, 0x4a, 0x06, 0x2d, 0x43, 0x1e, 0xd7, 0x8f, 0x4f, 0x78, 0x33, 0x8b,
	0x4a, 0xb0, 0xc1, 0x94, 0xad, 0x23, 0x23, 0xee, 0x74, 0x88, 0x5b, 0x4f, 0x95, 0x39, 0xba, 0xa3,
	0xf0, 0x8e, 0x93, 0xaa, 0x79, 0xaa, 0x8a, 0x41, 0x09, 0x17, 0x53, 0x2d, 0xa0, 0x6d, 0xd8, 0x4a,
	0x50, 0x69, 0xdd, 0x22, 0x85, 0x9d, 0xd6, 0x6b, 0xed, 0x56, 0xbd, 0xa9, 0x1b, 0x87, 0x9a, 0xfe,
	0x54, 0xd3, 0x9a, 0x54, 0x4b, 0x77, 0xa3, 0x22, 0xe4, 0x9a, 0xad, 0x8e, 0x66, 0xe8, 0xf5, 0xb6,
	0x92, 0xa3, 0x63, 0x3c, 0x6b, 0xb7, 0x35, 0x6c, 0x34, 0xea, 0x6d, 0x25, 0x4f, 0x9b, 0x8d, 0xd6,
	0x53, 0xd1, 0x04, 0xba, 0x73, 0x9d, 0xb6, 0xce, 0xf4, 0x13, 0x36, 0x2a, 0xa5, 0x80, 0x56, 0xa1,
	0xc0, 0xdb, 0xcc, 0x9e, 0x52, 0x44, 0x0a, 0x14, 0xb9, 0xa0, 0xaa, 0x35, 0x75, 0x0d, 0x2b, 0xcb,
	0x68, 0x13, 0xd6, 0x18, 0xfd, 0x61, 0x4b, 0xd7, 0x5b, 0xa7, 0xa2, 0xe3, 0x0a, 0xf5, 0x97, 0x2c,
	0x66, 0x7c, 0xab, 0x74, 0xf3, 0x96, 0xa5, 0x82, 0x44, 0x49, 0xde, 0x5a, 0x7b, 0xa6, 0x19, 0x7a,
	0xab, 0x6d, 0x1c, 0xb6, 0xce, 0x9a, 0xb5, 0x0a, 0x7e, 0xa6, 0xac, 0xa5, 0x54, 0xfc, 0xad, 0xab,
	0x2d, 0xdc, 0xd4, 0xb0, 0x82, 0xd0, 0x5d, 0x28, 0x25, 0x2a, 0xc1, 0x98, 0x00, 0xd7, 0x13, 0xf7,
	0x53, 0x2d, 0x7b, 0x10, 0xb8, 0x8d, 0xb1, 0x23, 0x2f, 0x99, 0xdb, 0x4c, 0xeb, 0x52, 0xf6, 0xb6,
	0xd0, 0x0e, 0xdc, 0x1e, 0xeb, 0x26, 0x0d, 0xde, 0x1a, 0xcf, 0xea, 0xa4, 0xc5, 0x12, 0xba, 0x07,
	0x77, 0xe4, 0x79, 0x36, 0xf8, 0x14, 0xc4, 0x33, 0xa6, 0xdc, 0x46, 0xbb, 0x70, 0x37, 0x35, 0xa5,
	0x93, 0x3d, 0xb6, 0xa9, 0x43, 0x39, 0x45, 0x05, 0x1b, 0x3a, 0xae, 0x1c, 0xd3, 0x3a, 0xe2, 0x0e,
	0xf5, 0xbe, 0xc0, 0x49, 0xe2, 0xbb, 0xac, 0x18, 0x8a, 0xdf, 0xbd, 0x7d, 0xd6, 0xae, 0x37, 0x94,
	0x1d, 0x5a, 0x0c, 0x8d, 0x87, 0xc7, 0x85, 0x6f, 0x53, 0xfc, 0x51, 0x0b, 0x6b, 0x27, 0x5a, 0xa5,
	0x66, 0x1c, 0xb3, 0x5a, 0xa9, 0x51, 0x51, 0xee, 0xd1, 0x8a, 0xa5, 0x7a, 0x52, 0x6f, 0x1a, 0xc7,
	0xcd, 0x8a, 0x7e, 0x42, 0x29, 0x77, 0xa9, 0x7d, 0x26, 0x62, 0xbc, 0xc7, 0xad, 0x26, 0x95, 0xbe,
	0x43, 0xf1, 0x4c, 0xca, 0x99, 0x85, 0x58, 0x55, 0x7f, 0x08, 0xc5, 0x86, 0x67, 0xb1, 0xb5, 0x59,
	0x77, 0x7b, 0x1e, 0x7a, 0x1f, 0x96, 0x1c, 0x33, 0x32, 0x1c, 0xb7, 0x2f, 0xca, 0x83, 0xf5, 0x78,
	0x29, 0xd2, 0xa5, 0x5a, 0x6e, 0x98, 0x51, 0xc3, 0xed, 0xe3, 0x45, 0x87, 0xfd, 0xaa, 0x4f, 0x21,
	0xd7, 0x0e, 0x68, 0x71, 0x1c, 0x8d, 0x10, 0x82, 0x79, 0xd7, 0x1c, 0x10, 0x51, 0x10, 0xb1, 0x67,
	0x5a, 0x4b, 0xbe, 0x34, 0x9d, 0x21, 0x11, 0x55, 0x10, 0x6f, 0xa0, 0x77, 0xa0, 0x38, 0xb4, 0xdd,
	0xe8, 0xa3, 0x0f, 0x0c, 0xae, 0xa4, 0x89, 0x64, 0x1e, 0x17, 0xb8, 0xec, 0x09, 0x15, 0xa9, 0xbf,
	0x98, 0x03, 0x45, 0x73, 0x23, 0x3b, 0x1a, 0x49, 0x05, 0x8c, 0x02, 0x73, 0x03, 0xbb, 0x2b, 0x0c,
	0xd0, 0x47, 0xb4, 0x05, 0x8b, 0x8e, 0x67, 0x99, 0x4e, 0x6c, 0x40, 0xb4, 0xd0, 0x2e, 0x14, 0xba,
	0x24, 0xb4, 0x02, 0xdb, 0x67, 0x49, 0x85, 0x57, 0xb2, 0xb2, 0x88, 0x8e, 0x2c, 0xb4, 0xbc, 0x20,
	0x2e, 0x04, 0x78, 0x03, 0xbd, 0x0d, 0x20, 0xed, 0xc4, 0xbc, 0x0a, 0x90, 0x24, 0x54, 0x1f, 0x79,
	0xbe, 0x6d, 0x99, 0x8e, 0x1d, 0x8d, 0x44, 0x1d, 0x20, 0x49, 0x2e, 0x97, 0x58, 0x4b, 0xdf, 0xb6,
	0xc4, 0xaa, 0x43, 0xde, 0x11, 0xf3, 0x13, 0x96, 0x72, 0xac, 0x16, 0x9a, 0xc6, 0x26, 0xcf, 0x27,
	0x1e, 0xa3, 0xd1, 0x31, 0x80, 0xcf, 0x27, 0xcb, 0x26, 0x61, 0x29, 0xcf, 0xb8, 0xa6, 0x26, 0x5a,
	0x31, 0xbb, 0x58, 0x82, 0xaa, 0x7f, 0xc9, 0xc2, 0x46, 0xc7, 0xec, 0x91, 0x0e, 0x31, 0x03, 0xeb,
	0x85, 0x34, 0x41, 0x9f, 0xc2, 0x82, 0xd9, 0x1d, 0x3a, 0x91, 0x38, 0x9d, 0xcc, 0xb0, 0xe9, 0x70,
	0x1c, 0x25, 0x08, 0x7d, 0xcf, 0xeb, 0xb1, 0xe9, 0x9c, 0x8d, 0x80, 0xe1, 0x50, 0x15, 0x96, 0x06,
	0xa4, 0x4b, 0xa7, 0x43, 0x6c, 0x4f, 0x33, 0x50, 0xc4, 0x48, 0xa4, 0x41, 0xee, 0xa5, 0xed, 0x39,
	0x2c, 0x06, 0xe6, 0x67, 0x65, 0x49, 0xa0, 0xe8, 0x13, 0x98, 0x0f, 0x4c, 0x6b, 0x34, 0x7b, 0x85,
	0xc6, 0x60, 0xea, 0x2b, 0x28, 0xd0, 0xd5, 0xe6, 0xb9, 0x7d, 0x4c, 0xac, 0x08, 0x3d, 0x84, 0xc2,
	0xc0, 0x76, 0x8d, 0x1b, 0x2c, 0xce, 0xfc, 0xc0, 0x76, 0xf9, 0x23, 0x03, 0x99, 0x17, 0x09, 0x28,
	0xfb, 0x3a, 0x90, 0x79, 0xc1, 0x1f, 0xd5, 0x00, 0xf2, 0x55, 0x7a, 0x2e, 0x65, 0xf9, 0x60, 0x0f,
	0x16, 0xd8, 0x21, 0x55, 0x18, 0x44, 0x29, 0x2c, 0xeb, 0x86, 0x79, 0x87, 0xf1, 0x8a, 0xca, 0xca,
	0x2b, 0xea, 0x3d, 0x58, 0xf1, 0xed, 0x0b, 0xe2, 0x18, 0xbd, 0xc0, 0xb4, 0x92, 0xc5, 0x98, 0xc5,
	0xcb, 0x4c, 0x7a, 0x24, 0x84, 0xea, 0xe7, 0x50, 0xaa, 0x79, 0x03, 0xdb, 0x35, 0xdd, 0x88, 0x91,
	0x86, 0x52, 0x54, 0xfd, 0x08, 0x16, 0x99, 0x85, 0xb0, 0x94, 0x61, 0x31, 0xbb, 0x37, 0xc5, 0x93,
	0xc9, 0xe0, 0xb1, 0xc0, 0xa9, 0x21, 0xac, 0xb2, 0x33, 0x52, 0x3b, 0x89, 0x61, 0xf4, 0x53, 0x58,
	0xed, 0x0a, 0x83, 0x46, 0xc2, 0x4e, 0xdf, 0xf0, 0x7b, 0x53, 0xd8, 0xaf, 0x1b, 0x26, 0x5e, 0xe9,
	0xa6, 0x34, 0xea, 0xaf, 0x33, 0x90, 0xab, 0x06, 0x9e, 0x7f, 0x62, 0xbb, 0xd1, 0x7f, 0xe0, 0xec,
	0x95, 0x4e, 0x55, 0xd9, 0x4b, 0xa9, 0x6a, 0x1f, 0xd6, 0xed, 0x81, 0xef, 0x05, 0x91, 0xe9, 0x5a,
	0x64, 0xd2, 0xfb, 0x68, 0xac, 0x4a, 0xa6, 0xe0, 0x27, 0xb0, 0x1e, 0x0f, 0x57, 0xf6, 0xfe, 0x11,
	0x80, 0x15, 0x78, 0xbe, 0xf1, 0x82, 0xca, 0xc5, 0x0c, 0x4c, 0xcb, 0x1a, 0x31, 0x0f, 0xce, 0x5b,
	0x31, 0xa3, 0xfa, 0x11, 0xac, 0x26, 0xf4, 0x6d, 0x33, 0x30, 0x07, 0x21, 0x7a, 0x17, 0x96, 0xcd,
	0xd0, 0x27, 0x56, 0x64, 0xb0, 0xcb, 0x15, 0xce, 0x9e, 0xc5, 0x45, 0x2e, 0xc4, 0x4c, 0xa6, 0xd6,
	0x00, 0x3d, 0x25, 0xe7, 0xb5, 0xf8, 0x08, 0x25, 0xa0, 0x65, 0x58, 0xb7, 0x5d, 0xcb, 0x19, 0x76,
	0x89, 0xd1, 0x27, 0x5e, 0xea, 0x36, 0x23, 0x87, 0xd7, 0x84, 0xea, 0x98, 0x78, 0xe2, 0x52, 0x43,
	0xfd, 0x7d, 0x16, 0x8a, 0x2c, 0x04, 0xaa, 0xf4, 0x8c, 0x7d, 0x11, 0xa1, 0x26, 0x2c, 0xb3, 0x55,
	0xe1, 0xb9, 0x7d, 0x23, 0x20, 0x56, 0x24, 0x26, 0x64, 0xda, 0x51, 0x5b, 0x5a, 0x91, 0xb8, 0xe0,
	0x48, 0xcb, 0xf3, 0x3d, 0x58, 0x71, 0x4c, 0xb7, 0x3f, 0xa4, 0xc7, 0x7e, 0xee, 0xaa, 0xec, 0xee,
	0xdc, 0x5e, 0x1e, 0x2f, 0xc7, 0x52, 0xf6, 0xe2, 0xe8, 0x39, 0xac, 0x8d, 0xbd, 0x69, 0xf8, 0xec,
	0x65, 0x44, 0xcd, 0x5b, 0xbe, 0xa1, 0x53, 0x85, 0xf7, 0xf0, 0xaa, 0x35, 0xe1, 0x4e, 0x0b, 0x36,
	0x52, 0xf7, 0x59, 0x31, 0xfd, 0x22, 0xa3, 0x7f, 0x30, 0x85, 0xfe, 0xb2, 0x93, 0x31, 0x7a, 0x75,
	0x49, 0xa6, 0xfe, 0x2d, 0x03, 0x1b, 0x22, 0x3a, 0x08, 0x73, 0x28, 0x26, 0x5f, 0x0d, 0x49, 0x18,
	0xa1, 0x47, 0xb0, 0xc0, 0xee, 0x38, 0x84, 0x23, 0xff, 0xe7, 0x26, 0x77, 0x16, 0x98, 0x43, 0xd0,
	0x21, 0xe4, 0x7a, 0xfc, 0xa6, 0x8a, 0xbb, 0xad, 0x70, 0xf0, 0xbf, 0x37, 0xbb, 0xd8, 0xc2, 0x09,
	0x8e, 0xae, 0x30, 0x7e, 0xe9, 0x62, 0xf1, 0x19, 0x66, 0x91, 0x3e, 0x7d, 0x85, 0xc9, 0x41, 0x81,
	0x8b, 0xb6, 0xd4, 0x52, 0x1f, 0xc3, 0x16, 0xd3, 0x8e, 0x17, 0x43, 0x1c, 0x3c, 0x0a, 0xcc, 0x8d,
	0xaf, 0x7e, 0xe8, 0x23, 0xba, 0x07, 0x05, 0x9f, 0x1a, 0x77, 0x87, 0x83, 0x73, 0x12, 0xc4, 0xb7,
	0x6a, 0x54, 0xd4, 0x64, 0x12, 0xf5, 0xcf, 0x39, 0xd8, 0x9c, 0xf0, 0x5b, 0xe8, 0x7b, 0x6e, 0x48,
	0xd0, 0x67, 0xa0, 0xf4, 0x4c, 0x8b, 0x48, 0x77, 0x97, 0xf1, 0x32, 0xfb, 0xee, 0x4c, 0x47, 0x2b,
	0xbc, 0xda, 0x4b, 0xb5, 0x43, 0x74, 0x0e, 0x1b, 0xf1, 0x2d, 0x42, 0x8a, 0x9d, 0xbb, 0x78, 0x7f,
	0x0a, 0xfb, 0x64, 0xf9, 0x85, 0xd7, 0x63, 0x32, 0xd9, 0xc6, 0x73, 0x50, 0x1c, 0xaf, 0xef, 0xa5,
	0xf8, 0xe7, 0xde, 0x8c, 0x7f, 0x95, 0x12, 0xc9, 0xdc, 0x9f, 0xc3, 0x9a, 0x63, 0x9e, 0x13, 0x27,
	0x45, 0x3e, 0xff, 0x66, 0xe4, 0x0a, 0x63, 0x9a, 0x18, 0xf9, 0xc4, 0x9d, 0x71, 0x58, 0x5a, 0x78,
	0xc3, 0x91, 0x53, 0x22, 0x99, 0xdb, 0x80, 0x8d, 0xde, 0xd0, 0x71, 0x8c, 0x09, 0x03, 0xec, 0x9e,
	0x62, 0xfa, 0xbc, 0xea, 0x29, 0x36, 0x8c, 0x28, 0x55, 0x5a, 0x86, 0x6c, 0xd8, 0x0a, 0xcd, 0x1e,
	0x31, 0x42, 0x56, 0x82, 0xc9, 0x26, 0xf8, 0x6a, 0x7f, 0x38, 0xc5, 0xc4, 0x55, 0xe5, 0x1b, 0xde,
	0x08, 0xaf, 0x2a, 0xea, 0x5c, 0xb8, 0xc3, 0x17, 0xd6, 0xb8, 0x02, 0x94, 0xed, 0xe5, 0x6e, 0x94,
	0xbc, 0x26, 0xb6, 0x5f, 0x7c, 0xdb, 0x4e, 0x0b, 0x24, 0x7b, 0x3d, 0xd8, 0x94, 0x52, 0xa4, 0x64,
	0xa9, 0xc0, 0x2c, 0x1d, 0xdc, 0x34, 0x4d, 0xca, 0x91, 0x6b, 0x5d, 0xb1, 0xb1, 0xb5, 0x61, 0x39,
	0x95, 0x2e, 0xd9, 0x1d, 0xcf, 0xf4, 0x84, 0x21, 0xe7, 0x49, 0x5c, 0x94, 0x33, 0x24, 0xad, 0x95,
	0x48, 0x10, 0x78, 0x01, 0xab, 0xf8, 0xa4, 0x5a, 0x29, 0xf0, 0xad, 0x72, 0x87, 0x7d, 0x03, 0xc0,
	0xbc, 0x03, 0x6a, 0x89, 0xbb, 0xdf, 0x8b, 0xa8, 0xb4, 0xc9, 0xfa, 0x7e, 0x78, 0x13, 0xff, 0x5d,
	0x4a, 0x44, 0x38, 0x66, 0x51, 0x07, 0xb0, 0x7d, 0x68, 0x46, 0xc9, 0xbc, 0xf1, 0x14, 0x13, 0xc6,
	0xb9, 0xb9, 0x05, 0xb9, 0x80, 0x3f, 0xc6, 0xa9, 0x65, 0x5a, 0x7c, 0x5c, 0x95, 0xe2, 0x71, 0x42,
	0xa2, 0x7e, 0x05, 0x77, 0xae, 0x34, 0x27, 0x52, 0x1a, 0x86, 0x7c, 0x20, 0x9e, 0x63, 0x83, 0x1f,
	0xcc, 0x66, 0x90, 0x83, 0xf1, 0x98, 0x46, 0xfd, 0x43, 0x16, 0x4a, 0x95, 0x70, 0xe4, 0x5a, 0x71,
	0xcf, 0x23, 0xdb, 0x49, 0x36, 0x9f, 0x53, 0x28, 0xda, 0xae, 0x3f, 0x8c, 0xf8, 0x3d, 0x6a, 0xff,
	0x86, 0x9b, 0x79, 0x9d, 0x42, 0xd8, 0xe5, 0x6a, 0x1f, 0x17, 0xec, 0x71, 0xe3, 0xbf, 0x73, 0x3f,
	0xa2, 0x8c, 0xde, 0x30, 0x92, 0xde, 0x72, 0xfe, 0x46, 0x8c, 0x2d, 0x86, 0x11, 0xaf, 0x59, 0xf4,
	0xa4, 0x96, 0x3a, 0x80, 0xdb, 0x57, 0xb8, 0x54, 0x4c, 0xe2, 0x25, 0x73, 0x99, 0x6f, 0x6b, 0x6e,
	0x08, 0x6f, 0x33, 0x73, 0xa9, 0xd0, 0xa1, 0x36, 0x93, 0x40, 0xed, 0x5c, 0x0a, 0xd4, 0x69, 0xe5,
	0xf8, 0x75, 0x21, 0x21, 0x05, 0xeb, 0x08, 0xee, 0x5d, 0x6b, 0x56, 0xbc, 0xeb, 0x93, 0xcb, 0x01,
	0xfb, 0xfd, 0xd9, 0x0d, 0x5f, 0x0e, 0xda, 0x10, 0x0a, 0x52, 0x90, 0xd1, 0x13, 0x78, 0xdf, 0x0a,
	0x0d, 0xf1, 0x71, 0x87, 0xfb, 0x73, 0xda, 0x69, 0xe6, 0xd8, 0x0a, 0xc5, 0xa7, 0x9d, 0x7c, 0x3f,
	0x7e, 0x44, 0x77, 0x20, 0x3f, 0xb0, 0x07, 0xc4, 0x60, 0xf7, 0xb0, 0xe2, 0x0b, 0x13, 0x15, 0xe8,
	0x23, 0x9f, 0xa8, 0x3f, 0xcb, 0x40, 0x51, 0x9e, 0x05, 0xf4, 0x04, 0x56, 0xa9, 0xd9, 0x2e, 0x09,
	0x23, 0xdb, 0xe5, 0xb9, 0x34, 0x73, 0xa3, 0x8d, 0xe8, 0xd8, 0x0a, 0x6b, 0x63, 0x10, 0x5e, 0xe9,
	0xa7, 0xda, 0x68, 0x07, 0xe0, 0x9c, 0xfa, 0xd4, 0x08, 0xed, 0xaf, 0x89, 0xa8, 0x79, 0xf2, 0x4c,
	0xd2, 0xb1, 0xbf, 0x26, 0xea, 0x0e, 0xe4, 0x93, 0xc1, 0x5f, 0x2e, 0x99, 0x54, 0x15, 0x56, 0xd2,
	0xfc, 0x57, 0xf4, 0xf9, 0x4d, 0x16, 0xd6, 0x5a, 0xf1, 0xb7, 0xd7, 0x53, 0x12, 0x99, 0x5d, 0x33,
	0x32, 0x51, 0x03, 0x16, 0x42, 0xea, 0x75, 0x71, 0xcd, 0x30, 0xed, 0xdb, 0xd0, 0x25, 0x02, 0x96,
	0x8c, 0x09, 0xe6, 0x24, 0xe8, 0x63, 0x28, 0x58, 0x01, 0x31, 0x23, 0x62, 0x44, 0xf6, 0x80, 0x5f,
	0xfa, 0x14, 0x0e, 0xb6, 0x63, 0xce, 0xf8, 0x03, 0x6f, 0x59, 0x8f, 0x3f, 0xf0, 0x62, 0xe0, 0xdd,
	0xa9, 0x80, 0x82, 0x87, 0x7e, 0x37, 0x01, 0x2f, 0x4e, 0x07, 0xf3, 0xee, 0x54, 0xa0, 0xfe, 0x18,
	0x16, 0xd8, 0x48, 0xd0, 0x26, 0xac, 0x75, 0xf4, 0x8a, 0x3e, 0xf9, 0x51, 0xb5, 0x00, 0x4b, 0x55,
	0xac, 0x55, 0x74, 0xad, 0xa6, 0x64, 0x68, 0x03, 0x9f, 0x35, 0x9b, 0xf5, 0xe6, 0xb1, 0x92, 0x45,
	0x39, 0x98, 0xaf, 0xb5, 0x9a, 0x9a, 0x32, 0x87, 0x96, 0x21, 0x5f, 0xad, 0x34, 0xab, 0x5a, 0xa3,
	0xa1, 0xd5, 0x94, 0xf9, 0xfb, 0x04, 0x40, 0xfa, 0x24, 0x50, 0x80, 0x25, 0x71, 0x15, 0xae, 0xbc,
	0x85, 0xd6, 0x60, 0xf9, 0x89, 0x86, 0x9f, 0x19, 0x67, 0xcd, 0x46, 0xfd, 0xb1, 0xd6, 0x78, 0xa6,
	0x64, 0x50, 0x11, 0x72, 0x49, 0x2b, 0x4b, 0x5b, 0xed, 0x56, 0xa7, 0x53, 0x3f, 0x6c, 0x50, 0x62,
	0x80, 0x45, 0xa1, 0x99, 0x47, 0xab, 0x50, 0x60, 0x50, 0x21, 0x58, 0x38, 0xf8, 0x7b, 0x16, 0x56,
	0xe4, 0x2d, 0xc9, 0x0b, 0xd0, 0x6f, 0x33, 0xb0, 0x7e, 0xc5, 0x9e, 0x80, 0x7e, 0x30, 0xed, 0x88,
	0x7b, 0xed, 0xb6, 0xb5, 0xfd, 0xe8, 0x4d, 0xa0, 0x7c, 0xe9, 0xa9, 0xef, 0x7d, 0xf3, 0xc7, 0xbf,
	0xfe, 0x3c, 0x7b, 0x4f, 0xdd, 0x9e, 0xfc, 0x0b, 0x43, 0xf8, 0x48, 0x94, 0x14, 0xe4, 0x51, 0xe6,
	0x3e, 0xfa, 0x55, 0x06, 0x6e, 0x5d, 0x93, 0x1c, 0xd0, 0x27, 0x37, 0xc9, 0x00, 0xd7, 0xe6, 0xb2,
	0xed, 0x9d, 0x18, 0x2e, 0xfd, 0x91, 0x60, 0x1c, 0x8b, 0x6a, 0x99, 0x0d, 0x70, 0x4f, 0x7d, 0x57,
	0x1a, 0x60, 0x8f, 0xe2, 0x1f, 0x99, 0x97, 0x78, 0x1f, 0x65, 0xee, 0x1f, 0x7e, 0x93, 0x81, 0x77,
	0x2c, 0x6f, 0xf0, 0xfa, 0x31, 0x1d, 0xae, 0xa7, 0x67, 0xa5, 0x4d, 0x03, 0xb0, 0x9d, 0x79, 0x5e,
	0x15, 0xa8, 0xbe, 0x47, 0x8f, 0xa3, 0x65, 0x2f, 0xe8, 0xef, 0xf7, 0x89, 0xcb, 0xc2, 0x73, 0x9f,
	0xab, 0x4c, 0xdf, 0x0e, 0xaf, 0xf9, 0x97, 0xc4, 0xc7, 0x5c, 0xf0, 0xcf, 0x4c, 0xe6, 0x7c, 0x91,
	0x41, 0x1e, 0xfe, 0x3b, 0x00, 0x00, 0xff, 0xff, 0x49, 0x4b, 0x80, 0x49, 0x2c, 0x22, 0x00, 0x00,
}
