; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -instcombine -S < %s | FileCheck %s
; PR5438

; TODO: This should also optimize down.
;define i32 @test1(i32 %a, i32 %b) nounwind readnone {
;entry:
;        %0 = icmp sgt i32 %a, -1
;        %1 = icmp slt i32 %b, 0
;        %2 = xor i1 %1, %0
;        %3 = zext i1 %2 to i32
;        ret i32 %3
;}

; TODO: This optimizes partially but not all the way.
;define i32 @test2(i32 %a, i32 %b) nounwind readnone {
;entry:
;        %0 = and i32 %a, 8
;        %1 = and i32 %b, 8
;        %2 = icmp eq i32 %0, %1
;        %3 = zext i1 %2 to i32
;        ret i32 %3
;}

define i32 @test3(i32 %a, i32 %b) nounwind readnone {
; CHECK-LABEL: @test3(
; CHECK-NEXT:    [[T2_UNSHIFTED:%.*]] = xor i32 %a, %b
; CHECK-NEXT:    [[T2_UNSHIFTED_LOBIT:%.*]] = lshr i32 [[T2_UNSHIFTED]], 31
; CHECK-NEXT:    [[T2_UNSHIFTED_LOBIT_NOT:%.*]] = xor i32 [[T2_UNSHIFTED_LOBIT]], 1
; CHECK-NEXT:    ret i32 [[T2_UNSHIFTED_LOBIT_NOT]]
;
  %t0 = lshr i32 %a, 31
  %t1 = lshr i32 %b, 31
  %t2 = icmp eq i32 %t0, %t1
  %t3 = zext i1 %t2 to i32
  ret i32 %t3
}

; Variation on @test3: checking the 2nd bit in a situation where the 5th bit
; is one, not zero.
define i32 @test3i(i32 %a, i32 %b) nounwind readnone {
; CHECK-LABEL: @test3i(
; CHECK-NEXT:    [[T01:%.*]] = xor i32 %a, %b
; CHECK-NEXT:    [[TMP1:%.*]] = lshr i32 [[T01]], 31
; CHECK-NEXT:    [[T4:%.*]] = xor i32 [[TMP1]], 1
; CHECK-NEXT:    ret i32 [[T4]]
;
  %t0 = lshr i32 %a, 29
  %t1 = lshr i32 %b, 29
  %t2 = or i32 %t0, 35
  %t3 = or i32 %t1, 35
  %t4 = icmp eq i32 %t2, %t3
  %t5 = zext i1 %t4 to i32
  ret i32 %t5
}

define i1 @test4a(i32 %a) {
; CHECK-LABEL: @test4a(
; CHECK-NEXT:    [[C:%.*]] = icmp slt i32 %a, 1
; CHECK-NEXT:    ret i1 [[C]]
;
  %l = ashr i32 %a, 31
  %na = sub i32 0, %a
  %r = lshr i32 %na, 31
  %signum = or i32 %l, %r
  %c = icmp slt i32 %signum, 1
  ret i1 %c
}

define i1 @test4b(i64 %a) {
; CHECK-LABEL: @test4b(
; CHECK-NEXT:    [[C:%.*]] = icmp slt i64 %a, 1
; CHECK-NEXT:    ret i1 [[C]]
;
  %l = ashr i64 %a, 63
  %na = sub i64 0, %a
  %r = lshr i64 %na, 63
  %signum = or i64 %l, %r
  %c = icmp slt i64 %signum, 1
  ret i1 %c
}

define i1 @test4c(i64 %a) {
; CHECK-LABEL: @test4c(
; CHECK-NEXT:    [[C:%.*]] = icmp slt i64 %a, 1
; CHECK-NEXT:    ret i1 [[C]]
;
  %l = ashr i64 %a, 63
  %na = sub i64 0, %a
  %r = lshr i64 %na, 63
  %signum = or i64 %l, %r
  %signum.trunc = trunc i64 %signum to i32
  %c = icmp slt i32 %signum.trunc, 1
  ret i1 %c
}
