// Copyright 2002 - 2008, 2010, 2011 National Technology Engineering
// Solutions of Sandia, LLC (NTESS). Under the terms of Contract
// DE-NA0003525 with NTESS, the U.S. Government retains certain rights
// in this software.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
// 
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
// 
//     * Redistributions in binary form must reproduce the above
//       copyright notice, this list of conditions and the following
//       disclaimer in the documentation and/or other materials provided
//       with the distribution.
// 
//     * Neither the name of NTESS nor the names of its contributors
//       may be used to endorse or promote products derived from this
//       software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// 


#include <stk_util/util/PageAlignedAllocator.hpp>
#include <sys/mman.h>                   // for mmap, munmap, MAP_ANON, etc
#include <unistd.h>                     // for sysconf, _SC_PAGE_SIZE
#include <new>                          // for bad_alloc

namespace stk { namespace detail {

const size_t page_aligned_allocator_impl::half_page_size = (sysconf( _SC_PAGE_SIZE ) >> 1);
const int page_aligned_allocator_impl::m_mmap_flags = MAP_PRIVATE | MAP_ANON;
const int page_aligned_allocator_impl::m_mmap_protection = PROT_READ | PROT_WRITE;


void * page_aligned_allocator_impl::allocate(size_t num_bytes)
{
  void * ptr = mmap(nullptr, num_bytes, m_mmap_protection, m_mmap_flags, -1 /*file descriptor*/, 0 /*offset*/);
  // TODO - Is it OK to throw here? Having a throw will change
  // the code generated by the compiler to be slower, but will allow
  // this allocator to behave the same as new (you'll get an
  // exception when you run out of memory).
  if (ptr == MAP_FAILED) {
    throw std::bad_alloc();
  }

  return ptr;
}

void page_aligned_allocator_impl::deallocate( void * ptr, size_t num_bytes)
{
  munmap(ptr,num_bytes);
}


}} // namespace stk::detail

