---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, statistiques, R
---

# Comment faire collaborer LaTeX et `R` ?

Le principe est de générer un document LaTeX comportant des résultats (tableaux,
graphiques, etc.) produits par `R` (ou `Python`, `Julia`, etc.).

Il existe plusieurs solutions toutes basées sur le même principe : dans un
document écrit dans un langage balisé (markdown ou LaTeX par ex.) on incorpore
des morceaux de code R appelés *chunks* délimités par des triples backticks
(```` ``` ````). Une première compilation produit un document LaTeX comportant
les résultats du code `R` (un tableau par exemple). On compile ensuite ce
document pour obtenir le fichier final (en PDF si on utilise LaTeX).

De plus la maintenance est simplifiée : chaque chunk peut être exécuté seul (ce
qui simplifie l'écriture et le déboguage) et il n'y a qu'un seul document (au
pire deux ou trois avec d'éventuels fichiers de configuration).

## Knitr

un fichier [`knitr`](https://yihui.org/knitr/) (`.Rnw`) est un fichier LaTeX
standard qui contient des *chunks* de code `R`. Un exemple :

```{noedit}
\section{Introduction}

<<setup, include=FALSE, cache=FALSE>>=
plot(iris)
@

bla, bla, bla.
```

L'écriture est lourde et il n'existe pas de modèles prédéfinis.

## R markdown

[R markdown](https://rmarkdown.rstudio.com/) est un format de fichier qui mélange
du code `R` et du texte en `Markdown`. Les réglages généraux sont écrits dans un
en-tête en `yaml`. Après une première compilation pour `R`, le fichier est
converti en LaTeX via [pandoc](https://pandoc.org/) puis compilé en PDF (toute
la précédure étant automatisée). Un export en HTML voire en `.docx` est
également possible.

````markdown
## Introduction

```{r, echo = FALSE, fig.cap = "Vue globale de Iris"}
plot(iris)
```

bla, bla, bla.
````

## `Quarto`

[`Quarto`](https://quarto.org/) est une évolution de R Markdown. La syntaxe est
plus simple et il existe nombre de fonctions pour des mises en page complexes,
des pages de titre, etc. C'est le seul qui continue à être réellement
maintenu. La documentation est très bien faite.

````markdown
## Introduction

```{r}
#| label: irisf1
#| fig-cap: Vue globale de Iris

plot(iris)
```

bla, bla, bla.
````

La suite de cette documentation se concentrera sur `Quarto`.
