/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ditaa;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.command.PSystemBasicFactory;
import net.sourceforge.plantuml.core.DiagramType;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.ditaa.PSystemDitaa;

public class PSystemDitaaFactory
extends PSystemBasicFactory<PSystemDitaa> {
    public PSystemDitaaFactory(DiagramType diagramType) {
        super(diagramType);
    }

    @Override
    public PSystemDitaa initDiagram(UmlSource source, String startLine) {
        boolean performSeparationOfCommonEdges = true;
        if (startLine != null && (startLine.contains("-E") || startLine.contains("--no-separation"))) {
            performSeparationOfCommonEdges = false;
        }
        boolean dropShadows = true;
        if (startLine != null && (startLine.contains("-S") || startLine.contains("--no-shadows"))) {
            dropShadows = false;
        }
        float scale = this.extractScale(startLine);
        if (this.getDiagramType() == DiagramType.UML) {
            return null;
        }
        if (this.getDiagramType() == DiagramType.DITAA) {
            return new PSystemDitaa(source, "", performSeparationOfCommonEdges, dropShadows, scale);
        }
        throw new IllegalStateException(this.getDiagramType().name());
    }

    @Override
    public PSystemDitaa executeLine(UmlSource source, PSystemDitaa system, String line) {
        if (system == null && (line.equals("ditaa") || line.startsWith("ditaa("))) {
            boolean performSeparationOfCommonEdges = true;
            if (line.contains("-E") || line.contains("--no-separation")) {
                performSeparationOfCommonEdges = false;
            }
            boolean dropShadows = true;
            if (line.contains("-S") || line.contains("--no-shadows")) {
                dropShadows = false;
            }
            float scale = this.extractScale(line);
            return new PSystemDitaa(source, "", performSeparationOfCommonEdges, dropShadows, scale);
        }
        if (system == null) {
            return null;
        }
        return system.add(line);
    }

    private float extractScale(String line) {
        if (line == null) {
            return 1.0f;
        }
        Pattern p = Pattern.compile("scale=([\\d.]+)");
        Matcher m = p.matcher(line);
        if (m.find()) {
            String number = m.group(1);
            return Float.parseFloat(number);
        }
        return 1.0f;
    }
}

