// https://github.com/mattiaisgro/loadgl

#include "engine/render/PGlFuncs.hpp"

#include "engine/PLog.hpp"

#include <SDL.h>

#include <cstdio>

namespace PGlFuncs {

void load_funcs();

int load_lib() {

    int err = SDL_GL_LoadLibrary(NULL);
    
	if (err != 0)
		PLog::Write(PLog::ERR, "PGl", "SDL didn't load OpenGl: %s", SDL_GetError());

    load_funcs();

	return err;

}

void free_lib() {

    SDL_GL_UnloadLibrary();

}

static void* get_proc(const char* proc) {

    void* proc_ptr = SDL_GL_GetProcAddress(proc);

    if (!proc_ptr)
        PLog::Write(PLog::ERR, "PGl", "Couldn't find %s\n", proc);
    
    return proc_ptr;

}

void load_funcs() {

	// gl_ActiveShaderProgram = (PFNGLACTIVESHADERPROGRAMPROC) get_proc("glActiveShaderProgram");
	gl_ActiveTexture = (PFNGLACTIVETEXTUREPROC) get_proc("glActiveTexture");
	gl_AttachShader = (PFNGLATTACHSHADERPROC) get_proc("glAttachShader");
	// gl_BeginConditionalRender = (PFNGLBEGINCONDITIONALRENDERPROC) get_proc("glBeginConditionalRender");
	// gl_BeginQuery = (PFNGLBEGINQUERYPROC) get_proc("glBeginQuery");
	// gl_BeginQueryIndexed = (PFNGLBEGINQUERYINDEXEDPROC) get_proc("glBeginQueryIndexed");
	// gl_BeginTransformFeedback = (PFNGLBEGINTRANSFORMFEEDBACKPROC) get_proc("glBeginTransformFeedback");
	gl_BindAttribLocation = (PFNGLBINDATTRIBLOCATIONPROC) get_proc("glBindAttribLocation");
	gl_BindBuffer = (PFNGLBINDBUFFERPROC) get_proc("glBindBuffer");
	// gl_BindBufferBase = (PFNGLBINDBUFFERBASEPROC) get_proc("glBindBufferBase");
	// gl_BindBufferRange = (PFNGLBINDBUFFERRANGEPROC) get_proc("glBindBufferRange");
	// gl_BindBuffersBase = (PFNGLBINDBUFFERSBASEPROC) get_proc("glBindBuffersBase");
	// gl_BindBuffersRange = (PFNGLBINDBUFFERSRANGEPROC) get_proc("glBindBuffersRange");
	gl_BindFragDataLocation = (PFNGLBINDFRAGDATALOCATIONPROC) get_proc("glBindFragDataLocation");
	// gl_BindFragDataLocationIndexed = (PFNGLBINDFRAGDATALOCATIONINDEXEDPROC) get_proc("glBindFragDataLocationIndexed");
	gl_BindFramebuffer = (PFNGLBINDFRAMEBUFFERPROC) get_proc("glBindFramebuffer");
	// gl_BindImageTexture = (PFNGLBINDIMAGETEXTUREPROC) get_proc("glBindImageTexture");
	// gl_BindImageTextures = (PFNGLBINDIMAGETEXTURESPROC) get_proc("glBindImageTextures");
	// gl_BindProgramPipeline = (PFNGLBINDPROGRAMPIPELINEPROC) get_proc("glBindProgramPipeline");
	// gl_BindRenderbuffer = (PFNGLBINDRENDERBUFFERPROC) get_proc("glBindRenderbuffer");
	// gl_BindSampler = (PFNGLBINDSAMPLERPROC) get_proc("glBindSampler");
	// gl_BindSamplers = (PFNGLBINDSAMPLERSPROC) get_proc("glBindSamplers");
	gl_BindTexture = (PFNGLBINDTEXTUREPROC) get_proc("glBindTexture");
	// gl_BindTextureUnit = (PFNGLBINDTEXTUREUNITPROC) get_proc("glBindTextureUnit");
	// gl_BindTextures = (PFNGLBINDTEXTURESPROC) get_proc("glBindTextures");
	// gl_BindTransformFeedback = (PFNGLBINDTRANSFORMFEEDBACKPROC) get_proc("glBindTransformFeedback");
	gl_BindVertexArray = (PFNGLBINDVERTEXARRAYPROC) get_proc("glBindVertexArray");
	// gl_BindVertexBuffer = (PFNGLBINDVERTEXBUFFERPROC) get_proc("glBindVertexBuffer");
	// gl_BindVertexBuffers = (PFNGLBINDVERTEXBUFFERSPROC) get_proc("glBindVertexBuffers");
	// gl_BlendColor = (PFNGLBLENDCOLORPROC) get_proc("glBlendColor");
	// gl_BlendEquation = (PFNGLBLENDEQUATIONPROC) get_proc("glBlendEquation");
	// gl_BlendEquationSeparate = (PFNGLBLENDEQUATIONSEPARATEPROC) get_proc("glBlendEquationSeparate");
	// gl_BlendEquationSeparatei = (PFNGLBLENDEQUATIONSEPARATEIPROC) get_proc("glBlendEquationSeparatei");
	// gl_BlendEquationSeparateiARB = (PFNGLBLENDEQUATIONSEPARATEIARBPROC) get_proc("glBlendEquationSeparateiARB");
	// gl_BlendEquationi = (PFNGLBLENDEQUATIONIPROC) get_proc("glBlendEquationi");
	// gl_BlendEquationiARB = (PFNGLBLENDEQUATIONIARBPROC) get_proc("glBlendEquationiARB");
	// gl_BlendFunc = (PFNGLBLENDFUNCPROC) get_proc("glBlendFunc");
	// gl_BlendFuncSeparate = (PFNGLBLENDFUNCSEPARATEPROC) get_proc("glBlendFuncSeparate");
	// gl_BlendFuncSeparatei = (PFNGLBLENDFUNCSEPARATEIPROC) get_proc("glBlendFuncSeparatei");
	// gl_BlendFuncSeparateiARB = (PFNGLBLENDFUNCSEPARATEIARBPROC) get_proc("glBlendFuncSeparateiARB");
	// gl_BlendFunci = (PFNGLBLENDFUNCIPROC) get_proc("glBlendFunci");
	// gl_BlendFunciARB = (PFNGLBLENDFUNCIARBPROC) get_proc("glBlendFunciARB");
	// gl_BlitFramebuffer = (PFNGLBLITFRAMEBUFFERPROC) get_proc("glBlitFramebuffer");
	// gl_BlitNamedFramebuffer = (PFNGLBLITNAMEDFRAMEBUFFERPROC) get_proc("glBlitNamedFramebuffer");
	gl_BufferData = (PFNGLBUFFERDATAPROC) get_proc("glBufferData");
	// gl_BufferPageCommitmentARB = (PFNGLBUFFERPAGECOMMITMENTARBPROC) get_proc("glBufferPageCommitmentARB");
	// gl_BufferStorage = (PFNGLBUFFERSTORAGEPROC) get_proc("glBufferStorage");
	// gl_BufferSubData = (PFNGLBUFFERSUBDATAPROC) get_proc("glBufferSubData");
	gl_CheckFramebufferStatus = (PFNGLCHECKFRAMEBUFFERSTATUSPROC) get_proc("glCheckFramebufferStatus");
	// gl_CheckNamedFramebufferStatus = (PFNGLCHECKNAMEDFRAMEBUFFERSTATUSPROC) get_proc("glCheckNamedFramebufferStatus");
	// gl_ClampColor = (PFNGLCLAMPCOLORPROC) get_proc("glClampColor");
	gl_Clear = (PFNGLCLEARPROC) get_proc("glClear");
	// gl_ClearBufferData = (PFNGLCLEARBUFFERDATAPROC) get_proc("glClearBufferData");
	// gl_ClearBufferSubData = (PFNGLCLEARBUFFERSUBDATAPROC) get_proc("glClearBufferSubData");
	// gl_ClearBufferfi = (PFNGLCLEARBUFFERFIPROC) get_proc("glClearBufferfi");
	// gl_ClearBufferfv = (PFNGLCLEARBUFFERFVPROC) get_proc("glClearBufferfv");
	// gl_ClearBufferiv = (PFNGLCLEARBUFFERIVPROC) get_proc("glClearBufferiv");
	// gl_ClearBufferuiv = (PFNGLCLEARBUFFERUIVPROC) get_proc("glClearBufferuiv");
	gl_ClearColor = (PFNGLCLEARCOLORPROC) get_proc("glClearColor");
	// gl_ClearDepth = (PFNGLCLEARDEPTHPROC) get_proc("glClearDepth");
	// gl_ClearDepthf = (PFNGLCLEARDEPTHFPROC) get_proc("glClearDepthf");
	// gl_ClearNamedBufferData = (PFNGLCLEARNAMEDBUFFERDATAPROC) get_proc("glClearNamedBufferData");
	// gl_ClearNamedBufferSubData = (PFNGLCLEARNAMEDBUFFERSUBDATAPROC) get_proc("glClearNamedBufferSubData");
	// gl_ClearNamedFramebufferfi = (PFNGLCLEARNAMEDFRAMEBUFFERFIPROC) get_proc("glClearNamedFramebufferfi");
	// gl_ClearNamedFramebufferfv = (PFNGLCLEARNAMEDFRAMEBUFFERFVPROC) get_proc("glClearNamedFramebufferfv");
	// gl_ClearNamedFramebufferiv = (PFNGLCLEARNAMEDFRAMEBUFFERIVPROC) get_proc("glClearNamedFramebufferiv");
	// gl_ClearNamedFramebufferuiv = (PFNGLCLEARNAMEDFRAMEBUFFERUIVPROC) get_proc("glClearNamedFramebufferuiv");
	// gl_ClearStencil = (PFNGLCLEARSTENCILPROC) get_proc("glClearStencil");
	// gl_ClearTexImage = (PFNGLCLEARTEXIMAGEPROC) get_proc("glClearTexImage");
	// gl_ClearTexSubImage = (PFNGLCLEARTEXSUBIMAGEPROC) get_proc("glClearTexSubImage");
	// gl_ClientWaitSync = (PFNGLCLIENTWAITSYNCPROC) get_proc("glClientWaitSync");
	// gl_ClipControl = (PFNGLCLIPCONTROLPROC) get_proc("glClipControl");
	// gl_ColorMask = (PFNGLCOLORMASKPROC) get_proc("glColorMask");
	// gl_ColorMaski = (PFNGLCOLORMASKIPROC) get_proc("glColorMaski");
	gl_CompileShader = (PFNGLCOMPILESHADERPROC) get_proc("glCompileShader");
	// gl_CompileShaderIncludeARB = (PFNGLCOMPILESHADERINCLUDEARBPROC) get_proc("glCompileShaderIncludeARB");
	// gl_CompressedTexImage1D = (PFNGLCOMPRESSEDTEXIMAGE1DPROC) get_proc("glCompressedTexImage1D");
	// gl_CompressedTexImage2D = (PFNGLCOMPRESSEDTEXIMAGE2DPROC) get_proc("glCompressedTexImage2D");
	// gl_CompressedTexImage3D = (PFNGLCOMPRESSEDTEXIMAGE3DPROC) get_proc("glCompressedTexImage3D");
	// gl_CompressedTexSubImage1D = (PFNGLCOMPRESSEDTEXSUBIMAGE1DPROC) get_proc("glCompressedTexSubImage1D");
	// gl_CompressedTexSubImage2D = (PFNGLCOMPRESSEDTEXSUBIMAGE2DPROC) get_proc("glCompressedTexSubImage2D");
	// gl_CompressedTexSubImage3D = (PFNGLCOMPRESSEDTEXSUBIMAGE3DPROC) get_proc("glCompressedTexSubImage3D");
	// gl_CompressedTextureSubImage1D = (PFNGLCOMPRESSEDTEXTURESUBIMAGE1DPROC) get_proc("glCompressedTextureSubImage1D");
	// gl_CompressedTextureSubImage2D = (PFNGLCOMPRESSEDTEXTURESUBIMAGE2DPROC) get_proc("glCompressedTextureSubImage2D");
	// gl_CompressedTextureSubImage3D = (PFNGLCOMPRESSEDTEXTURESUBIMAGE3DPROC) get_proc("glCompressedTextureSubImage3D");
	// gl_CopyBufferSubData = (PFNGLCOPYBUFFERSUBDATAPROC) get_proc("glCopyBufferSubData");
	// gl_CopyImageSubData = (PFNGLCOPYIMAGESUBDATAPROC) get_proc("glCopyImageSubData");
	// gl_CopyNamedBufferSubData = (PFNGLCOPYNAMEDBUFFERSUBDATAPROC) get_proc("glCopyNamedBufferSubData");
	// gl_CopyTexImage1D = (PFNGLCOPYTEXIMAGE1DPROC) get_proc("glCopyTexImage1D");
	// gl_CopyTexImage2D = (PFNGLCOPYTEXIMAGE2DPROC) get_proc("glCopyTexImage2D");
	// gl_CopyTexSubImage1D = (PFNGLCOPYTEXSUBIMAGE1DPROC) get_proc("glCopyTexSubImage1D");
	// gl_CopyTexSubImage2D = (PFNGLCOPYTEXSUBIMAGE2DPROC) get_proc("glCopyTexSubImage2D");
	// gl_CopyTexSubImage3D = (PFNGLCOPYTEXSUBIMAGE3DPROC) get_proc("glCopyTexSubImage3D");
	// gl_CopyTextureSubImage1D = (PFNGLCOPYTEXTURESUBIMAGE1DPROC) get_proc("glCopyTextureSubImage1D");
	// gl_CopyTextureSubImage2D = (PFNGLCOPYTEXTURESUBIMAGE2DPROC) get_proc("glCopyTextureSubImage2D");
	// gl_CopyTextureSubImage3D = (PFNGLCOPYTEXTURESUBIMAGE3DPROC) get_proc("glCopyTextureSubImage3D");
	// gl_CreateBuffers = (PFNGLCREATEBUFFERSPROC) get_proc("glCreateBuffers");
	// gl_CreateFramebuffers = (PFNGLCREATEFRAMEBUFFERSPROC) get_proc("glCreateFramebuffers");
	gl_CreateProgram = (PFNGLCREATEPROGRAMPROC) get_proc("glCreateProgram");
	// gl_CreateProgramPipelines = (PFNGLCREATEPROGRAMPIPELINESPROC) get_proc("glCreateProgramPipelines");
	// gl_CreateQueries = (PFNGLCREATEQUERIESPROC) get_proc("glCreateQueries");
	// gl_CreateRenderbuffers = (PFNGLCREATERENDERBUFFERSPROC) get_proc("glCreateRenderbuffers");
	// gl_CreateSamplers = (PFNGLCREATESAMPLERSPROC) get_proc("glCreateSamplers");
	gl_CreateShader = (PFNGLCREATESHADERPROC) get_proc("glCreateShader");
	// gl_CreateShaderProgramv = (PFNGLCREATESHADERPROGRAMVPROC) get_proc("glCreateShaderProgramv");
	// gl_CreateSyncFromCLeventARB = (PFNGLCREATESYNCFROMCLEVENTARBPROC) get_proc("glCreateSyncFromCLeventARB");
	// gl_CreateTextures = (PFNGLCREATETEXTURESPROC) get_proc("glCreateTextures");
	// gl_CreateTransformFeedbacks = (PFNGLCREATETRANSFORMFEEDBACKSPROC) get_proc("glCreateTransformFeedbacks");
	// gl_CreateVertexArrays = (PFNGLCREATEVERTEXARRAYSPROC) get_proc("glCreateVertexArrays");
	// gl_CullFace = (PFNGLCULLFACEPROC) get_proc("glCullFace");
	// gl_DebugMessageCallback = (PFNGLDEBUGMESSAGECALLBACKPROC) get_proc("glDebugMessageCallback");
	// gl_DebugMessageCallbackARB = (PFNGLDEBUGMESSAGECALLBACKARBPROC) get_proc("glDebugMessageCallbackARB");
	// gl_DebugMessageControl = (PFNGLDEBUGMESSAGECONTROLPROC) get_proc("glDebugMessageControl");
	// gl_DebugMessageControlARB = (PFNGLDEBUGMESSAGECONTROLARBPROC) get_proc("glDebugMessageControlARB");
	// gl_DebugMessageInsert = (PFNGLDEBUGMESSAGEINSERTPROC) get_proc("glDebugMessageInsert");
	// gl_DebugMessageInsertARB = (PFNGLDEBUGMESSAGEINSERTARBPROC) get_proc("glDebugMessageInsertARB");
	gl_DeleteBuffers = (PFNGLDELETEBUFFERSPROC) get_proc("glDeleteBuffers");
	gl_DeleteFramebuffers = (PFNGLDELETEFRAMEBUFFERSPROC) get_proc("glDeleteFramebuffers");
	// gl_DeleteNamedStringARB = (PFNGLDELETENAMEDSTRINGARBPROC) get_proc("glDeleteNamedStringARB");
	gl_DeleteProgram = (PFNGLDELETEPROGRAMPROC) get_proc("glDeleteProgram");
	// gl_DeleteProgramPipelines = (PFNGLDELETEPROGRAMPIPELINESPROC) get_proc("glDeleteProgramPipelines");
	// gl_DeleteQueries = (PFNGLDELETEQUERIESPROC) get_proc("glDeleteQueries");
	// gl_DeleteRenderbuffers = (PFNGLDELETERENDERBUFFERSPROC) get_proc("glDeleteRenderbuffers");
	// gl_DeleteSamplers = (PFNGLDELETESAMPLERSPROC) get_proc("glDeleteSamplers");
	gl_DeleteShader = (PFNGLDELETESHADERPROC) get_proc("glDeleteShader");
	// gl_DeleteSync = (PFNGLDELETESYNCPROC) get_proc("glDeleteSync");
	gl_DeleteTextures = (PFNGLDELETETEXTURESPROC) get_proc("glDeleteTextures");
	// gl_DeleteTransformFeedbacks = (PFNGLDELETETRANSFORMFEEDBACKSPROC) get_proc("glDeleteTransformFeedbacks");
	gl_DeleteVertexArrays = (PFNGLDELETEVERTEXARRAYSPROC) get_proc("glDeleteVertexArrays");
	// gl_DepthFunc = (PFNGLDEPTHFUNCPROC) get_proc("glDepthFunc");
	// gl_DepthMask = (PFNGLDEPTHMASKPROC) get_proc("glDepthMask");
	// gl_DepthRange = (PFNGLDEPTHRANGEPROC) get_proc("glDepthRange");
	// gl_DepthRangeArrayv = (PFNGLDEPTHRANGEARRAYVPROC) get_proc("glDepthRangeArrayv");
	// gl_DepthRangeIndexed = (PFNGLDEPTHRANGEINDEXEDPROC) get_proc("glDepthRangeIndexed");
	// gl_DepthRangef = (PFNGLDEPTHRANGEFPROC) get_proc("glDepthRangef");
	// gl_DetachShader = (PFNGLDETACHSHADERPROC) get_proc("glDetachShader");
	gl_Disable = (PFNGLDISABLEPROC) get_proc("glDisable");
	// gl_DisableVertexArrayAttrib = (PFNGLDISABLEVERTEXARRAYATTRIBPROC) get_proc("glDisableVertexArrayAttrib");
	// gl_DisableVertexAttribArray = (PFNGLDISABLEVERTEXATTRIBARRAYPROC) get_proc("glDisableVertexAttribArray");
	// gl_Disablei = (PFNGLDISABLEIPROC) get_proc("glDisablei");
	// gl_DispatchCompute = (PFNGLDISPATCHCOMPUTEPROC) get_proc("glDispatchCompute");
	// gl_DispatchComputeGroupSizeARB = (PFNGLDISPATCHCOMPUTEGROUPSIZEARBPROC) get_proc("glDispatchComputeGroupSizeARB");
	// gl_DispatchComputeIndirect = (PFNGLDISPATCHCOMPUTEINDIRECTPROC) get_proc("glDispatchComputeIndirect");
	gl_DrawArrays = (PFNGLDRAWARRAYSPROC) get_proc("glDrawArrays");
	// gl_DrawArraysIndirect = (PFNGLDRAWARRAYSINDIRECTPROC) get_proc("glDrawArraysIndirect");
	// gl_DrawArraysInstanced = (PFNGLDRAWARRAYSINSTANCEDPROC) get_proc("glDrawArraysInstanced");
	// gl_DrawArraysInstancedBaseInstance = (PFNGLDRAWARRAYSINSTANCEDBASEINSTANCEPROC) get_proc("glDrawArraysInstancedBaseInstance");
	// gl_DrawBuffer = (PFNGLDRAWBUFFERPROC) get_proc("glDrawBuffer");
	gl_DrawBuffers = (PFNGLDRAWBUFFERSPROC) get_proc("glDrawBuffers");
	// gl_DrawElements = (PFNGLDRAWELEMENTSPROC) get_proc("glDrawElements");
	// gl_DrawElementsBaseVertex = (PFNGLDRAWELEMENTSBASEVERTEXPROC) get_proc("glDrawElementsBaseVertex");
	// gl_DrawElementsIndirect = (PFNGLDRAWELEMENTSINDIRECTPROC) get_proc("glDrawElementsIndirect");
	// gl_DrawElementsInstanced = (PFNGLDRAWELEMENTSINSTANCEDPROC) get_proc("glDrawElementsInstanced");
	// gl_DrawElementsInstancedBaseInstance = (PFNGLDRAWELEMENTSINSTANCEDBASEINSTANCEPROC) get_proc("glDrawElementsInstancedBaseInstance");
	// gl_DrawElementsInstancedBaseVertex = (PFNGLDRAWELEMENTSINSTANCEDBASEVERTEXPROC) get_proc("glDrawElementsInstancedBaseVertex");
	// gl_DrawElementsInstancedBaseVertexBaseInstance = (PFNGLDRAWELEMENTSINSTANCEDBASEVERTEXBASEINSTANCEPROC) get_proc("glDrawElementsInstancedBaseVertexBaseInstance");
	// gl_DrawRangeElements = (PFNGLDRAWRANGEELEMENTSPROC) get_proc("glDrawRangeElements");
	// gl_DrawRangeElementsBaseVertex = (PFNGLDRAWRANGEELEMENTSBASEVERTEXPROC) get_proc("glDrawRangeElementsBaseVertex");
	// gl_DrawTransformFeedback = (PFNGLDRAWTRANSFORMFEEDBACKPROC) get_proc("glDrawTransformFeedback");
	// gl_DrawTransformFeedbackInstanced = (PFNGLDRAWTRANSFORMFEEDBACKINSTANCEDPROC) get_proc("glDrawTransformFeedbackInstanced");
	// gl_DrawTransformFeedbackStream = (PFNGLDRAWTRANSFORMFEEDBACKSTREAMPROC) get_proc("glDrawTransformFeedbackStream");
	// gl_DrawTransformFeedbackStreamInstanced = (PFNGLDRAWTRANSFORMFEEDBACKSTREAMINSTANCEDPROC) get_proc("glDrawTransformFeedbackStreamInstanced");
	gl_Enable = (PFNGLENABLEPROC) get_proc("glEnable");
	// gl_EnableVertexArrayAttrib = (PFNGLENABLEVERTEXARRAYATTRIBPROC) get_proc("glEnableVertexArrayAttrib");
	gl_EnableVertexAttribArray = (PFNGLENABLEVERTEXATTRIBARRAYPROC) get_proc("glEnableVertexAttribArray");
	// gl_Enablei = (PFNGLENABLEIPROC) get_proc("glEnablei");
	// gl_EndConditionalRender = (PFNGLENDCONDITIONALRENDERPROC) get_proc("glEndConditionalRender");
	// gl_EndQuery = (PFNGLENDQUERYPROC) get_proc("glEndQuery");
	// gl_EndQueryIndexed = (PFNGLENDQUERYINDEXEDPROC) get_proc("glEndQueryIndexed");
	// gl_EndTransformFeedback = (PFNGLENDTRANSFORMFEEDBACKPROC) get_proc("glEndTransformFeedback");
	// gl_FenceSync = (PFNGLFENCESYNCPROC) get_proc("glFenceSync");
	// gl_Finish = (PFNGLFINISHPROC) get_proc("glFinish");
	// gl_Flush = (PFNGLFLUSHPROC) get_proc("glFlush");
	// gl_FlushMappedBufferRange = (PFNGLFLUSHMAPPEDBUFFERRANGEPROC) get_proc("glFlushMappedBufferRange");
	// gl_FlushMappedNamedBufferRange = (PFNGLFLUSHMAPPEDNAMEDBUFFERRANGEPROC) get_proc("glFlushMappedNamedBufferRange");
	// gl_FramebufferParameteri = (PFNGLFRAMEBUFFERPARAMETERIPROC) get_proc("glFramebufferParameteri");
	// gl_FramebufferRenderbuffer = (PFNGLFRAMEBUFFERRENDERBUFFERPROC) get_proc("glFramebufferRenderbuffer");
	// gl_FramebufferTexture = (PFNGLFRAMEBUFFERTEXTUREPROC) get_proc("glFramebufferTexture");
	// gl_FramebufferTexture1D = (PFNGLFRAMEBUFFERTEXTURE1DPROC) get_proc("glFramebufferTexture1D");
	gl_FramebufferTexture2D = (PFNGLFRAMEBUFFERTEXTURE2DPROC) get_proc("glFramebufferTexture2D");
	// gl_FramebufferTexture3D = (PFNGLFRAMEBUFFERTEXTURE3DPROC) get_proc("glFramebufferTexture3D");
	// gl_FramebufferTextureLayer = (PFNGLFRAMEBUFFERTEXTURELAYERPROC) get_proc("glFramebufferTextureLayer");
	// gl_FrontFace = (PFNGLFRONTFACEPROC) get_proc("glFrontFace");
	gl_GenBuffers = (PFNGLGENBUFFERSPROC) get_proc("glGenBuffers");
	gl_GenFramebuffers = (PFNGLGENFRAMEBUFFERSPROC) get_proc("glGenFramebuffers");
	// gl_GenProgramPipelines = (PFNGLGENPROGRAMPIPELINESPROC) get_proc("glGenProgramPipelines");
	// gl_GenQueries = (PFNGLGENQUERIESPROC) get_proc("glGenQueries");
	// gl_GenRenderbuffers = (PFNGLGENRENDERBUFFERSPROC) get_proc("glGenRenderbuffers");
	// gl_GenSamplers = (PFNGLGENSAMPLERSPROC) get_proc("glGenSamplers");
	gl_GenTextures = (PFNGLGENTEXTURESPROC) get_proc("glGenTextures");
	// gl_GenTransformFeedbacks = (PFNGLGENTRANSFORMFEEDBACKSPROC) get_proc("glGenTransformFeedbacks");
	gl_GenVertexArrays = (PFNGLGENVERTEXARRAYSPROC) get_proc("glGenVertexArrays");
	// gl_GenerateMipmap = (PFNGLGENERATEMIPMAPPROC) get_proc("glGenerateMipmap");
	// gl_GenerateTextureMipmap = (PFNGLGENERATETEXTUREMIPMAPPROC) get_proc("glGenerateTextureMipmap");
	// gl_GetActiveAtomicCounterBufferiv = (PFNGLGETACTIVEATOMICCOUNTERBUFFERIVPROC) get_proc("glGetActiveAtomicCounterBufferiv");
	// gl_GetActiveAttrib = (PFNGLGETACTIVEATTRIBPROC) get_proc("glGetActiveAttrib");
	// gl_GetActiveSubroutineName = (PFNGLGETACTIVESUBROUTINENAMEPROC) get_proc("glGetActiveSubroutineName");
	// gl_GetActiveSubroutineUniformName = (PFNGLGETACTIVESUBROUTINEUNIFORMNAMEPROC) get_proc("glGetActiveSubroutineUniformName");
	// gl_GetActiveSubroutineUniformiv = (PFNGLGETACTIVESUBROUTINEUNIFORMIVPROC) get_proc("glGetActiveSubroutineUniformiv");
	// gl_GetActiveUniform = (PFNGLGETACTIVEUNIFORMPROC) get_proc("glGetActiveUniform");
	// gl_GetActiveUniformBlockName = (PFNGLGETACTIVEUNIFORMBLOCKNAMEPROC) get_proc("glGetActiveUniformBlockName");
	// gl_GetActiveUniformBlockiv = (PFNGLGETACTIVEUNIFORMBLOCKIVPROC) get_proc("glGetActiveUniformBlockiv");
	// gl_GetActiveUniformName = (PFNGLGETACTIVEUNIFORMNAMEPROC) get_proc("glGetActiveUniformName");
	// gl_GetActiveUniformsiv = (PFNGLGETACTIVEUNIFORMSIVPROC) get_proc("glGetActiveUniformsiv");
	// gl_GetAttachedShaders = (PFNGLGETATTACHEDSHADERSPROC) get_proc("glGetAttachedShaders");
	gl_GetAttribLocation = (PFNGLGETATTRIBLOCATIONPROC) get_proc("glGetAttribLocation");
	// gl_GetBooleani_v = (PFNGLGETBOOLEANI_VPROC) get_proc("glGetBooleani_v");
	// gl_GetBooleanv = (PFNGLGETBOOLEANVPROC) get_proc("glGetBooleanv");
	// gl_GetBufferParameteri64v = (PFNGLGETBUFFERPARAMETERI64VPROC) get_proc("glGetBufferParameteri64v");
	// gl_GetBufferParameteriv = (PFNGLGETBUFFERPARAMETERIVPROC) get_proc("glGetBufferParameteriv");
	// gl_GetBufferPointerv = (PFNGLGETBUFFERPOINTERVPROC) get_proc("glGetBufferPointerv");
	// gl_GetBufferSubData = (PFNGLGETBUFFERSUBDATAPROC) get_proc("glGetBufferSubData");
	// gl_GetCompressedTexImage = (PFNGLGETCOMPRESSEDTEXIMAGEPROC) get_proc("glGetCompressedTexImage");
	// gl_GetCompressedTextureImage = (PFNGLGETCOMPRESSEDTEXTUREIMAGEPROC) get_proc("glGetCompressedTextureImage");
	// gl_GetCompressedTextureSubImage = (PFNGLGETCOMPRESSEDTEXTURESUBIMAGEPROC) get_proc("glGetCompressedTextureSubImage");
	// gl_GetDebugMessageLog = (PFNGLGETDEBUGMESSAGELOGPROC) get_proc("glGetDebugMessageLog");
	// gl_GetDebugMessageLogARB = (PFNGLGETDEBUGMESSAGELOGARBPROC) get_proc("glGetDebugMessageLogARB");
	// gl_GetDoublei_v = (PFNGLGETDOUBLEI_VPROC) get_proc("glGetDoublei_v");
	// gl_GetDoublev = (PFNGLGETDOUBLEVPROC) get_proc("glGetDoublev");
	// gl_GetError = (PFNGLGETERRORPROC) get_proc("glGetError");
	// gl_GetFloati_v = (PFNGLGETFLOATI_VPROC) get_proc("glGetFloati_v");
	// gl_GetFloatv = (PFNGLGETFLOATVPROC) get_proc("glGetFloatv");
	// gl_GetFragDataIndex = (PFNGLGETFRAGDATAINDEXPROC) get_proc("glGetFragDataIndex");
	// gl_GetFragDataLocation = (PFNGLGETFRAGDATALOCATIONPROC) get_proc("glGetFragDataLocation");
	// gl_GetFramebufferAttachmentParameteriv = (PFNGLGETFRAMEBUFFERATTACHMENTPARAMETERIVPROC) get_proc("glGetFramebufferAttachmentParameteriv");
	// gl_GetFramebufferParameteriv = (PFNGLGETFRAMEBUFFERPARAMETERIVPROC) get_proc("glGetFramebufferParameteriv");
	// gl_GetGraphicsResetStatus = (PFNGLGETGRAPHICSRESETSTATUSPROC) get_proc("glGetGraphicsResetStatus");
	// gl_GetGraphicsResetStatusARB = (PFNGLGETGRAPHICSRESETSTATUSARBPROC) get_proc("glGetGraphicsResetStatusARB");
	// gl_GetImageHandleARB = (PFNGLGETIMAGEHANDLEARBPROC) get_proc("glGetImageHandleARB");
	// gl_GetInteger64i_v = (PFNGLGETINTEGER64I_VPROC) get_proc("glGetInteger64i_v");
	// gl_GetInteger64v = (PFNGLGETINTEGER64VPROC) get_proc("glGetInteger64v");
	// gl_GetIntegeri_v = (PFNGLGETINTEGERI_VPROC) get_proc("glGetIntegeri_v");
	gl_GetIntegerv = (PFNGLGETINTEGERVPROC) get_proc("glGetIntegerv");
	// gl_GetInternalformati64v = (PFNGLGETINTERNALFORMATI64VPROC) get_proc("glGetInternalformati64v");
	// gl_GetInternalformativ = (PFNGLGETINTERNALFORMATIVPROC) get_proc("glGetInternalformativ");
	// gl_GetMultisamplefv = (PFNGLGETMULTISAMPLEFVPROC) get_proc("glGetMultisamplefv");
	// gl_GetNamedBufferParameteri64v = (PFNGLGETNAMEDBUFFERPARAMETERI64VPROC) get_proc("glGetNamedBufferParameteri64v");
	// gl_GetNamedBufferParameteriv = (PFNGLGETNAMEDBUFFERPARAMETERIVPROC) get_proc("glGetNamedBufferParameteriv");
	// gl_GetNamedBufferPointerv = (PFNGLGETNAMEDBUFFERPOINTERVPROC) get_proc("glGetNamedBufferPointerv");
	// gl_GetNamedBufferSubData = (PFNGLGETNAMEDBUFFERSUBDATAPROC) get_proc("glGetNamedBufferSubData");
	// gl_GetNamedFramebufferAttachmentParameteriv = (PFNGLGETNAMEDFRAMEBUFFERATTACHMENTPARAMETERIVPROC) get_proc("glGetNamedFramebufferAttachmentParameteriv");
	// gl_GetNamedFramebufferParameteriv = (PFNGLGETNAMEDFRAMEBUFFERPARAMETERIVPROC) get_proc("glGetNamedFramebufferParameteriv");
	// gl_GetNamedRenderbufferParameteriv = (PFNGLGETNAMEDRENDERBUFFERPARAMETERIVPROC) get_proc("glGetNamedRenderbufferParameteriv");
	// gl_GetNamedStringARB = (PFNGLGETNAMEDSTRINGARBPROC) get_proc("glGetNamedStringARB");
	// gl_GetNamedStringivARB = (PFNGLGETNAMEDSTRINGIVARBPROC) get_proc("glGetNamedStringivARB");
	// gl_GetObjectLabel = (PFNGLGETOBJECTLABELPROC) get_proc("glGetObjectLabel");
	// gl_GetObjectPtrLabel = (PFNGLGETOBJECTPTRLABELPROC) get_proc("glGetObjectPtrLabel");
	// gl_GetPointerv = (PFNGLGETPOINTERVPROC) get_proc("glGetPointerv");
	// gl_GetProgramBinary = (PFNGLGETPROGRAMBINARYPROC) get_proc("glGetProgramBinary");
	gl_GetProgramInfoLog = (PFNGLGETPROGRAMINFOLOGPROC) get_proc("glGetProgramInfoLog");
	// gl_GetProgramInterfaceiv = (PFNGLGETPROGRAMINTERFACEIVPROC) get_proc("glGetProgramInterfaceiv");
	// gl_GetProgramPipelineInfoLog = (PFNGLGETPROGRAMPIPELINEINFOLOGPROC) get_proc("glGetProgramPipelineInfoLog");
	// gl_GetProgramPipelineiv = (PFNGLGETPROGRAMPIPELINEIVPROC) get_proc("glGetProgramPipelineiv");
	// gl_GetProgramResourceIndex = (PFNGLGETPROGRAMRESOURCEINDEXPROC) get_proc("glGetProgramResourceIndex");
	// gl_GetProgramResourceLocation = (PFNGLGETPROGRAMRESOURCELOCATIONPROC) get_proc("glGetProgramResourceLocation");
	// gl_GetProgramResourceLocationIndex = (PFNGLGETPROGRAMRESOURCELOCATIONINDEXPROC) get_proc("glGetProgramResourceLocationIndex");
	// gl_GetProgramResourceName = (PFNGLGETPROGRAMRESOURCENAMEPROC) get_proc("glGetProgramResourceName");
	// gl_GetProgramResourceiv = (PFNGLGETPROGRAMRESOURCEIVPROC) get_proc("glGetProgramResourceiv");
	// gl_GetProgramStageiv = (PFNGLGETPROGRAMSTAGEIVPROC) get_proc("glGetProgramStageiv");
	gl_GetProgramiv = (PFNGLGETPROGRAMIVPROC) get_proc("glGetProgramiv");
	// gl_GetQueryBufferObjecti64v = (PFNGLGETQUERYBUFFEROBJECTI64VPROC) get_proc("glGetQueryBufferObjecti64v");
	// gl_GetQueryBufferObjectiv = (PFNGLGETQUERYBUFFEROBJECTIVPROC) get_proc("glGetQueryBufferObjectiv");
	// gl_GetQueryBufferObjectui64v = (PFNGLGETQUERYBUFFEROBJECTUI64VPROC) get_proc("glGetQueryBufferObjectui64v");
	// gl_GetQueryBufferObjectuiv = (PFNGLGETQUERYBUFFEROBJECTUIVPROC) get_proc("glGetQueryBufferObjectuiv");
	// gl_GetQueryIndexediv = (PFNGLGETQUERYINDEXEDIVPROC) get_proc("glGetQueryIndexediv");
	// gl_GetQueryObjecti64v = (PFNGLGETQUERYOBJECTI64VPROC) get_proc("glGetQueryObjecti64v");
	// gl_GetQueryObjectiv = (PFNGLGETQUERYOBJECTIVPROC) get_proc("glGetQueryObjectiv");
	// gl_GetQueryObjectui64v = (PFNGLGETQUERYOBJECTUI64VPROC) get_proc("glGetQueryObjectui64v");
	// gl_GetQueryObjectuiv = (PFNGLGETQUERYOBJECTUIVPROC) get_proc("glGetQueryObjectuiv");
	// gl_GetQueryiv = (PFNGLGETQUERYIVPROC) get_proc("glGetQueryiv");
	// gl_GetRenderbufferParameteriv = (PFNGLGETRENDERBUFFERPARAMETERIVPROC) get_proc("glGetRenderbufferParameteriv");
	// gl_GetSamplerParameterIiv = (PFNGLGETSAMPLERPARAMETERIIVPROC) get_proc("glGetSamplerParameterIiv");
	// gl_GetSamplerParameterIuiv = (PFNGLGETSAMPLERPARAMETERIUIVPROC) get_proc("glGetSamplerParameterIuiv");
	// gl_GetSamplerParameterfv = (PFNGLGETSAMPLERPARAMETERFVPROC) get_proc("glGetSamplerParameterfv");
	// gl_GetSamplerParameteriv = (PFNGLGETSAMPLERPARAMETERIVPROC) get_proc("glGetSamplerParameteriv");
	gl_GetShaderInfoLog = (PFNGLGETSHADERINFOLOGPROC) get_proc("glGetShaderInfoLog");
	// gl_GetShaderPrecisionFormat = (PFNGLGETSHADERPRECISIONFORMATPROC) get_proc("glGetShaderPrecisionFormat");
	// gl_GetShaderSource = (PFNGLGETSHADERSOURCEPROC) get_proc("glGetShaderSource");
	gl_GetShaderiv = (PFNGLGETSHADERIVPROC) get_proc("glGetShaderiv");
	gl_GetString = (PFNGLGETSTRINGPROC) get_proc("glGetString");
	// gl_GetStringi = (PFNGLGETSTRINGIPROC) get_proc("glGetStringi");
	// gl_GetSubroutineIndex = (PFNGLGETSUBROUTINEINDEXPROC) get_proc("glGetSubroutineIndex");
	// gl_GetSubroutineUniformLocation = (PFNGLGETSUBROUTINEUNIFORMLOCATIONPROC) get_proc("glGetSubroutineUniformLocation");
	// gl_GetSynciv = (PFNGLGETSYNCIVPROC) get_proc("glGetSynciv");
	// gl_GetTexImage = (PFNGLGETTEXIMAGEPROC) get_proc("glGetTexImage");
	// gl_GetTexLevelParameterfv = (PFNGLGETTEXLEVELPARAMETERFVPROC) get_proc("glGetTexLevelParameterfv");
	// gl_GetTexLevelParameteriv = (PFNGLGETTEXLEVELPARAMETERIVPROC) get_proc("glGetTexLevelParameteriv");
	// gl_GetTexParameterIiv = (PFNGLGETTEXPARAMETERIIVPROC) get_proc("glGetTexParameterIiv");
	// gl_GetTexParameterIuiv = (PFNGLGETTEXPARAMETERIUIVPROC) get_proc("glGetTexParameterIuiv");
	// gl_GetTexParameterfv = (PFNGLGETTEXPARAMETERFVPROC) get_proc("glGetTexParameterfv");
	// gl_GetTexParameteriv = (PFNGLGETTEXPARAMETERIVPROC) get_proc("glGetTexParameteriv");
	// gl_GetTextureHandleARB = (PFNGLGETTEXTUREHANDLEARBPROC) get_proc("glGetTextureHandleARB");
	// gl_GetTextureImage = (PFNGLGETTEXTUREIMAGEPROC) get_proc("glGetTextureImage");
	// gl_GetTextureLevelParameterfv = (PFNGLGETTEXTURELEVELPARAMETERFVPROC) get_proc("glGetTextureLevelParameterfv");
	// gl_GetTextureLevelParameteriv = (PFNGLGETTEXTURELEVELPARAMETERIVPROC) get_proc("glGetTextureLevelParameteriv");
	// gl_GetTextureParameterIiv = (PFNGLGETTEXTUREPARAMETERIIVPROC) get_proc("glGetTextureParameterIiv");
	// gl_GetTextureParameterIuiv = (PFNGLGETTEXTUREPARAMETERIUIVPROC) get_proc("glGetTextureParameterIuiv");
	// gl_GetTextureParameterfv = (PFNGLGETTEXTUREPARAMETERFVPROC) get_proc("glGetTextureParameterfv");
	// gl_GetTextureParameteriv = (PFNGLGETTEXTUREPARAMETERIVPROC) get_proc("glGetTextureParameteriv");
	// gl_GetTextureSamplerHandleARB = (PFNGLGETTEXTURESAMPLERHANDLEARBPROC) get_proc("glGetTextureSamplerHandleARB");
	// gl_GetTextureSubImage = (PFNGLGETTEXTURESUBIMAGEPROC) get_proc("glGetTextureSubImage");
	// gl_GetTransformFeedbackVarying = (PFNGLGETTRANSFORMFEEDBACKVARYINGPROC) get_proc("glGetTransformFeedbackVarying");
	// gl_GetTransformFeedbacki64_v = (PFNGLGETTRANSFORMFEEDBACKI64_VPROC) get_proc("glGetTransformFeedbacki64_v");
	// gl_GetTransformFeedbacki_v = (PFNGLGETTRANSFORMFEEDBACKI_VPROC) get_proc("glGetTransformFeedbacki_v");
	// gl_GetTransformFeedbackiv = (PFNGLGETTRANSFORMFEEDBACKIVPROC) get_proc("glGetTransformFeedbackiv");
	// gl_GetUniformBlockIndex = (PFNGLGETUNIFORMBLOCKINDEXPROC) get_proc("glGetUniformBlockIndex");
	// gl_GetUniformIndices = (PFNGLGETUNIFORMINDICESPROC) get_proc("glGetUniformIndices");
	gl_GetUniformLocation = (PFNGLGETUNIFORMLOCATIONPROC) get_proc("glGetUniformLocation");
	// gl_GetUniformSubroutineuiv = (PFNGLGETUNIFORMSUBROUTINEUIVPROC) get_proc("glGetUniformSubroutineuiv");
	// gl_GetUniformdv = (PFNGLGETUNIFORMDVPROC) get_proc("glGetUniformdv");
	// gl_GetUniformfv = (PFNGLGETUNIFORMFVPROC) get_proc("glGetUniformfv");
	// gl_GetUniformiv = (PFNGLGETUNIFORMIVPROC) get_proc("glGetUniformiv");
	// gl_GetUniformuiv = (PFNGLGETUNIFORMUIVPROC) get_proc("glGetUniformuiv");
	// gl_GetVertexArrayIndexed64iv = (PFNGLGETVERTEXARRAYINDEXED64IVPROC) get_proc("glGetVertexArrayIndexed64iv");
	// gl_GetVertexArrayIndexediv = (PFNGLGETVERTEXARRAYINDEXEDIVPROC) get_proc("glGetVertexArrayIndexediv");
	// gl_GetVertexArrayiv = (PFNGLGETVERTEXARRAYIVPROC) get_proc("glGetVertexArrayiv");
	// gl_GetVertexAttribIiv = (PFNGLGETVERTEXATTRIBIIVPROC) get_proc("glGetVertexAttribIiv");
	// gl_GetVertexAttribIuiv = (PFNGLGETVERTEXATTRIBIUIVPROC) get_proc("glGetVertexAttribIuiv");
	// gl_GetVertexAttribLdv = (PFNGLGETVERTEXATTRIBLDVPROC) get_proc("glGetVertexAttribLdv");
	// gl_GetVertexAttribLui64vARB = (PFNGLGETVERTEXATTRIBLUI64VARBPROC) get_proc("glGetVertexAttribLui64vARB");
	// gl_GetVertexAttribPointerv = (PFNGLGETVERTEXATTRIBPOINTERVPROC) get_proc("glGetVertexAttribPointerv");
	// gl_GetVertexAttribdv = (PFNGLGETVERTEXATTRIBDVPROC) get_proc("glGetVertexAttribdv");
	// gl_GetVertexAttribfv = (PFNGLGETVERTEXATTRIBFVPROC) get_proc("glGetVertexAttribfv");
	// gl_GetVertexAttribiv = (PFNGLGETVERTEXATTRIBIVPROC) get_proc("glGetVertexAttribiv");
	// gl_GetnCompressedTexImage = (PFNGLGETNCOMPRESSEDTEXIMAGEPROC) get_proc("glGetnCompressedTexImage");
	// gl_GetnCompressedTexImageARB = (PFNGLGETNCOMPRESSEDTEXIMAGEARBPROC) get_proc("glGetnCompressedTexImageARB");
	// gl_GetnTexImage = (PFNGLGETNTEXIMAGEPROC) get_proc("glGetnTexImage");
	// gl_GetnTexImageARB = (PFNGLGETNTEXIMAGEARBPROC) get_proc("glGetnTexImageARB");
	// gl_GetnUniformdv = (PFNGLGETNUNIFORMDVPROC) get_proc("glGetnUniformdv");
	// gl_GetnUniformdvARB = (PFNGLGETNUNIFORMDVARBPROC) get_proc("glGetnUniformdvARB");
	// gl_GetnUniformfv = (PFNGLGETNUNIFORMFVPROC) get_proc("glGetnUniformfv");
	// gl_GetnUniformfvARB = (PFNGLGETNUNIFORMFVARBPROC) get_proc("glGetnUniformfvARB");
	// gl_GetnUniformiv = (PFNGLGETNUNIFORMIVPROC) get_proc("glGetnUniformiv");
	// gl_GetnUniformivARB = (PFNGLGETNUNIFORMIVARBPROC) get_proc("glGetnUniformivARB");
	// gl_GetnUniformuiv = (PFNGLGETNUNIFORMUIVPROC) get_proc("glGetnUniformuiv");
	// gl_GetnUniformuivARB = (PFNGLGETNUNIFORMUIVARBPROC) get_proc("glGetnUniformuivARB");
	// gl_Hint = (PFNGLHINTPROC) get_proc("glHint");
	// gl_InvalidateBufferData = (PFNGLINVALIDATEBUFFERDATAPROC) get_proc("glInvalidateBufferData");
	// gl_InvalidateBufferSubData = (PFNGLINVALIDATEBUFFERSUBDATAPROC) get_proc("glInvalidateBufferSubData");
	// gl_InvalidateFramebuffer = (PFNGLINVALIDATEFRAMEBUFFERPROC) get_proc("glInvalidateFramebuffer");
	// gl_InvalidateNamedFramebufferData = (PFNGLINVALIDATENAMEDFRAMEBUFFERDATAPROC) get_proc("glInvalidateNamedFramebufferData");
	// gl_InvalidateNamedFramebufferSubData = (PFNGLINVALIDATENAMEDFRAMEBUFFERSUBDATAPROC) get_proc("glInvalidateNamedFramebufferSubData");
	// gl_InvalidateSubFramebuffer = (PFNGLINVALIDATESUBFRAMEBUFFERPROC) get_proc("glInvalidateSubFramebuffer");
	// gl_InvalidateTexImage = (PFNGLINVALIDATETEXIMAGEPROC) get_proc("glInvalidateTexImage");
	// gl_InvalidateTexSubImage = (PFNGLINVALIDATETEXSUBIMAGEPROC) get_proc("glInvalidateTexSubImage");
	// gl_IsBuffer = (PFNGLISBUFFERPROC) get_proc("glIsBuffer");
	// gl_IsEnabled = (PFNGLISENABLEDPROC) get_proc("glIsEnabled");
	// gl_IsEnabledi = (PFNGLISENABLEDIPROC) get_proc("glIsEnabledi");
	// gl_IsFramebuffer = (PFNGLISFRAMEBUFFERPROC) get_proc("glIsFramebuffer");
	// gl_IsImageHandleResidentARB = (PFNGLISIMAGEHANDLERESIDENTARBPROC) get_proc("glIsImageHandleResidentARB");
	// gl_IsNamedStringARB = (PFNGLISNAMEDSTRINGARBPROC) get_proc("glIsNamedStringARB");
	// gl_IsProgram = (PFNGLISPROGRAMPROC) get_proc("glIsProgram");
	// gl_IsProgramPipeline = (PFNGLISPROGRAMPIPELINEPROC) get_proc("glIsProgramPipeline");
	// gl_IsQuery = (PFNGLISQUERYPROC) get_proc("glIsQuery");
	// gl_IsRenderbuffer = (PFNGLISRENDERBUFFERPROC) get_proc("glIsRenderbuffer");
	// gl_IsSampler = (PFNGLISSAMPLERPROC) get_proc("glIsSampler");
	// gl_IsShader = (PFNGLISSHADERPROC) get_proc("glIsShader");
	// gl_IsSync = (PFNGLISSYNCPROC) get_proc("glIsSync");
	// gl_IsTexture = (PFNGLISTEXTUREPROC) get_proc("glIsTexture");
	// gl_IsTextureHandleResidentARB = (PFNGLISTEXTUREHANDLERESIDENTARBPROC) get_proc("glIsTextureHandleResidentARB");
	// gl_IsTransformFeedback = (PFNGLISTRANSFORMFEEDBACKPROC) get_proc("glIsTransformFeedback");
	// gl_IsVertexArray = (PFNGLISVERTEXARRAYPROC) get_proc("glIsVertexArray");
	// gl_LineWidth = (PFNGLLINEWIDTHPROC) get_proc("glLineWidth");
	gl_LinkProgram = (PFNGLLINKPROGRAMPROC) get_proc("glLinkProgram");
	// gl_LogicOp = (PFNGLLOGICOPPROC) get_proc("glLogicOp");
	// gl_MakeImageHandleNonResidentARB = (PFNGLMAKEIMAGEHANDLENONRESIDENTARBPROC) get_proc("glMakeImageHandleNonResidentARB");
	// gl_MakeImageHandleResidentARB = (PFNGLMAKEIMAGEHANDLERESIDENTARBPROC) get_proc("glMakeImageHandleResidentARB");
	// gl_MakeTextureHandleNonResidentARB = (PFNGLMAKETEXTUREHANDLENONRESIDENTARBPROC) get_proc("glMakeTextureHandleNonResidentARB");
	// gl_MakeTextureHandleResidentARB = (PFNGLMAKETEXTUREHANDLERESIDENTARBPROC) get_proc("glMakeTextureHandleResidentARB");
	// gl_MapBuffer = (PFNGLMAPBUFFERPROC) get_proc("glMapBuffer");
	// gl_MapBufferRange = (PFNGLMAPBUFFERRANGEPROC) get_proc("glMapBufferRange");
	// gl_MapNamedBuffer = (PFNGLMAPNAMEDBUFFERPROC) get_proc("glMapNamedBuffer");
	// gl_MapNamedBufferRange = (PFNGLMAPNAMEDBUFFERRANGEPROC) get_proc("glMapNamedBufferRange");
	// gl_MemoryBarrier = (PFNGLMEMORYBARRIERPROC) get_proc("glMemoryBarrier");
	// gl_MemoryBarrierByRegion = (PFNGLMEMORYBARRIERBYREGIONPROC) get_proc("glMemoryBarrierByRegion");
	// gl_MinSampleShading = (PFNGLMINSAMPLESHADINGPROC) get_proc("glMinSampleShading");
	// gl_MinSampleShadingARB = (PFNGLMINSAMPLESHADINGARBPROC) get_proc("glMinSampleShadingARB");
	// gl_MultiDrawArrays = (PFNGLMULTIDRAWARRAYSPROC) get_proc("glMultiDrawArrays");
	// gl_MultiDrawArraysIndirect = (PFNGLMULTIDRAWARRAYSINDIRECTPROC) get_proc("glMultiDrawArraysIndirect");
	// gl_MultiDrawArraysIndirectCountARB = (PFNGLMULTIDRAWARRAYSINDIRECTCOUNTARBPROC) get_proc("glMultiDrawArraysIndirectCountARB");
	// gl_MultiDrawElements = (PFNGLMULTIDRAWELEMENTSPROC) get_proc("glMultiDrawElements");
	// gl_MultiDrawElementsBaseVertex = (PFNGLMULTIDRAWELEMENTSBASEVERTEXPROC) get_proc("glMultiDrawElementsBaseVertex");
	// gl_MultiDrawElementsIndirect = (PFNGLMULTIDRAWELEMENTSINDIRECTPROC) get_proc("glMultiDrawElementsIndirect");
	// gl_MultiDrawElementsIndirectCountARB = (PFNGLMULTIDRAWELEMENTSINDIRECTCOUNTARBPROC) get_proc("glMultiDrawElementsIndirectCountARB");
	// gl_NamedBufferData = (PFNGLNAMEDBUFFERDATAPROC) get_proc("glNamedBufferData");
	// gl_NamedBufferPageCommitmentARB = (PFNGLNAMEDBUFFERPAGECOMMITMENTARBPROC) get_proc("glNamedBufferPageCommitmentARB");
	// gl_NamedBufferPageCommitmentEXT = (PFNGLNAMEDBUFFERPAGECOMMITMENTEXTPROC) get_proc("glNamedBufferPageCommitmentEXT");
	// gl_NamedBufferStorage = (PFNGLNAMEDBUFFERSTORAGEPROC) get_proc("glNamedBufferStorage");
	// gl_NamedBufferSubData = (PFNGLNAMEDBUFFERSUBDATAPROC) get_proc("glNamedBufferSubData");
	// gl_NamedFramebufferDrawBuffer = (PFNGLNAMEDFRAMEBUFFERDRAWBUFFERPROC) get_proc("glNamedFramebufferDrawBuffer");
	// gl_NamedFramebufferDrawBuffers = (PFNGLNAMEDFRAMEBUFFERDRAWBUFFERSPROC) get_proc("glNamedFramebufferDrawBuffers");
	// gl_NamedFramebufferParameteri = (PFNGLNAMEDFRAMEBUFFERPARAMETERIPROC) get_proc("glNamedFramebufferParameteri");
	// gl_NamedFramebufferReadBuffer = (PFNGLNAMEDFRAMEBUFFERREADBUFFERPROC) get_proc("glNamedFramebufferReadBuffer");
	// gl_NamedFramebufferRenderbuffer = (PFNGLNAMEDFRAMEBUFFERRENDERBUFFERPROC) get_proc("glNamedFramebufferRenderbuffer");
	// gl_NamedFramebufferTexture = (PFNGLNAMEDFRAMEBUFFERTEXTUREPROC) get_proc("glNamedFramebufferTexture");
	// gl_NamedFramebufferTextureLayer = (PFNGLNAMEDFRAMEBUFFERTEXTURELAYERPROC) get_proc("glNamedFramebufferTextureLayer");
	// gl_NamedRenderbufferStorage = (PFNGLNAMEDRENDERBUFFERSTORAGEPROC) get_proc("glNamedRenderbufferStorage");
	// gl_NamedRenderbufferStorageMultisample = (PFNGLNAMEDRENDERBUFFERSTORAGEMULTISAMPLEPROC) get_proc("glNamedRenderbufferStorageMultisample");
	// gl_NamedStringARB = (PFNGLNAMEDSTRINGARBPROC) get_proc("glNamedStringARB");
	// gl_ObjectLabel = (PFNGLOBJECTLABELPROC) get_proc("glObjectLabel");
	// gl_ObjectPtrLabel = (PFNGLOBJECTPTRLABELPROC) get_proc("glObjectPtrLabel");
	// gl_PatchParameterfv = (PFNGLPATCHPARAMETERFVPROC) get_proc("glPatchParameterfv");
	// gl_PatchParameteri = (PFNGLPATCHPARAMETERIPROC) get_proc("glPatchParameteri");
	// gl_PauseTransformFeedback = (PFNGLPAUSETRANSFORMFEEDBACKPROC) get_proc("glPauseTransformFeedback");
	// gl_PixelStoref = (PFNGLPIXELSTOREFPROC) get_proc("glPixelStoref");
	// gl_PixelStorei = (PFNGLPIXELSTOREIPROC) get_proc("glPixelStorei");
	// gl_PointParameterf = (PFNGLPOINTPARAMETERFPROC) get_proc("glPointParameterf");
	// gl_PointParameterfv = (PFNGLPOINTPARAMETERFVPROC) get_proc("glPointParameterfv");
	// gl_PointParameteri = (PFNGLPOINTPARAMETERIPROC) get_proc("glPointParameteri");
	// gl_PointParameteriv = (PFNGLPOINTPARAMETERIVPROC) get_proc("glPointParameteriv");
	// gl_PointSize = (PFNGLPOINTSIZEPROC) get_proc("glPointSize");
	// gl_PolygonMode = (PFNGLPOLYGONMODEPROC) get_proc("glPolygonMode");
	// gl_PolygonOffset = (PFNGLPOLYGONOFFSETPROC) get_proc("glPolygonOffset");
	// gl_PopDebugGroup = (PFNGLPOPDEBUGGROUPPROC) get_proc("glPopDebugGroup");
	// gl_PrimitiveRestartIndex = (PFNGLPRIMITIVERESTARTINDEXPROC) get_proc("glPrimitiveRestartIndex");
	// gl_ProgramBinary = (PFNGLPROGRAMBINARYPROC) get_proc("glProgramBinary");
	// gl_ProgramParameteri = (PFNGLPROGRAMPARAMETERIPROC) get_proc("glProgramParameteri");
	// gl_ProgramUniform1d = (PFNGLPROGRAMUNIFORM1DPROC) get_proc("glProgramUniform1d");
	// gl_ProgramUniform1dv = (PFNGLPROGRAMUNIFORM1DVPROC) get_proc("glProgramUniform1dv");
	// gl_ProgramUniform1f = (PFNGLPROGRAMUNIFORM1FPROC) get_proc("glProgramUniform1f");
	// gl_ProgramUniform1fv = (PFNGLPROGRAMUNIFORM1FVPROC) get_proc("glProgramUniform1fv");
	// gl_ProgramUniform1i = (PFNGLPROGRAMUNIFORM1IPROC) get_proc("glProgramUniform1i");
	// gl_ProgramUniform1iv = (PFNGLPROGRAMUNIFORM1IVPROC) get_proc("glProgramUniform1iv");
	// gl_ProgramUniform1ui = (PFNGLPROGRAMUNIFORM1UIPROC) get_proc("glProgramUniform1ui");
	// gl_ProgramUniform1uiv = (PFNGLPROGRAMUNIFORM1UIVPROC) get_proc("glProgramUniform1uiv");
	// gl_ProgramUniform2d = (PFNGLPROGRAMUNIFORM2DPROC) get_proc("glProgramUniform2d");
	// gl_ProgramUniform2dv = (PFNGLPROGRAMUNIFORM2DVPROC) get_proc("glProgramUniform2dv");
	// gl_ProgramUniform2f = (PFNGLPROGRAMUNIFORM2FPROC) get_proc("glProgramUniform2f");
	// gl_ProgramUniform2fv = (PFNGLPROGRAMUNIFORM2FVPROC) get_proc("glProgramUniform2fv");
	// gl_ProgramUniform2i = (PFNGLPROGRAMUNIFORM2IPROC) get_proc("glProgramUniform2i");
	// gl_ProgramUniform2iv = (PFNGLPROGRAMUNIFORM2IVPROC) get_proc("glProgramUniform2iv");
	// gl_ProgramUniform2ui = (PFNGLPROGRAMUNIFORM2UIPROC) get_proc("glProgramUniform2ui");
	// gl_ProgramUniform2uiv = (PFNGLPROGRAMUNIFORM2UIVPROC) get_proc("glProgramUniform2uiv");
	// gl_ProgramUniform3d = (PFNGLPROGRAMUNIFORM3DPROC) get_proc("glProgramUniform3d");
	// gl_ProgramUniform3dv = (PFNGLPROGRAMUNIFORM3DVPROC) get_proc("glProgramUniform3dv");
	// gl_ProgramUniform3f = (PFNGLPROGRAMUNIFORM3FPROC) get_proc("glProgramUniform3f");
	// gl_ProgramUniform3fv = (PFNGLPROGRAMUNIFORM3FVPROC) get_proc("glProgramUniform3fv");
	// gl_ProgramUniform3i = (PFNGLPROGRAMUNIFORM3IPROC) get_proc("glProgramUniform3i");
	// gl_ProgramUniform3iv = (PFNGLPROGRAMUNIFORM3IVPROC) get_proc("glProgramUniform3iv");
	// gl_ProgramUniform3ui = (PFNGLPROGRAMUNIFORM3UIPROC) get_proc("glProgramUniform3ui");
	// gl_ProgramUniform3uiv = (PFNGLPROGRAMUNIFORM3UIVPROC) get_proc("glProgramUniform3uiv");
	// gl_ProgramUniform4d = (PFNGLPROGRAMUNIFORM4DPROC) get_proc("glProgramUniform4d");
	// gl_ProgramUniform4dv = (PFNGLPROGRAMUNIFORM4DVPROC) get_proc("glProgramUniform4dv");
	// gl_ProgramUniform4f = (PFNGLPROGRAMUNIFORM4FPROC) get_proc("glProgramUniform4f");
	// gl_ProgramUniform4fv = (PFNGLPROGRAMUNIFORM4FVPROC) get_proc("glProgramUniform4fv");
	// gl_ProgramUniform4i = (PFNGLPROGRAMUNIFORM4IPROC) get_proc("glProgramUniform4i");
	// gl_ProgramUniform4iv = (PFNGLPROGRAMUNIFORM4IVPROC) get_proc("glProgramUniform4iv");
	// gl_ProgramUniform4ui = (PFNGLPROGRAMUNIFORM4UIPROC) get_proc("glProgramUniform4ui");
	// gl_ProgramUniform4uiv = (PFNGLPROGRAMUNIFORM4UIVPROC) get_proc("glProgramUniform4uiv");
	// gl_ProgramUniformHandleui64ARB = (PFNGLPROGRAMUNIFORMHANDLEUI64ARBPROC) get_proc("glProgramUniformHandleui64ARB");
	// gl_ProgramUniformHandleui64vARB = (PFNGLPROGRAMUNIFORMHANDLEUI64VARBPROC) get_proc("glProgramUniformHandleui64vARB");
	// gl_ProgramUniformMatrix2dv = (PFNGLPROGRAMUNIFORMMATRIX2DVPROC) get_proc("glProgramUniformMatrix2dv");
	// gl_ProgramUniformMatrix2fv = (PFNGLPROGRAMUNIFORMMATRIX2FVPROC) get_proc("glProgramUniformMatrix2fv");
	// gl_ProgramUniformMatrix2x3dv = (PFNGLPROGRAMUNIFORMMATRIX2X3DVPROC) get_proc("glProgramUniformMatrix2x3dv");
	// gl_ProgramUniformMatrix2x3fv = (PFNGLPROGRAMUNIFORMMATRIX2X3FVPROC) get_proc("glProgramUniformMatrix2x3fv");
	// gl_ProgramUniformMatrix2x4dv = (PFNGLPROGRAMUNIFORMMATRIX2X4DVPROC) get_proc("glProgramUniformMatrix2x4dv");
	// gl_ProgramUniformMatrix2x4fv = (PFNGLPROGRAMUNIFORMMATRIX2X4FVPROC) get_proc("glProgramUniformMatrix2x4fv");
	// gl_ProgramUniformMatrix3dv = (PFNGLPROGRAMUNIFORMMATRIX3DVPROC) get_proc("glProgramUniformMatrix3dv");
	// gl_ProgramUniformMatrix3fv = (PFNGLPROGRAMUNIFORMMATRIX3FVPROC) get_proc("glProgramUniformMatrix3fv");
	// gl_ProgramUniformMatrix3x2dv = (PFNGLPROGRAMUNIFORMMATRIX3X2DVPROC) get_proc("glProgramUniformMatrix3x2dv");
	// gl_ProgramUniformMatrix3x2fv = (PFNGLPROGRAMUNIFORMMATRIX3X2FVPROC) get_proc("glProgramUniformMatrix3x2fv");
	// gl_ProgramUniformMatrix3x4dv = (PFNGLPROGRAMUNIFORMMATRIX3X4DVPROC) get_proc("glProgramUniformMatrix3x4dv");
	// gl_ProgramUniformMatrix3x4fv = (PFNGLPROGRAMUNIFORMMATRIX3X4FVPROC) get_proc("glProgramUniformMatrix3x4fv");
	// gl_ProgramUniformMatrix4dv = (PFNGLPROGRAMUNIFORMMATRIX4DVPROC) get_proc("glProgramUniformMatrix4dv");
	// gl_ProgramUniformMatrix4fv = (PFNGLPROGRAMUNIFORMMATRIX4FVPROC) get_proc("glProgramUniformMatrix4fv");
	// gl_ProgramUniformMatrix4x2dv = (PFNGLPROGRAMUNIFORMMATRIX4X2DVPROC) get_proc("glProgramUniformMatrix4x2dv");
	// gl_ProgramUniformMatrix4x2fv = (PFNGLPROGRAMUNIFORMMATRIX4X2FVPROC) get_proc("glProgramUniformMatrix4x2fv");
	// gl_ProgramUniformMatrix4x3dv = (PFNGLPROGRAMUNIFORMMATRIX4X3DVPROC) get_proc("glProgramUniformMatrix4x3dv");
	// gl_ProgramUniformMatrix4x3fv = (PFNGLPROGRAMUNIFORMMATRIX4X3FVPROC) get_proc("glProgramUniformMatrix4x3fv");
	// gl_ProvokingVertex = (PFNGLPROVOKINGVERTEXPROC) get_proc("glProvokingVertex");
	// gl_PushDebugGroup = (PFNGLPUSHDEBUGGROUPPROC) get_proc("glPushDebugGroup");
	// gl_QueryCounter = (PFNGLQUERYCOUNTERPROC) get_proc("glQueryCounter");
	// gl_ReadBuffer = (PFNGLREADBUFFERPROC) get_proc("glReadBuffer");
	// gl_ReadPixels = (PFNGLREADPIXELSPROC) get_proc("glReadPixels");
	// gl_ReadnPixels = (PFNGLREADNPIXELSPROC) get_proc("glReadnPixels");
	// gl_ReadnPixelsARB = (PFNGLREADNPIXELSARBPROC) get_proc("glReadnPixelsARB");
	// gl_ReleaseShaderCompiler = (PFNGLRELEASESHADERCOMPILERPROC) get_proc("glReleaseShaderCompiler");
	// gl_RenderbufferStorage = (PFNGLRENDERBUFFERSTORAGEPROC) get_proc("glRenderbufferStorage");
	// gl_RenderbufferStorageMultisample = (PFNGLRENDERBUFFERSTORAGEMULTISAMPLEPROC) get_proc("glRenderbufferStorageMultisample");
	// gl_ResumeTransformFeedback = (PFNGLRESUMETRANSFORMFEEDBACKPROC) get_proc("glResumeTransformFeedback");
	// gl_SampleCoverage = (PFNGLSAMPLECOVERAGEPROC) get_proc("glSampleCoverage");
	// gl_SampleMaski = (PFNGLSAMPLEMASKIPROC) get_proc("glSampleMaski");
	// gl_SamplerParameterIiv = (PFNGLSAMPLERPARAMETERIIVPROC) get_proc("glSamplerParameterIiv");
	// gl_SamplerParameterIuiv = (PFNGLSAMPLERPARAMETERIUIVPROC) get_proc("glSamplerParameterIuiv");
	// gl_SamplerParameterf = (PFNGLSAMPLERPARAMETERFPROC) get_proc("glSamplerParameterf");
	// gl_SamplerParameterfv = (PFNGLSAMPLERPARAMETERFVPROC) get_proc("glSamplerParameterfv");
	// gl_SamplerParameteri = (PFNGLSAMPLERPARAMETERIPROC) get_proc("glSamplerParameteri");
	// gl_SamplerParameteriv = (PFNGLSAMPLERPARAMETERIVPROC) get_proc("glSamplerParameteriv");
	// gl_Scissor = (PFNGLSCISSORPROC) get_proc("glScissor");
	// gl_ScissorArrayv = (PFNGLSCISSORARRAYVPROC) get_proc("glScissorArrayv");
	// gl_ScissorIndexed = (PFNGLSCISSORINDEXEDPROC) get_proc("glScissorIndexed");
	// gl_ScissorIndexedv = (PFNGLSCISSORINDEXEDVPROC) get_proc("glScissorIndexedv");
	// gl_ShaderBinary = (PFNGLSHADERBINARYPROC) get_proc("glShaderBinary");
	gl_ShaderSource = (PFNGLSHADERSOURCEPROC) get_proc("glShaderSource");
	// gl_ShaderStorageBlockBinding = (PFNGLSHADERSTORAGEBLOCKBINDINGPROC) get_proc("glShaderStorageBlockBinding");
	// gl_StencilFunc = (PFNGLSTENCILFUNCPROC) get_proc("glStencilFunc");
	// gl_StencilFuncSeparate = (PFNGLSTENCILFUNCSEPARATEPROC) get_proc("glStencilFuncSeparate");
	// gl_StencilMask = (PFNGLSTENCILMASKPROC) get_proc("glStencilMask");
	// gl_StencilMaskSeparate = (PFNGLSTENCILMASKSEPARATEPROC) get_proc("glStencilMaskSeparate");
	// gl_StencilOp = (PFNGLSTENCILOPPROC) get_proc("glStencilOp");
	// gl_StencilOpSeparate = (PFNGLSTENCILOPSEPARATEPROC) get_proc("glStencilOpSeparate");
	// gl_TexBuffer = (PFNGLTEXBUFFERPROC) get_proc("glTexBuffer");
	// gl_TexBufferRange = (PFNGLTEXBUFFERRANGEPROC) get_proc("glTexBufferRange");
	gl_TexImage1D = (PFNGLTEXIMAGE1DPROC) get_proc("glTexImage1D");
	gl_TexImage2D = (PFNGLTEXIMAGE2DPROC) get_proc("glTexImage2D");
	// gl_TexImage2DMultisample = (PFNGLTEXIMAGE2DMULTISAMPLEPROC) get_proc("glTexImage2DMultisample");
	// gl_TexImage3D = (PFNGLTEXIMAGE3DPROC) get_proc("glTexImage3D");
	// gl_TexImage3DMultisample = (PFNGLTEXIMAGE3DMULTISAMPLEPROC) get_proc("glTexImage3DMultisample");
	// gl_TexPageCommitmentARB = (PFNGLTEXPAGECOMMITMENTARBPROC) get_proc("glTexPageCommitmentARB");
	// gl_TexParameterIiv = (PFNGLTEXPARAMETERIIVPROC) get_proc("glTexParameterIiv");
	// gl_TexParameterIuiv = (PFNGLTEXPARAMETERIUIVPROC) get_proc("glTexParameterIuiv");
	// gl_TexParameterf = (PFNGLTEXPARAMETERFPROC) get_proc("glTexParameterf");
	// gl_TexParameterfv = (PFNGLTEXPARAMETERFVPROC) get_proc("glTexParameterfv");
	gl_TexParameteri = (PFNGLTEXPARAMETERIPROC) get_proc("glTexParameteri");
	// gl_TexParameteriv = (PFNGLTEXPARAMETERIVPROC) get_proc("glTexParameteriv");
	// gl_TexStorage1D = (PFNGLTEXSTORAGE1DPROC) get_proc("glTexStorage1D");
	// gl_TexStorage2D = (PFNGLTEXSTORAGE2DPROC) get_proc("glTexStorage2D");
	// gl_TexStorage2DMultisample = (PFNGLTEXSTORAGE2DMULTISAMPLEPROC) get_proc("glTexStorage2DMultisample");
	// gl_TexStorage3D = (PFNGLTEXSTORAGE3DPROC) get_proc("glTexStorage3D");
	// gl_TexStorage3DMultisample = (PFNGLTEXSTORAGE3DMULTISAMPLEPROC) get_proc("glTexStorage3DMultisample");
	// gl_TexSubImage1D = (PFNGLTEXSUBIMAGE1DPROC) get_proc("glTexSubImage1D");
	// gl_TexSubImage2D = (PFNGLTEXSUBIMAGE2DPROC) get_proc("glTexSubImage2D");
	// gl_TexSubImage3D = (PFNGLTEXSUBIMAGE3DPROC) get_proc("glTexSubImage3D");
	// gl_TextureBarrier = (PFNGLTEXTUREBARRIERPROC) get_proc("glTextureBarrier");
	// gl_TextureBuffer = (PFNGLTEXTUREBUFFERPROC) get_proc("glTextureBuffer");
	// gl_TextureBufferRange = (PFNGLTEXTUREBUFFERRANGEPROC) get_proc("glTextureBufferRange");
	// gl_TextureParameterIiv = (PFNGLTEXTUREPARAMETERIIVPROC) get_proc("glTextureParameterIiv");
	// gl_TextureParameterIuiv = (PFNGLTEXTUREPARAMETERIUIVPROC) get_proc("glTextureParameterIuiv");
	// gl_TextureParameterf = (PFNGLTEXTUREPARAMETERFPROC) get_proc("glTextureParameterf");
	// gl_TextureParameterfv = (PFNGLTEXTUREPARAMETERFVPROC) get_proc("glTextureParameterfv");
	// gl_TextureParameteri = (PFNGLTEXTUREPARAMETERIPROC) get_proc("glTextureParameteri");
	// gl_TextureParameteriv = (PFNGLTEXTUREPARAMETERIVPROC) get_proc("glTextureParameteriv");
	// gl_TextureStorage1D = (PFNGLTEXTURESTORAGE1DPROC) get_proc("glTextureStorage1D");
	// gl_TextureStorage2D = (PFNGLTEXTURESTORAGE2DPROC) get_proc("glTextureStorage2D");
	// gl_TextureStorage2DMultisample = (PFNGLTEXTURESTORAGE2DMULTISAMPLEPROC) get_proc("glTextureStorage2DMultisample");
	// gl_TextureStorage3D = (PFNGLTEXTURESTORAGE3DPROC) get_proc("glTextureStorage3D");
	// gl_TextureStorage3DMultisample = (PFNGLTEXTURESTORAGE3DMULTISAMPLEPROC) get_proc("glTextureStorage3DMultisample");
	// gl_TextureSubImage1D = (PFNGLTEXTURESUBIMAGE1DPROC) get_proc("glTextureSubImage1D");
	// gl_TextureSubImage2D = (PFNGLTEXTURESUBIMAGE2DPROC) get_proc("glTextureSubImage2D");
	// gl_TextureSubImage3D = (PFNGLTEXTURESUBIMAGE3DPROC) get_proc("glTextureSubImage3D");
	// gl_TextureView = (PFNGLTEXTUREVIEWPROC) get_proc("glTextureView");
	// gl_TransformFeedbackBufferBase = (PFNGLTRANSFORMFEEDBACKBUFFERBASEPROC) get_proc("glTransformFeedbackBufferBase");
	// gl_TransformFeedbackBufferRange = (PFNGLTRANSFORMFEEDBACKBUFFERRANGEPROC) get_proc("glTransformFeedbackBufferRange");
	// gl_TransformFeedbackVaryings = (PFNGLTRANSFORMFEEDBACKVARYINGSPROC) get_proc("glTransformFeedbackVaryings");
	// gl_Uniform1d = (PFNGLUNIFORM1DPROC) get_proc("glUniform1d");
	// gl_Uniform1dv = (PFNGLUNIFORM1DVPROC) get_proc("glUniform1dv");
	gl_Uniform1f = (PFNGLUNIFORM1FPROC) get_proc("glUniform1f");
	// gl_Uniform1fv = (PFNGLUNIFORM1FVPROC) get_proc("glUniform1fv");
	gl_Uniform1i = (PFNGLUNIFORM1IPROC) get_proc("glUniform1i");
	// gl_Uniform1iv = (PFNGLUNIFORM1IVPROC) get_proc("glUniform1iv");
	// gl_Uniform1ui = (PFNGLUNIFORM1UIPROC) get_proc("glUniform1ui");
	// gl_Uniform1uiv = (PFNGLUNIFORM1UIVPROC) get_proc("glUniform1uiv");
	// gl_Uniform2d = (PFNGLUNIFORM2DPROC) get_proc("glUniform2d");
	// gl_Uniform2dv = (PFNGLUNIFORM2DVPROC) get_proc("glUniform2dv");
	gl_Uniform2f = (PFNGLUNIFORM2FPROC) get_proc("glUniform2f");
	// gl_Uniform2fv = (PFNGLUNIFORM2FVPROC) get_proc("glUniform2fv");
	// gl_Uniform2i = (PFNGLUNIFORM2IPROC) get_proc("glUniform2i");
	// gl_Uniform2iv = (PFNGLUNIFORM2IVPROC) get_proc("glUniform2iv");
	// gl_Uniform2ui = (PFNGLUNIFORM2UIPROC) get_proc("glUniform2ui");
	// gl_Uniform2uiv = (PFNGLUNIFORM2UIVPROC) get_proc("glUniform2uiv");
	// gl_Uniform3d = (PFNGLUNIFORM3DPROC) get_proc("glUniform3d");
	// gl_Uniform3dv = (PFNGLUNIFORM3DVPROC) get_proc("glUniform3dv");
	// gl_Uniform3f = (PFNGLUNIFORM3FPROC) get_proc("glUniform3f");
	gl_Uniform3fv = (PFNGLUNIFORM3FVPROC) get_proc("glUniform3fv");
	// gl_Uniform3i = (PFNGLUNIFORM3IPROC) get_proc("glUniform3i");
	// gl_Uniform3iv = (PFNGLUNIFORM3IVPROC) get_proc("glUniform3iv");
	// gl_Uniform3ui = (PFNGLUNIFORM3UIPROC) get_proc("glUniform3ui");
	// gl_Uniform3uiv = (PFNGLUNIFORM3UIVPROC) get_proc("glUniform3uiv");
	// gl_Uniform4d = (PFNGLUNIFORM4DPROC) get_proc("glUniform4d");
	// gl_Uniform4dv = (PFNGLUNIFORM4DVPROC) get_proc("glUniform4dv");
	// gl_Uniform4f = (PFNGLUNIFORM4FPROC) get_proc("glUniform4f");
	// gl_Uniform4fv = (PFNGLUNIFORM4FVPROC) get_proc("glUniform4fv");
	// gl_Uniform4i = (PFNGLUNIFORM4IPROC) get_proc("glUniform4i");
	// gl_Uniform4iv = (PFNGLUNIFORM4IVPROC) get_proc("glUniform4iv");
	// gl_Uniform4ui = (PFNGLUNIFORM4UIPROC) get_proc("glUniform4ui");
	// gl_Uniform4uiv = (PFNGLUNIFORM4UIVPROC) get_proc("glUniform4uiv");
	// gl_UniformBlockBinding = (PFNGLUNIFORMBLOCKBINDINGPROC) get_proc("glUniformBlockBinding");
	// gl_UniformHandleui64ARB = (PFNGLUNIFORMHANDLEUI64ARBPROC) get_proc("glUniformHandleui64ARB");
	// gl_UniformHandleui64vARB = (PFNGLUNIFORMHANDLEUI64VARBPROC) get_proc("glUniformHandleui64vARB");
	// gl_UniformMatrix2dv = (PFNGLUNIFORMMATRIX2DVPROC) get_proc("glUniformMatrix2dv");
	// gl_UniformMatrix2fv = (PFNGLUNIFORMMATRIX2FVPROC) get_proc("glUniformMatrix2fv");
	// gl_UniformMatrix2x3dv = (PFNGLUNIFORMMATRIX2X3DVPROC) get_proc("glUniformMatrix2x3dv");
	// gl_UniformMatrix2x3fv = (PFNGLUNIFORMMATRIX2X3FVPROC) get_proc("glUniformMatrix2x3fv");
	// gl_UniformMatrix2x4dv = (PFNGLUNIFORMMATRIX2X4DVPROC) get_proc("glUniformMatrix2x4dv");
	// gl_UniformMatrix2x4fv = (PFNGLUNIFORMMATRIX2X4FVPROC) get_proc("glUniformMatrix2x4fv");
	// gl_UniformMatrix3dv = (PFNGLUNIFORMMATRIX3DVPROC) get_proc("glUniformMatrix3dv");
	// gl_UniformMatrix3fv = (PFNGLUNIFORMMATRIX3FVPROC) get_proc("glUniformMatrix3fv");
	// gl_UniformMatrix3x2dv = (PFNGLUNIFORMMATRIX3X2DVPROC) get_proc("glUniformMatrix3x2dv");
	// gl_UniformMatrix3x2fv = (PFNGLUNIFORMMATRIX3X2FVPROC) get_proc("glUniformMatrix3x2fv");
	// gl_UniformMatrix3x4dv = (PFNGLUNIFORMMATRIX3X4DVPROC) get_proc("glUniformMatrix3x4dv");
	// gl_UniformMatrix3x4fv = (PFNGLUNIFORMMATRIX3X4FVPROC) get_proc("glUniformMatrix3x4fv");
	// gl_UniformMatrix4dv = (PFNGLUNIFORMMATRIX4DVPROC) get_proc("glUniformMatrix4dv");
	// gl_UniformMatrix4fv = (PFNGLUNIFORMMATRIX4FVPROC) get_proc("glUniformMatrix4fv");
	// gl_UniformMatrix4x2dv = (PFNGLUNIFORMMATRIX4X2DVPROC) get_proc("glUniformMatrix4x2dv");
	// gl_UniformMatrix4x2fv = (PFNGLUNIFORMMATRIX4X2FVPROC) get_proc("glUniformMatrix4x2fv");
	// gl_UniformMatrix4x3dv = (PFNGLUNIFORMMATRIX4X3DVPROC) get_proc("glUniformMatrix4x3dv");
	// gl_UniformMatrix4x3fv = (PFNGLUNIFORMMATRIX4X3FVPROC) get_proc("glUniformMatrix4x3fv");
	// gl_UniformSubroutinesuiv = (PFNGLUNIFORMSUBROUTINESUIVPROC) get_proc("glUniformSubroutinesuiv");
	// gl_UnmapBuffer = (PFNGLUNMAPBUFFERPROC) get_proc("glUnmapBuffer");
	// gl_UnmapNamedBuffer = (PFNGLUNMAPNAMEDBUFFERPROC) get_proc("glUnmapNamedBuffer");
	gl_UseProgram = (PFNGLUSEPROGRAMPROC) get_proc("glUseProgram");
	// gl_UseProgramStages = (PFNGLUSEPROGRAMSTAGESPROC) get_proc("glUseProgramStages");
	// gl_ValidateProgram = (PFNGLVALIDATEPROGRAMPROC) get_proc("glValidateProgram");
	// gl_ValidateProgramPipeline = (PFNGLVALIDATEPROGRAMPIPELINEPROC) get_proc("glValidateProgramPipeline");
	// gl_VertexArrayAttribBinding = (PFNGLVERTEXARRAYATTRIBBINDINGPROC) get_proc("glVertexArrayAttribBinding");
	// gl_VertexArrayAttribFormat = (PFNGLVERTEXARRAYATTRIBFORMATPROC) get_proc("glVertexArrayAttribFormat");
	// gl_VertexArrayAttribIFormat = (PFNGLVERTEXARRAYATTRIBIFORMATPROC) get_proc("glVertexArrayAttribIFormat");
	// gl_VertexArrayAttribLFormat = (PFNGLVERTEXARRAYATTRIBLFORMATPROC) get_proc("glVertexArrayAttribLFormat");
	// gl_VertexArrayBindingDivisor = (PFNGLVERTEXARRAYBINDINGDIVISORPROC) get_proc("glVertexArrayBindingDivisor");
	// gl_VertexArrayElementBuffer = (PFNGLVERTEXARRAYELEMENTBUFFERPROC) get_proc("glVertexArrayElementBuffer");
	// gl_VertexArrayVertexBuffer = (PFNGLVERTEXARRAYVERTEXBUFFERPROC) get_proc("glVertexArrayVertexBuffer");
	// gl_VertexArrayVertexBuffers = (PFNGLVERTEXARRAYVERTEXBUFFERSPROC) get_proc("glVertexArrayVertexBuffers");
	// gl_VertexAttrib1d = (PFNGLVERTEXATTRIB1DPROC) get_proc("glVertexAttrib1d");
	// gl_VertexAttrib1dv = (PFNGLVERTEXATTRIB1DVPROC) get_proc("glVertexAttrib1dv");
	// gl_VertexAttrib1f = (PFNGLVERTEXATTRIB1FPROC) get_proc("glVertexAttrib1f");
	// gl_VertexAttrib1fv = (PFNGLVERTEXATTRIB1FVPROC) get_proc("glVertexAttrib1fv");
	// gl_VertexAttrib1s = (PFNGLVERTEXATTRIB1SPROC) get_proc("glVertexAttrib1s");
	// gl_VertexAttrib1sv = (PFNGLVERTEXATTRIB1SVPROC) get_proc("glVertexAttrib1sv");
	// gl_VertexAttrib2d = (PFNGLVERTEXATTRIB2DPROC) get_proc("glVertexAttrib2d");
	// gl_VertexAttrib2dv = (PFNGLVERTEXATTRIB2DVPROC) get_proc("glVertexAttrib2dv");
	// gl_VertexAttrib2f = (PFNGLVERTEXATTRIB2FPROC) get_proc("glVertexAttrib2f");
	// gl_VertexAttrib2fv = (PFNGLVERTEXATTRIB2FVPROC) get_proc("glVertexAttrib2fv");
	// gl_VertexAttrib2s = (PFNGLVERTEXATTRIB2SPROC) get_proc("glVertexAttrib2s");
	// gl_VertexAttrib2sv = (PFNGLVERTEXATTRIB2SVPROC) get_proc("glVertexAttrib2sv");
	// gl_VertexAttrib3d = (PFNGLVERTEXATTRIB3DPROC) get_proc("glVertexAttrib3d");
	// gl_VertexAttrib3dv = (PFNGLVERTEXATTRIB3DVPROC) get_proc("glVertexAttrib3dv");
	// gl_VertexAttrib3f = (PFNGLVERTEXATTRIB3FPROC) get_proc("glVertexAttrib3f");
	// gl_VertexAttrib3fv = (PFNGLVERTEXATTRIB3FVPROC) get_proc("glVertexAttrib3fv");
	// gl_VertexAttrib3s = (PFNGLVERTEXATTRIB3SPROC) get_proc("glVertexAttrib3s");
	// gl_VertexAttrib3sv = (PFNGLVERTEXATTRIB3SVPROC) get_proc("glVertexAttrib3sv");
	// gl_VertexAttrib4Nbv = (PFNGLVERTEXATTRIB4NBVPROC) get_proc("glVertexAttrib4Nbv");
	// gl_VertexAttrib4Niv = (PFNGLVERTEXATTRIB4NIVPROC) get_proc("glVertexAttrib4Niv");
	// gl_VertexAttrib4Nsv = (PFNGLVERTEXATTRIB4NSVPROC) get_proc("glVertexAttrib4Nsv");
	// gl_VertexAttrib4Nub = (PFNGLVERTEXATTRIB4NUBPROC) get_proc("glVertexAttrib4Nub");
	// gl_VertexAttrib4Nubv = (PFNGLVERTEXATTRIB4NUBVPROC) get_proc("glVertexAttrib4Nubv");
	// gl_VertexAttrib4Nuiv = (PFNGLVERTEXATTRIB4NUIVPROC) get_proc("glVertexAttrib4Nuiv");
	// gl_VertexAttrib4Nusv = (PFNGLVERTEXATTRIB4NUSVPROC) get_proc("glVertexAttrib4Nusv");
	// gl_VertexAttrib4bv = (PFNGLVERTEXATTRIB4BVPROC) get_proc("glVertexAttrib4bv");
	// gl_VertexAttrib4d = (PFNGLVERTEXATTRIB4DPROC) get_proc("glVertexAttrib4d");
	// gl_VertexAttrib4dv = (PFNGLVERTEXATTRIB4DVPROC) get_proc("glVertexAttrib4dv");
	// gl_VertexAttrib4f = (PFNGLVERTEXATTRIB4FPROC) get_proc("glVertexAttrib4f");
	// gl_VertexAttrib4fv = (PFNGLVERTEXATTRIB4FVPROC) get_proc("glVertexAttrib4fv");
	// gl_VertexAttrib4iv = (PFNGLVERTEXATTRIB4IVPROC) get_proc("glVertexAttrib4iv");
	// gl_VertexAttrib4s = (PFNGLVERTEXATTRIB4SPROC) get_proc("glVertexAttrib4s");
	// gl_VertexAttrib4sv = (PFNGLVERTEXATTRIB4SVPROC) get_proc("glVertexAttrib4sv");
	// gl_VertexAttrib4ubv = (PFNGLVERTEXATTRIB4UBVPROC) get_proc("glVertexAttrib4ubv");
	// gl_VertexAttrib4uiv = (PFNGLVERTEXATTRIB4UIVPROC) get_proc("glVertexAttrib4uiv");
	// gl_VertexAttrib4usv = (PFNGLVERTEXATTRIB4USVPROC) get_proc("glVertexAttrib4usv");
	// gl_VertexAttribBinding = (PFNGLVERTEXATTRIBBINDINGPROC) get_proc("glVertexAttribBinding");
	// gl_VertexAttribDivisor = (PFNGLVERTEXATTRIBDIVISORPROC) get_proc("glVertexAttribDivisor");
	// gl_VertexAttribFormat = (PFNGLVERTEXATTRIBFORMATPROC) get_proc("glVertexAttribFormat");
	// gl_VertexAttribI1i = (PFNGLVERTEXATTRIBI1IPROC) get_proc("glVertexAttribI1i");
	// gl_VertexAttribI1iv = (PFNGLVERTEXATTRIBI1IVPROC) get_proc("glVertexAttribI1iv");
	// gl_VertexAttribI1ui = (PFNGLVERTEXATTRIBI1UIPROC) get_proc("glVertexAttribI1ui");
	// gl_VertexAttribI1uiv = (PFNGLVERTEXATTRIBI1UIVPROC) get_proc("glVertexAttribI1uiv");
	// gl_VertexAttribI2i = (PFNGLVERTEXATTRIBI2IPROC) get_proc("glVertexAttribI2i");
	// gl_VertexAttribI2iv = (PFNGLVERTEXATTRIBI2IVPROC) get_proc("glVertexAttribI2iv");
	// gl_VertexAttribI2ui = (PFNGLVERTEXATTRIBI2UIPROC) get_proc("glVertexAttribI2ui");
	// gl_VertexAttribI2uiv = (PFNGLVERTEXATTRIBI2UIVPROC) get_proc("glVertexAttribI2uiv");
	// gl_VertexAttribI3i = (PFNGLVERTEXATTRIBI3IPROC) get_proc("glVertexAttribI3i");
	// gl_VertexAttribI3iv = (PFNGLVERTEXATTRIBI3IVPROC) get_proc("glVertexAttribI3iv");
	// gl_VertexAttribI3ui = (PFNGLVERTEXATTRIBI3UIPROC) get_proc("glVertexAttribI3ui");
	// gl_VertexAttribI3uiv = (PFNGLVERTEXATTRIBI3UIVPROC) get_proc("glVertexAttribI3uiv");
	// gl_VertexAttribI4bv = (PFNGLVERTEXATTRIBI4BVPROC) get_proc("glVertexAttribI4bv");
	// gl_VertexAttribI4i = (PFNGLVERTEXATTRIBI4IPROC) get_proc("glVertexAttribI4i");
	// gl_VertexAttribI4iv = (PFNGLVERTEXATTRIBI4IVPROC) get_proc("glVertexAttribI4iv");
	// gl_VertexAttribI4sv = (PFNGLVERTEXATTRIBI4SVPROC) get_proc("glVertexAttribI4sv");
	// gl_VertexAttribI4ubv = (PFNGLVERTEXATTRIBI4UBVPROC) get_proc("glVertexAttribI4ubv");
	// gl_VertexAttribI4ui = (PFNGLVERTEXATTRIBI4UIPROC) get_proc("glVertexAttribI4ui");
	// gl_VertexAttribI4uiv = (PFNGLVERTEXATTRIBI4UIVPROC) get_proc("glVertexAttribI4uiv");
	// gl_VertexAttribI4usv = (PFNGLVERTEXATTRIBI4USVPROC) get_proc("glVertexAttribI4usv");
	// gl_VertexAttribIFormat = (PFNGLVERTEXATTRIBIFORMATPROC) get_proc("glVertexAttribIFormat");
	// gl_VertexAttribIPointer = (PFNGLVERTEXATTRIBIPOINTERPROC) get_proc("glVertexAttribIPointer");
	// gl_VertexAttribL1d = (PFNGLVERTEXATTRIBL1DPROC) get_proc("glVertexAttribL1d");
	// gl_VertexAttribL1dv = (PFNGLVERTEXATTRIBL1DVPROC) get_proc("glVertexAttribL1dv");
	// gl_VertexAttribL1ui64ARB = (PFNGLVERTEXATTRIBL1UI64ARBPROC) get_proc("glVertexAttribL1ui64ARB");
	// gl_VertexAttribL1ui64vARB = (PFNGLVERTEXATTRIBL1UI64VARBPROC) get_proc("glVertexAttribL1ui64vARB");
	// gl_VertexAttribL2d = (PFNGLVERTEXATTRIBL2DPROC) get_proc("glVertexAttribL2d");
	// gl_VertexAttribL2dv = (PFNGLVERTEXATTRIBL2DVPROC) get_proc("glVertexAttribL2dv");
	// gl_VertexAttribL3d = (PFNGLVERTEXATTRIBL3DPROC) get_proc("glVertexAttribL3d");
	// gl_VertexAttribL3dv = (PFNGLVERTEXATTRIBL3DVPROC) get_proc("glVertexAttribL3dv");
	// gl_VertexAttribL4d = (PFNGLVERTEXATTRIBL4DPROC) get_proc("glVertexAttribL4d");
	// gl_VertexAttribL4dv = (PFNGLVERTEXATTRIBL4DVPROC) get_proc("glVertexAttribL4dv");
	// gl_VertexAttribLFormat = (PFNGLVERTEXATTRIBLFORMATPROC) get_proc("glVertexAttribLFormat");
	// gl_VertexAttribLPointer = (PFNGLVERTEXATTRIBLPOINTERPROC) get_proc("glVertexAttribLPointer");
	// gl_VertexAttribP1ui = (PFNGLVERTEXATTRIBP1UIPROC) get_proc("glVertexAttribP1ui");
	// gl_VertexAttribP1uiv = (PFNGLVERTEXATTRIBP1UIVPROC) get_proc("glVertexAttribP1uiv");
	// gl_VertexAttribP2ui = (PFNGLVERTEXATTRIBP2UIPROC) get_proc("glVertexAttribP2ui");
	// gl_VertexAttribP2uiv = (PFNGLVERTEXATTRIBP2UIVPROC) get_proc("glVertexAttribP2uiv");
	// gl_VertexAttribP3ui = (PFNGLVERTEXATTRIBP3UIPROC) get_proc("glVertexAttribP3ui");
	// gl_VertexAttribP3uiv = (PFNGLVERTEXATTRIBP3UIVPROC) get_proc("glVertexAttribP3uiv");
	// gl_VertexAttribP4ui = (PFNGLVERTEXATTRIBP4UIPROC) get_proc("glVertexAttribP4ui");
	// gl_VertexAttribP4uiv = (PFNGLVERTEXATTRIBP4UIVPROC) get_proc("glVertexAttribP4uiv");
	gl_VertexAttribPointer = (PFNGLVERTEXATTRIBPOINTERPROC) get_proc("glVertexAttribPointer");
	// gl_VertexBindingDivisor = (PFNGLVERTEXBINDINGDIVISORPROC) get_proc("glVertexBindingDivisor");
	gl_Viewport = (PFNGLVIEWPORTPROC) get_proc("glViewport");
	// gl_ViewportArrayv = (PFNGLVIEWPORTARRAYVPROC) get_proc("glViewportArrayv");
	// gl_ViewportIndexedf = (PFNGLVIEWPORTINDEXEDFPROC) get_proc("glViewportIndexedf");
	// gl_ViewportIndexedfv = (PFNGLVIEWPORTINDEXEDFVPROC) get_proc("glViewportIndexedfv");
	// gl_WaitSync = (PFNGLWAITSYNCPROC) get_proc("glWaitSync");
}

};

PFNGLACTIVESHADERPROGRAMPROC gl_ActiveShaderProgram;
PFNGLACTIVETEXTUREPROC gl_ActiveTexture;
PFNGLATTACHSHADERPROC  gl_AttachShader;
PFNGLBEGINCONDITIONALRENDERPROC   gl_BeginConditionalRender;
PFNGLBEGINQUERYPROC gl_BeginQuery;
PFNGLBEGINQUERYINDEXEDPROC gl_BeginQueryIndexed;
PFNGLBEGINTRANSFORMFEEDBACKPROC   gl_BeginTransformFeedback;
PFNGLBINDATTRIBLOCATIONPROC gl_BindAttribLocation;
PFNGLBINDBUFFERPROC gl_BindBuffer;
PFNGLBINDBUFFERBASEPROC gl_BindBufferBase;
PFNGLBINDBUFFERRANGEPROC gl_BindBufferRange;
PFNGLBINDBUFFERSBASEPROC gl_BindBuffersBase;
PFNGLBINDBUFFERSRANGEPROC gl_BindBuffersRange;
PFNGLBINDFRAGDATALOCATIONPROC gl_BindFragDataLocation;
PFNGLBINDFRAGDATALOCATIONINDEXEDPROC  gl_BindFragDataLocationIndexed;
PFNGLBINDFRAMEBUFFERPROC gl_BindFramebuffer;
PFNGLBINDIMAGETEXTUREPROC gl_BindImageTexture;
PFNGLBINDIMAGETEXTURESPROC gl_BindImageTextures;
PFNGLBINDPROGRAMPIPELINEPROC gl_BindProgramPipeline;
PFNGLBINDRENDERBUFFERPROC gl_BindRenderbuffer;
PFNGLBINDSAMPLERPROC  gl_BindSampler;
PFNGLBINDSAMPLERSPROC  gl_BindSamplers;
PFNGLBINDTEXTUREPROC  gl_BindTexture;
PFNGLBINDTEXTUREUNITPROC gl_BindTextureUnit;
PFNGLBINDTEXTURESPROC  gl_BindTextures;
PFNGLBINDTRANSFORMFEEDBACKPROC  gl_BindTransformFeedback;
PFNGLBINDVERTEXARRAYPROC gl_BindVertexArray;
PFNGLBINDVERTEXBUFFERPROC gl_BindVertexBuffer;
PFNGLBINDVERTEXBUFFERSPROC gl_BindVertexBuffers;
PFNGLBLENDCOLORPROC gl_BlendColor;
PFNGLBLENDEQUATIONPROC gl_BlendEquation;
PFNGLBLENDEQUATIONSEPARATEPROC  gl_BlendEquationSeparate;
PFNGLBLENDEQUATIONSEPARATEIPROC   gl_BlendEquationSeparatei;
PFNGLBLENDEQUATIONSEPARATEIARBPROC  gl_BlendEquationSeparateiARB;
PFNGLBLENDEQUATIONIPROC gl_BlendEquationi;
PFNGLBLENDEQUATIONIARBPROC gl_BlendEquationiARB;
PFNGLBLENDFUNCPROC gl_BlendFunc;
PFNGLBLENDFUNCSEPARATEPROC gl_BlendFuncSeparate;
PFNGLBLENDFUNCSEPARATEIPROC gl_BlendFuncSeparatei;
PFNGLBLENDFUNCSEPARATEIARBPROC  gl_BlendFuncSeparateiARB;
PFNGLBLENDFUNCIPROC gl_BlendFunci;
PFNGLBLENDFUNCIARBPROC gl_BlendFunciARB;
PFNGLBLITFRAMEBUFFERPROC gl_BlitFramebuffer;
PFNGLBLITNAMEDFRAMEBUFFERPROC gl_BlitNamedFramebuffer;
PFNGLBUFFERDATAPROC gl_BufferData;
PFNGLBUFFERPAGECOMMITMENTARBPROC   gl_BufferPageCommitmentARB;
PFNGLBUFFERSTORAGEPROC gl_BufferStorage;
PFNGLBUFFERSUBDATAPROC gl_BufferSubData;
PFNGLCHECKFRAMEBUFFERSTATUSPROC   gl_CheckFramebufferStatus;
PFNGLCHECKNAMEDFRAMEBUFFERSTATUSPROC  gl_CheckNamedFramebufferStatus;
PFNGLCLAMPCOLORPROC gl_ClampColor;
PFNGLCLEARPROC  gl_Clear;
PFNGLCLEARBUFFERDATAPROC gl_ClearBufferData;
PFNGLCLEARBUFFERSUBDATAPROC gl_ClearBufferSubData;
PFNGLCLEARBUFFERFIPROC gl_ClearBufferfi;
PFNGLCLEARBUFFERFVPROC gl_ClearBufferfv;
PFNGLCLEARBUFFERIVPROC gl_ClearBufferiv;
PFNGLCLEARBUFFERUIVPROC gl_ClearBufferuiv;
PFNGLCLEARCOLORPROC gl_ClearColor;
PFNGLCLEARDEPTHPROC gl_ClearDepth;
PFNGLCLEARDEPTHFPROC  gl_ClearDepthf;
PFNGLCLEARNAMEDBUFFERDATAPROC gl_ClearNamedBufferData;
PFNGLCLEARNAMEDBUFFERSUBDATAPROC   gl_ClearNamedBufferSubData;
PFNGLCLEARNAMEDFRAMEBUFFERFIPROC   gl_ClearNamedFramebufferfi;
PFNGLCLEARNAMEDFRAMEBUFFERFVPROC   gl_ClearNamedFramebufferfv;
PFNGLCLEARNAMEDFRAMEBUFFERIVPROC   gl_ClearNamedFramebufferiv;
PFNGLCLEARNAMEDFRAMEBUFFERUIVPROC  gl_ClearNamedFramebufferuiv;
PFNGLCLEARSTENCILPROC  gl_ClearStencil;
PFNGLCLEARTEXIMAGEPROC gl_ClearTexImage;
PFNGLCLEARTEXSUBIMAGEPROC gl_ClearTexSubImage;
PFNGLCLIENTWAITSYNCPROC gl_ClientWaitSync;
PFNGLCLIPCONTROLPROC  gl_ClipControl;
PFNGLCOLORMASKPROC gl_ColorMask;
PFNGLCOLORMASKIPROC gl_ColorMaski;
PFNGLCOMPILESHADERPROC gl_CompileShader;
PFNGLCOMPILESHADERINCLUDEARBPROC   gl_CompileShaderIncludeARB;
PFNGLCOMPRESSEDTEXIMAGE1DPROC gl_CompressedTexImage1D;
PFNGLCOMPRESSEDTEXIMAGE2DPROC gl_CompressedTexImage2D;
PFNGLCOMPRESSEDTEXIMAGE3DPROC gl_CompressedTexImage3D;
PFNGLCOMPRESSEDTEXSUBIMAGE1DPROC   gl_CompressedTexSubImage1D;
PFNGLCOMPRESSEDTEXSUBIMAGE2DPROC   gl_CompressedTexSubImage2D;
PFNGLCOMPRESSEDTEXSUBIMAGE3DPROC   gl_CompressedTexSubImage3D;
PFNGLCOMPRESSEDTEXTURESUBIMAGE1DPROC  gl_CompressedTextureSubImage1D;
PFNGLCOMPRESSEDTEXTURESUBIMAGE2DPROC  gl_CompressedTextureSubImage2D;
PFNGLCOMPRESSEDTEXTURESUBIMAGE3DPROC  gl_CompressedTextureSubImage3D;
PFNGLCOPYBUFFERSUBDATAPROC gl_CopyBufferSubData;
PFNGLCOPYIMAGESUBDATAPROC gl_CopyImageSubData;
PFNGLCOPYNAMEDBUFFERSUBDATAPROC   gl_CopyNamedBufferSubData;
PFNGLCOPYTEXIMAGE1DPROC gl_CopyTexImage1D;
PFNGLCOPYTEXIMAGE2DPROC gl_CopyTexImage2D;
PFNGLCOPYTEXSUBIMAGE1DPROC gl_CopyTexSubImage1D;
PFNGLCOPYTEXSUBIMAGE2DPROC gl_CopyTexSubImage2D;
PFNGLCOPYTEXSUBIMAGE3DPROC gl_CopyTexSubImage3D;
PFNGLCOPYTEXTURESUBIMAGE1DPROC  gl_CopyTextureSubImage1D;
PFNGLCOPYTEXTURESUBIMAGE2DPROC  gl_CopyTextureSubImage2D;
PFNGLCOPYTEXTURESUBIMAGE3DPROC  gl_CopyTextureSubImage3D;
PFNGLCREATEBUFFERSPROC gl_CreateBuffers;
PFNGLCREATEFRAMEBUFFERSPROC gl_CreateFramebuffers;
PFNGLCREATEPROGRAMPROC gl_CreateProgram;
PFNGLCREATEPROGRAMPIPELINESPROC   gl_CreateProgramPipelines;
PFNGLCREATEQUERIESPROC gl_CreateQueries;
PFNGLCREATERENDERBUFFERSPROC gl_CreateRenderbuffers;
PFNGLCREATESAMPLERSPROC gl_CreateSamplers;
PFNGLCREATESHADERPROC  gl_CreateShader;
PFNGLCREATESHADERPROGRAMVPROC gl_CreateShaderProgramv;
PFNGLCREATESYNCFROMCLEVENTARBPROC  gl_CreateSyncFromCLeventARB;
PFNGLCREATETEXTURESPROC gl_CreateTextures;
PFNGLCREATETRANSFORMFEEDBACKSPROC  gl_CreateTransformFeedbacks;
PFNGLCREATEVERTEXARRAYSPROC gl_CreateVertexArrays;
PFNGLCULLFACEPROC  gl_CullFace;
PFNGLDEBUGMESSAGECALLBACKPROC gl_DebugMessageCallback;
PFNGLDEBUGMESSAGECALLBACKARBPROC   gl_DebugMessageCallbackARB;
PFNGLDEBUGMESSAGECONTROLPROC gl_DebugMessageControl;
PFNGLDEBUGMESSAGECONTROLARBPROC   gl_DebugMessageControlARB;
PFNGLDEBUGMESSAGEINSERTPROC gl_DebugMessageInsert;
PFNGLDEBUGMESSAGEINSERTARBPROC  gl_DebugMessageInsertARB;
PFNGLDELETEBUFFERSPROC gl_DeleteBuffers;
PFNGLDELETEFRAMEBUFFERSPROC gl_DeleteFramebuffers;
PFNGLDELETENAMEDSTRINGARBPROC gl_DeleteNamedStringARB;
PFNGLDELETEPROGRAMPROC gl_DeleteProgram;
PFNGLDELETEPROGRAMPIPELINESPROC   gl_DeleteProgramPipelines;
PFNGLDELETEQUERIESPROC gl_DeleteQueries;
PFNGLDELETERENDERBUFFERSPROC gl_DeleteRenderbuffers;
PFNGLDELETESAMPLERSPROC gl_DeleteSamplers;
PFNGLDELETESHADERPROC  gl_DeleteShader;
PFNGLDELETESYNCPROC gl_DeleteSync;
PFNGLDELETETEXTURESPROC gl_DeleteTextures;
PFNGLDELETETRANSFORMFEEDBACKSPROC  gl_DeleteTransformFeedbacks;
PFNGLDELETEVERTEXARRAYSPROC gl_DeleteVertexArrays;
PFNGLDEPTHFUNCPROC gl_DepthFunc;
PFNGLDEPTHMASKPROC gl_DepthMask;
PFNGLDEPTHRANGEPROC gl_DepthRange;
PFNGLDEPTHRANGEARRAYVPROC gl_DepthRangeArrayv;
PFNGLDEPTHRANGEINDEXEDPROC gl_DepthRangeIndexed;
PFNGLDEPTHRANGEFPROC  gl_DepthRangef;
PFNGLDETACHSHADERPROC  gl_DetachShader;
PFNGLDISABLEPROC  gl_Disable;
PFNGLDISABLEVERTEXARRAYATTRIBPROC  gl_DisableVertexArrayAttrib;
PFNGLDISABLEVERTEXATTRIBARRAYPROC  gl_DisableVertexAttribArray;
PFNGLDISABLEIPROC  gl_Disablei;
PFNGLDISPATCHCOMPUTEPROC gl_DispatchCompute;
PFNGLDISPATCHCOMPUTEGROUPSIZEARBPROC  gl_DispatchComputeGroupSizeARB;
PFNGLDISPATCHCOMPUTEINDIRECTPROC   gl_DispatchComputeIndirect;
PFNGLDRAWARRAYSPROC gl_DrawArrays;
PFNGLDRAWARRAYSINDIRECTPROC gl_DrawArraysIndirect;
PFNGLDRAWARRAYSINSTANCEDPROC gl_DrawArraysInstanced;
PFNGLDRAWARRAYSINSTANCEDBASEINSTANCEPROC  gl_DrawArraysInstancedBaseInstance;
PFNGLDRAWBUFFERPROC gl_DrawBuffer;
PFNGLDRAWBUFFERSPROC  gl_DrawBuffers;
PFNGLDRAWELEMENTSPROC  gl_DrawElements;
PFNGLDRAWELEMENTSBASEVERTEXPROC   gl_DrawElementsBaseVertex;
PFNGLDRAWELEMENTSINDIRECTPROC gl_DrawElementsIndirect;
PFNGLDRAWELEMENTSINSTANCEDPROC  gl_DrawElementsInstanced;
PFNGLDRAWELEMENTSINSTANCEDBASEINSTANCEPROC gl_DrawElementsInstancedBaseInstance;
PFNGLDRAWELEMENTSINSTANCEDBASEVERTEXPROC  gl_DrawElementsInstancedBaseVertex;
PFNGLDRAWELEMENTSINSTANCEDBASEVERTEXBASEINSTANCEPROC gl_DrawElementsInstancedBaseVertexBaseInstance;
PFNGLDRAWRANGEELEMENTSPROC gl_DrawRangeElements;
PFNGLDRAWRANGEELEMENTSBASEVERTEXPROC  gl_DrawRangeElementsBaseVertex;
PFNGLDRAWTRANSFORMFEEDBACKPROC  gl_DrawTransformFeedback;
PFNGLDRAWTRANSFORMFEEDBACKINSTANCEDPROC  gl_DrawTransformFeedbackInstanced;
PFNGLDRAWTRANSFORMFEEDBACKSTREAMPROC  gl_DrawTransformFeedbackStream;
PFNGLDRAWTRANSFORMFEEDBACKSTREAMINSTANCEDPROC gl_DrawTransformFeedbackStreamInstanced;
PFNGLENABLEPROC  gl_Enable;
PFNGLENABLEVERTEXARRAYATTRIBPROC   gl_EnableVertexArrayAttrib;
PFNGLENABLEVERTEXATTRIBARRAYPROC   gl_EnableVertexAttribArray;
PFNGLENABLEIPROC  gl_Enablei;
PFNGLENDCONDITIONALRENDERPROC gl_EndConditionalRender;
PFNGLENDQUERYPROC  gl_EndQuery;
PFNGLENDQUERYINDEXEDPROC gl_EndQueryIndexed;
PFNGLENDTRANSFORMFEEDBACKPROC gl_EndTransformFeedback;
PFNGLFENCESYNCPROC gl_FenceSync;
PFNGLFINISHPROC  gl_Finish;
PFNGLFLUSHPROC  gl_Flush;
PFNGLFLUSHMAPPEDBUFFERRANGEPROC   gl_FlushMappedBufferRange;
PFNGLFLUSHMAPPEDNAMEDBUFFERRANGEPROC  gl_FlushMappedNamedBufferRange;
PFNGLFRAMEBUFFERPARAMETERIPROC  gl_FramebufferParameteri;
PFNGLFRAMEBUFFERRENDERBUFFERPROC   gl_FramebufferRenderbuffer;
PFNGLFRAMEBUFFERTEXTUREPROC gl_FramebufferTexture;
PFNGLFRAMEBUFFERTEXTURE1DPROC gl_FramebufferTexture1D;
PFNGLFRAMEBUFFERTEXTURE2DPROC gl_FramebufferTexture2D;
PFNGLFRAMEBUFFERTEXTURE3DPROC gl_FramebufferTexture3D;
PFNGLFRAMEBUFFERTEXTURELAYERPROC   gl_FramebufferTextureLayer;
PFNGLFRONTFACEPROC gl_FrontFace;
PFNGLGENBUFFERSPROC gl_GenBuffers;
PFNGLGENFRAMEBUFFERSPROC gl_GenFramebuffers;
PFNGLGENPROGRAMPIPELINESPROC gl_GenProgramPipelines;
PFNGLGENQUERIESPROC gl_GenQueries;
PFNGLGENRENDERBUFFERSPROC gl_GenRenderbuffers;
PFNGLGENSAMPLERSPROC  gl_GenSamplers;
PFNGLGENTEXTURESPROC  gl_GenTextures;
PFNGLGENTRANSFORMFEEDBACKSPROC  gl_GenTransformFeedbacks;
PFNGLGENVERTEXARRAYSPROC gl_GenVertexArrays;
PFNGLGENERATEMIPMAPPROC gl_GenerateMipmap;
PFNGLGENERATETEXTUREMIPMAPPROC  gl_GenerateTextureMipmap;
PFNGLGETACTIVEATOMICCOUNTERBUFFERIVPROC  gl_GetActiveAtomicCounterBufferiv;
PFNGLGETACTIVEATTRIBPROC gl_GetActiveAttrib;
PFNGLGETACTIVESUBROUTINENAMEPROC   gl_GetActiveSubroutineName;
PFNGLGETACTIVESUBROUTINEUNIFORMNAMEPROC  gl_GetActiveSubroutineUniformName;
PFNGLGETACTIVESUBROUTINEUNIFORMIVPROC  gl_GetActiveSubroutineUniformiv;
PFNGLGETACTIVEUNIFORMPROC gl_GetActiveUniform;
PFNGLGETACTIVEUNIFORMBLOCKNAMEPROC  gl_GetActiveUniformBlockName;
PFNGLGETACTIVEUNIFORMBLOCKIVPROC   gl_GetActiveUniformBlockiv;
PFNGLGETACTIVEUNIFORMNAMEPROC gl_GetActiveUniformName;
PFNGLGETACTIVEUNIFORMSIVPROC gl_GetActiveUniformsiv;
PFNGLGETATTACHEDSHADERSPROC gl_GetAttachedShaders;
PFNGLGETATTRIBLOCATIONPROC gl_GetAttribLocation;
PFNGLGETBOOLEANI_VPROC gl_GetBooleani_v;
PFNGLGETBOOLEANVPROC  gl_GetBooleanv;
PFNGLGETBUFFERPARAMETERI64VPROC   gl_GetBufferParameteri64v;
PFNGLGETBUFFERPARAMETERIVPROC gl_GetBufferParameteriv;
PFNGLGETBUFFERPOINTERVPROC gl_GetBufferPointerv;
PFNGLGETBUFFERSUBDATAPROC gl_GetBufferSubData;
PFNGLGETCOMPRESSEDTEXIMAGEPROC  gl_GetCompressedTexImage;
PFNGLGETCOMPRESSEDTEXTUREIMAGEPROC  gl_GetCompressedTextureImage;
PFNGLGETCOMPRESSEDTEXTURESUBIMAGEPROC  gl_GetCompressedTextureSubImage;
PFNGLGETDEBUGMESSAGELOGPROC gl_GetDebugMessageLog;
PFNGLGETDEBUGMESSAGELOGARBPROC  gl_GetDebugMessageLogARB;
PFNGLGETDOUBLEI_VPROC  gl_GetDoublei_v;
PFNGLGETDOUBLEVPROC gl_GetDoublev;
PFNGLGETERRORPROC  gl_GetError;
PFNGLGETFLOATI_VPROC  gl_GetFloati_v;
PFNGLGETFLOATVPROC gl_GetFloatv;
PFNGLGETFRAGDATAINDEXPROC gl_GetFragDataIndex;
PFNGLGETFRAGDATALOCATIONPROC gl_GetFragDataLocation;
PFNGLGETFRAMEBUFFERATTACHMENTPARAMETERIVPROC  gl_GetFramebufferAttachmentParameteriv;
PFNGLGETFRAMEBUFFERPARAMETERIVPROC  gl_GetFramebufferParameteriv;
PFNGLGETGRAPHICSRESETSTATUSPROC   gl_GetGraphicsResetStatus;
PFNGLGETGRAPHICSRESETSTATUSARBPROC  gl_GetGraphicsResetStatusARB;
PFNGLGETIMAGEHANDLEARBPROC gl_GetImageHandleARB;
PFNGLGETINTEGER64I_VPROC gl_GetInteger64i_v;
PFNGLGETINTEGER64VPROC gl_GetInteger64v;
PFNGLGETINTEGERI_VPROC gl_GetIntegeri_v;
PFNGLGETINTEGERVPROC  gl_GetIntegerv;
PFNGLGETINTERNALFORMATI64VPROC  gl_GetInternalformati64v;
PFNGLGETINTERNALFORMATIVPROC gl_GetInternalformativ;
PFNGLGETMULTISAMPLEFVPROC gl_GetMultisamplefv;
PFNGLGETNAMEDBUFFERPARAMETERI64VPROC  gl_GetNamedBufferParameteri64v;
PFNGLGETNAMEDBUFFERPARAMETERIVPROC  gl_GetNamedBufferParameteriv;
PFNGLGETNAMEDBUFFERPOINTERVPROC   gl_GetNamedBufferPointerv;
PFNGLGETNAMEDBUFFERSUBDATAPROC  gl_GetNamedBufferSubData;
PFNGLGETNAMEDFRAMEBUFFERATTACHMENTPARAMETERIVPROC gl_GetNamedFramebufferAttachmentParameteriv;
PFNGLGETNAMEDFRAMEBUFFERPARAMETERIVPROC  gl_GetNamedFramebufferParameteriv;
PFNGLGETNAMEDRENDERBUFFERPARAMETERIVPROC  gl_GetNamedRenderbufferParameteriv;
PFNGLGETNAMEDSTRINGARBPROC gl_GetNamedStringARB;
PFNGLGETNAMEDSTRINGIVARBPROC gl_GetNamedStringivARB;
PFNGLGETOBJECTLABELPROC gl_GetObjectLabel;
PFNGLGETOBJECTPTRLABELPROC gl_GetObjectPtrLabel;
PFNGLGETPOINTERVPROC  gl_GetPointerv;
PFNGLGETPROGRAMBINARYPROC gl_GetProgramBinary;
PFNGLGETPROGRAMINFOLOGPROC gl_GetProgramInfoLog;
PFNGLGETPROGRAMINTERFACEIVPROC  gl_GetProgramInterfaceiv;
PFNGLGETPROGRAMPIPELINEINFOLOGPROC  gl_GetProgramPipelineInfoLog;
PFNGLGETPROGRAMPIPELINEIVPROC gl_GetProgramPipelineiv;
PFNGLGETPROGRAMRESOURCEINDEXPROC   gl_GetProgramResourceIndex;
PFNGLGETPROGRAMRESOURCELOCATIONPROC  gl_GetProgramResourceLocation;
PFNGLGETPROGRAMRESOURCELOCATIONINDEXPROC  gl_GetProgramResourceLocationIndex;
PFNGLGETPROGRAMRESOURCENAMEPROC   gl_GetProgramResourceName;
PFNGLGETPROGRAMRESOURCEIVPROC gl_GetProgramResourceiv;
PFNGLGETPROGRAMSTAGEIVPROC gl_GetProgramStageiv;
PFNGLGETPROGRAMIVPROC  gl_GetProgramiv;
PFNGLGETQUERYBUFFEROBJECTI64VPROC  gl_GetQueryBufferObjecti64v;
PFNGLGETQUERYBUFFEROBJECTIVPROC   gl_GetQueryBufferObjectiv;
PFNGLGETQUERYBUFFEROBJECTUI64VPROC  gl_GetQueryBufferObjectui64v;
PFNGLGETQUERYBUFFEROBJECTUIVPROC   gl_GetQueryBufferObjectuiv;
PFNGLGETQUERYINDEXEDIVPROC gl_GetQueryIndexediv;
PFNGLGETQUERYOBJECTI64VPROC gl_GetQueryObjecti64v;
PFNGLGETQUERYOBJECTIVPROC gl_GetQueryObjectiv;
PFNGLGETQUERYOBJECTUI64VPROC gl_GetQueryObjectui64v;
PFNGLGETQUERYOBJECTUIVPROC gl_GetQueryObjectuiv;
PFNGLGETQUERYIVPROC gl_GetQueryiv;
PFNGLGETRENDERBUFFERPARAMETERIVPROC  gl_GetRenderbufferParameteriv;
PFNGLGETSAMPLERPARAMETERIIVPROC   gl_GetSamplerParameterIiv;
PFNGLGETSAMPLERPARAMETERIUIVPROC   gl_GetSamplerParameterIuiv;
PFNGLGETSAMPLERPARAMETERFVPROC  gl_GetSamplerParameterfv;
PFNGLGETSAMPLERPARAMETERIVPROC  gl_GetSamplerParameteriv;
PFNGLGETSHADERINFOLOGPROC gl_GetShaderInfoLog;
PFNGLGETSHADERPRECISIONFORMATPROC  gl_GetShaderPrecisionFormat;
PFNGLGETSHADERSOURCEPROC gl_GetShaderSource;
PFNGLGETSHADERIVPROC  gl_GetShaderiv;
PFNGLGETSTRINGPROC gl_GetString;
PFNGLGETSTRINGIPROC gl_GetStringi;
PFNGLGETSUBROUTINEINDEXPROC gl_GetSubroutineIndex;
PFNGLGETSUBROUTINEUNIFORMLOCATIONPROC  gl_GetSubroutineUniformLocation;
PFNGLGETSYNCIVPROC gl_GetSynciv;
PFNGLGETTEXIMAGEPROC  gl_GetTexImage;
PFNGLGETTEXLEVELPARAMETERFVPROC   gl_GetTexLevelParameterfv;
PFNGLGETTEXLEVELPARAMETERIVPROC   gl_GetTexLevelParameteriv;
PFNGLGETTEXPARAMETERIIVPROC gl_GetTexParameterIiv;
PFNGLGETTEXPARAMETERIUIVPROC gl_GetTexParameterIuiv;
PFNGLGETTEXPARAMETERFVPROC gl_GetTexParameterfv;
PFNGLGETTEXPARAMETERIVPROC gl_GetTexParameteriv;
PFNGLGETTEXTUREHANDLEARBPROC gl_GetTextureHandleARB;
PFNGLGETTEXTUREIMAGEPROC gl_GetTextureImage;
PFNGLGETTEXTURELEVELPARAMETERFVPROC  gl_GetTextureLevelParameterfv;
PFNGLGETTEXTURELEVELPARAMETERIVPROC  gl_GetTextureLevelParameteriv;
PFNGLGETTEXTUREPARAMETERIIVPROC   gl_GetTextureParameterIiv;
PFNGLGETTEXTUREPARAMETERIUIVPROC   gl_GetTextureParameterIuiv;
PFNGLGETTEXTUREPARAMETERFVPROC  gl_GetTextureParameterfv;
PFNGLGETTEXTUREPARAMETERIVPROC  gl_GetTextureParameteriv;
PFNGLGETTEXTURESAMPLERHANDLEARBPROC  gl_GetTextureSamplerHandleARB;
PFNGLGETTEXTURESUBIMAGEPROC gl_GetTextureSubImage;
PFNGLGETTRANSFORMFEEDBACKVARYINGPROC  gl_GetTransformFeedbackVarying;
PFNGLGETTRANSFORMFEEDBACKI64_VPROC  gl_GetTransformFeedbacki64_v;
PFNGLGETTRANSFORMFEEDBACKI_VPROC   gl_GetTransformFeedbacki_v;
PFNGLGETTRANSFORMFEEDBACKIVPROC   gl_GetTransformFeedbackiv;
PFNGLGETUNIFORMBLOCKINDEXPROC gl_GetUniformBlockIndex;
PFNGLGETUNIFORMINDICESPROC gl_GetUniformIndices;
PFNGLGETUNIFORMLOCATIONPROC gl_GetUniformLocation;
PFNGLGETUNIFORMSUBROUTINEUIVPROC   gl_GetUniformSubroutineuiv;
PFNGLGETUNIFORMDVPROC  gl_GetUniformdv;
PFNGLGETUNIFORMFVPROC  gl_GetUniformfv;
PFNGLGETUNIFORMIVPROC  gl_GetUniformiv;
PFNGLGETUNIFORMUIVPROC gl_GetUniformuiv;
PFNGLGETVERTEXARRAYINDEXED64IVPROC  gl_GetVertexArrayIndexed64iv;
PFNGLGETVERTEXARRAYINDEXEDIVPROC   gl_GetVertexArrayIndexediv;
PFNGLGETVERTEXARRAYIVPROC gl_GetVertexArrayiv;
PFNGLGETVERTEXATTRIBIIVPROC gl_GetVertexAttribIiv;
PFNGLGETVERTEXATTRIBIUIVPROC gl_GetVertexAttribIuiv;
PFNGLGETVERTEXATTRIBLDVPROC gl_GetVertexAttribLdv;
PFNGLGETVERTEXATTRIBLUI64VARBPROC  gl_GetVertexAttribLui64vARB;
PFNGLGETVERTEXATTRIBPOINTERVPROC   gl_GetVertexAttribPointerv;
PFNGLGETVERTEXATTRIBDVPROC gl_GetVertexAttribdv;
PFNGLGETVERTEXATTRIBFVPROC gl_GetVertexAttribfv;
PFNGLGETVERTEXATTRIBIVPROC gl_GetVertexAttribiv;
PFNGLGETNCOMPRESSEDTEXIMAGEPROC   gl_GetnCompressedTexImage;
PFNGLGETNCOMPRESSEDTEXIMAGEARBPROC  gl_GetnCompressedTexImageARB;
PFNGLGETNTEXIMAGEPROC  gl_GetnTexImage;
PFNGLGETNTEXIMAGEARBPROC gl_GetnTexImageARB;
PFNGLGETNUNIFORMDVPROC gl_GetnUniformdv;
PFNGLGETNUNIFORMDVARBPROC gl_GetnUniformdvARB;
PFNGLGETNUNIFORMFVPROC gl_GetnUniformfv;
PFNGLGETNUNIFORMFVARBPROC gl_GetnUniformfvARB;
PFNGLGETNUNIFORMIVPROC gl_GetnUniformiv;
PFNGLGETNUNIFORMIVARBPROC gl_GetnUniformivARB;
PFNGLGETNUNIFORMUIVPROC gl_GetnUniformuiv;
PFNGLGETNUNIFORMUIVARBPROC gl_GetnUniformuivARB;
PFNGLHINTPROC  gl_Hint;
PFNGLINVALIDATEBUFFERDATAPROC gl_InvalidateBufferData;
PFNGLINVALIDATEBUFFERSUBDATAPROC   gl_InvalidateBufferSubData;
PFNGLINVALIDATEFRAMEBUFFERPROC  gl_InvalidateFramebuffer;
PFNGLINVALIDATENAMEDFRAMEBUFFERDATAPROC  gl_InvalidateNamedFramebufferData;
PFNGLINVALIDATENAMEDFRAMEBUFFERSUBDATAPROC gl_InvalidateNamedFramebufferSubData;
PFNGLINVALIDATESUBFRAMEBUFFERPROC  gl_InvalidateSubFramebuffer;
PFNGLINVALIDATETEXIMAGEPROC gl_InvalidateTexImage;
PFNGLINVALIDATETEXSUBIMAGEPROC  gl_InvalidateTexSubImage;
PFNGLISBUFFERPROC  gl_IsBuffer;
PFNGLISENABLEDPROC gl_IsEnabled;
PFNGLISENABLEDIPROC gl_IsEnabledi;
PFNGLISFRAMEBUFFERPROC gl_IsFramebuffer;
PFNGLISIMAGEHANDLERESIDENTARBPROC  gl_IsImageHandleResidentARB;
PFNGLISNAMEDSTRINGARBPROC gl_IsNamedStringARB;
PFNGLISPROGRAMPROC gl_IsProgram;
PFNGLISPROGRAMPIPELINEPROC gl_IsProgramPipeline;
PFNGLISQUERYPROC  gl_IsQuery;
PFNGLISRENDERBUFFERPROC gl_IsRenderbuffer;
PFNGLISSAMPLERPROC gl_IsSampler;
PFNGLISSHADERPROC  gl_IsShader;
PFNGLISSYNCPROC  gl_IsSync;
PFNGLISTEXTUREPROC gl_IsTexture;
PFNGLISTEXTUREHANDLERESIDENTARBPROC  gl_IsTextureHandleResidentARB;
PFNGLISTRANSFORMFEEDBACKPROC gl_IsTransformFeedback;
PFNGLISVERTEXARRAYPROC gl_IsVertexArray;
PFNGLLINEWIDTHPROC gl_LineWidth;
PFNGLLINKPROGRAMPROC  gl_LinkProgram;
PFNGLLOGICOPPROC  gl_LogicOp;
PFNGLMAKEIMAGEHANDLENONRESIDENTARBPROC  gl_MakeImageHandleNonResidentARB;
PFNGLMAKEIMAGEHANDLERESIDENTARBPROC  gl_MakeImageHandleResidentARB;
PFNGLMAKETEXTUREHANDLENONRESIDENTARBPROC  gl_MakeTextureHandleNonResidentARB;
PFNGLMAKETEXTUREHANDLERESIDENTARBPROC  gl_MakeTextureHandleResidentARB;
PFNGLMAPBUFFERPROC gl_MapBuffer;
PFNGLMAPBUFFERRANGEPROC gl_MapBufferRange;
PFNGLMAPNAMEDBUFFERPROC gl_MapNamedBuffer;
PFNGLMAPNAMEDBUFFERRANGEPROC gl_MapNamedBufferRange;
PFNGLMEMORYBARRIERPROC gl_MemoryBarrier;
PFNGLMEMORYBARRIERBYREGIONPROC  gl_MemoryBarrierByRegion;
PFNGLMINSAMPLESHADINGPROC gl_MinSampleShading;
PFNGLMINSAMPLESHADINGARBPROC gl_MinSampleShadingARB;
PFNGLMULTIDRAWARRAYSPROC gl_MultiDrawArrays;
PFNGLMULTIDRAWARRAYSINDIRECTPROC   gl_MultiDrawArraysIndirect;
PFNGLMULTIDRAWARRAYSINDIRECTCOUNTARBPROC  gl_MultiDrawArraysIndirectCountARB;
PFNGLMULTIDRAWELEMENTSPROC gl_MultiDrawElements;
PFNGLMULTIDRAWELEMENTSBASEVERTEXPROC  gl_MultiDrawElementsBaseVertex;
PFNGLMULTIDRAWELEMENTSINDIRECTPROC  gl_MultiDrawElementsIndirect;
PFNGLMULTIDRAWELEMENTSINDIRECTCOUNTARBPROC gl_MultiDrawElementsIndirectCountARB;
PFNGLNAMEDBUFFERDATAPROC gl_NamedBufferData;
PFNGLNAMEDBUFFERPAGECOMMITMENTARBPROC  gl_NamedBufferPageCommitmentARB;
PFNGLNAMEDBUFFERPAGECOMMITMENTEXTPROC  gl_NamedBufferPageCommitmentEXT;
PFNGLNAMEDBUFFERSTORAGEPROC gl_NamedBufferStorage;
PFNGLNAMEDBUFFERSUBDATAPROC gl_NamedBufferSubData;
PFNGLNAMEDFRAMEBUFFERDRAWBUFFERPROC  gl_NamedFramebufferDrawBuffer;
PFNGLNAMEDFRAMEBUFFERDRAWBUFFERSPROC  gl_NamedFramebufferDrawBuffers;
PFNGLNAMEDFRAMEBUFFERPARAMETERIPROC  gl_NamedFramebufferParameteri;
PFNGLNAMEDFRAMEBUFFERREADBUFFERPROC  gl_NamedFramebufferReadBuffer;
PFNGLNAMEDFRAMEBUFFERRENDERBUFFERPROC  gl_NamedFramebufferRenderbuffer;
PFNGLNAMEDFRAMEBUFFERTEXTUREPROC   gl_NamedFramebufferTexture;
PFNGLNAMEDFRAMEBUFFERTEXTURELAYERPROC  gl_NamedFramebufferTextureLayer;
PFNGLNAMEDRENDERBUFFERSTORAGEPROC  gl_NamedRenderbufferStorage;
PFNGLNAMEDRENDERBUFFERSTORAGEMULTISAMPLEPROC  gl_NamedRenderbufferStorageMultisample;
PFNGLNAMEDSTRINGARBPROC gl_NamedStringARB;
PFNGLOBJECTLABELPROC  gl_ObjectLabel;
PFNGLOBJECTPTRLABELPROC gl_ObjectPtrLabel;
PFNGLPATCHPARAMETERFVPROC gl_PatchParameterfv;
PFNGLPATCHPARAMETERIPROC gl_PatchParameteri;
PFNGLPAUSETRANSFORMFEEDBACKPROC   gl_PauseTransformFeedback;
PFNGLPIXELSTOREFPROC  gl_PixelStoref;
PFNGLPIXELSTOREIPROC  gl_PixelStorei;
PFNGLPOINTPARAMETERFPROC gl_PointParameterf;
PFNGLPOINTPARAMETERFVPROC gl_PointParameterfv;
PFNGLPOINTPARAMETERIPROC gl_PointParameteri;
PFNGLPOINTPARAMETERIVPROC gl_PointParameteriv;
PFNGLPOINTSIZEPROC gl_PointSize;
PFNGLPOLYGONMODEPROC  gl_PolygonMode;
PFNGLPOLYGONOFFSETPROC gl_PolygonOffset;
PFNGLPOPDEBUGGROUPPROC gl_PopDebugGroup;
PFNGLPRIMITIVERESTARTINDEXPROC  gl_PrimitiveRestartIndex;
PFNGLPROGRAMBINARYPROC gl_ProgramBinary;
PFNGLPROGRAMPARAMETERIPROC gl_ProgramParameteri;
PFNGLPROGRAMUNIFORM1DPROC gl_ProgramUniform1d;
PFNGLPROGRAMUNIFORM1DVPROC gl_ProgramUniform1dv;
PFNGLPROGRAMUNIFORM1FPROC gl_ProgramUniform1f;
PFNGLPROGRAMUNIFORM1FVPROC gl_ProgramUniform1fv;
PFNGLPROGRAMUNIFORM1IPROC gl_ProgramUniform1i;
PFNGLPROGRAMUNIFORM1IVPROC gl_ProgramUniform1iv;
PFNGLPROGRAMUNIFORM1UIPROC gl_ProgramUniform1ui;
PFNGLPROGRAMUNIFORM1UIVPROC gl_ProgramUniform1uiv;
PFNGLPROGRAMUNIFORM2DPROC gl_ProgramUniform2d;
PFNGLPROGRAMUNIFORM2DVPROC gl_ProgramUniform2dv;
PFNGLPROGRAMUNIFORM2FPROC gl_ProgramUniform2f;
PFNGLPROGRAMUNIFORM2FVPROC gl_ProgramUniform2fv;
PFNGLPROGRAMUNIFORM2IPROC gl_ProgramUniform2i;
PFNGLPROGRAMUNIFORM2IVPROC gl_ProgramUniform2iv;
PFNGLPROGRAMUNIFORM2UIPROC gl_ProgramUniform2ui;
PFNGLPROGRAMUNIFORM2UIVPROC gl_ProgramUniform2uiv;
PFNGLPROGRAMUNIFORM3DPROC gl_ProgramUniform3d;
PFNGLPROGRAMUNIFORM3DVPROC gl_ProgramUniform3dv;
PFNGLPROGRAMUNIFORM3FPROC gl_ProgramUniform3f;
PFNGLPROGRAMUNIFORM3FVPROC gl_ProgramUniform3fv;
PFNGLPROGRAMUNIFORM3IPROC gl_ProgramUniform3i;
PFNGLPROGRAMUNIFORM3IVPROC gl_ProgramUniform3iv;
PFNGLPROGRAMUNIFORM3UIPROC gl_ProgramUniform3ui;
PFNGLPROGRAMUNIFORM3UIVPROC gl_ProgramUniform3uiv;
PFNGLPROGRAMUNIFORM4DPROC gl_ProgramUniform4d;
PFNGLPROGRAMUNIFORM4DVPROC gl_ProgramUniform4dv;
PFNGLPROGRAMUNIFORM4FPROC gl_ProgramUniform4f;
PFNGLPROGRAMUNIFORM4FVPROC gl_ProgramUniform4fv;
PFNGLPROGRAMUNIFORM4IPROC gl_ProgramUniform4i;
PFNGLPROGRAMUNIFORM4IVPROC gl_ProgramUniform4iv;
PFNGLPROGRAMUNIFORM4UIPROC gl_ProgramUniform4ui;
PFNGLPROGRAMUNIFORM4UIVPROC gl_ProgramUniform4uiv;
PFNGLPROGRAMUNIFORMHANDLEUI64ARBPROC  gl_ProgramUniformHandleui64ARB;
PFNGLPROGRAMUNIFORMHANDLEUI64VARBPROC  gl_ProgramUniformHandleui64vARB;
PFNGLPROGRAMUNIFORMMATRIX2DVPROC   gl_ProgramUniformMatrix2dv;
PFNGLPROGRAMUNIFORMMATRIX2FVPROC   gl_ProgramUniformMatrix2fv;
PFNGLPROGRAMUNIFORMMATRIX2X3DVPROC  gl_ProgramUniformMatrix2x3dv;
PFNGLPROGRAMUNIFORMMATRIX2X3FVPROC  gl_ProgramUniformMatrix2x3fv;
PFNGLPROGRAMUNIFORMMATRIX2X4DVPROC  gl_ProgramUniformMatrix2x4dv;
PFNGLPROGRAMUNIFORMMATRIX2X4FVPROC  gl_ProgramUniformMatrix2x4fv;
PFNGLPROGRAMUNIFORMMATRIX3DVPROC   gl_ProgramUniformMatrix3dv;
PFNGLPROGRAMUNIFORMMATRIX3FVPROC   gl_ProgramUniformMatrix3fv;
PFNGLPROGRAMUNIFORMMATRIX3X2DVPROC  gl_ProgramUniformMatrix3x2dv;
PFNGLPROGRAMUNIFORMMATRIX3X2FVPROC  gl_ProgramUniformMatrix3x2fv;
PFNGLPROGRAMUNIFORMMATRIX3X4DVPROC  gl_ProgramUniformMatrix3x4dv;
PFNGLPROGRAMUNIFORMMATRIX3X4FVPROC  gl_ProgramUniformMatrix3x4fv;
PFNGLPROGRAMUNIFORMMATRIX4DVPROC   gl_ProgramUniformMatrix4dv;
PFNGLPROGRAMUNIFORMMATRIX4FVPROC   gl_ProgramUniformMatrix4fv;
PFNGLPROGRAMUNIFORMMATRIX4X2DVPROC  gl_ProgramUniformMatrix4x2dv;
PFNGLPROGRAMUNIFORMMATRIX4X2FVPROC  gl_ProgramUniformMatrix4x2fv;
PFNGLPROGRAMUNIFORMMATRIX4X3DVPROC  gl_ProgramUniformMatrix4x3dv;
PFNGLPROGRAMUNIFORMMATRIX4X3FVPROC  gl_ProgramUniformMatrix4x3fv;
PFNGLPROVOKINGVERTEXPROC gl_ProvokingVertex;
PFNGLPUSHDEBUGGROUPPROC gl_PushDebugGroup;
PFNGLQUERYCOUNTERPROC  gl_QueryCounter;
PFNGLREADBUFFERPROC gl_ReadBuffer;
PFNGLREADPIXELSPROC gl_ReadPixels;
PFNGLREADNPIXELSPROC  gl_ReadnPixels;
PFNGLREADNPIXELSARBPROC gl_ReadnPixelsARB;
PFNGLRELEASESHADERCOMPILERPROC  gl_ReleaseShaderCompiler;
PFNGLRENDERBUFFERSTORAGEPROC gl_RenderbufferStorage;
PFNGLRENDERBUFFERSTORAGEMULTISAMPLEPROC  gl_RenderbufferStorageMultisample;
PFNGLRESUMETRANSFORMFEEDBACKPROC   gl_ResumeTransformFeedback;
PFNGLSAMPLECOVERAGEPROC gl_SampleCoverage;
PFNGLSAMPLEMASKIPROC  gl_SampleMaski;
PFNGLSAMPLERPARAMETERIIVPROC gl_SamplerParameterIiv;
PFNGLSAMPLERPARAMETERIUIVPROC gl_SamplerParameterIuiv;
PFNGLSAMPLERPARAMETERFPROC gl_SamplerParameterf;
PFNGLSAMPLERPARAMETERFVPROC gl_SamplerParameterfv;
PFNGLSAMPLERPARAMETERIPROC gl_SamplerParameteri;
PFNGLSAMPLERPARAMETERIVPROC gl_SamplerParameteriv;
PFNGLSCISSORPROC  gl_Scissor;
PFNGLSCISSORARRAYVPROC gl_ScissorArrayv;
PFNGLSCISSORINDEXEDPROC gl_ScissorIndexed;
PFNGLSCISSORINDEXEDVPROC gl_ScissorIndexedv;
PFNGLSHADERBINARYPROC  gl_ShaderBinary;
PFNGLSHADERSOURCEPROC  gl_ShaderSource;
PFNGLSHADERSTORAGEBLOCKBINDINGPROC  gl_ShaderStorageBlockBinding;
PFNGLSTENCILFUNCPROC  gl_StencilFunc;
PFNGLSTENCILFUNCSEPARATEPROC gl_StencilFuncSeparate;
PFNGLSTENCILMASKPROC  gl_StencilMask;
PFNGLSTENCILMASKSEPARATEPROC gl_StencilMaskSeparate;
PFNGLSTENCILOPPROC gl_StencilOp;
PFNGLSTENCILOPSEPARATEPROC gl_StencilOpSeparate;
PFNGLTEXBUFFERPROC gl_TexBuffer;
PFNGLTEXBUFFERRANGEPROC gl_TexBufferRange;
PFNGLTEXIMAGE1DPROC gl_TexImage1D;
PFNGLTEXIMAGE2DPROC gl_TexImage2D;
PFNGLTEXIMAGE2DMULTISAMPLEPROC  gl_TexImage2DMultisample;
PFNGLTEXIMAGE3DPROC gl_TexImage3D;
PFNGLTEXIMAGE3DMULTISAMPLEPROC  gl_TexImage3DMultisample;
PFNGLTEXPAGECOMMITMENTARBPROC gl_TexPageCommitmentARB;
PFNGLTEXPARAMETERIIVPROC gl_TexParameterIiv;
PFNGLTEXPARAMETERIUIVPROC gl_TexParameterIuiv;
PFNGLTEXPARAMETERFPROC gl_TexParameterf;
PFNGLTEXPARAMETERFVPROC gl_TexParameterfv;
PFNGLTEXPARAMETERIPROC gl_TexParameteri;
PFNGLTEXPARAMETERIVPROC gl_TexParameteriv;
PFNGLTEXSTORAGE1DPROC  gl_TexStorage1D;
PFNGLTEXSTORAGE2DPROC  gl_TexStorage2D;
PFNGLTEXSTORAGE2DMULTISAMPLEPROC   gl_TexStorage2DMultisample;
PFNGLTEXSTORAGE3DPROC  gl_TexStorage3D;
PFNGLTEXSTORAGE3DMULTISAMPLEPROC   gl_TexStorage3DMultisample;
PFNGLTEXSUBIMAGE1DPROC gl_TexSubImage1D;
PFNGLTEXSUBIMAGE2DPROC gl_TexSubImage2D;
PFNGLTEXSUBIMAGE3DPROC gl_TexSubImage3D;
PFNGLTEXTUREBARRIERPROC gl_TextureBarrier;
PFNGLTEXTUREBUFFERPROC gl_TextureBuffer;
PFNGLTEXTUREBUFFERRANGEPROC gl_TextureBufferRange;
PFNGLTEXTUREPARAMETERIIVPROC gl_TextureParameterIiv;
PFNGLTEXTUREPARAMETERIUIVPROC gl_TextureParameterIuiv;
PFNGLTEXTUREPARAMETERFPROC gl_TextureParameterf;
PFNGLTEXTUREPARAMETERFVPROC gl_TextureParameterfv;
PFNGLTEXTUREPARAMETERIPROC gl_TextureParameteri;
PFNGLTEXTUREPARAMETERIVPROC gl_TextureParameteriv;
PFNGLTEXTURESTORAGE1DPROC gl_TextureStorage1D;
PFNGLTEXTURESTORAGE2DPROC gl_TextureStorage2D;
PFNGLTEXTURESTORAGE2DMULTISAMPLEPROC  gl_TextureStorage2DMultisample;
PFNGLTEXTURESTORAGE3DPROC gl_TextureStorage3D;
PFNGLTEXTURESTORAGE3DMULTISAMPLEPROC  gl_TextureStorage3DMultisample;
PFNGLTEXTURESUBIMAGE1DPROC gl_TextureSubImage1D;
PFNGLTEXTURESUBIMAGE2DPROC gl_TextureSubImage2D;
PFNGLTEXTURESUBIMAGE3DPROC gl_TextureSubImage3D;
PFNGLTEXTUREVIEWPROC  gl_TextureView;
PFNGLTRANSFORMFEEDBACKBUFFERBASEPROC  gl_TransformFeedbackBufferBase;
PFNGLTRANSFORMFEEDBACKBUFFERRANGEPROC  gl_TransformFeedbackBufferRange;
PFNGLTRANSFORMFEEDBACKVARYINGSPROC  gl_TransformFeedbackVaryings;
PFNGLUNIFORM1DPROC gl_Uniform1d;
PFNGLUNIFORM1DVPROC gl_Uniform1dv;
PFNGLUNIFORM1FPROC gl_Uniform1f;
PFNGLUNIFORM1FVPROC gl_Uniform1fv;
PFNGLUNIFORM1IPROC gl_Uniform1i;
PFNGLUNIFORM1IVPROC gl_Uniform1iv;
PFNGLUNIFORM1UIPROC gl_Uniform1ui;
PFNGLUNIFORM1UIVPROC  gl_Uniform1uiv;
PFNGLUNIFORM2DPROC gl_Uniform2d;
PFNGLUNIFORM2DVPROC gl_Uniform2dv;
PFNGLUNIFORM2FPROC gl_Uniform2f;
PFNGLUNIFORM2FVPROC gl_Uniform2fv;
PFNGLUNIFORM2IPROC gl_Uniform2i;
PFNGLUNIFORM2IVPROC gl_Uniform2iv;
PFNGLUNIFORM2UIPROC gl_Uniform2ui;
PFNGLUNIFORM2UIVPROC  gl_Uniform2uiv;
PFNGLUNIFORM3DPROC gl_Uniform3d;
PFNGLUNIFORM3DVPROC gl_Uniform3dv;
PFNGLUNIFORM3FPROC gl_Uniform3f;
PFNGLUNIFORM3FVPROC gl_Uniform3fv;
PFNGLUNIFORM3IPROC gl_Uniform3i;
PFNGLUNIFORM3IVPROC gl_Uniform3iv;
PFNGLUNIFORM3UIPROC gl_Uniform3ui;
PFNGLUNIFORM3UIVPROC  gl_Uniform3uiv;
PFNGLUNIFORM4DPROC gl_Uniform4d;
PFNGLUNIFORM4DVPROC gl_Uniform4dv;
PFNGLUNIFORM4FPROC gl_Uniform4f;
PFNGLUNIFORM4FVPROC gl_Uniform4fv;
PFNGLUNIFORM4IPROC gl_Uniform4i;
PFNGLUNIFORM4IVPROC gl_Uniform4iv;
PFNGLUNIFORM4UIPROC gl_Uniform4ui;
PFNGLUNIFORM4UIVPROC  gl_Uniform4uiv;
PFNGLUNIFORMBLOCKBINDINGPROC gl_UniformBlockBinding;
PFNGLUNIFORMHANDLEUI64ARBPROC gl_UniformHandleui64ARB;
PFNGLUNIFORMHANDLEUI64VARBPROC  gl_UniformHandleui64vARB;
PFNGLUNIFORMMATRIX2DVPROC gl_UniformMatrix2dv;
PFNGLUNIFORMMATRIX2FVPROC gl_UniformMatrix2fv;
PFNGLUNIFORMMATRIX2X3DVPROC gl_UniformMatrix2x3dv;
PFNGLUNIFORMMATRIX2X3FVPROC gl_UniformMatrix2x3fv;
PFNGLUNIFORMMATRIX2X4DVPROC gl_UniformMatrix2x4dv;
PFNGLUNIFORMMATRIX2X4FVPROC gl_UniformMatrix2x4fv;
PFNGLUNIFORMMATRIX3DVPROC gl_UniformMatrix3dv;
PFNGLUNIFORMMATRIX3FVPROC gl_UniformMatrix3fv;
PFNGLUNIFORMMATRIX3X2DVPROC gl_UniformMatrix3x2dv;
PFNGLUNIFORMMATRIX3X2FVPROC gl_UniformMatrix3x2fv;
PFNGLUNIFORMMATRIX3X4DVPROC gl_UniformMatrix3x4dv;
PFNGLUNIFORMMATRIX3X4FVPROC gl_UniformMatrix3x4fv;
PFNGLUNIFORMMATRIX4DVPROC gl_UniformMatrix4dv;
PFNGLUNIFORMMATRIX4FVPROC gl_UniformMatrix4fv;
PFNGLUNIFORMMATRIX4X2DVPROC gl_UniformMatrix4x2dv;
PFNGLUNIFORMMATRIX4X2FVPROC gl_UniformMatrix4x2fv;
PFNGLUNIFORMMATRIX4X3DVPROC gl_UniformMatrix4x3dv;
PFNGLUNIFORMMATRIX4X3FVPROC gl_UniformMatrix4x3fv;
PFNGLUNIFORMSUBROUTINESUIVPROC  gl_UniformSubroutinesuiv;
PFNGLUNMAPBUFFERPROC  gl_UnmapBuffer;
PFNGLUNMAPNAMEDBUFFERPROC gl_UnmapNamedBuffer;
PFNGLUSEPROGRAMPROC gl_UseProgram;
PFNGLUSEPROGRAMSTAGESPROC gl_UseProgramStages;
PFNGLVALIDATEPROGRAMPROC gl_ValidateProgram;
PFNGLVALIDATEPROGRAMPIPELINEPROC   gl_ValidateProgramPipeline;
PFNGLVERTEXARRAYATTRIBBINDINGPROC  gl_VertexArrayAttribBinding;
PFNGLVERTEXARRAYATTRIBFORMATPROC   gl_VertexArrayAttribFormat;
PFNGLVERTEXARRAYATTRIBIFORMATPROC  gl_VertexArrayAttribIFormat;
PFNGLVERTEXARRAYATTRIBLFORMATPROC  gl_VertexArrayAttribLFormat;
PFNGLVERTEXARRAYBINDINGDIVISORPROC  gl_VertexArrayBindingDivisor;
PFNGLVERTEXARRAYELEMENTBUFFERPROC  gl_VertexArrayElementBuffer;
PFNGLVERTEXARRAYVERTEXBUFFERPROC   gl_VertexArrayVertexBuffer;
PFNGLVERTEXARRAYVERTEXBUFFERSPROC  gl_VertexArrayVertexBuffers;
PFNGLVERTEXATTRIB1DPROC gl_VertexAttrib1d;
PFNGLVERTEXATTRIB1DVPROC gl_VertexAttrib1dv;
PFNGLVERTEXATTRIB1FPROC gl_VertexAttrib1f;
PFNGLVERTEXATTRIB1FVPROC gl_VertexAttrib1fv;
PFNGLVERTEXATTRIB1SPROC gl_VertexAttrib1s;
PFNGLVERTEXATTRIB1SVPROC gl_VertexAttrib1sv;
PFNGLVERTEXATTRIB2DPROC gl_VertexAttrib2d;
PFNGLVERTEXATTRIB2DVPROC gl_VertexAttrib2dv;
PFNGLVERTEXATTRIB2FPROC gl_VertexAttrib2f;
PFNGLVERTEXATTRIB2FVPROC gl_VertexAttrib2fv;
PFNGLVERTEXATTRIB2SPROC gl_VertexAttrib2s;
PFNGLVERTEXATTRIB2SVPROC gl_VertexAttrib2sv;
PFNGLVERTEXATTRIB3DPROC gl_VertexAttrib3d;
PFNGLVERTEXATTRIB3DVPROC gl_VertexAttrib3dv;
PFNGLVERTEXATTRIB3FPROC gl_VertexAttrib3f;
PFNGLVERTEXATTRIB3FVPROC gl_VertexAttrib3fv;
PFNGLVERTEXATTRIB3SPROC gl_VertexAttrib3s;
PFNGLVERTEXATTRIB3SVPROC gl_VertexAttrib3sv;
PFNGLVERTEXATTRIB4NBVPROC gl_VertexAttrib4Nbv;
PFNGLVERTEXATTRIB4NIVPROC gl_VertexAttrib4Niv;
PFNGLVERTEXATTRIB4NSVPROC gl_VertexAttrib4Nsv;
PFNGLVERTEXATTRIB4NUBPROC gl_VertexAttrib4Nub;
PFNGLVERTEXATTRIB4NUBVPROC gl_VertexAttrib4Nubv;
PFNGLVERTEXATTRIB4NUIVPROC gl_VertexAttrib4Nuiv;
PFNGLVERTEXATTRIB4NUSVPROC gl_VertexAttrib4Nusv;
PFNGLVERTEXATTRIB4BVPROC gl_VertexAttrib4bv;
PFNGLVERTEXATTRIB4DPROC gl_VertexAttrib4d;
PFNGLVERTEXATTRIB4DVPROC gl_VertexAttrib4dv;
PFNGLVERTEXATTRIB4FPROC gl_VertexAttrib4f;
PFNGLVERTEXATTRIB4FVPROC gl_VertexAttrib4fv;
PFNGLVERTEXATTRIB4IVPROC gl_VertexAttrib4iv;
PFNGLVERTEXATTRIB4SPROC gl_VertexAttrib4s;
PFNGLVERTEXATTRIB4SVPROC gl_VertexAttrib4sv;
PFNGLVERTEXATTRIB4UBVPROC gl_VertexAttrib4ubv;
PFNGLVERTEXATTRIB4UIVPROC gl_VertexAttrib4uiv;
PFNGLVERTEXATTRIB4USVPROC gl_VertexAttrib4usv;
PFNGLVERTEXATTRIBBINDINGPROC gl_VertexAttribBinding;
PFNGLVERTEXATTRIBDIVISORPROC gl_VertexAttribDivisor;
PFNGLVERTEXATTRIBFORMATPROC gl_VertexAttribFormat;
PFNGLVERTEXATTRIBI1IPROC gl_VertexAttribI1i;
PFNGLVERTEXATTRIBI1IVPROC gl_VertexAttribI1iv;
PFNGLVERTEXATTRIBI1UIPROC gl_VertexAttribI1ui;
PFNGLVERTEXATTRIBI1UIVPROC gl_VertexAttribI1uiv;
PFNGLVERTEXATTRIBI2IPROC gl_VertexAttribI2i;
PFNGLVERTEXATTRIBI2IVPROC gl_VertexAttribI2iv;
PFNGLVERTEXATTRIBI2UIPROC gl_VertexAttribI2ui;
PFNGLVERTEXATTRIBI2UIVPROC gl_VertexAttribI2uiv;
PFNGLVERTEXATTRIBI3IPROC gl_VertexAttribI3i;
PFNGLVERTEXATTRIBI3IVPROC gl_VertexAttribI3iv;
PFNGLVERTEXATTRIBI3UIPROC gl_VertexAttribI3ui;
PFNGLVERTEXATTRIBI3UIVPROC gl_VertexAttribI3uiv;
PFNGLVERTEXATTRIBI4BVPROC gl_VertexAttribI4bv;
PFNGLVERTEXATTRIBI4IPROC gl_VertexAttribI4i;
PFNGLVERTEXATTRIBI4IVPROC gl_VertexAttribI4iv;
PFNGLVERTEXATTRIBI4SVPROC gl_VertexAttribI4sv;
PFNGLVERTEXATTRIBI4UBVPROC gl_VertexAttribI4ubv;
PFNGLVERTEXATTRIBI4UIPROC gl_VertexAttribI4ui;
PFNGLVERTEXATTRIBI4UIVPROC gl_VertexAttribI4uiv;
PFNGLVERTEXATTRIBI4USVPROC gl_VertexAttribI4usv;
PFNGLVERTEXATTRIBIFORMATPROC gl_VertexAttribIFormat;
PFNGLVERTEXATTRIBIPOINTERPROC gl_VertexAttribIPointer;
PFNGLVERTEXATTRIBL1DPROC gl_VertexAttribL1d;
PFNGLVERTEXATTRIBL1DVPROC gl_VertexAttribL1dv;
PFNGLVERTEXATTRIBL1UI64ARBPROC  gl_VertexAttribL1ui64ARB;
PFNGLVERTEXATTRIBL1UI64VARBPROC   gl_VertexAttribL1ui64vARB;
PFNGLVERTEXATTRIBL2DPROC gl_VertexAttribL2d;
PFNGLVERTEXATTRIBL2DVPROC gl_VertexAttribL2dv;
PFNGLVERTEXATTRIBL3DPROC gl_VertexAttribL3d;
PFNGLVERTEXATTRIBL3DVPROC gl_VertexAttribL3dv;
PFNGLVERTEXATTRIBL4DPROC gl_VertexAttribL4d;
PFNGLVERTEXATTRIBL4DVPROC gl_VertexAttribL4dv;
PFNGLVERTEXATTRIBLFORMATPROC gl_VertexAttribLFormat;
PFNGLVERTEXATTRIBLPOINTERPROC gl_VertexAttribLPointer;
PFNGLVERTEXATTRIBP1UIPROC gl_VertexAttribP1ui;
PFNGLVERTEXATTRIBP1UIVPROC gl_VertexAttribP1uiv;
PFNGLVERTEXATTRIBP2UIPROC gl_VertexAttribP2ui;
PFNGLVERTEXATTRIBP2UIVPROC gl_VertexAttribP2uiv;
PFNGLVERTEXATTRIBP3UIPROC gl_VertexAttribP3ui;
PFNGLVERTEXATTRIBP3UIVPROC gl_VertexAttribP3uiv;
PFNGLVERTEXATTRIBP4UIPROC gl_VertexAttribP4ui;
PFNGLVERTEXATTRIBP4UIVPROC gl_VertexAttribP4uiv;
PFNGLVERTEXATTRIBPOINTERPROC gl_VertexAttribPointer;
PFNGLVERTEXBINDINGDIVISORPROC gl_VertexBindingDivisor;
PFNGLVIEWPORTPROC  gl_Viewport;
PFNGLVIEWPORTARRAYVPROC gl_ViewportArrayv;
PFNGLVIEWPORTINDEXEDFPROC gl_ViewportIndexedf;
PFNGLVIEWPORTINDEXEDFVPROC gl_ViewportIndexedfv;
PFNGLWAITSYNCPROC  gl_WaitSync;
