// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: Nek5000PluginInfo.C
// ****************************************************************************

#include <Nek5000PluginInfo.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(Nek5000,DBP_EXPORT)

VISIT_DATABASE_PLUGIN_ENTRY(Nek5000,General)

// ****************************************************************************
//  Method: Nek5000GeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the database plugin.
//
//  Returns:    A pointer to the name of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
Nek5000GeneralPluginInfo::GetName() const
{
    return "Nek5000";
}

// ****************************************************************************
//  Method: Nek5000GeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the database plugin.
//
//  Returns:    A pointer to the version of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
Nek5000GeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: Nek5000GeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the database plugin.
//
//  Returns:    A pointer to the id of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
Nek5000GeneralPluginInfo::GetID() const
{
    return "Nek5000_1.0";
}
// ****************************************************************************
//  Method: Nek5000GeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
Nek5000GeneralPluginInfo::EnabledByDefault() const
{
    return true;
}
// ****************************************************************************
//  Method: Nek5000GeneralPluginInfo::HasWriter
//
//  Purpose:
//    Return true if this plugin has a database writer.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
Nek5000GeneralPluginInfo::HasWriter() const
{
    return false;
}
// ****************************************************************************
//  Method:  Nek5000GeneralPluginInfo::GetDefaultFilePatterns
//
//  Purpose:
//    Returns the default patterns for a Nek5000 database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
std::vector<std::string>
Nek5000GeneralPluginInfo::GetDefaultFilePatterns() const
{
    std::vector<std::string> defaultPatterns;
    defaultPatterns.push_back("*.nek3d");
    defaultPatterns.push_back("*.nek2d");
    defaultPatterns.push_back("*.nek5k");
    defaultPatterns.push_back("*.nek5000");
    defaultPatterns.push_back("*.nek");

    return defaultPatterns;
}

// ****************************************************************************
//  Method:  Nek5000GeneralPluginInfo::AreDefaultFilePatternsStrict
//
//  Purpose:
//    Returns if the file patterns for a Nek5000 database are
//    intended to be interpreted strictly by default.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
Nek5000GeneralPluginInfo::AreDefaultFilePatternsStrict() const
{
    return false;
}

// ****************************************************************************
//  Method:  Nek5000GeneralPluginInfo::OpensWholeDirectory
//
//  Purpose:
//    Returns if the Nek5000 plugin opens a whole directory name
//    instead of a single file.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
Nek5000GeneralPluginInfo::OpensWholeDirectory() const
{
    return false;
}
