import {styleTags, tags as t} from "@lezer/highlight"

export const rustHighlighting = styleTags({
  "const macro_rules struct union enum type fn impl trait let static": t.definitionKeyword,
  "mod use crate": t.moduleKeyword,
  "pub unsafe async mut extern default move": t.modifier,
  "for if else loop while match continue break return await": t.controlKeyword,
  "as in ref": t.operatorKeyword,
  "where _ crate super dyn": t.keyword,
  "self": t.self,
  String: t.string,
  Char: t.character,
  RawString: t.special(t.string),
  Boolean: t.bool,
  Identifier: t.variableName,
  "CallExpression/Identifier": t.function(t.variableName),
  BoundIdentifier: t.definition(t.variableName),
  "FunctionItem/BoundIdentifier": t.function(t.definition(t.variableName)),
  LoopLabel: t.labelName,
  FieldIdentifier: t.propertyName,
  "CallExpression/FieldExpression/FieldIdentifier": t.function(t.propertyName),
  Lifetime: t.special(t.variableName),
  ScopeIdentifier: t.namespace,
  TypeIdentifier: t.typeName,
  "MacroInvocation/Identifier MacroInvocation/ScopedIdentifier/Identifier": t.macroName,
  "MacroInvocation/TypeIdentifier MacroInvocation/ScopedIdentifier/TypeIdentifier": t.macroName,
  "\"!\"": t.macroName,
  UpdateOp: t.updateOperator,
  LineComment: t.lineComment,
  BlockComment: t.blockComment,
  Integer: t.integer,
  Float: t.float,
  ArithOp: t.arithmeticOperator,
  LogicOp: t.logicOperator,
  BitOp: t.bitwiseOperator,
  CompareOp: t.compareOperator,
  "=": t.definitionOperator,
  ".. ... => ->": t.punctuation,
  "( )": t.paren,
  "[ ]": t.squareBracket,
  "{ }": t.brace,
  ". DerefOp": t.derefOperator,
  "&": t.operator,
  ", ; ::": t.separator,
  "Attribute/...": t.meta,
})
