/***************************************************************************
 *   Copyright (C) 2005-2007 by Eugene V. Lyubimkin aka jackyf             *
 *   jackyf@yfnote-debian                                                  *
 *                                                                         *
 *   This file is a part of yf-library                                     *
 *                                                                         *																*
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License for Libraries    *
 *   as published by the Free Software Foundation                          *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for Libraries for more details.            *
 *                                                                         *
 *   You should have received a copy of the GNU LGPL                       *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
//---------------------------------------------------------------------------
#ifndef yf_exceptionH
#define yf_exceptionH

#include <exception>

#include <yf/defs.hpp>
#include <yf/exception/messages.hpp>
#include <yf/exception/errtypes.hpp>

namespace yf
{
	class exception : public std::exception
	{
	 private:
		error_types::error __err_type;
		char __message[line_max];
	 public:
		exception( const std::exception& std_e );
		exception( const exception& rhsE );
		exception( 	const char* who,
						error_types::error error_type,
						const char* message,
						const char* file,
						uint32 line
							);
		virtual ~exception() throw();

		virtual const char* what() const throw();
		virtual error_types::error errtype() const throw();
	};
}

#define YF_FUNC_EXCEPTION(ERROR) throw yf::exception( __FUNCTION__, \
													yf::error_types:: ERROR, \
													yf::thrown_messages:: ERROR, \
													__FILE__, \
													__LINE__ \
												);

#define YF_FUNC_MESSAGE_EXCEPTION(ERROR, MESSAGE) throw yf::exception( __FUNCTION__, \
																		yf::error_types:: ERROR, \
																		MESSAGE, \
																		__FILE__, \
																		__LINE__ \
																	);

#define YF_EXCEPTION(CALLER, ERROR) throw yf::exception(CALLER, \
														yf::error_types:: ERROR, \
														yf::thrown_messages:: ERROR, \
														__FILE__, \
														__LINE__ \
														);

#define YF_MESSAGE_EXCEPTION(CALLER, ERROR, MESSAGE) throw yf::exception( 	CALLER, \
																			yf::error_types:: ERROR, \
																			MESSAGE, \
																			__FILE__, \
																			__LINE__ \
																		);

//---------------------------------------------------------------------------
#endif
