use strict;
package MyDef::output_general;

our $debug=0;
our $out;
our $mode;
our $page;
our %plugin_statement;
our %plugin_condition;


sub get_interface {
    return (\&init_page, \&parsecode, \&set_output, \&modeswitch, \&dumpout);
}

sub init_page {
    my ($t_page)=@_;
    $page=$t_page;
    MyDef::set_page_extension("txt");
    my $init_mode="sub";
    return $init_mode;
}

sub set_output {
    my ($newout)=@_;
    $out = $newout;
}

sub modeswitch {
    my ($mode, $in)=@_;
}

sub parsecode {
    my ($l)=@_;
    if ($debug eq "parse") {
        my $yellow="\033[33;1m";
        my $normal="\033[0m";
        print "$yellow parsecode: [$l]$normal\n";
    }

    if ($l=~/^DEBUG (\w+)/) {
        if ($1 eq "OFF") {
            $debug=0;
        }
        else {
            $debug=$1;
        }
        return;
    }
    elsif ($l=~/^\$eval\s+(\w+)(.*)/) {
        my ($codename, $param)=($1, $2);
        $param=~s/^\s*,\s*//;
        my $t=MyDef::compileutil::eval_sub($codename);
        eval $t;
        if ($@ and !$MyDef::compileutil::eval_sub_error{$codename}) {
            $MyDef::compileutil::eval_sub_error{$codename}=1;
            print "evalsub - $codename\n";
            print "[$t]\n";
            print "eval error: [$@] package [", __PACKAGE__, "]\n";
        }
        return;
    }
    if ($l=~/^DUMP_STUB\s/) {
        push @$out, $l;
    }
    elsif ($l=~/^\s*\$(\w+)\((.*?)\)\s+(.*?)\s*$/) {
        my ($func, $param1, $param2)=($1, $2, $3);
        if ($func eq "plugin") {
            if ($param2=~/_condition$/) {
                $plugin_condition{$param1}=$param2;
            }
            else {
                $plugin_statement{$param1}=$param2;
            }
            return;
        }
    }
    elsif ($l=~/^\s*\$(\w+)\s*(.*)$/) {
        my ($func, $param) = ($1, $2);
        if ($param !~ /^=/) {
            if ($func eq "plugin") {
                foreach my $p (split /,\s*/, $param) {
                    if ($p=~/^&(.+)/) {
                        if ($p=~/_condition$/) {
                            $plugin_condition{$1}=$p;
                        }
                        else {
                            $plugin_statement{$1}=$p;
                        }
                    }
                    else {
                        if ($p=~/_condition$/) {
                            $plugin_condition{$p}=$p;
                        }
                        else {
                            $plugin_statement{$p}=$p;
                        }
                    }
                }
                return;
            }
            elsif ($plugin_statement{$func}) {
                my $c= $plugin_statement{$func};
                if ($c=~/^&(.+)/) {
                    return "PARSE:\&call $1, $param";
                }
                else {
                    MyDef::compileutil::call_sub("$c, $param");
                }
                return;
            }
        }
    }
    elsif ($l=~/^CALLBACK\s+(\w+)\s*(.*)/) {
        my ($func, $param)=($1, $2);
        my $codelist=$MyDef::compileutil::named_blocks{"last_grab"};
        return;
    }


    push @$out, $l;
}

sub dumpout {
    my ($f, $out)=@_;
    my $dump={out=>$out,f=>$f};
    MyDef::dumpout::dumpout($dump);
}

sub single_block {
    my ($t1, $t2, $scope)=@_;
    my @src;
    push @src, "$t1";
    push @src, "INDENT";
    push @src, "BLOCK";
    push @src, "DEDENT";
    push @src, "$t2";
    MyDef::compileutil::set_named_block("NEWBLOCK", \@src);
    if ($scope) {
        return "NEWBLOCK-$scope";
    }
    else {
        return "NEWBLOCK";
    }
}

1;

1;
