//
//  pam.hpp
//  Mothur
//
//  Created by Sarah Westcott on 7/1/21.
//  Copyright © 2021 Schloss Lab. All rights reserved.
//

#ifndef pam_hpp
#define pam_hpp

#include "calculator.h"

/* dcmut version of PAM model from  www.ebi.ac.uk/goldman-srv/dayhoff/ */
static double pameigs[] =
{0,-1.93321786301018,-2.20904642493621,-1.74835983874903,
-1.64854548332072,-1.54505559488222,-1.33859384676989,-1.29786201193594,
-0.235548517495575,-0.266951066089808,-0.28965813670665,-1.10505826965282,
-1.04323310568532,-0.430423720979904,-0.541719761016713,-0.879636093986914,
-0.711249353378695,-0.725050487280602,-0.776855937389452,-0.808735559461343};

static double pamprobs[20][20] ={
{0.08712695644, 0.04090397955, 0.04043197978, 0.04687197656,
0.03347398326, 0.03825498087, 0.04952997524, 0.08861195569,
0.03361898319, 0.03688598156, 0.08535695732, 0.08048095976,
0.01475299262, 0.03977198011, 0.05067997466, 0.06957696521,
0.05854197073, 0.01049399475, 0.02991598504, 0.06471796764},
{0.07991048383, 0.006888314018, 0.03857806206, 0.07947073194,
0.004895492884, 0.03815829405, -0.1087562465, 0.008691167141,
-0.0140554828, 0.001306404001, -0.001888411299, -0.006921303342,
0.0007655604228, 0.001583298443, 0.006879590446, -0.171806883,
0.04890917949, 0.0006700432804, 0.0002276237277, -0.01350591875},
{-0.01641514483, -0.007233933239, -0.1377830621, 0.1163201333,
-0.002305138017, 0.01557250366, -0.07455879489, -0.003225343503,
0.0140630487, 0.005112274204, 0.001405731862, 0.01975833782,
-0.001348402973, -0.001085733262, -0.003880514478, 0.0851493313,
-0.01163526615, -0.0001197903399, 0.002056153393, 0.0001536095643},
{0.009669278686, -0.006905863869, 0.101083544, 0.01179903104,
-0.003780967591, 0.05845105878, -0.09138357299, -0.02850503638,
-0.03233951408, 0.008708065876, -0.004700705411, -0.02053221579,
0.001165851398, -0.001366585849, -0.01317695074, 0.1199985703,
-0.1146346193, -0.0005953021314, -0.0004297615194, 0.007475695618},
{0.1722243502, -0.003737582995, -0.02964873222, -0.02050116381,
-0.0004530478465, -0.02460043205, 0.02280768412, -0.02127364909,
0.01570095258, 0.1027744285, -0.005330539586, 0.0179697651,
-0.002904077286, -0.007068126663, -0.0142869583, -0.01444241844,
-0.08218861544, 0.0002069181629, 0.001099671379, -0.1063484263},
{-0.1553433627, -0.001169168032, 0.02134785337, 0.0007602305436,
0.0001395330122, 0.03194992019, -0.01290252206, 0.03281720789,
-0.01311103735, 0.1177254769, -0.008008783885, -0.02375317548,
-0.002817809762, -0.008196682776, 0.01731267617, 0.01853526375,
0.08249908546, -2.788771776e-05, 0.001266182191, -0.09902299976},
{-0.03671080341, 0.0274168035, 0.04625877597, 0.07520706414,
-0.0001833803619, -0.1207833161, -0.006415807779, -0.005465629648,
0.02778273972, 0.007589688485, -0.02945266034, -0.03797542064,
0.07044042052, -0.002018573865, 0.01845277071, 0.006901513991,
-0.02430934639, -0.0005919635873, -0.001266962331, -0.01487591261},
{-0.03060317816, 0.01182361623, 0.04200270053, 0.05406235279,
-0.0003920498815, -0.09159709348, -0.009602690652, -0.00382944418,
0.01761361993, 0.01605684317, 0.05198878008, 0.02198696949,
-0.09308930025, -0.00102622863, 0.01477637127, 0.0009314065393,
-0.01860959472, -0.0005964703968, -0.002694284083, 0.02079767439},
{0.0195976494, -0.005104484936, 0.007406728707, 0.01236244954,
0.0201446796, 0.007039564785, 0.01276942134, 0.02641595685,
0.002764624354, 0.001273314658, -0.01335316035, 0.01105658671,
2.148773499e-05, -0.02692205639, 0.0118684991, 0.01212624708,
0.01127770094, -0.09842754796, -0.01942336432, 0.007105703151},
{-0.01819461888, -0.01509348507, -0.01297636935, -0.01996453439,
0.1715705905, -0.01601550692, -0.02122706144, -0.02854628494,
-0.009351082371, -0.001527995472, -0.010198224, -0.03609537551,
-0.003153182095, 0.02395980501, -0.01378664626, -0.005992611421,
-0.01176810875, 0.003132361603, 0.03018439539, -0.004956065656},
{-0.02733614784, -0.02258066705, -0.0153112506, -0.02475728664,
-0.04480525045, -0.01526640341, -0.02438517425, -0.04836914601,
-0.00635964824, 0.02263169831, 0.09794101931, -0.04004304158,
0.008464393478, 0.1185443142, -0.02239294163, -0.0281550321,
-0.01453581604, -0.0246742804, 0.0879619849, 0.02342867605},
{0.06483718238, 0.1260012082, -0.006496013283, 0.009914915531,
-0.004181603532, 0.0003493226286, 0.01408035752, -0.04881663016,
-0.03431167356, -0.01768005602, 0.02362447761, -0.1482364784,
-0.01289035619, -0.001778893279, -0.05240099752, 0.05536174567,
0.06782165352, -0.003548568717, 0.001125301173, -0.03277489363},
{0.06520296909, -0.0754802543, 0.03139281903, -0.03266449554,
-0.004485188002, -0.03389072036, -0.06163274338, -0.06484769882,
0.05722658289, -0.02824079619, 0.01544837349, 0.03909752708,
0.002029218884, 0.003151939572, -0.05471208363, 0.07962008342,
0.125916047, 0.0008696184937, -0.01086027514, -0.05314092355},
{0.004543119081, 0.01935177735, 0.01905511007, 0.02682993409,
-0.01199617967, 0.01426278655, 0.02472521255, 0.03864795501,
0.02166224804, -0.04754243479, -0.1921545477, 0.03621321546,
-0.02120627881, 0.04928097895, 0.009396088815, 0.01748042052,
-6.173742851e-05, -0.003168033098, 0.07723565812, -0.08255529309},
{0.06710378668, -0.09441410284, -0.004801776989, 0.008830272165,
-0.01021645042, -0.02764365608, 0.004250361851, 0.1648777542,
-0.037446109, 0.004541057635, -0.0296980702, -0.1532325189,
-0.008940580901, 0.006998050812, 0.02338809379, 0.03175059182,
0.02033965512, 0.006388075608, 0.001762762044, 0.02616280361},
{0.01915943021, -0.05432967274, 0.01249342683, 0.06836622457,
0.002054462161, -0.01233535859, 0.07087282652, -0.08948637051,
-0.1245896013, -0.02204522882, 0.03791481736, 0.06557467874,
0.005529294156, -0.006296644235, 0.02144530752, 0.01664230081,
0.02647078439, 0.001737725271, 0.01414149877, -0.05331990116},
{0.0266659303, 0.0564142853, -0.0263767738, -0.08029726006,
-0.006059357163, -0.06317558457, -0.0911894019, 0.05401487057,
-0.08178072458, 0.01580699778, -0.05370550396, 0.09798653264,
0.003934944022, 0.01977291947, 0.0441198541, 0.02788220393,
0.03201877081, -0.00206161759, -0.005101423308, 0.03113033802},
{0.02980360751, -0.009513246268, -0.009543527165, -0.02190644172,
-0.006146440672, 0.01207009085, -0.0126989156, -0.1378266418,
0.0275235217, 0.00551720592, -0.03104791544, -0.07111701247,
-0.006081754489, -0.01337494521, 0.1783961085, 0.01453225059,
0.01938736048, 0.0004488631071, 0.0110844398, 0.02049339243},
{-0.01433508581, 0.01258858175, -0.004294252236, -0.007146532854,
0.009541628809, 0.008040155729, -0.006857781832, 0.05584120066,
0.007749418365, -0.05867835844, 0.08008131283, -0.004877854222,
-0.0007128540743, 0.09489058424, 0.06421121962, 0.00271493526,
-0.03229944773, -0.001732026038, -0.08053448316, -0.1241903609},
{-0.009854113227, 0.01294129929, -0.00593064392, -0.03016833115,
-0.002018439732, -0.00792418722, -0.03372768732, 0.07828561288,
0.007722254639, -0.05067377561, 0.1191848621, 0.005059475202,
0.004762387166, -0.1029870175, 0.03537190114, 0.001089956203,
-0.02139157573, -0.001015245062, 0.08400521847, -0.08273195059}};

/**************************************************************************************************/
//PAM - Dayhoff PAM matrix

class PAM : public DistCalc {
    
public:
    
    PAM(double c) : DistCalc(c) { name = "PAM (Dayhoff PAM matrix)"; }

    double calcDist(Protein A, Protein B) { return (makeDists(A, B, pameigs, pamprobs)); } //calc distance between 2 seqeunces
    string getCitation() { return "https://evolution.gs.washington.edu/phylip/doc/protdist.html, https://evolution.genetics.washington.edu/phylip/credits.html"; }
    
private:
    
};

/**************************************************************************************************/
#endif /* pam_hpp */
