# vISA Assembly Syntax

Notation
--------

-  Left associated rules are used
-  \| : indicates "or"
-  &lt;abc&gt; : means abc is none-terminal token
-  [xyz] : 0 or 1 occurrence of xyz
-  [xyz]?: 1 occurrence of x, or y, or z
-   [xyz]\* : 0 or more occurrences of x, y and z.
-  [xyz]+ : 1 or more occurrences of x, y and z.
-  ^ : start position of a line

Lexemes
-------

### Operators:

&lt;operators&gt;::=+\|-\|\*\|/

&lt;assign_operator&gt;::='='

&lt;colon&gt;::=':'

&lt;other_operators&gt;::=, \| ; \| '&lt;' \| '&gt;' \| '(' \| ')'

### Types:

&lt;variable_type&gt; ::= G\|A\|P\|S\|T

&lt;data_type&gt; ::= &lt;FLOAT&gt; \| &lt;INT&gt; \| &lt;BOOLEAN&gt; \| &lt;VECTOR&gt;

&lt;FLOAT&gt;::=f \| df \| F \| DF

&lt;INT&gt;::= ud \| d \| uw \| w \| ub \| b \| UD \| D \| UW \| W \| UB \| B

&lt;BOOLEAN&gt;::=bool \| BOOL

&lt;VECTOR&gt;::= v \| vf \| V \| VF

&lt;src_modifier&gt;::=[(-) \| (abs) \| (-abs)]

### Tokens:

&lt;directives&gt;::=.attr \| .decl \| .input \| .kernel \| .function \|
.version

&lt;pred_ctrl&gt;::= all \| any

&lt;pred_state&gt;::= !

&lt;vme_op_type&gt;::=inter \| intra \| all

&lt;align&gt;::= byte\|word\|dword\|qword\|oword\|GRF\|2GRF

&lt;rel_op&gt;::= eq\|ne\|gt\|ge\|lt\|le\|EQ\|NE\|GT\|GE\|LT\|LE

&lt;start_offset&gt;::=M0\|M1\|M2\|M3\|M4\|M5\|M6\|M7\|NM

&lt;attribute&gt;::= asmName \| FlagRegNum

&lt;other_tokens&gt;::= num_elts \| align \| alias \| type \| v_type \|
size \| attr \| offset \| .sat

&lt;OP&gt;::=
and\|or\|xor\|shl\|shr\|asr\|not\|inv\|log\|exp\|sqrt\|rsqrt\|sin\|cos\|div\|mod\|pow\|frc\|lzd\|rndd\|rndu
\|rnde\|rndz\|add\|avg\|dp2\|dp3\|dp4\|dhp\|line\|mul\|pow\|mulh\|sad2\|mad\|asin\|acos\|atan\|addr_add\|sel\|mov\|movs\|setp\|cmp\|oword_ld\|oword_st\|oword_ld_unaligned\|media_ld\|media_st\|gather\|scatter\|dword_atomic\|sample\|load\|sample_unorm\|vme\|jmp\|call\|ret\|if\|while\|else\|do\|endif\|break\|cont\|vme_fbr\|vme_sic\|vme_ime

&lt;atomic_op&gt;::=add\|sub\|inc\|dec\|min\|max\|xchg\|cmpxchg\|and\|or\|xor\|imin\|imax

### Numbers:

&lt;number&gt;::=&lt;int_number&gt;\|&lt;hex_number&gt;\|&lt;float_point_number&gt;

&lt;int_number&gt;::=&lt;oct_number&gt;\|&lt;hex_number&gt;

&lt;oct_number&gt;::= [0-9]+

&lt;hex_number&gt;::=0x[0-9a-fA-F]+

&lt;float_point_number&gt;::=&lt;float_number_basic&gt;
\|&lt;float_number_science&gt;

&lt; float_number_basic &gt;::=[0-9]+"."[0-9]+

&lt; float_number_science &gt;::= ([0-9]+"."[0-9]+)"e"("+"\|"-")[0-9]+

&lt;exp&gt;::=&lt;INT_NUMBER&gt;\|Exp'+'Exp\|Exp'-'Exp\|Exp'\*'Exp\|Exp'/'Exp\|'-'
Exp\|'('Exp')'

&lt;offset&gt;::=&lt;exp&gt;

### Strings:

&lt;label&gt;::= ^[a-zA-Z_$@?]?[a-zA-Z0-9_\\-$@?]\*

&lt;asmFileName&gt;::=[a-zA-Z_]?[a-zA-Z0-9_\\-$]\*"."asm

&lt;func_name&gt;::=[a-zA-Z_$@\\?]?[a-zA-Z0-9_\\-$@\\?]\*

&lt;bracket_pairs&gt;::= '&lt;'[a-zA-Z_]?[a-zA-Z0-9_\\-, \\t]\*'&gt;' \| '('
[a-zA-Z][a-zA-Z0-9_\\-, \\t]\*')'

&lt;kernel_name&gt;::= [a-zA-Z_]?[a-zA-Z0-9_\\-]\*[&lt;bracket_pairs&gt;]

&lt;var_name&gt;::= [a-zA-Z_]?[a-zA-Z0-9_\\-]\*

&lt;comment&gt;::= /\* &lt;string_with_no_end_comment&gt; \*/

&lt;end_of_line&gt;::='\\n'

vISA Assembly File
------------------

&lt;vISA_Assembly_File&gt;::=&lt;directives_declares&gt; [&lt;kernel_function&gt;]+

&lt;directives_declares&gt;::= &lt;directive_kernel&gt;&lt;end_line&gt;
&lt;directive_version&gt;&lt;end_line&gt; &lt;directives_declares &gt;&lt;end_line&gt;[
&lt;directives_input &gt;&lt;end_line&gt;]+ [&lt;directives_attr &gt;&gt;&lt;end_line&gt;]+

&lt;kernel_function&gt;::=&lt;directive_function&gt;[[&lt;vISA_instructions&gt;&lt;end_line&gt;]\|[&lt;decl_label&gt;&lt;end_line&gt;]]+

Directives and Declarations Syntax
----------------------------------

### Directives

| Directive               | Mnemonic / Syntax                                 | Example                            |
| --- | --- | --- |
| &lt;directive_attr&gt;       | .attr &lt;attr_name&gt;=&lt;attr_value&gt;                  | .attr AsmName=IS_genx_1.asm      |
| &lt;directive_decl&gt;       | See following Declarations table                  | See following Declarations table   |
| &lt;directive_input&gt;      | .input &lt;input_var&gt; offset=&lt;offset&gt; size=&lt;size&gt;   | .input T5 offset=36 size=4         |
| &lt;directive_version&gt;    | .version &lt;major_version&gt;.&lt;minor_version&gt;        | .version 1.0                       |
| &lt;directive_kernel&gt;     | .kernel &lt;kernel_name&gt;                            | .kernel BlockMotionSearch          |
| &lt;directive_function&gt;   | .function &lt;func_name&gt;                            | .function foo                      |


&lt;directive_decl&gt;::=[&lt;decl_gen_var&gt;\|&lt;decl_add_var&gt;\|&lt;decl_pred_var&gt;\|&lt;decl_samp_var&gt;\|&lt;decl_surf_var&gt;]+

### Declarations

| Variable  | Declaration Mnemonic / Syntax  | Type  | Max Count   | R\\W   | Input   | Address-able   | Example |
| --- | --- | --- | --- | --- | --- | --- | --- |
| &lt;decl_gen_var&gt;    | .decl &lt;gen_var_name&gt; v_type=G type= &lt;data_type&gt; num_elts =&lt;num_elements&gt; [align=&lt;align&gt;] [alias (&lt;alias_variable_name&gt;, &lt;offset&gt;)]   | UD, D, UW, W, UB, B, DF, F   | 65536       | R\\W   | Y       | Y              | .decl V8 v_type=G type=UD num_elts=1 align=dword    |
| &lt;decl_add_var&gt;    | .decl &lt;addr_var_name&gt; v_type=A type=&lt;data_type&gt; num_elts=&lt;num_elements&gt;                                                                | UW                           | 4096        | R\\W   | N       | N              | .decl A14 v_type=A type=UW num_elts=1               |
| &lt;decl_pred_var&gt;   | .decl &lt;pred_var_name&gt; v_type=P num_elts=&lt;num_elements&gt; [ attr: FlagRegNum =&lt;reg_num&gt;]                                                  | BOOL                         | 4096        | R\\W   | N       | N              | .decl P182 v_type=P num_elts=8                      |
| &lt;decl_samp_var&gt;   | .decl &lt;samp_var_name&gt; v_type = S                                                                                                          |                              | 16          | R      | Y       | N              | .decl S0 v_type=S                                    |
| &lt;decl_surf_var&gt;   | .decl &lt;surf_var_name&gt; v_type=T                                                                                                            |                              | 128         | R      | Y       | N              | .decl T5 v_type=T                                    |
| &lt;decl_label&gt;       | &lt;label &gt;:                                                                                                                                    |                              | 4096        | R      | N       | N              | BB_11224:                                            |
|                     |                                                                                                                                              |                              |             |        |         |                | ??$d_transpose@M$07$0IA@@@YAXVSurfaceIndex@@0HH@Z:   |

&lt;gen_var_name&gt;::=&lt;var_name&gt;

&lt;addr_var_name&gt;::=&lt;var_name&gt;

&lt;pred_var_name&gt;::=&lt;var_name&gt;

&lt;samp_var_name&gt;::=&lt;var_name&gt;

&lt;surf_var_name&gt;::=&lt;var_name&gt;

&lt;input_var&gt;::=&lt;gen_var_name&gt;\|&lt;samp_var_name&gt;\|&lt;surf_var_name&gt;\|&lt;samp_var_name

vISA instruction syntax
-----------------------

### Operands

| Operand position   | Operand group   | Operand type  | Operand type ID  |  Mnemonic / Syntax |  Example |
| --- | --- | --- | --- | --- | --- |
| Execution size     |                 |                                                                                                                                                           | &lt;exec_size&gt;                | ( &lt;start_offset&gt;, &lt;exp&gt;)                                                                                                     | (M1, 4)           |
| Predicate          |                 | Predicate                                                                                                                                                 | P                           | [!] &lt;pred_var_name&gt;[.&lt;pred_ctrl&gt;]                                                                                          | !P64.all          |
| Source             | V_OPND         | General                                                                                                                                                   | G                           | [&lt;src_modifier&gt;] &lt;gen_var_name&gt; (&lt;row_offset&gt;, &lt; col_offset&gt;) '&lt;'&lt;vertical_stride&gt;; &lt;width&gt;, &lt;horizontal_stride&gt;'&gt;'    | V58(0,0)&lt;8;8,1&gt;   |
| Address            | A               | &lt;addr_var_name&gt; (&lt;offset&gt;)'&lt;'&lt;width&gt;'&gt;'                                                                                                                 | A3(0)&lt;1&gt;                    |                                                                                                                               |                   |
| Indirect           | I               | [&lt;src_modifier&gt;]r'[' &lt;addr_var_name&gt;(&lt;addr_offset&gt;), &lt; indirect_offset&gt; ']' '&lt;' &lt;vertical_stride&gt;; &lt;width&gt;, &lt;horizontal_stride&gt;'&gt;': &lt;data_type&gt;   | r[A3(0),448]&lt;8;8,1&gt;:ud      |                                                                                                                               |                   |
| Predicate          | P               | [&lt;src_modifier&gt;] &lt;pred_var_name&gt;                                                                                                                       | P17                         |                                                                                                                               |                   |
| Immediate          | IM              | &lt;value&gt;:&lt;data_type&gt;                                                                                                                                      | 0x100:uw                    |                                                                                                                               |                   |
| Address Of         | AO              | &&lt;gen_var_name&gt; [+\|-] &lt;addr_offset&gt;                                                                                                                   |  &V21+0                     |                                                                                                                               |                   |
| R_OPND            | Raw             | G                                                                                                                                                         | &lt;gen_var_name&gt;.&lt;offset&gt;   | V16.0                                                                                                                         |                   |
| OTHERS             | Sampler         | S                                                                                                                                                         | &lt;samp_var_name&gt;           | S9                                                                                                                            |                   |
| Surface            | T               | &lt;surf_var_name&gt;                                                                                                                                         | T2                          |                                                                                                                               |                   |
| Destination        | V_OPND         | General                                                                                                                                                   | G                           | &lt;gen_var_name&gt;(&lt;row_offset&gt;, &lt;col_offset&gt;)'&lt;'&lt;horizontal_stride&gt; '&gt;'                                                     | V55(0,0)&lt;1&gt;       |
| Address            | A               | &lt;addr_var_name&gt; (&lt;offset&gt;)                                                                                                                              | A11(0)                      |                                                                                                                               |                   |
| Predicate          | P               | pred_var_name                                                                                                                                           | P8                          |                                                                                                                               |                   |
| Indirect           | I               | r'['&lt; addr_var_name&gt;(&lt;addr_offset&gt;), &lt; indirect_offset&gt; ']' ' &lt;'&lt; horizontal_stride&gt; '&gt;': &lt;data_type&gt;                                               | r[A11(0),64]&lt;1&gt;:ud          |                                                                                                                               |                   |
| R_OPND            | Raw             | G                                                                                                                                                         | &lt;gen_var_name&gt;.&lt;offset&gt;   | V16.0                                                                                                                         |                   |

&lt;horizontal_stride&gt;::= &lt;exp&gt;

&lt; vertical_stride &gt;::= &lt;exp&gt;

&lt;row_offset&gt;::= &lt;exp&gt;

&lt;col_offset&gt;::= &lt;exp&gt;

&lt; addr_offset &gt;::= &lt;exp&gt;

### Instructions formats summary

| Format ID                          | Mnemonic/Syntax                                      | Operands                       | Instructions  |
| --- | --- | --- | --- |
| 1                                  | [(P)] &lt;OP&gt; &lt;exec_size&gt; &lt;dst&gt; &lt;src0&gt;                 | Dst (V_OPND): G\|I            | EXP, FRC, LOG, RNDD, RNDU, RNDE, RNDZ, SIN, COS, SQRT, RSQRT, INV, ASIN, ACOS, ATAN, LZD,                                                                      |
|                                    |                                                      | Src0 (V_OPND): G\|I\|IM       |                                                                                                                                                                |
| Dst (V_OPND): G\|I\|A             | MOV                                                  |                                |                                                                                                                                                                |
| Src0 (V_OPND): G\|I\|IM\|P \|AO   |                                                      |                                |                                                                                                                                                                |
| 2                                  | &lt;OP&gt; &lt;exec_size&gt; &lt;dst&gt; &lt;src0&gt;                       | Dst (V_OPND): P               | STEP, MOVS                                                                                                                                                     |
|                                    |                                                      | Src0 (V_OPND): G\|I\|IM       |                                                                                                                                                                |
| 3                                  | [(P)] &lt;OP&gt; &lt;exec_size&gt; &lt;dst&gt; &lt;src0&gt; &lt;src1&gt;          | Dst (V_OPND): G\|I            | ADD, AVG, DIV, DP2, DP3, DP4, DPH, MULH, MOD, MUL, SHL, SHR, SEL                                                                                               |
|                                    |                                                      | Src0 (V_OPND): G\|I\|IM       |                                                                                                                                                                |
|                                    |                                                      | Src1 (V_OPND): G\|I\|IM       |                                                                                                                                                                |
| Dst (V_OPND): G\|I                | POW,                                                 |                                |                                                                                                                                                                |
| Src0 (V_OPND): G\|I\|IM           |                                                      |                                |                                                                                                                                                                |
| Src1 (V_OPND): G\|I               |                                                      |                                |                                                                                                                                                                |
| Dst (V_OPND):G\|I\|P              | AND, OR, XOR, NOT,                                   |                                |                                                                                                                                                                |
| Src0 (V_OPND):G\|I\|P\|IM         |                                                      |                                |                                                                                                                                                                |
| Src1 (V_OPND):G\|I\|P\|IM         |                                                      |                                |                                                                                                                                                                |
| Dst (V_OPND): G\|I                | LINE                                                 |                                |                                                                                                                                                                |
| Src0 (V_OPND): G                  |                                                      |                                |                                                                                                                                                                |
| Src1 (V_OPND): G\|I\|IM           |                                                      |                                |                                                                                                                                                                |
| 4                                  | &lt;OP&gt; &lt;exec_size&gt; &lt;dst&gt; &lt;src0&gt; &lt;src1&gt;                | Dst (V_OPND): A               | ADDR_ADD                                                                                                                                                      |
|                                    |                                                      | Src0 (V_OPND):A\|AO           |                                                                                                                                                                |
|                                    |                                                      | Src1 (V_OPND):G\|IM           |                                                                                                                                                                |
| 5                                  | [(P)] &lt;OP&gt; &lt;exec_size&gt; &lt;dst&gt; &lt;src0&gt; &lt;src1&gt; &lt;src2&gt;   | Dst (V_OPND): G\|I            | MAD,                                                                                                                                                           |
|                                    |                                                      | Src0 (V_OPND): G\|I\|IM       |                                                                                                                                                                |
|                                    |                                                      | Src1 (V_OPND): G\|I\|IM       |                                                                                                                                                                |
|                                    |                                                      | Src2(V_OPND): G\|I\|IM        |                                                                                                                                                                |
| 6                                  | CMP.&lt;rel_op&gt; (exec_size) &lt;dst&gt; &lt;src0&gt; &lt;src1&gt;       | | Rel_op(ub): EQ\|NE\| GT\|   | CMP                                                                                                                                                            |
|                                    |                                                      | | GE\|LT\|LE                   |                                                                                                                                                                |
|                                    |                                                      |                                |                                                                                                                                                                |
|                                    |                                                      | | Dst (V_OPND): P             |                                                                                                                                                                |
|                                    |                                                      | | Src0 (V_OPND): G\|I\|IM     |                                                                                                                                                                |
|                                    |                                                      | | Src1 (V_OPND): G\|I\|IM     |                                                                                                                                                                |
| 7                                  | [(P)] &lt;OP&gt; (&lt;exec_size&gt;)                            |                                | RET                                                                                                                                                            |
| 8                                  | [(P)] &lt;OP&gt; &lt;exec_size&gt; &lt;label&gt;                      |                                | JMP, CALL,                                                                                                                                                     |
| 9                                  | &lt;OP&gt; (&lt;start_offset&gt;, &lt;exec_size&gt;)                 |                                | ELSE, ENDIF, DO                                                                                                                                                |
| 10                                 | [(P)]&lt;OP&gt; (&lt;start_offset&gt;, &lt;exec_size&gt;)            |                                | IF, WHILE, BREAK, CONT                                                                                                                                         |
| 11                                 | Instruction specific syntax                          | Instruction specific           | OWORD_LD, OWORD_ST, MEDIA_LD, MEDIA_ST, GATHER, SCATTER, DWORD_ATOMIC, OWORD_LD_UNALIGNED, SAMPLE, SAMPLE_UNORM, LOAD, FILE, LOC, VME_IME, VME_SIC   |

### Instruction syntax


| **ID**  | **Opcode**  | **Mnemonic / Syntax**  | **Operands**  |**Data types and other constraints**  |
| --- | --- | --- | --- | --- |
| 0       | 0x0         | Reserved                                                                                                     |                                                                                               |                                                                                       |
| 1       | 0x1         | [(P)] ADD [.sat] &lt;exec_size&gt; &lt;dst&gt; &lt;src0&gt; &lt;src1&gt;                                                            | Exec_size (ub): NO LIMIT                                                                     |                                                                                       |
|         |             |                                                                                                              |                                                                                               |                                                                                       |
|         |             |                                                                                                              | Dst (V_OPND): G\|I                                                                           | - Types: FLOAT|INT                                                                    |
|         |             |                                                                                                              |                                                                                               |                                                                                       |
|         |             |                                                                                                              | Src0 (V_OPND): G\|I\|IM                                                                      |                                                                                       |
|         |             |                                                                                                              |                                                                                               |                                                                                       |
|         |             |                                                                                                              | Src1 (V_OPND): G\|I\|IM                                                                      |                                                                                       |
| 2       | 0x2         | [(P)] AVG [.sat] &lt;exec_size&gt; &lt;dst&gt; &lt;src0&gt; &lt;src1&gt;                                                            | Exec_size (ub): NO LIMIT                                                                     | - Type: INT                                                                           |
|         |             |                                                                                                              | Dst (V_OPND): G\|I                                                                           |                                                                                       |
|         |             |                                                                                                              | Src0 (V_OPND): G\|I\|IM                                                                      |                                                                                       |
|         |             |                                                                                                              | Src1 (V_OPND): G\|I\|IM                                                                      |                                                                                       |
| 3       | 0x3         | [(P)] DIV [.sat] &lt;exec_size&gt;&lt;dst&gt; &lt;src0&gt; &lt;src1&gt;                                                             | Exec_size (ub): NO LIMIT                                                                     | - Types: FLOAT|INT                                                                    |
|         |             |                                                                                                              | Dst (V_OPND): G\|I                                                                           | - ".sat" only works in float type                                                     |
|         |             |                                                                                                              | Src0 (V_OPND): G\|I\|IM                                                                      |                                                                                       |
|         |             |                                                                                                              | Src1 (V_OPND): G\|I\|IM                                                                      |                                                                                       |
| 4       | 0x4         | [(P)] DP2 [.sat] &lt;exec_size&gt; &lt;dst&gt; &lt;src0&gt; &lt;src1&gt;                                                            | Exec_size (ub): &gt;=4                                                                          | - Types: FLOAT                                                                        |
|         |             |                                                                                                              | Dst (V_OPND): G\|I                                                                           | - The horizontal stride of dst,  src0, and src1 must be 1                             |
|         |             |                                                                                                              | Src0 (V_OPND): G\|I\|IM                                                                      |                                                                                       |
|         |             |                                                                                                              | Src1 (V_OPND): G\|I\|IM                                                                      |                                                                                       |
| 5       | 0x5         | [(P)] DP3 [.sat] &lt;exec_size&gt; &lt;dst&gt; &lt;src0&gt; &lt;src1&gt;                                                            | Exec_size (ub): &gt;=4                                                                          | - Types: FLOAT                                                                        |
|         |             |                                                                                                              | Dst (V_OPND): G\|I                                                                           | - The horizontal stride of dst,  src0, and src1 must be 1                             |
|         |             |                                                                                                              | Src0 (V_OPND): G\|I\|IM                                                                      |                                                                                       | 
|         |             |                                                                                                              | Src1 (V_OPND): G\|I\|IM                                                                      |                                                                                       |
| 6       | 0x6         | [(P)] DP4 [.sat] &lt;exec_size&gt; &lt;dst&gt; &lt;src0&gt; &lt;src1&gt;                                                            | Exec_size (ub): &gt;=4                                                                          | - Types: FLOAT                                                                        |
|         |             |                                                                                                              | Dst (V_OPND): G\|I                                                                           | - The horizontal stride of dst,  src0, and src1 must be 1                             |
|         |             |                                                                                                              | Src0 (V_OPND): G\|I\|IM                                                                      |                                                                                       |
|         |             |                                                                                                              | Src1 (V_OPND): G\|I\|IM                                                                      |                                                                                       |
| 7       | 0x7         | [(P)] DPH [.sat] &lt;exec_size&gt; &lt;dst&gt; &lt;src0&gt; &lt;src1&gt;                                                            | Exec_size (ub): &gt;=4                                                                          | - Types: FLOAT                                                                        |
|         |             |                                                                                                              | Dst (V_OPND): G\|I                                                                           | - The horizontal stride of dst, src0, and src1 must be 1                              |
|         |             |                                                                                                              | Src0 (V_OPND): G\|I\|IM                                                                      |                                                                                       |
|         |             |                                                                                                              | Src1 (V_OPND): G\|I\|IM                                                                      |                                                                                       |
| 8       | 0x8         | [(P)] EXP [.sat] &lt;exec_size&gt; &lt;dst&gt; &lt;src0&gt;                                                                   | Exec_size (ub): NO LIMIT                                                                     | - Types: FLOAT                                                                        |
|         |             |                                                                                                              | Dst (V_OPND): G\|I                                                                           |                                                                                       |
|         |             |                                                                                                              | Src0 (V_OPND): G\|I\|IM                                                                      |                                                                                       |
| 9       | 0x9         | [(P)] FRC &lt;exec_size&gt; &lt;dst&gt; &lt;src0&gt;                                                                          | Exec_size (ub): NO LIMIT                                                                     | - Types: FLOAT                                                                        |
|         |             |                                                                                                              | Dst (V_OPND): G\|I                                                                           |                                                                                       |
|         |             |                                                                                                              | Src0 (V_OPND): G\|I\|IM                                                                      |                                                                                       |
| 10      | 0xA         | [(P)] LINE [.sat] &lt;exec_size&gt; &lt;dst&gt; &lt;src0&gt; &lt;src1&gt;                                                           | Exec_size (ub): &gt;=4                                                                          | - Types: FLOAT|INT                                                                    |
|         |             |                                                                                                              | Dst (V_OPND): G\|I                                                                           | - Src0's  horizontal and vertical  stride must be 0                                   |
|         |             |                                                                                                              | Src0 (V_OPND): G                                                                             |                                                                                       |
|         |             |                                                                                                              | Src1 (V_OPND): G\|I\|IM                                                                      |                                                                                       |
| 11      | 0xB         | [(P)] LOG [.sat] &lt;exec_size&gt; &lt;dst&gt; &lt;src0&gt;                                                                   | Exec_size (ub): NO LIMIT                                                                     | - Types: FLOAT                                                                        |
|         |             |                                                                                                              | Dst (V_OPND): G\|I                                                                           |                                                                                       |
|         |             |                                                                                                              | Src0 (V_OPND): G\|I\|IM                                                                      |                                                                                       |
| 12      | 0xC         | [(P)] MAD[.sat] &lt;exec_size&gt; &lt;dst&gt; &lt;src0&gt; &lt;src1&gt; &lt;src2&gt;                                                      | Exec_size (ub): NO LIMIT                                                                     | - Types: FLOAT|INT                                                                    |
|         |             |                                                                                                              | Dst (V_OPND): G\|I                                                                           | - [.sat] only works for FLOAT                                                         |
|         |             |                                                                                                              | Src0 (V_OPND): G\|I:M                                                                        |                                                                                       |
|         |             |                                                                                                              | Src1 (V_OPND): G\|I\|IM                                                                      |                                                                                       |
|         |             |                                                                                                              | Src12(V_OPND): G\|I\|IM                                                                      |                                                                                       |
| 13      | 0xD         | [(P)] MULH &lt;exec_size&gt; &lt;dst&gt; &lt;src0&gt; &lt;src1&gt;                                                                  | Exec_size (ub): NO LIMIT                                                                     | - Types: INT|UD|D                                                                     |
|         |             |                                                                                                              | Dst (V_OPND): G\|I                                                                           |                                                                                       |
|         |             |                                                                                                              | Src0 (V_OPND): G\|I\|IM                                                                      |                                                                                       |
|         |             |                                                                                                              | Src1 (V_OPND): G\|I\|IM                                                                      |                                                                                       |
| 14      | 0xE         | Reserved                                                                                                     |                                                                                               |                                                                                       |
| 15      | 0xF         | [(P)] MOD &lt;exec_size&gt; &lt;dst&gt; &lt;src0&gt; &lt;src1&gt;                                                                   | Exec_size (ub): NO LIMIT                                                                     | - Types: INT                                                                          |
|         |             |                                                                                                              | Dst (V_OPND): G\|I                                                                           |                                                                                       |
|         |             |                                                                                                              | Src0 (V_OPND): G\|I\|IM                                                                      |                                                                                       |
|         |             |                                                                                                              | Src1 (V_OPND): G\|I\|IM                                                                      |                                                                                       |
| 16      | 0x10        | [(P)] MUL [.sat] &lt;exec_size&gt; &lt;dst&gt; &lt;src0&gt; &lt;src1&gt;                                                            | Exec_size (ub): NO LIMIT                                                                     | - Types: FLOAT|INT                                                                    |
|         |             |                                                                                                              | Dst (V_OPND): G\|I                                                                           |                                                                                       |
|         |             |                                                                                                              | Src0 (V_OPND): G\|I\|IM                                                                      |                                                                                       |
|         |             |                                                                                                              | Src1 (V_OPND): G\|I\|IM                                                                      |                                                                                       |
| 17      | 0x11        | [(P)] POW [.sat] &lt;exec_size&gt; &lt;dst&gt; &lt;src0&gt; &lt;src1&gt;                                                            | Exec_size (ub): NO LIMIT                                                                     | - Types: FLOAT                                                                        |
|         |             |                                                                                                              | Dst (V_OPND): G\|I                                                                           | - Src1's horizontal and vertical  stride must be 0                                    |
|         |             |                                                                                                              | Src0 (V_OPND): G\|I\|IM                                                                      |                                                                                       |
|         |             |                                                                                                              | Src1 (V_OPND): G\|I                                                                          |                                                                                       |
| 18      | 0x12        | [(P)] RNDD [.sat] &lt;exec_size&gt; &lt;dst&gt; &lt;src0&gt;                                                                  | Exec_size (ub): NO LIMIT                                                                     | - Types: FLOAT                                                                        |
|         |             |                                                                                                              | Dst (V_OPND): G\|I                                                                           |                                                                                       |
|         |             |                                                                                                              | Src0 (V_OPND): G\|I\|IM                                                                      |                                                                                       |
| 19      | 0x13        | [(P)] RNDU [.sat] &lt;exec_size&gt; &lt;dst&gt; &lt;src0&gt;                                                                  | Exec_size (ub): NO LIMIT                                                                     | - Types: FLOAT                                                                        |
|         |             |                                                                                                              | Dst (V_OPND): G\|I                                                                           |                                                                                       |
|         |             |                                                                                                              | Src0 (V_OPND): G\|I\|IM                                                                      |                                                                                       |
| 20      | 0x14        | [(P)] RNDE [.sat] &lt;exec_size&gt; &lt;dst&gt; &lt;src0&gt;                                                                  | Exec_size (ub): NO LIMIT                                                                     | - Types: FLOAT                                                                        |
|         |             |                                                                                                              | Dst (V_OPND): G\|I                                                                           |                                                                                       |
|         |             |                                                                                                              | Src0 (V_OPND): G\|I\|IM                                                                      |                                                                                       |
| 21      | 0x15        | [(P)] RNDZ [.sat] &lt;exec_size&gt; &lt;dst&gt; &lt;src0&gt;                                                                  | Exec_size (ub): NO LIMIT                                                                     | - Types: FLOAT                                                                        |
|         |             |                                                                                                              | Dst (V_OPND): G\|I                                                                           |                                                                                       |
|         |             |                                                                                                              | Src0 (V_OPND): G\|I\|IM                                                                      |                                                                                       |
| 22      | 0x16        | [(P)] SAD2 [.sat] &lt;exec_size&gt; &lt;dst&gt; &lt;src0&gt; &lt;src1&gt;                                                           | Exec_size (ub): NO LIMIT                                                                     | - Dst Type: W|UW                                                                      |
|         |             |                                                                                                              | Dst (V_OPND): G\|I                                                                           | - Dst horizontal stride: 2                                                            |
|         |             |                                                                                                              | Src0 (V_OPND): G\|I\|IM                                                                      | - Src0 Type: B:UB                                                                     |
|         |             |                                                                                                              | Src1 (V_OPND): G\|I                                                                          | - Src1 Type: B:UB                                                                     |
| 23      | 0x17        | [(P)] SIN [.sat] &lt;exec_size&gt; &lt;dst&gt; &lt;src0&gt;                                                                   | Exec_size (ub): NO LIMIT                                                                     | - Types: FLOAT                                                                        |
|         |             |                                                                                                              | Dst (V_OPND): G\|I                                                                           |                                                                                       |
|         |             |                                                                                                              | Src0 (V_OPND): G\|I\|IM                                                                      |                                                                                       |
| 24      | 0x18        | [(P)] COS [.sat] &lt;exec_size&gt; &lt;dst&gt; &lt;src0&gt;                                                                   | Exec_size (ub): NO LIMIT                                                                     | - Types: FLOAT                                                                        |
|         |             |                                                                                                              | Dst (V_OPND): G\|I                                                                           |                                                                                       |
|         |             |                                                                                                              | Src0 (V_OPND): G\|I\|IM                                                                      |                                                                                       |
| 25      | 0x19        | [(P)] SQRT [.sat] &lt;exec_size&gt; &lt;dst&gt; &lt;src0&gt;                                                                  | Exec_size (ub): NO LIMIT                                                                     | - Types: FLOAT                                                                        |
|         |             |                                                                                                              | Dst (V_OPND): G\|I                                                                           |                                                                                       |
|         |             |                                                                                                              | Src0 (V_OPND): G\|I\|IM                                                                      |                                                                                       |
| 26      | 0x1A        | [(P)] RSQRT [.sat] &lt;exec_size&gt; &lt;dst&gt; &lt;src0&gt;                                                                 | Exec_size (ub): NO LIMIT                                                                     | - Types: FLOAT                                                                        |
|         |             |                                                                                                              | Dst (V_OPND): G\|I                                                                           |                                                                                       |
|         |             |                                                                                                              | Src0 (V_OPND): G\|I\|IM                                                                      |                                                                                       |
| 27      | 0x1B        | [(P)] INV [.sat] &lt;exec_size&gt; &lt;dst&gt; &lt;src0&gt;                                                                   | | Exec_size (ub): NO LIMIT                                                                   | - Types: FLOAT                                                                        |
|         |             |                                                                                                              | | Dst (V_OPND): G\|I                                                                         |                                                                                       |
|         |             |                                                                                                              |                                                                                               |                                                                                       |
|         |             |                                                                                                              | Src0 (V_OPND): G\|I\|IM                                                                      |                                                                                       |
| 28      | 0x1C        | [(P)] ASIN [.sat] &lt;exec_size&gt; &lt;dst&gt; &lt;src0&gt;                                                                  | Exec_size (ub): NO LIMIT                                                                     | - Types: FLOAT                                                                        |
|         |             |                                                                                                              | Dst (V_OPND): G\|I                                                                           |                                                                                       |
|         |             |                                                                                                              | Src0 (V_OPND): G\|I\|IM                                                                      |                                                                                       |
| 29      | 0x1d        | [(P)] ACOS [.sat] &lt;exec_size&gt; &lt;dst&gt; &lt;src0&gt;                                                                  | Exec_size (ub): No limit                                                                     | - Types: FLOAT                                                                        |
|         |             |                                                                                                              | Dst (V_OPND): G\|I                                                                           |                                                                                       |
|         |             |                                                                                                              | Src0 (V_OPND): G\|I\|IM                                                                      |                                                                                       |
| 30      | 0x1E        | [(P)] ATAN [.sat] &lt;exec_size&gt; &lt;dst&gt; &lt;src0&gt;                                                                  | Exec_size (ub): NO LIMIT                                                                     | - Types: FLOAT                                                                        |
|         |             |                                                                                                              | Dst (V_OPND): G\|I                                                                           |                                                                                       |
|         |             |                                                                                                              | Src0 (V_OPND): G\|I\|IM                                                                      |                                                                                       |
| 31      | 0x1F        | [(P)] LZD &lt;exec_size&gt; &lt;dst&gt; &lt;src0&gt;                                                                          | Exec_size (ub): NO LIMIT                                                                     | - Types: UD                                                                           |
|         |             |                                                                                                              | Dst (V_OPND): G\|I                                                                           |                                                                                       |
|         |             |                                                                                                              | Src0 (V_OPND): G\|I\|IM                                                                      |                                                                                       |
|         |             |                                                                                                              |                                                                                               |                                                                                       |
|         |             |                                                                                                              |                                                                                               |                                                                                       |
| 32      | 0x20        | [(P)] AND &lt;exec_size&gt; &lt;dst&gt; &lt;src0&gt; &lt;src1&gt;                                                                   | Exec_size (ub): NO LIMIT                                                                     | - "[(P)]" only exists for non-predication operands.                                   |
|         |             |                                                                                                              | Dst (V_OPND): G\|I\|P                                                                        | - Types: INT|P                                                                        | 
|         |             |                                                                                                              | Src0 (V_OPND): G\|I\| P\|IM                                                                  | - Single data type for all operands                                                   |
|         |             |                                                                                                              | Src1 (V_OPND): G\|I\|P\|IM                                                                   |                                                                                       | 
| 33      | 0x21        | [(P)] OR &lt;exec_size&gt; &lt;dst&gt; &lt;src0&gt; &lt;src1&gt;                                                                    | Exec_size (ub): NO LIMIT                                                                     | - "[(P)]" only exists for  non-predication operands.                                  |
|         |             |                                                                                                              | Dst (V_OPND): G\|I\|P                                                                        | - Types: INT|P                                                                        |
|         |             |                                                                                                              | Src0 (V_OPND): G\|I\| P\|IM                                                                  | - Single data type for all operands                                                   |
|         |             |                                                                                                              | Src1 (V_OPND): G\|I\|P\|IM                                                                   |                                                                                       |
| 34      | 0x22        | [(P)] XOR &lt;exec_size&gt; &lt;dst&gt; &lt;src0&gt; &lt;src1&gt;                                                                   | Exec_size (ub): NO LIMIT                                                                     | - "[(P)]" only exists for  non-predication operands.                                  |
|         |             |                                                                                                              | Dst (V_OPND): G\|I\|P                                                                        | - Types: INT|P                                                                        | 
|         |             |                                                                                                              | Src0 (V_OPND): G\|I\| P\|IM                                                                  | - Single data type for all operands                                                   |
|         |             |                                                                                                              | Src1 (V_OPND): G\|I\|P\|IM                                                                   |                                                                                       |
| 35      | 0x23        | [(P)] NOT &lt;exec_size&gt; &lt;dst&gt; &lt;src0&gt;                                                                          | Exec_size (ub): NO LIMIT                                                                     | - "[(P)]" only exists for  non-predication operands.                                  |
|         |             |                                                                                                              | Dst (V_OPND): G\|I\|P                                                                        | - Types: INT|P                                                                        | 
|         |             |                                                                                                              | Src0 (V_OPND): G\|I\| P\|IM                                                                  | - Single data type for all operands                                                   |
|         |             |                                                                                                              | Src1 (V_OPND): G\|I\|P\|IM                                                                   |                                                                                       |
| 36      | 0x24        | [(P)] SHL &lt;exec_size&gt; &lt;dst&gt; &lt;src0&gt; &lt;src1&gt;                                                                   | Exec_size (ub): NO LIMIT                                                                     | - Type: INT                                                                           |
|         |             |                                                                                                              | Dst (V_OPND): G\|I                                                                           | - Dst and Src0 may have  different types                                              |
|         |             |                                                                                                              | Src0 (V_OPND):G\|I\|IM                                                                       | - Src1: only 5 LSB bits work                                                          |
|         |             |                                                                                                              | Src1 (V_OPND): G\|I\|IM                                                                      |                                                                                       |
| 37      | 0x25        | [(P)] SHR &lt;exec_size&gt; &lt;dst&gt; &lt;src0&gt; &lt;src1&gt;                                                                   | Exec_size (ub): NO LIMIT                                                                     | - Type: INT                                                                           |
|         |             |                                                                                                              | Dst (V_OPND): G\|I                                                                           | - Dst and Src0 may have different types                                               |
|         |             |                                                                                                              | Src0 (V_OPND):G\|I\|IM                                                                       | - Src1: only 5 LSB bits work                                                          | 
|         |             |                                                                                                              | Src1 (V_OPND): G\|I\|IM                                                                      |                                                                                       |
| 38      | 0x26        | [(P)] ASR &lt;exec_size&gt; &lt;dst&gt; &lt;src0&gt; &lt;src1&gt;                                                                   | Exec_size (ub): NO LIMIT                                                                     | - Type: INT                                                                           |
|         |             |                                                                                                              | Dst (V_OPND): G\|I                                                                           | - Dst and Src0 may have different types                                               |
|         |             |                                                                                                              | Src0 (V_OPND):G\|I\|IM                                                                       | - Src1: only 5 LSB bits work                                                          |
|         |             |                                                                                                              | Src1 (V_OPND): G\|I\|IM                                                                      |                                                                                       |
| 39      | 0x27        | reserved                                                                                                     |                                                                                               |                                                                                       |
| 40      | 0x28        | ADDR_ADD &lt;exec_size&gt; &lt;dst&gt; &lt;src0&gt; &lt;src1&gt;                                                                   | Exec_size (ub): &lt;=8                                                                          | - Dst: right aligned                                                                  |
|         |             |                                                                                                              | Dst (V_OPND): A                                                                              | - Src0(AO):                                                                           |
|         |             |                                                                                                              | Src0 (V_OPND):A\|AO                                                                          |    - Implicit region &lt;0;1,0&gt;                                                          |
|         |             |                                                                                                              | Src1 (V_OPND):G\|IM                                                                          |    - Dst point to same gen variable                                                   |
|         |             |                                                                                                              |                                                                                               | - Src1: UW                                                                            |
| 41      | 0x29        | [(P)] MOV &lt;exec_size&gt; &lt;dst&gt; &lt;src0&gt;                                                                          | Exec_size (ub): NO LIMIT                                                                     | - Type conversion when Dst and Src0 have different data types                         |
|         |             |                                                                                                              | Dst (V_OPND): G\|I\|A                                                                        | - Src0(AO)-&gt;Dst(A)                                                                    | 
|         |             |                                                                                                              | Src0 (V_OPND): G\|I\|IM\|P \|AO                                                              |                                                                                       |
| 42      | 0x2A        | [(P)] SEL &lt;exec_size&gt; &lt;dst&gt; &lt;src0&gt; &lt;src1&gt;                                                                   | Exec_size (ub): NO LIMIT                                                                     | - Consistent type required for Dst, Src0 and Src1.                                    |
|         |             |                                                                                                              | Dst (V_OPND): G\|I                                                                           |                                                                                       |
|         |             |                                                                                                              | Src0 (V_OPND): G\|I\|IM                                                                      |                                                                                       |
|         |             |                                                                                                              | Src1 (V_OPND): G\|I\|IM                                                                      |                                                                                       |
| 43      | 0x2B        | SETP &lt;exec_size&gt; &lt;dst&gt; &lt;src0&gt;                                                                               | Exec_size (ub): NO LIMIT                                                                     | - Src0 Type: INT                                                                      |
|         |             |                                                                                                              | Dst (V_OPND): P                                                                              |                                                                                       |
|         |             |                                                                                                              | Src0 (V_OPND): G\|I\|IM                                                                      |                                                                                       |
| 44      | 0x2C        | CMP.&lt;rel_op&gt; &lt;exec_size&gt; &lt;dst&gt; &lt;src0&gt; &lt;src1&gt;                                                               | Exec_size (ub): NO LIMIT                                                                     |                                                                                       |
|         |             |                                                                                                              | Rel_op(ub): EQ\| NE\| GT\|                                                                   |                                                                                       |
|         |             |                                                                                                              | GE\| LT\| LE                                                                                  |                                                                                       |
|         |             |                                                                                                              | Dst (V_OPND): P                                                                              |                                                                                       |
|         |             |                                                                                                              | Src0 (V_OPND): G\|I\|IM                                                                      |                                                                                       |
|         |             |                                                                                                              | Src1 (V_OPND): G\|I\|IM                                                                      |                                                                                       |
| 45      | 0x2D        | MOVS (1) &lt;dst&gt; &lt;src0&gt;                                                                                        | | Exec_size (ub): 1                                                                          | - Dst and Src0  have same type which is one of Sampler or Surface                     |
|         |             |                                                                                                              | | Dst: S\|T                                                                                   |                                                                                       |
|         |             |                                                                                                              |                                                                                               |                                                                                       |
|         |             |                                                                                                              | Src0: S\|T                                                                                    |                                                                                       |
| 46      | 0x2E~0x2F   | reserved                                                                                                     |                                                                                               |                                                                                       |
| 48      | 0x30        | FUNC &lt;label&gt;                                                                                                 | Label(uw) : Index of the label variable                                                       | - Exists only in vISA binary code                                                     |
| 49      | 0x31        | LABEL &lt;label&gt;                                                                                                | Label(uw) : Index of the label variable                                                       | - Exists only in vISA binary code                                                     |
| 50      | 0x32        | [(P)] JMP &lt;exec_size&gt; &lt;label&gt;                                                                               | Exec_size (ub): 1.                                                                           |                                                                                       |
|         |             |                                                                                                              | Label:BL                                                                                      |                                                                                       |
| 51      | 0x33        | [(P)] CALL &lt;exec_size&gt; &lt;label&gt;                                                                              | Exec_size (ub): 1.                                                                           |                                                                                       |
|         |             |                                                                                                              | Label (uw): FL                                                                                |                                                                                       |
| 52      | 0x34        | [(P)] RET (exec_size)                                                                                       | Exec_size (ub): 1.                                                                           |                                                                                       |
| 53      | 0x35        | OWORD_LD[.mod] (&lt;size&gt;) &lt;surface&gt; &lt;offset&gt; &lt;dst&gt;                                                            | Size (ub): 1\|2\|4\|8                                                                         | - Offset (G|IM): Scalar region                                                        |
|         |             |                                                                                                              | Surface: T                                                                                    | - Offset(IM): UD                                                                      |
|         |             |                                                                                                              | Offset (V_OPND): G\|I\|IM                                                                    | - Dst (R_OPND):                                                                       |
|         |             |                                                                                                              | Dst (R_OPND): G                                                                              | - Dst: GRF-ALIGNED                                                                    |
|         |             |                                                                                                              |                                                                                               | - Dst: sizeof(Dst) &gt;= Size                                                            |
| 54      | 0x36        | OWORD_ST (&lt;size&gt;) &lt;surface&gt; &lt;offset&gt; &lt;src&gt;                                                                  | Size (ub): 1\|2\|4\|8                                                                         | - Offset (G|IM): Scalar region                                                        |
|         |             |                                                                                                              | Surface: T                                                                                    | - Offset(IM): UD                                                                      |
|         |             |                                                                                                              | Offset (V_OPND): G\|I\|IM                                                                    | - Dst (R_OPND):                                                                       |
|         |             |                                                                                                              | Dst (R_OPND): G                                                                              | - Dst: GRF-ALIGNED                                                                    |
|         |             |                                                                                                              |                                                                                               | - Dst: sizeof(Dst) &gt;= Size                                                            |
| 55      | 0x37        | MEDIA_LD.&lt;mods&gt; (&lt;block_width&gt;, &lt;block_height&gt;) &lt;surface&gt; "[" &lt;plane&gt; "]" &lt;x_offset&gt; &lt;y_offset&gt; &lt;dst&gt;   | | Mods(ub): nomod\|modified\|top\|bottom\|top_mod\|bottom_mod                               | - Plane (ub):  [0, 3]                                                                 |
|         |             |                                                                                                              | | Surface (ub): T                                                                             | - Block_width (ub):  [1, 32]                                                          |
|         |             |                                                                                                              |                                                                                               | - Block_height (ub): [1, 64]                                                          |
|         |             |                                                                                                              | | Plane (ub): IM                                                                              | - X_offset (G|I): Scalar region                                                      |
|         |             |                                                                                                              | | Block_width (ub): IM                                                                       | - X_offset(IM): UD                                                                   |
|         |             |                                                                                                              | | Block_height (ub): IM                                                                      | - Y_offset (G|I): Scalar region                                                      |
|         |             |                                                                                                              | | X_offset (V_OPND): G\|I\|IM                                                               | - Y_offset (IM): UD                                                                  |
|         |             |                                                                                                              | | Y_offset (V_OPND): G\|I\|IM                                                               | - Dst (R_OPND):                                                                      |
|         |             |                                                                                                              | | Dst (R_OPND): G                                                                            | - Dst: GRF-aligned                                                                    |
|         |             |                                                                                                              |                                                                                               | - Dst: Sizeof(Dst) &gt;= block_height - block_width ?                                  |
|         |             |                                                                                                              |                                                                                               | - Dst: sizeof(Dst) &gt;= Size                                                            |
| 56      | 0x38        | MEDIA_ST.&lt;mods&gt; (&lt;block_width&gt;, &lt;block_height&gt;) &lt;surface&gt;"["&lt;plane&gt;"]" &lt;x_offset&gt; &lt;y_offset&gt; &lt;src&gt;      | | Mods(ub): nomod\|reserved\|top \|bottom                                                     | - Plane (ub):  [0, 3]                                                                 |
|         |             |                                                                                                              | | Surface (ub): T                                                                             | - Block_width (ub):  [1, 32]                                                          |
|         |             |                                                                                                              |                                                                                               | - Block_height (ub): [1, 64]                                                          |
|         |             |                                                                                                              | | Plane (ub): IM                                                                              | - X_offset (G|I): Scalar region                                                      |
|         |             |                                                                                                              | | Block_width (ub): IM                                                                       | - X_offset(IM): UD                                                                   |
|         |             |                                                                                                              | | Block_height (ub): IM                                                                      | - Y_offset (G|I): Scalar region                                                      |
|         |             |                                                                                                              | | X_offset (V_OPND): G\|I\|IM                                                               | - Y_offset (IM): UD                                                                  |
|         |             |                                                                                                              | | Y_offset (V_OPND): G\|I\|IM                                                               | - Dst (R_OPND):                                                                      |
|         |             |                                                                                                              | | Src (R_OPND): G                                                                            | - Dst: GRF-aligned                                                                    |
|         |             |                                                                                                              |                                                                                               | - Dst: Sizeof(Dst) &gt;= block_height - block_width ?                                  |
|         |             |                                                                                                              |                                                                                               | - Dst: sizeof(Dst) &gt;= Size                                                            |
| 57      | 0x39        | GATHER[.mod] (&lt;num_elts&gt;) (&lt;elt_size&gt;) &lt;surface&gt; &lt;global offset&gt; &lt;element offset&gt; &lt;dst&gt;                    | Num_elts (ub): 8\|16                                                                         | - Global Offset:UD                                                                    |
|         |             |                                                                                                              | Elt_size (ub): 1\|2\|4                                                                       | - Element Offset: UD                                                                  |
|         |             |                                                                                                              | Surface (ub): T                                                                               | - Element Offset: GRF-aligned                                                         |
|         |             |                                                                                                              | Global Offset (V_OPND): G\|I\|IM                                                             | - Dst Type: UD|D|F                                                                    |
|         |             |                                                                                                              | Element Offset (R_OPND): G                                                                   | - Dst: GRF-aligned                                                                    |
|         |             |                                                                                                              | Dst (R_OPND): G                                                                              | - 1 and 2 byte accesses, the upper bits of Dst element will be ignored                |
|         |             |                                                                                                              |                                                                                               |                                                                                       |
|         |             |                                                                                                              |                                                                                               |                                                                                       |
|         |             |                                                                                                              |                                                                                               |                                                                                       |
| 58      | 0x3A        | SCATTER (&lt;num_elts&gt;) (&lt;elt_size&gt;) &lt;surface&gt; &lt;global offset&gt; &lt;element offset&gt; &lt;src&gt;                         | Num_elts (ub): 8\|16                                                                         | - Global Offset:UD                                                                    |
|         |             |                                                                                                              | Elt_size (ub): 1\|2\|4                                                                       | - Element Offset: UD                                                                  |
|         |             |                                                                                                              | Surface (ub): T                                                                               | - Element Offset: GRF-aligned                                                         |
|         |             |                                                                                                              | Global Offset (V_OPND): G\|I\|IM                                                             | - Dst Type: UD|D|F                                                                    |
|         |             |                                                                                                              | Element Offset (R_OPND): G                                                                   | - Dst: GRF-aligned                                                                    |
|         |             |                                                                                                              | Src (R_OPND): G                                                                              | - 1 and 2 byte accesses, the upper bits of Dst element will be ignored                |
|         |             |                                                                                                              |                                                                                               |                                                                                       |
|         |             |                                                                                                              |                                                                                               |                                                                                       |
| 59      | 0x3B        | DWORD_ATOMIC[.&lt;atomic_op&gt;] (&lt;num_elts&gt;) &lt;surface&gt; &lt;global offset&gt; &lt;element offset&gt; &lt;dst&gt; &lt;src0&gt; &lt;src1&gt;    | atomic_op(ub):ADD\|SUB\|INC \|DEC\|MIN\|MAX\| XCHG\| CMPXCHG \|AND \|OR \|XOR \|IMIN\|IMAX   | - Global Offset Type:UD                                                               |
|         |             |                                                                                                              | Num_elts (ub):8\|16                                                                          |   Src0 (INC|DEC): V0                                                                  |
|         |             |                                                                                                              | Surface (ub): T                                                                               | - Src0 Type(IMIN|IMAX): D                                                             |
|         |             |                                                                                                              | Global Offset (V_OPND): G\|I\|IM                                                             | - Src0 Type(others): UD                                                               |
|         |             |                                                                                                              | Element Offset (R_OPND): G                                                                   | - Src0: GRF-aligned                                                                   |
|         |             |                                                                                                              | Src0 (R_OPND): G                                                                             | - Src1 Type: UD                                                                       |
|         |             |                                                                                                              | Src1 (R_OPND): G                                                                             | - Src1: GRF-aligned                                                                   |
|         |             |                                                                                                              | Dst (R_OPND):G                                                                               | - Src1: work only for CMPXCHG                                                         |
|         |             |                                                                                                              |                                                                                               | - Dst: GRF-aligned                                                                    |
|         |             |                                                                                                              |                                                                                               | - Dst(IMIN|IMAX) Type:D                                                               |
|         |             |                                                                                                              |                                                                                               | - Dst (others) Type:UD                                                                |
| 60      | 0x3C        | OWORD_LD_UNALIGNED[.mod] (&lt;size&gt;) &lt;surface&gt; &lt;offset&gt; &lt;dst&gt;                                                 | Size (ub): 1\|2\|4\|8                                                                         | - Offset (G|I): Scalar region                                                         |
|         |             |                                                                                                              | Surface (ub): T                                                                               | - Offset Type: UD                                                                     |
|         |             |                                                                                                              | Offset (V_OPND): G\|I\|IM                                                                    | - Dst:  GRF-ALIGNED                                                                   |
|         |             |                                                                                                              | Dst (R_OPND): G                                                                              | - Dst:  sizeof(Dst) &gt;= Size*sizeof(Oword)                                             |
|         |             |                                                                                                              |                                                                                               |                                                                                       |
| 61      | 0x3D~0x3F   | Reserved                                                                                                     |                                                                                               |                                                                                       |
| 64      | 0x40        | SAMPLE.&lt;channel&gt; (&lt;SIMD_mode&gt;) &lt;surface&gt; &lt;sampler&gt; &lt;u_offset&gt; &lt;v_offset&gt; &lt;r_offset&gt; &lt;dst&gt;                | channel: [R, G, B, A, RG, RB, RA, RGB, ... RGBA]                                              | - U_offset Type:F, GRF-aligned                                                        |
|         |             |                                                                                                              | SIMD_mode: SIMD8\| SIMD16                                                                    | - V_offset Type:F, GRF-aligned                                                        |
|         |             |                                                                                                              | Sampler (ub): S                                                                               | - R_offset Type:F, GRF-aligned                                                        |
|         |             |                                                                                                              | Surface (ub): T                                                                               | - U_offset Type:F, GRF-aligned                                                        |
|         |             |                                                                                                              | U_offset (R_OPND):G                                                                         | - Dst  Type:F, GRF-aligned                                                            |
|         |             |                                                                                                              | V_offset (R_OPND):G                                                                         | - Dst (SIMD8): elem_num(Dst)&gt;=32                                                      |
|         |             |                                                                                                              | R_offset (R_OPND):G                                                                         | - Dst (SIMD16): elem_num(Dst) &gt;=16 * enabled_channels                                |
|         |             |                                                                                                              | Dst (R_OPND):G                                                                               |                                                                                       |
| 65      | 0x41        | SAMPLE_UNORM.&lt;channel&gt; &lt;surface&gt; &lt;sampler&gt; &lt;u_offset&gt; &lt;v_offset&gt; &lt;deltaU&gt; &lt;deltaV&gt; &lt;dst&gt;                  | channel: [R, G, B, A, RG, RB, RA, RGB, ... RGBA]                                              | - U_offse Type: F                                                                     |
|         |             |                                                                                                              |                                                                                               | - V_offset Type: F                                                                    |
|         |             |                                                                                                              | Sampler (ub): S                                                                               |   deltaU Type: F                                                                      |
|         |             |                                                                                                              |                                                                                               |   deltaV Type: F                                                                      |
|         |             |                                                                                                              | Surface (ub): T                                                                               |   Dst Type:UW                                                                         |
|         |             |                                                                                                              |                                                                                               | - Dst elemnum&gt;enabled_channels*32                                                    |
|         |             |                                                                                                              | | U_offset (R_OPND): G\|I\|IM                                                               | - Dst : GRF-aligned                                                                   |
|         |             |                                                                                                              | | V_offset (R_OPND): G\|I\|IM                                                               |                                                                                       |
|         |             |                                                                                                              | | deltaU (V_OPND):G\|I\|IM                                                                   |                                                                                       |
|         |             |                                                                                                              | | deltaV: (V_OPND):G\|I\|IM                                                                  |                                                                                       |
|         |             |                                                                                                              | | Dst (R_OPND):G                                                                             |                                                                                       |
| 66      | 0x42        | LOAD.&lt;channel&gt; (&lt;SIMD_mode&gt;) &lt;surface&gt; &lt;u_offset&gt; &lt;v_offset&gt; &lt;r_offset&gt; &lt;dst&gt;                            | channel: [R, G, B, A, RG, RB, RA, RGB, ... RGBA]                                              | - U_offset Type:F                                                                    |
|         |             |                                                                                                              |                                                                                               | - V_offset Type: F                                                                   |
|         |             |                                                                                                              | | SIMD_mode: SIMD8\| SIMD16                                                                  | - R_offset Type:F                                                                    |
|         |             |                                                                                                              | | Sampler (ub): S                                                                             | - Dst Type:UW                                                                         |
|         |             |                                                                                                              | | Surface (ub): T                                                                             | - Dst elem_num &gt; channels*32                                                         |
|         |             |                                                                                                              | | U_offset (R_OPND):G                                                                       | - Dst: GRF-aligned                                                                    |
|         |             |                                                                                                              | | V_offset (R_OPND):G                                                                       |                                                                                       |
|         |             |                                                                                                              | | R_offset (R_OPND):G                                                                       |                                                                                       |
|         |             |                                                                                                              | | Dst (R_OPND):G                                                                             |                                                                                       |
| 67      | 0x43        | AVS                                                                                                          |                                                                                               |                                                                                       |
| 68      | 0x44        | VA                                                                                                           |                                                                                               |                                                                                       |
| 69      | 0x45        | FMINMAX                                                                                                      |                                                                                               |                                                                                       |
| 70      | 0x46        | BFE                                                                                                          |                                                                                               |                                                                                       |
| 71      | 0x47        | BFI                                                                                                          |                                                                                               |                                                                                       |
| 72      | 0x48        | BFREV                                                                                                        |                                                                                               |                                                                                       |
| 73      | 0x49        | ADDC                                                                                                         |                                                                                               |                                                                                       |
| 74      | 0x4A        | SUBB                                                                                                         |                                                                                               |                                                                                       |
| 75      | 0x4B        | GATHER4_TYPED                                                                                               |                                                                                               |                                                                                       |
| 76      | 0x4C        | SCATTER4_TYPED                                                                                              |                                                                                               |                                                                                       |
| 77      | 0x4D        | VA+                                                                                                          |                                                                                               |                                                                                       |
| 78      | 0x4E        | SVM                                                                                                          |                                                                                               |                                                                                       |
| 79-80   | 0x4F-50     | Reserved                                                                                                     |                                                                                               |                                                                                       |
| 81      | 0x51        | FILE &lt;file_name&gt;                                                                                            | File_name(uw):FILE_NAME                                                                     | - Exists only in vISA binary code                                                     |
|         |             |                                                                                                              |                                                                                               | - File_name &gt;= 0                                                                     |
|         |             |                                                                                                              |                                                                                               | - Stlen(StringPool[File_name])&lt;256                                                   |
|         |             |                                                                                                              |                                                                                               |                                                                                       |
| 82      | 0x52        | LOC &lt;line_number&gt;                                                                                           | Line_number(ud): IM                                                                          | - Exists only in vISA binary code                                                     |
|         |             |                                                                                                              |                                                                                               | - line_number &gt;= 0                                                                   |
| 83      | 0x53        | Reserved                                                                                                     |                                                                                               |                                                                                       |
| 84      | 0x54        | VME_SIC &lt;surface&gt; &lt;UNIInput&gt; &lt;SICInput&gt; &lt;output&gt;                                                            | Surface (ub): T                                                                               | - UNIInput Types:UB                                                                   |
|         |             |                                                                                                              |                                                                                               | - UNIInput elem_num : 96                                                              |
|         |             |                                                                                                              | UNIInput(R_OPND):G                                                                           | - SICInput Types:UB                                                                   |
|         |             |                                                                                                              |                                                                                               | - SICInput elem_num: 128                                                              |
|         |             |                                                                                                              | SICInput (R_OPND):G                                                                          | - output Types:UB                                                                     |
|         |             |                                                                                                              |                                                                                               | - output(dis) size: 224                                                               |
|         |             |                                                                                                              | output(R_OPND):G                                                                             |                                                                                       |
| 85      | 0x55        | VME_FBR (&lt;FBRMbMode&gt; &lt;FBRSubMbShape&gt; &lt;FBRSubPredMode&gt;) &lt;surface&gt; &lt;UNIInput&gt; &lt;FBRInput&gt; &lt;output&gt;             | FBRMbMode(ub):16x16\|16x8\|8x16\|8x8                                                          | - UNIInput Types:UB                                                                   |
|         |             |                                                                                                              |                                                                                               | - UNIInput elem_num : 96                                                              |
|         |             |                                                                                                              | FBRSubMbShape(ub):IM                                                                          | - FBRInput Types:UB                                                                   |
|         |             |                                                                                                              |                                                                                               | - FBRInput elem_num: 128                                                              |
|         |             |                                                                                                              | FBRSubPredMode(ub):IM                                                                         | - output Types:UB                                                                     |
|         |             |                                                                                                              |                                                                                               | - output(dis) size: 224                                                               |
|         |             |                                                                                                              | Surface (ub): T                                                                               |                                                                                       |
|         |             |                                                                                                              |                                                                                               |                                                                                       |
|         |             |                                                                                                              | UNIInput(R_OPND):G                                                                           |                                                                                       |
|         |             |                                                                                                              |                                                                                               |                                                                                       |
|         |             |                                                                                                              | FBRInput (R_OPND):G                                                                          |                                                                                       |
|         |             |                                                                                                              |                                                                                               |                                                                                       |
|         |             |                                                                                                              | output(R_OPND):G                                                                             |                                                                                       |
| 89      | 0x59~0x5f   | reserved                                                                                                     |                                                                                               |                                                                                       |
| 96      | 0x60        | [(P)] IF &lt;exec_size&gt;                                                                                        | Exec_size (ub): NO LIMIT                                                                     | - start_offset value: 0|4|8|12|16|20|24|28|32|NoneSIMD                               |
|         |             |                                                                                                              |                                                                                               | - start_offset value + exec_size  &lt; current_SIMD_block_width                     |
|         |             |                                                                                                              | Start_offset: M1\|M2\|M3 \|M4\|M5\|M6\|M7\|M8\|NM                                            |                                                                                       | 
|         |             |                                                                                                              |                                                                                               |                                                                                       |
| 97      | 0x61        | ELSE &lt;exec_size&gt;                                                                                            | Exec_size (ub): NO LIMIT                                                                     | - start_offset value: 0|4|8|12|16|20|24|28|32|NoneSIMD                               |
|         |             |                                                                                                              |                                                                                               | - start_offset value + exec_size &lt; current_SIMD_block_width                      | 
|         |             |                                                                                                              | Start_offset: M1\|M2\|M3 \|M4\|M5\|M6\|M7\|M8\|NM                                            |                                                                                       | 
|         |             |                                                                                                              |                                                                                               |                                                                                       |
| 98      | 0x62        | ENDIF &lt;exec_size&gt;                                                                                           | Exec_size (ub): NO LIMIT                                                                     | - start_offset value: 0|4|8|12|16|20|24|28|32|NoneSIMD                               |
|         |             |                                                                                                              |                                                                                               | - start_offset value + exec_size &lt; current_SIMD_block_width                      | 
|         |             |                                                                                                              | Start_offset: M1\|M2\|M3 \|M4\|M5\|M6\|M7\|M8\|NM                                            |                                                                                       |
|         |             |                                                                                                              |                                                                                               |                                                                                       |
| 99      | 0x63        | DO &lt;exec_size&gt;                                                                                              | Exec_size (ub): NO LIMIT                                                                     | - start_offset value: 0|4|8|12|16|20|24|28|32|NoneSIMD                               |
|         |             |                                                                                                              |                                                                                               | - start_offset value + exec_size &lt; current_SIMD_block_width                      |
|         |             |                                                                                                              | Start_offset: M1\|M2\|M3 \|M4\|M5\|M6\|M7\|M8\|NM                                            |                                                                                       | 
|         |             |                                                                                                              |                                                                                               |                                                                                       | 
| 100     | 0x64        | [(P)] WHILE &lt;exec_size&gt;                                                                                     | Exec_size (ub): NO LIMIT                                                                     | - start_offset value: 0|4|8|12|16|20|24|28|32|NoneSIMD                               |
|         |             |                                                                                                              |                                                                                               | - start_offset value + exec_size &lt; current_SIMD_block_width                      |
|         |             |                                                                                                              | Start_offset: M1\|M2\|M3 \|M4\|M5\|M6\|M7\|M8\|NM                                            |                                                                                       |
|         |             |                                                                                                              |                                                                                               |                                                                                       |
| 101     | 0x65        | [(P)] BREAK &lt;exec_size&gt;                                                                                     | Exec_size (ub): NO LIMIT                                                                     | - start_offset value: 0|4|8|12|16|20|24|28|32|NoneSIMD                               |
|         |             |                                                                                                              |                                                                                               | - start_offset value + exec_size &lt; current_SIMD_block_width                      |
|         |             |                                                                                                              | Start_offset: M1\|M2\|M3 \|M4\|M5\|M6\|M7\|M8\|NM                                            |                                                                                       |
|         |             |                                                                                                              |                                                                                               |                                                                                       |
| 102     | 0x66        | [(P)] CONT &lt;exec_size&gt;                                                                                      | Exec_size (ub): NO LIMIT                                                                     | - start_offset value: 0|4|8|12|16|20|24|28|32|NoneSIMD                               |
|         |             |                                                                                                              |                                                                                               | - start_offset value + exec_size &lt; current_SIMD_block_width                      |
|         |             |                                                                                                              | Start_offset: M1\|M2\|M3 \|M4\|M5\|M6\|M7\|M8\|NM                                            |                                                                                       |
|         |             |                                                                                                              |                                                                                               |                                                                                       |

Notation:

Execution size must be then number which is powers-of-two from 1 to 32,
not matter "NO LIMIT" or range specified.

If the predicate is "P0", this means the instruction is not predicated.

Except the MOV instruction, and predicate operand, all the instructions
should have consistent data type for other vector operands.

.. UNREFERENCED_FOOTNOTE [1]
    vISA 3.1 and earlier has the offsets in dwords
