/* $Id: samread.h 224758 2021-12-13 00:43:41Z twu $ */
#ifndef SAMREAD_INCLUDED
#define SAMREAD_INCLUDED
#include <stdio.h>
#include "types.h"		/* For HAVE_64_BIT */
#include "samflags.h"
#include "genomicpos.h"		/* For Chrpos_T */
#include "list.h"


#ifdef HAVE_64_BIT
typedef UINT8 Hashseq_T;
#else
typedef UINT4 Hashseq_T;
#endif

extern int
Samread_cigar_string_readlength (int *hardclip_low, int *hardclip_high, char *cigar);
extern int
Samread_cigar_string_initial_softclip (char *cigar);
extern SAM_split_output_type
Samread_parse_XO_and_HI (char **hiti, char *line);
extern char *
Samread_parse_XH_XO_and_HI (SAM_split_output_type *split_output, char **hiti, char *line, int linelength);

extern char *
Samread_parse_read (char *line, int linelength, unsigned int flag);

extern char *
Samread_parse_read_and_hiti (char **hiti, char *line, int linelength, unsigned int flag);

extern char *
Samread_flag_duplicate (char *line, int linelength, unsigned int flag);

extern char *
Samread_auxinfo (unsigned int *flag, int *fragment_length, char *line);

extern char *
Samread_get_aux_string (const char *tags, char *auxinfo);
extern int
Samread_get_aux_int (const char *tags, char *auxinfo);

extern char *
Samread_single_cell_info (char **umi_barcode, char **transcripts_consistent,
			  char **transcripts_inconsistent, char *auxinfo);
extern void
Samread_get_transcripts (List_T *transcripts_consistent_list, List_T *transcripts_inconsistent_list,
			 char *line);

#endif

