/************************************************************************
**
**  Copyright (C) 2010  Strahinja Markovic
**
**  This file is part of FlightCrew.
**
**  FlightCrew is free software: you can redistribute it and/or modify
**  it under the terms of the GNU Lesser General Public License as published
**  by the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  FlightCrew is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU Lesser General Public License for more details.
**
**  You should have received a copy of the GNU Lesser General Public License
**  along with FlightCrew.  If not, see <http://www.gnu.org/licenses/>.
**
*************************************************************************/

#include <stdafx.h>

/*
   Navigation Control for XML applications 2005-1 DTD
   
   Specification: http://www.niso.org/workrooms/daisy/Z39-86-2005.html#NCX

   Namespace: http://www.daisy.org/z3986/2005/ncx/
   
   Taken from: http://www.daisy.org/z3986/2005/ncx-2005-1.dtd

   This DTD module is identified by the PUBLIC and SYSTEM identifiers:

   PUBLIC "-//NISO//DTD ncx 2005-1//EN"
   SYSTEM "http://www.daisy.org/z3986/2005/ncx-2005-1.dtd"

 */

namespace FlightCrew
{

const char*         NCX_2005_1_DTD_ID  = "http://www.daisy.org/z3986/2005/ncx-2005-1.dtd";
const unsigned int  NCX_2005_1_DTD_LEN = 11050;
const unsigned char NCX_2005_1_DTD[]   = {
  0x3c, 0x21, 0x2d, 0x2d, 0x20, 0x4e, 0x43, 0x58, 0x20, 0x32, 0x30, 0x30,
  0x35, 0x2d, 0x31, 0x20, 0x44, 0x54, 0x44, 0x20, 0x20, 0x32, 0x30, 0x30,
  0x35, 0x2d, 0x30, 0x36, 0x2d, 0x32, 0x36, 0x0d, 0x0a, 0x66, 0x69, 0x6c,
  0x65, 0x3a, 0x20, 0x6e, 0x63, 0x78, 0x2d, 0x32, 0x30, 0x30, 0x35, 0x2d,
  0x31, 0x2e, 0x64, 0x74, 0x64, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x0d, 0x0a, 0x0d, 0x0a, 0x20, 0x20, 0x41, 0x75, 0x74, 0x68,
  0x6f, 0x72, 0x73, 0x3a, 0x20, 0x4d, 0x61, 0x72, 0x6b, 0x20, 0x48, 0x61,
  0x6b, 0x6b, 0x69, 0x6e, 0x65, 0x6e, 0x2c, 0x20, 0x47, 0x65, 0x6f, 0x72,
  0x67, 0x65, 0x20, 0x4b, 0x65, 0x72, 0x73, 0x63, 0x68, 0x65, 0x72, 0x2c,
  0x20, 0x54, 0x6f, 0x6d, 0x20, 0x4d, 0x63, 0x4c, 0x61, 0x75, 0x67, 0x68,
  0x6c, 0x69, 0x6e, 0x2c, 0x20, 0x4a, 0x61, 0x6d, 0x65, 0x73, 0x20, 0x50,
  0x72, 0x69, 0x74, 0x63, 0x68, 0x65, 0x74, 0x74, 0x2c, 0x20, 0x61, 0x6e,
  0x64, 0x20, 0x4d, 0x69, 0x63, 0x68, 0x61, 0x65, 0x6c, 0x20, 0x4d, 0x6f,
  0x6f, 0x64, 0x69, 0x65, 0x0d, 0x0a, 0x20, 0x20, 0x43, 0x68, 0x61, 0x6e,
  0x67, 0x65, 0x20, 0x6c, 0x69, 0x73, 0x74, 0x3a, 0x0d, 0x0a, 0x20, 0x20,
  0x32, 0x30, 0x30, 0x32, 0x2d, 0x30, 0x32, 0x2d, 0x31, 0x32, 0x20, 0x4d,
  0x2e, 0x20, 0x4d, 0x6f, 0x6f, 0x64, 0x69, 0x65, 0x2e, 0x20, 0x43, 0x68,
  0x61, 0x6e, 0x67, 0x65, 0x64, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
  0x74, 0x20, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x20, 0x6f, 0x66, 0x20, 0x6e,
  0x61, 0x76, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x20, 0x65, 0x6c, 0x65, 0x6d,
  0x65, 0x6e, 0x74, 0x20, 0x74, 0x6f, 0x20, 0x65, 0x6c, 0x69, 0x6d, 0x69,
  0x6e, 0x61, 0x74, 0x65, 0x20, 0x61, 0x6d, 0x62, 0x69, 0x67, 0x75, 0x69,
  0x74, 0x79, 0x2e, 0x0d, 0x0a, 0x20, 0x20, 0x32, 0x30, 0x30, 0x32, 0x2d,
  0x30, 0x32, 0x2d, 0x32, 0x37, 0x20, 0x4d, 0x2e, 0x20, 0x4d, 0x6f, 0x6f,
  0x64, 0x69, 0x65, 0x2e, 0x20, 0x47, 0x72, 0x61, 0x6d, 0x6d, 0x61, 0x74,
  0x69, 0x63, 0x61, 0x6c, 0x20, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73,
  0x20, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x65, 0x64, 0x20, 0x62,
  0x79, 0x20, 0x65, 0x64, 0x69, 0x74, 0x6f, 0x72, 0x2e, 0x0d, 0x0a, 0x20,
  0x20, 0x32, 0x30, 0x30, 0x34, 0x2d, 0x30, 0x33, 0x2d, 0x33, 0x31, 0x20,
  0x4a, 0x2e, 0x20, 0x50, 0x72, 0x69, 0x74, 0x63, 0x68, 0x65, 0x74, 0x74,
  0x2e, 0x20, 0x20, 0x56, 0x61, 0x72, 0x69, 0x6f, 0x75, 0x73, 0x20, 0x63,
  0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x20, 0x70, 0x65, 0x72, 0x20, 0x74,
  0x68, 0x65, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x63, 0x68, 0x61, 0x6e,
  0x67, 0x65, 0x20, 0x6c, 0x69, 0x73, 0x74, 0x3a, 0x0d, 0x0a, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20,
  0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x20, 0x69, 0x6e, 0x74, 0x65,
  0x72, 0x6e, 0x61, 0x6c, 0x20, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
  0x20, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x20, 0x66, 0x72, 0x6f,
  0x6d, 0x20, 0x31, 0x2e, 0x31, 0x2e, 0x30, 0x20, 0x74, 0x6f, 0x20, 0x31,
  0x2e, 0x32, 0x2e, 0x30, 0x0d, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x4d, 0x61, 0x64, 0x65,
  0x20, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x20, 0x63, 0x6c, 0x69, 0x70, 0x42,
  0x65, 0x67, 0x69, 0x6e, 0x2f, 0x63, 0x6c, 0x69, 0x70, 0x45, 0x6e, 0x64,
  0x20, 0x6d, 0x61, 0x6e, 0x64, 0x61, 0x74, 0x6f, 0x72, 0x79, 0x20, 0x28,
  0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x20, 0x23, 0x31, 0x30, 0x29, 0x0d,
  0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x2d, 0x20, 0x44, 0x72, 0x6f, 0x70, 0x70, 0x65, 0x64, 0x20, 0x76,
  0x61, 0x6c, 0x75, 0x65, 0x20, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
  0x74, 0x65, 0x20, 0x66, 0x72, 0x6f, 0x6d, 0x20, 0x6e, 0x61, 0x76, 0x50,
  0x6f, 0x69, 0x6e, 0x74, 0x20, 0x28, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65,
  0x20, 0x23, 0x31, 0x31, 0x29, 0x0d, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x52, 0x65, 0x70,
  0x6c, 0x61, 0x63, 0x65, 0x64, 0x20, 0x6c, 0x61, 0x6e, 0x67, 0x20, 0x61,
  0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x20, 0x77, 0x69, 0x74,
  0x68, 0x20, 0x78, 0x6d, 0x6c, 0x3a, 0x6c, 0x61, 0x6e, 0x67, 0x20, 0x28,
  0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x20, 0x23, 0x31, 0x32, 0x29, 0x0d,
  0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x2d, 0x20, 0x41, 0x64, 0x64, 0x65, 0x64, 0x20, 0x3c, 0x70, 0x61,
  0x67, 0x65, 0x4c, 0x69, 0x73, 0x74, 0x3e, 0x20, 0x61, 0x6e, 0x64, 0x20,
  0x3c, 0x70, 0x61, 0x67, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x3e,
  0x20, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x20, 0x28, 0x63,
  0x68, 0x61, 0x6e, 0x67, 0x65, 0x20, 0x23, 0x34, 0x38, 0x29, 0x0d, 0x0a,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x2d, 0x20, 0x44, 0x72, 0x6f, 0x70, 0x70, 0x65, 0x64, 0x20, 0x6f, 0x6e,
  0x46, 0x6f, 0x63, 0x75, 0x73, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x6f, 0x6e,
  0x42, 0x6c, 0x75, 0x72, 0x20, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
  0x74, 0x65, 0x73, 0x20, 0x66, 0x72, 0x6f, 0x6d, 0x20, 0x6e, 0x61, 0x76,
  0x50, 0x6f, 0x69, 0x6e, 0x74, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x6e, 0x61,
  0x76, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x20, 0x28, 0x63, 0x68, 0x61,
  0x6e, 0x67, 0x65, 0x20, 0x23, 0x34, 0x39, 0x29, 0x0d, 0x0a, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20,
  0x41, 0x64, 0x64, 0x65, 0x64, 0x20, 0x3c, 0x69, 0x6d, 0x67, 0x3e, 0x20,
  0x74, 0x6f, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x20, 0x6d,
  0x6f, 0x64, 0x65, 0x6c, 0x73, 0x20, 0x6f, 0x66, 0x20, 0x64, 0x6f, 0x63,
  0x54, 0x69, 0x74, 0x6c, 0x65, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x64, 0x6f,
  0x63, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x20, 0x28, 0x63, 0x68, 0x61,
  0x6e, 0x67, 0x65, 0x20, 0x23, 0x35, 0x30, 0x29, 0x0d, 0x0a, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20,
  0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x64, 0x20, 0x72, 0x65, 0x66, 0x65,
  0x72, 0x65, 0x6e, 0x63, 0x65, 0x20, 0x74, 0x6f, 0x20, 0x70, 0x61, 0x67,
  0x65, 0x73, 0x20, 0x69, 0x6e, 0x20, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
  0x70, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x20, 0x6e, 0x61, 0x76,
  0x4c, 0x69, 0x73, 0x74, 0x20, 0x28, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65,
  0x20, 0x23, 0x35, 0x32, 0x29, 0x0d, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x41, 0x64, 0x64,
  0x65, 0x64, 0x20, 0x3c, 0x6e, 0x61, 0x76, 0x49, 0x6e, 0x66, 0x6f, 0x3e,
  0x20, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x20, 0x28, 0x63, 0x68,
  0x61, 0x6e, 0x67, 0x65, 0x20, 0x23, 0x35, 0x33, 0x29, 0x0d, 0x0a, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d,
  0x20, 0x41, 0x64, 0x64, 0x65, 0x64, 0x20, 0x64, 0x65, 0x66, 0x61, 0x75,
  0x6c, 0x74, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65,
  0x20, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x20, 0x74,
  0x6f, 0x20, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
  0x6e, 0x20, 0x6f, 0x66, 0x20, 0x3c, 0x6e, 0x63, 0x78, 0x3e, 0x20, 0x28,
  0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x20, 0x23, 0x4c, 0x38, 0x29, 0x0d,
  0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x2d, 0x20, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x64, 0x20, 0x70,
  0x61, 0x67, 0x65, 0x52, 0x65, 0x66, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x6d,
  0x61, 0x70, 0x52, 0x65, 0x66, 0x20, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62,
  0x75, 0x74, 0x65, 0x73, 0x0d, 0x0a, 0x20, 0x20, 0x32, 0x30, 0x30, 0x34,
  0x2d, 0x30, 0x34, 0x2d, 0x30, 0x35, 0x20, 0x4a, 0x2e, 0x20, 0x50, 0x72,
  0x69, 0x74, 0x63, 0x68, 0x65, 0x74, 0x74, 0x2e, 0x20, 0x20, 0x43, 0x68,
  0x61, 0x6e, 0x67, 0x65, 0x73, 0x20, 0x61, 0x66, 0x74, 0x65, 0x72, 0x20,
  0x66, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x20, 0x66, 0x72, 0x6f,
  0x6d, 0x20, 0x4d, 0x4d, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x4d, 0x47, 0x20,
  0x74, 0x6f, 0x20, 0x32, 0x30, 0x30, 0x34, 0x2d, 0x30, 0x33, 0x2d, 0x33,
  0x31, 0x20, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x0d, 0x0a, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d,
  0x20, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x20, 0x69, 0x6e, 0x74,
  0x65, 0x72, 0x6e, 0x61, 0x6c, 0x20, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
  0x6e, 0x20, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x20, 0x66, 0x72,
  0x6f, 0x6d, 0x20, 0x31, 0x2e, 0x32, 0x2e, 0x30, 0x20, 0x74, 0x6f, 0x20,
  0x31, 0x2e, 0x31, 0x2e, 0x32, 0x20, 0x28, 0x70, 0x65, 0x72, 0x20, 0x4d,
  0x4d, 0x20, 0x65, 0x2d, 0x6d, 0x61, 0x69, 0x6c, 0x20, 0x6f, 0x66, 0x20,
  0x33, 0x2f, 0x33, 0x31, 0x29, 0x0d, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x43, 0x68, 0x61,
  0x6e, 0x67, 0x65, 0x64, 0x20, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x20,
  0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x20, 0x74,
  0x6f, 0x20, 0x75, 0x73, 0x65, 0x20, 0x7a, 0x33, 0x39, 0x38, 0x36, 0x2f,
  0x32, 0x30, 0x30, 0x34, 0x20, 0x61, 0x73, 0x20, 0x70, 0x61, 0x74, 0x68,
  0x20, 0x69, 0x6e, 0x73, 0x74, 0x65, 0x61, 0x64, 0x20, 0x6f, 0x66, 0x20,
  0x7a, 0x33, 0x39, 0x38, 0x36, 0x2f, 0x76, 0x31, 0x30, 0x30, 0x20, 0x28,
  0x70, 0x65, 0x72, 0x20, 0x33, 0x2f, 0x33, 0x31, 0x20, 0x63, 0x6f, 0x6e,
  0x20, 0x63, 0x61, 0x6c, 0x6c, 0x29, 0x0d, 0x0a, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x41, 0x64,
  0x64, 0x65, 0x64, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x20, 0x61, 0x74,
  0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x20, 0x74, 0x6f, 0x20, 0x62,
  0x6f, 0x74, 0x68, 0x20, 0x70, 0x61, 0x67, 0x65, 0x54, 0x61, 0x72, 0x67,
  0x65, 0x74, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x70, 0x61, 0x67, 0x65, 0x4c,
  0x69, 0x73, 0x74, 0x20, 0x28, 0x70, 0x65, 0x72, 0x20, 0x4d, 0x47, 0x20,
  0x65, 0x2d, 0x6d, 0x61, 0x69, 0x6c, 0x20, 0x6f, 0x66, 0x20, 0x34, 0x2f,
  0x31, 0x29, 0x0d, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x41, 0x64, 0x64, 0x65, 0x64, 0x20,
  0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x20, 0x74, 0x65, 0x78, 0x74,
  0x20, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x62, 0x69, 0x6e, 0x67, 0x20,
  0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62,
  0x75, 0x74, 0x65, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x70, 0x61, 0x67, 0x65,
  0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x6e,
  0x61, 0x76, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x20, 0x28, 0x70, 0x65,
  0x72, 0x20, 0x4d, 0x4d, 0x20, 0x65, 0x2d, 0x6d, 0x61, 0x69, 0x6c, 0x20,
  0x6f, 0x66, 0x20, 0x33, 0x2f, 0x33, 0x31, 0x29, 0x0d, 0x0a, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20,
  0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x20, 0x64, 0x65, 0x63, 0x6c,
  0x61, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x20, 0x74,
  0x79, 0x70, 0x65, 0x20, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
  0x65, 0x20, 0x6f, 0x6e, 0x20, 0x70, 0x61, 0x67, 0x65, 0x54, 0x61, 0x72,
  0x67, 0x65, 0x74, 0x20, 0x74, 0x6f, 0x20, 0x65, 0x6e, 0x75, 0x6d, 0x65,
  0x72, 0x61, 0x74, 0x65, 0x20, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64,
  0x20, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x20, 0x0d, 0x0a, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20,
  0x41, 0x64, 0x64, 0x65, 0x64, 0x20, 0x70, 0x6c, 0x61, 0x79, 0x4f, 0x72,
  0x64, 0x65, 0x72, 0x20, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
  0x65, 0x20, 0x74, 0x6f, 0x20, 0x6e, 0x61, 0x76, 0x50, 0x6f, 0x69, 0x6e,
  0x74, 0x2c, 0x20, 0x6e, 0x61, 0x76, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74,
  0x2c, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x70, 0x61, 0x67, 0x65, 0x54, 0x61,
  0x72, 0x67, 0x65, 0x74, 0x20, 0x28, 0x70, 0x65, 0x72, 0x20, 0x4c, 0x6c,
  0x6f, 0x79, 0x64, 0x27, 0x73, 0x20, 0x70, 0x72, 0x6f, 0x70, 0x6f, 0x73,
  0x61, 0x6c, 0x29, 0x0d, 0x0a, 0x32, 0x30, 0x30, 0x34, 0x2d, 0x30, 0x34,
  0x2d, 0x30, 0x35, 0x20, 0x54, 0x2e, 0x20, 0x4d, 0x63, 0x4c, 0x61, 0x75,
  0x67, 0x68, 0x6c, 0x69, 0x6e, 0x2e, 0x20, 0x49, 0x6e, 0x20, 0x64, 0x65,
  0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66,
  0x20, 0x73, 0x6d, 0x69, 0x6c, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x54,
  0x65, 0x73, 0x74, 0x2c, 0x20, 0x61, 0x64, 0x64, 0x65, 0x64, 0x20, 0x69,
  0x64, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c,
  0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x20, 0x61, 0x72, 0x65, 0x20, 0x74,
  0x6f, 0x20, 0x62, 0x65, 0x20, 0x63, 0x6f, 0x70, 0x69, 0x65, 0x64, 0x2e,
  0x20, 0x0d, 0x0a, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x20, 0x75,
  0x70, 0x64, 0x61, 0x74, 0x65, 0x20, 0x74, 0x6f, 0x20, 0x31, 0x2e, 0x31,
  0x2e, 0x33, 0x2e, 0x0d, 0x0a, 0x32, 0x30, 0x30, 0x34, 0x2d, 0x30, 0x35,
  0x2d, 0x31, 0x34, 0x20, 0x54, 0x2e, 0x20, 0x4d, 0x63, 0x4c, 0x61, 0x75,
  0x67, 0x68, 0x6c, 0x69, 0x6e, 0x2e, 0x20, 0x52, 0x65, 0x69, 0x6e, 0x73,
  0x74, 0x61, 0x74, 0x65, 0x64, 0x20, 0x6f, 0x76, 0x65, 0x72, 0x72, 0x69,
  0x64, 0x65, 0x20, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65,
  0x20, 0x74, 0x6f, 0x20, 0x62, 0x65, 0x20, 0x63, 0x6f, 0x70, 0x69, 0x65,
  0x64, 0x20, 0x61, 0x6c, 0x73, 0x6f, 0x2e, 0x20, 0x41, 0x64, 0x64, 0x65,
  0x64, 0x20, 0x62, 0x6f, 0x6f, 0x6b, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74,
  0x20, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x20, 0x0d,
  0x0a, 0x61, 0x6e, 0x64, 0x20, 0x65, 0x6e, 0x75, 0x6d, 0x20, 0x6c, 0x69,
  0x73, 0x74, 0x20, 0x74, 0x6f, 0x20, 0x73, 0x6d, 0x69, 0x6c, 0x43, 0x75,
  0x73, 0x74, 0x6f, 0x6d, 0x54, 0x65, 0x73, 0x74, 0x2e, 0x20, 0x55, 0x70,
  0x64, 0x61, 0x74, 0x65, 0x20, 0x74, 0x6f, 0x20, 0x31, 0x2e, 0x31, 0x2e,
  0x34, 0x2e, 0x0d, 0x0a, 0x52, 0x65, 0x76, 0x69, 0x73, 0x65, 0x64, 0x2c,
  0x20, 0x34, 0x2f, 0x35, 0x2f, 0x32, 0x30, 0x30, 0x34, 0x3a, 0x20, 0x20,
  0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x20, 0x76, 0x65, 0x72, 0x73,
  0x69, 0x6f, 0x6e, 0x20, 0x74, 0x6f, 0x20, 0x31, 0x2e, 0x31, 0x2e, 0x32,
  0x20, 0x0d, 0x0a, 0x52, 0x65, 0x76, 0x69, 0x73, 0x65, 0x64, 0x2c, 0x20,
  0x34, 0x2f, 0x35, 0x2f, 0x32, 0x30, 0x30, 0x34, 0x3a, 0x20, 0x20, 0x43,
  0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x20, 0x73, 0x79, 0x73, 0x74, 0x65,
  0x6d, 0x20, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72,
  0x20, 0x74, 0x6f, 0x20, 0x75, 0x73, 0x65, 0x20, 0x27, 0x32, 0x30, 0x30,
  0x34, 0x27, 0x20, 0x70, 0x61, 0x74, 0x68, 0x20, 0x0d, 0x0a, 0x52, 0x65,
  0x76, 0x69, 0x73, 0x65, 0x64, 0x2c, 0x20, 0x34, 0x2f, 0x35, 0x2f, 0x32,
  0x30, 0x30, 0x34, 0x3a, 0x20, 0x20, 0x54, 0x4d, 0x2c, 0x20, 0x43, 0x68,
  0x61, 0x6e, 0x67, 0x65, 0x64, 0x20, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
  0x6e, 0x20, 0x74, 0x6f, 0x20, 0x31, 0x2e, 0x31, 0x2e, 0x33, 0x20, 0x0d,
  0x0a, 0x52, 0x65, 0x76, 0x69, 0x73, 0x65, 0x64, 0x2c, 0x20, 0x35, 0x2f,
  0x31, 0x34, 0x2f, 0x32, 0x30, 0x30, 0x34, 0x3a, 0x20, 0x20, 0x54, 0x4d,
  0x2c, 0x20, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x20, 0x76, 0x65,
  0x72, 0x73, 0x69, 0x6f, 0x6e, 0x20, 0x74, 0x6f, 0x20, 0x31, 0x2e, 0x31,
  0x2e, 0x34, 0x20, 0x0d, 0x0a, 0x32, 0x30, 0x30, 0x34, 0x2d, 0x30, 0x37,
  0x2d, 0x30, 0x37, 0x20, 0x4d, 0x2e, 0x20, 0x4d, 0x6f, 0x6f, 0x64, 0x69,
  0x65, 0x20, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x20, 0x76, 0x65,
  0x72, 0x73, 0x69, 0x6f, 0x6e, 0x20, 0x74, 0x6f, 0x20, 0x31, 0x2e, 0x32,
  0x2e, 0x30, 0x20, 0x65, 0x76, 0x65, 0x72, 0x79, 0x77, 0x68, 0x65, 0x72,
  0x65, 0x20, 0x62, 0x75, 0x74, 0x20, 0x61, 0x74, 0x20, 0x74, 0x6f, 0x70,
  0x2c, 0x20, 0x77, 0x68, 0x65, 0x72, 0x65, 0x20, 0x76, 0x65, 0x72, 0x73,
  0x69, 0x6f, 0x6e, 0x20, 0x77, 0x61, 0x73, 0x20, 0x73, 0x65, 0x74, 0x20,
  0x74, 0x6f, 0x20, 0x31, 0x2e, 0x31, 0x2e, 0x35, 0x2e, 0x0d, 0x0a, 0x32,
  0x30, 0x30, 0x34, 0x2d, 0x30, 0x39, 0x2d, 0x31, 0x35, 0x20, 0x4d, 0x2e,
  0x20, 0x4d, 0x6f, 0x6f, 0x64, 0x69, 0x65, 0x2e, 0x20, 0x20, 0x43, 0x68,
  0x61, 0x6e, 0x67, 0x65, 0x64, 0x20, 0x75, 0x72, 0x69, 0x20, 0x74, 0x6f,
  0x20, 0x55, 0x52, 0x49, 0x20, 0x74, 0x68, 0x72, 0x6f, 0x75, 0x67, 0x68,
  0x6f, 0x75, 0x74, 0x2e, 0x20, 0x20, 0x53, 0x65, 0x74, 0x20, 0x76, 0x65,
  0x72, 0x73, 0x69, 0x6f, 0x6e, 0x20, 0x74, 0x6f, 0x20, 0x31, 0x2e, 0x31,
  0x2e, 0x36, 0x2e, 0x0d, 0x0a, 0x32, 0x30, 0x30, 0x34, 0x2d, 0x30, 0x39,
  0x2d, 0x31, 0x36, 0x20, 0x4d, 0x2e, 0x20, 0x4d, 0x6f, 0x6f, 0x64, 0x69,
  0x65, 0x2e, 0x20, 0x20, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x20,
  0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x20, 0x74, 0x6f, 0x20, 0x31,
  0x2e, 0x32, 0x2e, 0x30, 0x0d, 0x0a, 0x32, 0x30, 0x30, 0x35, 0x2d, 0x30,
  0x36, 0x2d, 0x32, 0x36, 0x20, 0x4d, 0x2e, 0x20, 0x47, 0x79, 0x6c, 0x6c,
  0x69, 0x6e, 0x67, 0x2e, 0x20, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64,
  0x20, 0x70, 0x69, 0x64, 0x2c, 0x20, 0x73, 0x69, 0x64, 0x2c, 0x20, 0x6e,
  0x73, 0x20, 0x75, 0x72, 0x69, 0x2c, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x66,
  0x69, 0x6c, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x20, 0x66, 0x6f, 0x72, 0x20,
  0x5a, 0x33, 0x39, 0x38, 0x36, 0x2d, 0x32, 0x30, 0x30, 0x35, 0x0d, 0x0a,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x0d, 0x0a, 0x20, 0x20, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
  0x69, 0x6f, 0x6e, 0x3a, 0x0d, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x0d, 0x0a, 0x20, 0x20,
  0x4e, 0x43, 0x58, 0x20, 0x28, 0x4e, 0x61, 0x76, 0x69, 0x67, 0x61, 0x74,
  0x69, 0x6f, 0x6e, 0x20, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x20,
  0x66, 0x6f, 0x72, 0x20, 0x58, 0x4d, 0x4c, 0x20, 0x61, 0x70, 0x70, 0x6c,
  0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x29, 0x20, 0x69, 0x73,
  0x20, 0x61, 0x20, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x6c, 0x69, 0x7a,
  0x65, 0x64, 0x20, 0x6e, 0x61, 0x76, 0x69, 0x67, 0x61, 0x74, 0x69, 0x6f,
  0x6e, 0x20, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e,
  0x20, 0x44, 0x54, 0x44, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x61, 0x70, 0x70,
  0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x0d, 0x0a, 0x74, 0x6f,
  0x20, 0x44, 0x69, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x20, 0x54, 0x61, 0x6c,
  0x6b, 0x69, 0x6e, 0x67, 0x20, 0x42, 0x6f, 0x6f, 0x6b, 0x73, 0x2c, 0x20,
  0x65, 0x42, 0x6f, 0x6f, 0x6b, 0x73, 0x2c, 0x20, 0x61, 0x6e, 0x64, 0x20,
  0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x6c, 0x20, 0x77, 0x65, 0x62, 0x20,
  0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x20, 0x6d, 0x6f, 0x64, 0x65,
  0x6c, 0x73, 0x2e, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x0d, 0x0a, 0x54, 0x68, 0x69, 0x73, 0x20, 0x44, 0x54,
  0x44, 0x20, 0x69, 0x73, 0x20, 0x61, 0x6e, 0x20, 0x58, 0x4d, 0x4c, 0x20,
  0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20,
  0x74, 0x68, 0x61, 0x74, 0x20, 0x6c, 0x61, 0x79, 0x65, 0x72, 0x73, 0x20,
  0x6e, 0x61, 0x76, 0x69, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x66,
  0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x69, 0x74, 0x79,
  0x20, 0x6f, 0x6e, 0x20, 0x74, 0x6f, 0x70, 0x20, 0x6f, 0x66, 0x20, 0x53,
  0x4d, 0x49, 0x4c, 0x20, 0x32, 0x2e, 0x30, 0x20, 0x20, 0x63, 0x6f, 0x6e,
  0x74, 0x65, 0x6e, 0x74, 0x2e, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x0d, 0x0a, 0x20, 0x20,
  0x0d, 0x0a, 0x20, 0x20, 0x54, 0x68, 0x65, 0x20, 0x4e, 0x43, 0x58, 0x20,
  0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x73, 0x20, 0x61, 0x20, 0x6e, 0x61,
  0x76, 0x69, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x70, 0x61, 0x74,
  0x68, 0x2f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x20, 0x74, 0x68, 0x61, 0x74,
  0x20, 0x6d, 0x61, 0x79, 0x20, 0x62, 0x65, 0x20, 0x61, 0x70, 0x70, 0x6c,
  0x69, 0x65, 0x64, 0x20, 0x75, 0x70, 0x6f, 0x6e, 0x20, 0x65, 0x78, 0x69,
  0x73, 0x74, 0x69, 0x6e, 0x67, 0x20, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2c, 0x0d, 0x0a, 0x77, 0x69, 0x74,
  0x68, 0x6f, 0x75, 0x74, 0x20, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x63,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65,
  0x20, 0x65, 0x78, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x20, 0x70, 0x75,
  0x62, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x73, 0x6f,
  0x75, 0x72, 0x63, 0x65, 0x2c, 0x20, 0x73, 0x6f, 0x20, 0x6c, 0x6f, 0x6e,
  0x67, 0x20, 0x61, 0x73, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6e, 0x61, 0x76,
  0x69, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x74, 0x61, 0x72, 0x67,
  0x65, 0x74, 0x73, 0x20, 0x77, 0x69, 0x74, 0x68, 0x69, 0x6e, 0x0d, 0x0a,
  0x74, 0x68, 0x65, 0x20, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x20, 0x70,
  0x75, 0x62, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x63,
  0x61, 0x6e, 0x20, 0x62, 0x65, 0x20, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74,
  0x6c, 0x79, 0x20, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
  0x64, 0x20, 0x76, 0x69, 0x61, 0x20, 0x61, 0x20, 0x55, 0x52, 0x49, 0x2e,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x0d, 0x0a,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x0d, 0x0a, 0x54, 0x68, 0x65, 0x20, 0x66, 0x6f, 0x6c, 0x6c, 0x6f,
  0x77, 0x69, 0x6e, 0x67, 0x20, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66,
  0x69, 0x65, 0x72, 0x73, 0x20, 0x61, 0x70, 0x70, 0x6c, 0x79, 0x20, 0x74,
  0x6f, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x44, 0x54, 0x44, 0x3a, 0x0d,
  0x0a, 0x20, 0x20, 0x22, 0x2d, 0x2f, 0x2f, 0x4e, 0x49, 0x53, 0x4f, 0x2f,
  0x2f, 0x44, 0x54, 0x44, 0x20, 0x6e, 0x63, 0x78, 0x20, 0x32, 0x30, 0x30,
  0x35, 0x2d, 0x31, 0x2f, 0x2f, 0x45, 0x4e, 0x22, 0x0d, 0x0a, 0x20, 0x20,
  0x22, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e,
  0x64, 0x61, 0x69, 0x73, 0x79, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x7a, 0x33,
  0x39, 0x38, 0x36, 0x2f, 0x32, 0x30, 0x30, 0x35, 0x2f, 0x6e, 0x63, 0x78,
  0x2d, 0x32, 0x30, 0x30, 0x35, 0x2d, 0x31, 0x2e, 0x64, 0x74, 0x64, 0x22,
  0x0d, 0x0a, 0x2d, 0x2d, 0x3e, 0x0d, 0x0a, 0x0d, 0x0a, 0x3c, 0x21, 0x2d,
  0x2d, 0x20, 0x42, 0x61, 0x73, 0x69, 0x63, 0x20, 0x45, 0x6e, 0x74, 0x69,
  0x74, 0x69, 0x65, 0x73, 0x20, 0x2d, 0x2d, 0x3e, 0x0d, 0x0a, 0x0d, 0x0a,
  0x3c, 0x21, 0x45, 0x4e, 0x54, 0x49, 0x54, 0x59, 0x20, 0x25, 0x20, 0x69,
  0x31, 0x38, 0x6e, 0x20, 0x0d, 0x0a, 0x20, 0x20, 0x22, 0x78, 0x6d, 0x6c,
  0x3a, 0x6c, 0x61, 0x6e, 0x67, 0x20, 0x20, 0x20, 0x20, 0x4e, 0x4d, 0x54,
  0x4f, 0x4b, 0x45, 0x4e, 0x20, 0x20, 0x20, 0x20, 0x23, 0x49, 0x4d, 0x50,
  0x4c, 0x49, 0x45, 0x44, 0x0d, 0x0a, 0x20, 0x20, 0x64, 0x69, 0x72, 0x20,
  0x20, 0x20, 0x20, 0x28, 0x6c, 0x74, 0x72, 0x7c, 0x72, 0x74, 0x6c, 0x29,
  0x20, 0x20, 0x23, 0x49, 0x4d, 0x50, 0x4c, 0x49, 0x45, 0x44, 0x22, 0x20,
  0x3e, 0x0d, 0x0a, 0x0d, 0x0a, 0x3c, 0x21, 0x45, 0x4e, 0x54, 0x49, 0x54,
  0x59, 0x20, 0x25, 0x20, 0x53, 0x4d, 0x49, 0x4c, 0x74, 0x69, 0x6d, 0x65,
  0x56, 0x61, 0x6c, 0x20, 0x20, 0x22, 0x43, 0x44, 0x41, 0x54, 0x41, 0x22,
  0x20, 0x3e, 0x0d, 0x0a, 0x3c, 0x21, 0x45, 0x4e, 0x54, 0x49, 0x54, 0x59,
  0x20, 0x25, 0x20, 0x55, 0x52, 0x49, 0x20, 0x20, 0x20, 0x20, 0x22, 0x43,
  0x44, 0x41, 0x54, 0x41, 0x22, 0x20, 0x3e, 0x0d, 0x0a, 0x3c, 0x21, 0x45,
  0x4e, 0x54, 0x49, 0x54, 0x59, 0x20, 0x25, 0x20, 0x73, 0x63, 0x72, 0x69,
  0x70, 0x74, 0x20, 0x20, 0x22, 0x43, 0x44, 0x41, 0x54, 0x41, 0x22, 0x20,
  0x3e, 0x0d, 0x0a, 0x0d, 0x0a, 0x3c, 0x21, 0x2d, 0x2d, 0x20, 0x45, 0x4c,
  0x45, 0x4d, 0x45, 0x4e, 0x54, 0x53, 0x20, 0x2d, 0x2d, 0x3e, 0x0d, 0x0a,
  0x0d, 0x0a, 0x3c, 0x21, 0x2d, 0x2d, 0x20, 0x54, 0x6f, 0x70, 0x20, 0x4c,
  0x65, 0x76, 0x65, 0x6c, 0x20, 0x4e, 0x43, 0x58, 0x20, 0x43, 0x6f, 0x6e,
  0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x20, 0x2d, 0x2d, 0x3e, 0x0d,
  0x0a, 0x3c, 0x21, 0x2d, 0x2d, 0x20, 0x52, 0x65, 0x76, 0x69, 0x73, 0x65,
  0x64, 0x2c, 0x20, 0x33, 0x2f, 0x33, 0x31, 0x2f, 0x32, 0x30, 0x30, 0x34,
  0x3a, 0x20, 0x20, 0x41, 0x64, 0x64, 0x65, 0x64, 0x20, 0x70, 0x61, 0x67,
  0x65, 0x4c, 0x69, 0x73, 0x74, 0x20, 0x74, 0x6f, 0x20, 0x63, 0x6f, 0x6e,
  0x74, 0x65, 0x6e, 0x74, 0x20, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x20, 0x2d,
  0x2d, 0x3e, 0x0d, 0x0a, 0x3c, 0x21, 0x45, 0x4c, 0x45, 0x4d, 0x45, 0x4e,
  0x54, 0x20, 0x6e, 0x63, 0x78, 0x20, 0x28, 0x68, 0x65, 0x61, 0x64, 0x2c,
  0x20, 0x64, 0x6f, 0x63, 0x54, 0x69, 0x74, 0x6c, 0x65, 0x2c, 0x20, 0x64,
  0x6f, 0x63, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x2a, 0x2c, 0x20, 0x6e,
  0x61, 0x76, 0x4d, 0x61, 0x70, 0x2c, 0x20, 0x70, 0x61, 0x67, 0x65, 0x4c,
  0x69, 0x73, 0x74, 0x3f, 0x2c, 0x20, 0x6e, 0x61, 0x76, 0x4c, 0x69, 0x73,
  0x74, 0x2a, 0x29, 0x3e, 0x0d, 0x0a, 0x3c, 0x21, 0x2d, 0x2d, 0x20, 0x52,
  0x65, 0x76, 0x69, 0x73, 0x65, 0x64, 0x2c, 0x20, 0x34, 0x2f, 0x35, 0x2f,
  0x32, 0x30, 0x30, 0x34, 0x3a, 0x20, 0x20, 0x43, 0x68, 0x61, 0x6e, 0x67,
  0x65, 0x64, 0x20, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x20, 0x74,
  0x6f, 0x20, 0x31, 0x2e, 0x31, 0x2e, 0x32, 0x20, 0x2d, 0x2d, 0x3e, 0x0d,
  0x0a, 0x3c, 0x21, 0x2d, 0x2d, 0x20, 0x52, 0x65, 0x76, 0x69, 0x73, 0x65,
  0x64, 0x20, 0x33, 0x2f, 0x32, 0x39, 0x2f, 0x32, 0x30, 0x30, 0x34, 0x3a,
  0x20, 0x20, 0x41, 0x64, 0x64, 0x65, 0x64, 0x20, 0x78, 0x6d, 0x6c, 0x6e,
  0x73, 0x20, 0x2d, 0x2d, 0x3e, 0x0d, 0x0a, 0x3c, 0x21, 0x2d, 0x2d, 0x20,
  0x52, 0x65, 0x76, 0x69, 0x73, 0x65, 0x64, 0x2c, 0x20, 0x34, 0x2f, 0x35,
  0x2f, 0x32, 0x30, 0x30, 0x34, 0x3a, 0x20, 0x20, 0x54, 0x4d, 0x2c, 0x20,
  0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x20, 0x76, 0x65, 0x72, 0x73,
  0x69, 0x6f, 0x6e, 0x20, 0x74, 0x6f, 0x20, 0x31, 0x2e, 0x31, 0x2e, 0x33,
  0x20, 0x2d, 0x2d, 0x3e, 0x0d, 0x0a, 0x3c, 0x21, 0x2d, 0x2d, 0x20, 0x52,
  0x65, 0x76, 0x69, 0x73, 0x65, 0x64, 0x2c, 0x20, 0x35, 0x2f, 0x31, 0x34,
  0x2f, 0x32, 0x30, 0x30, 0x34, 0x3a, 0x20, 0x20, 0x54, 0x4d, 0x2c, 0x20,
  0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x20, 0x76, 0x65, 0x72, 0x73,
  0x69, 0x6f, 0x6e, 0x20, 0x74, 0x6f, 0x20, 0x31, 0x2e, 0x31, 0x2e, 0x34,
  0x20, 0x2d, 0x2d, 0x3e, 0x0d, 0x0a, 0x3c, 0x21, 0x2d, 0x2d, 0x20, 0x52,
  0x65, 0x76, 0x69, 0x73, 0x65, 0x64, 0x2c, 0x20, 0x37, 0x2f, 0x37, 0x2f,
  0x32, 0x30, 0x30, 0x34, 0x3a, 0x20, 0x20, 0x4d, 0x4d, 0x2c, 0x20, 0x43,
  0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x20, 0x76, 0x65, 0x72, 0x73, 0x69,
  0x6f, 0x6e, 0x20, 0x74, 0x6f, 0x20, 0x31, 0x2e, 0x32, 0x2e, 0x30, 0x20,
  0x2d, 0x2d, 0x3e, 0x0d, 0x0a, 0x3c, 0x21, 0x41, 0x54, 0x54, 0x4c, 0x49,
  0x53, 0x54, 0x20, 0x6e, 0x63, 0x78, 0x20, 0x0d, 0x0a, 0x20, 0x20, 0x76,
  0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x20, 0x20, 0x20, 0x20, 0x20, 0x43,
  0x44, 0x41, 0x54, 0x41, 0x20, 0x20, 0x20, 0x20, 0x20, 0x23, 0x46, 0x49,
  0x58, 0x45, 0x44, 0x20, 0x22, 0x32, 0x30, 0x30, 0x35, 0x2d, 0x31, 0x22,
  0x0d, 0x0a, 0x20, 0x20, 0x78, 0x6d, 0x6c, 0x6e, 0x73, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x25, 0x55, 0x52, 0x49, 0x3b, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x23, 0x46, 0x49, 0x58, 0x45, 0x44, 0x20, 0x22, 0x68, 0x74,
  0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x64, 0x61, 0x69,
  0x73, 0x79, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x7a, 0x33, 0x39, 0x38, 0x36,
  0x2f, 0x32, 0x30, 0x30, 0x35, 0x2f, 0x6e, 0x63, 0x78, 0x2f, 0x22, 0x0d,
  0x0a, 0x20, 0x20, 0x25, 0x69, 0x31, 0x38, 0x6e, 0x3b, 0x0d, 0x0a, 0x3e,
  0x0d, 0x0a, 0x0d, 0x0a, 0x3c, 0x21, 0x2d, 0x2d, 0x20, 0x44, 0x6f, 0x63,
  0x75, 0x6d, 0x65, 0x6e, 0x74, 0x20, 0x48, 0x65, 0x61, 0x64, 0x20, 0x2d,
  0x20, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x73, 0x20, 0x61, 0x6c,
  0x6c, 0x20, 0x4e, 0x43, 0x58, 0x20, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61,
  0x74, 0x61, 0x2e, 0x20, 0x20, 0x0d, 0x0a, 0x2d, 0x2d, 0x3e, 0x0d, 0x0a,
  0x0d, 0x0a, 0x3c, 0x21, 0x45, 0x4c, 0x45, 0x4d, 0x45, 0x4e, 0x54, 0x20,
  0x68, 0x65, 0x61, 0x64, 0x20, 0x28, 0x73, 0x6d, 0x69, 0x6c, 0x43, 0x75,
  0x73, 0x74, 0x6f, 0x6d, 0x54, 0x65, 0x73, 0x74, 0x20, 0x7c, 0x20, 0x6d,
  0x65, 0x74, 0x61, 0x29, 0x2b, 0x3e, 0x0d, 0x0a, 0x0d, 0x0a, 0x3c, 0x21,
  0x2d, 0x2d, 0x20, 0x32, 0x30, 0x30, 0x34, 0x2d, 0x30, 0x34, 0x2d, 0x30,
  0x35, 0x20, 0x54, 0x4d, 0x20, 0x2d, 0x20, 0x6f, 0x6e, 0x6c, 0x79, 0x20,
  0x69, 0x64, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x64, 0x65, 0x66, 0x61, 0x75,
  0x6c, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x20, 0x61, 0x72, 0x65, 0x20,
  0x63, 0x6f, 0x70, 0x69, 0x65, 0x64, 0x20, 0x2d, 0x2d, 0x3e, 0x0d, 0x0a,
  0x3c, 0x21, 0x2d, 0x2d, 0x20, 0x32, 0x30, 0x30, 0x34, 0x2d, 0x30, 0x35,
  0x2d, 0x31, 0x34, 0x20, 0x54, 0x4d, 0x20, 0x2d, 0x20, 0x72, 0x65, 0x76,
  0x65, 0x72, 0x74, 0x20, 0x74, 0x6f, 0x20, 0x6f, 0x76, 0x65, 0x72, 0x72,
  0x69, 0x64, 0x65, 0x20, 0x63, 0x6f, 0x70, 0x69, 0x65, 0x64, 0x20, 0x74,
  0x6f, 0x6f, 0x3b, 0x20, 0x61, 0x64, 0x64, 0x65, 0x64, 0x20, 0x62, 0x6f,
  0x6f, 0x6b, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x20, 0x61, 0x74, 0x74,
  0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x20, 0x2d, 0x2d, 0x3e, 0x0d, 0x0a,
  0x3c, 0x21, 0x2d, 0x2d, 0x20, 0x73, 0x6d, 0x69, 0x6c, 0x43, 0x75, 0x73,
  0x74, 0x6f, 0x6d, 0x54, 0x65, 0x73, 0x74, 0x20, 0x2d, 0x20, 0x44, 0x75,
  0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x65, 0x73, 0x20, 0x63, 0x75, 0x73,
  0x74, 0x6f, 0x6d, 0x54, 0x65, 0x73, 0x74, 0x20, 0x64, 0x61, 0x74, 0x61,
  0x20, 0x66, 0x6f, 0x75, 0x6e, 0x64, 0x20, 0x69, 0x6e, 0x20, 0x53, 0x4d,
  0x49, 0x4c, 0x20, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x2e, 0x20, 0x20, 0x45,
  0x61, 0x63, 0x68, 0x20, 0x75, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x20, 0x63,
  0x75, 0x73, 0x74, 0x6f, 0x6d, 0x54, 0x65, 0x73, 0x74, 0x20, 0x0d, 0x0a,
  0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x20, 0x74, 0x68, 0x61, 0x74,
  0x20, 0x61, 0x70, 0x70, 0x65, 0x61, 0x72, 0x73, 0x20, 0x69, 0x6e, 0x20,
  0x6f, 0x6e, 0x65, 0x20, 0x6f, 0x72, 0x20, 0x6d, 0x6f, 0x72, 0x65, 0x20,
  0x53, 0x4d, 0x49, 0x4c, 0x20, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x20, 0x6d,
  0x75, 0x73, 0x74, 0x20, 0x68, 0x61, 0x76, 0x65, 0x20, 0x69, 0x74, 0x73,
  0x20, 0x69, 0x64, 0x2c, 0x20, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74,
  0x53, 0x74, 0x61, 0x74, 0x65, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x6f, 0x76,
  0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x20, 0x0d, 0x0a, 0x61, 0x74, 0x74,
  0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x20, 0x64, 0x75, 0x70, 0x6c,
  0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x20, 0x69, 0x6e, 0x20, 0x61, 0x20,
  0x73, 0x6d, 0x69, 0x6c, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x54, 0x65,
  0x73, 0x74, 0x20, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x20, 0x69,
  0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x4e, 0x43, 0x58, 0x2e, 0x20, 0x20,
  0x54, 0x68, 0x65, 0x20, 0x4e, 0x43, 0x58, 0x20, 0x74, 0x68, 0x75, 0x73,
  0x20, 0x67, 0x61, 0x74, 0x68, 0x65, 0x72, 0x73, 0x20, 0x69, 0x6e, 0x20,
  0x6f, 0x6e, 0x65, 0x20, 0x0d, 0x0a, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x20,
  0x61, 0x6c, 0x6c, 0x20, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x54, 0x65,
  0x73, 0x74, 0x20, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x20,
  0x75, 0x73, 0x65, 0x64, 0x20, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20,
  0x53, 0x4d, 0x49, 0x4c, 0x20, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x2c, 0x20,
  0x66, 0x6f, 0x72, 0x20, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x61,
  0x74, 0x69, 0x6f, 0x6e, 0x20, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x20,
  0x75, 0x73, 0x65, 0x72, 0x2e, 0x0d, 0x0a, 0x2d, 0x2d, 0x3e, 0x0d, 0x0a,
  0x3c, 0x21, 0x45, 0x4c, 0x45, 0x4d, 0x45, 0x4e, 0x54, 0x20, 0x73, 0x6d,
  0x69, 0x6c, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x54, 0x65, 0x73, 0x74,
  0x20, 0x45, 0x4d, 0x50, 0x54, 0x59, 0x3e, 0x0d, 0x0a, 0x3c, 0x21, 0x41,
  0x54, 0x54, 0x4c, 0x49, 0x53, 0x54, 0x20, 0x73, 0x6d, 0x69, 0x6c, 0x43,
  0x75, 0x73, 0x74, 0x6f, 0x6d, 0x54, 0x65, 0x73, 0x74, 0x0d, 0x0a, 0x69,
  0x64, 0x20, 0x20, 0x20, 0x20, 0x49, 0x44, 0x20, 0x20, 0x20, 0x20, 0x23,
  0x52, 0x45, 0x51, 0x55, 0x49, 0x52, 0x45, 0x44, 0x0d, 0x0a, 0x64, 0x65,
  0x66, 0x61, 0x75, 0x6c, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x20, 0x20,
  0x28, 0x74, 0x72, 0x75, 0x65, 0x7c, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x29,
  0x20, 0x20, 0x20, 0x27, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x27, 0x0d, 0x0a,
  0x6f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x20, 0x20, 0x28, 0x76,
  0x69, 0x73, 0x69, 0x62, 0x6c, 0x65, 0x7c, 0x68, 0x69, 0x64, 0x64, 0x65,
  0x6e, 0x29, 0x20, 0x27, 0x68, 0x69, 0x64, 0x64, 0x65, 0x6e, 0x27, 0x0d,
  0x0a, 0x62, 0x6f, 0x6f, 0x6b, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x20,
  0x20, 0x28, 0x50, 0x41, 0x47, 0x45, 0x5f, 0x4e, 0x55, 0x4d, 0x42, 0x45,
  0x52, 0x7c, 0x4e, 0x4f, 0x54, 0x45, 0x7c, 0x4e, 0x4f, 0x54, 0x45, 0x5f,
  0x52, 0x45, 0x46, 0x45, 0x52, 0x45, 0x4e, 0x43, 0x45, 0x7c, 0x41, 0x4e,
  0x4e, 0x4f, 0x54, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x7c, 0x4c, 0x49, 0x4e,
  0x45, 0x5f, 0x4e, 0x55, 0x4d, 0x42, 0x45, 0x52, 0x7c, 0x4f, 0x50, 0x54,
  0x49, 0x4f, 0x4e, 0x41, 0x4c, 0x5f, 0x53, 0x49, 0x44, 0x45, 0x42, 0x41,
  0x52, 0x7c, 0x4f, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x41, 0x4c, 0x5f, 0x50,
  0x52, 0x4f, 0x44, 0x55, 0x43, 0x45, 0x52, 0x5f, 0x4e, 0x4f, 0x54, 0x45,
  0x29, 0x20, 0x20, 0x23, 0x49, 0x4d, 0x50, 0x4c, 0x49, 0x45, 0x44, 0x0d,
  0x0a, 0x3e, 0x0d, 0x0a, 0x0d, 0x0a, 0x3c, 0x21, 0x2d, 0x2d, 0x20, 0x4d,
  0x65, 0x74, 0x61, 0x20, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x20,
  0x2d, 0x20, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x20, 0x61,
  0x62, 0x6f, 0x75, 0x74, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x4e, 0x43,
  0x58, 0x20, 0x2d, 0x2d, 0x3e, 0x0d, 0x0a, 0x3c, 0x21, 0x45, 0x4c, 0x45,
  0x4d, 0x45, 0x4e, 0x54, 0x20, 0x6d, 0x65, 0x74, 0x61, 0x20, 0x45, 0x4d,
  0x50, 0x54, 0x59, 0x3e, 0x0d, 0x0a, 0x3c, 0x21, 0x41, 0x54, 0x54, 0x4c,
  0x49, 0x53, 0x54, 0x20, 0x6d, 0x65, 0x74, 0x61, 0x0d, 0x0a, 0x20, 0x20,
  0x6e, 0x61, 0x6d, 0x65, 0x20, 0x20, 0x20, 0x20, 0x43, 0x44, 0x41, 0x54,
  0x41, 0x20, 0x20, 0x20, 0x20, 0x23, 0x52, 0x45, 0x51, 0x55, 0x49, 0x52,
  0x45, 0x44, 0x0d, 0x0a, 0x20, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
  0x74, 0x20, 0x20, 0x43, 0x44, 0x41, 0x54, 0x41, 0x20, 0x20, 0x20, 0x20,
  0x23, 0x52, 0x45, 0x51, 0x55, 0x49, 0x52, 0x45, 0x44, 0x0d, 0x0a, 0x20,
  0x20, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x65, 0x20, 0x20, 0x43, 0x44, 0x41,
  0x54, 0x41, 0x20, 0x20, 0x20, 0x20, 0x23, 0x49, 0x4d, 0x50, 0x4c, 0x49,
  0x45, 0x44, 0x0d, 0x0a, 0x3e, 0x0d, 0x0a, 0x0d, 0x0a, 0x3c, 0x21, 0x2d,
  0x2d, 0x20, 0x44, 0x6f, 0x63, 0x54, 0x69, 0x74, 0x6c, 0x65, 0x20, 0x2d,
  0x20, 0x74, 0x68, 0x65, 0x20, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x20, 0x6f,
  0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
  0x6e, 0x74, 0x2c, 0x20, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64,
  0x20, 0x61, 0x6e, 0x64, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x69, 0x6d,
  0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x6c, 0x79, 0x20, 0x66, 0x6f,
  0x6c, 0x6c, 0x6f, 0x77, 0x20, 0x68, 0x65, 0x61, 0x64, 0x2e, 0x20, 0x0d,
  0x0a, 0x2d, 0x2d, 0x3e, 0x0d, 0x0a, 0x0d, 0x0a, 0x3c, 0x21, 0x2d, 0x2d,
  0x20, 0x52, 0x65, 0x76, 0x69, 0x73, 0x65, 0x64, 0x2c, 0x20, 0x33, 0x2f,
  0x33, 0x31, 0x2f, 0x32, 0x30, 0x30, 0x34, 0x3a, 0x20, 0x20, 0x41, 0x64,
  0x64, 0x65, 0x64, 0x20, 0x69, 0x6d, 0x67, 0x20, 0x74, 0x6f, 0x20, 0x63,
  0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x20, 0x6d, 0x6f, 0x64, 0x65, 0x6c,
  0x20, 0x2d, 0x2d, 0x3e, 0x0d, 0x0a, 0x3c, 0x21, 0x45, 0x4c, 0x45, 0x4d,
  0x45, 0x4e, 0x54, 0x20, 0x64, 0x6f, 0x63, 0x54, 0x69, 0x74, 0x6c, 0x65,
  0x20, 0x28, 0x74, 0x65, 0x78, 0x74, 0x2c, 0x20, 0x61, 0x75, 0x64, 0x69,
  0x6f, 0x3f, 0x2c, 0x20, 0x69, 0x6d, 0x67, 0x3f, 0x29, 0x3e, 0x0d, 0x0a,
  0x3c, 0x21, 0x41, 0x54, 0x54, 0x4c, 0x49, 0x53, 0x54, 0x20, 0x64, 0x6f,
  0x63, 0x54, 0x69, 0x74, 0x6c, 0x65, 0x0d, 0x0a, 0x20, 0x20, 0x69, 0x64,
  0x20, 0x20, 0x20, 0x20, 0x49, 0x44, 0x20, 0x20, 0x20, 0x20, 0x23, 0x49,
  0x4d, 0x50, 0x4c, 0x49, 0x45, 0x44, 0x0d, 0x0a, 0x20, 0x20, 0x25, 0x69,
  0x31, 0x38, 0x6e, 0x3b, 0x0d, 0x0a, 0x3e, 0x0d, 0x0a, 0x0d, 0x0a, 0x3c,
  0x21, 0x2d, 0x2d, 0x20, 0x44, 0x6f, 0x63, 0x41, 0x75, 0x74, 0x68, 0x6f,
  0x72, 0x20, 0x2d, 0x20, 0x74, 0x68, 0x65, 0x20, 0x61, 0x75, 0x74, 0x68,
  0x6f, 0x72, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x64, 0x6f,
  0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2c, 0x20, 0x69, 0x6d, 0x6d, 0x65,
  0x64, 0x69, 0x61, 0x74, 0x65, 0x6c, 0x79, 0x20, 0x66, 0x6f, 0x6c, 0x6c,
  0x6f, 0x77, 0x73, 0x20, 0x64, 0x6f, 0x63, 0x54, 0x69, 0x74, 0x6c, 0x65,
  0x2e, 0x0d, 0x0a, 0x2d, 0x2d, 0x3e, 0x0d, 0x0a, 0x0d, 0x0a, 0x3c, 0x21,
  0x2d, 0x2d, 0x20, 0x52, 0x65, 0x76, 0x69, 0x73, 0x65, 0x64, 0x2c, 0x20,
  0x33, 0x2f, 0x33, 0x31, 0x2f, 0x32, 0x30, 0x30, 0x34, 0x3a, 0x20, 0x20,
  0x41, 0x64, 0x64, 0x65, 0x64, 0x20, 0x69, 0x6d, 0x67, 0x20, 0x74, 0x6f,
  0x20, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x20, 0x6d, 0x6f, 0x64,
  0x65, 0x6c, 0x20, 0x2d, 0x2d, 0x3e, 0x0d, 0x0a, 0x3c, 0x21, 0x45, 0x4c,
  0x45, 0x4d, 0x45, 0x4e, 0x54, 0x20, 0x64, 0x6f, 0x63, 0x41, 0x75, 0x74,
  0x68, 0x6f, 0x72, 0x20, 0x28, 0x74, 0x65, 0x78, 0x74, 0x2c, 0x20, 0x61,
  0x75, 0x64, 0x69, 0x6f, 0x3f, 0x2c, 0x20, 0x69, 0x6d, 0x67, 0x3f, 0x29,
  0x3e, 0x0d, 0x0a, 0x3c, 0x21, 0x41, 0x54, 0x54, 0x4c, 0x49, 0x53, 0x54,
  0x20, 0x64, 0x6f, 0x63, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x0d, 0x0a,
  0x20, 0x20, 0x69, 0x64, 0x20, 0x20, 0x20, 0x20, 0x49, 0x44, 0x20, 0x20,
  0x20, 0x20, 0x23, 0x49, 0x4d, 0x50, 0x4c, 0x49, 0x45, 0x44, 0x0d, 0x0a,
  0x20, 0x20, 0x25, 0x69, 0x31, 0x38, 0x6e, 0x3b, 0x0d, 0x0a, 0x3e, 0x0d,
  0x0a, 0x0d, 0x0a, 0x3c, 0x21, 0x2d, 0x2d, 0x20, 0x4e, 0x61, 0x76, 0x69,
  0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x53, 0x74, 0x72, 0x75, 0x63,
  0x74, 0x75, 0x72, 0x65, 0x20, 0x2d, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x61,
  0x69, 0x6e, 0x65, 0x72, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x61, 0x6c, 0x6c,
  0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x4e, 0x43, 0x58, 0x20,
  0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x20, 0x74, 0x68, 0x61, 0x74,
  0x20, 0x61, 0x72, 0x65, 0x20, 0x70, 0x61, 0x72, 0x74, 0x20, 0x6f, 0x66,
  0x20, 0x74, 0x68, 0x65, 0x20, 0x0d, 0x0a, 0x68, 0x69, 0x65, 0x72, 0x61,
  0x72, 0x63, 0x68, 0x69, 0x63, 0x61, 0x6c, 0x20, 0x73, 0x74, 0x72, 0x75,
  0x63, 0x74, 0x75, 0x72, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65,
  0x20, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x0d, 0x0a,
  0x2d, 0x2d, 0x3e, 0x0d, 0x0a, 0x0d, 0x0a, 0x3c, 0x21, 0x2d, 0x2d, 0x20,
  0x52, 0x65, 0x76, 0x69, 0x73, 0x65, 0x64, 0x2c, 0x20, 0x33, 0x2f, 0x33,
  0x31, 0x2f, 0x32, 0x30, 0x30, 0x34, 0x3a, 0x20, 0x20, 0x41, 0x64, 0x64,
  0x65, 0x64, 0x20, 0x6e, 0x61, 0x76, 0x49, 0x6e, 0x66, 0x6f, 0x20, 0x74,
  0x6f, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x20, 0x6d, 0x6f,
  0x64, 0x65, 0x6c, 0x20, 0x2d, 0x2d, 0x3e, 0x0d, 0x0a, 0x3c, 0x21, 0x45,
  0x4c, 0x45, 0x4d, 0x45, 0x4e, 0x54, 0x20, 0x6e, 0x61, 0x76, 0x4d, 0x61,
  0x70, 0x20, 0x28, 0x6e, 0x61, 0x76, 0x49, 0x6e, 0x66, 0x6f, 0x2a, 0x2c,
  0x20, 0x6e, 0x61, 0x76, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x2a, 0x2c, 0x20,
  0x6e, 0x61, 0x76, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x2b, 0x29, 0x3e, 0x0d,
  0x0a, 0x3c, 0x21, 0x41, 0x54, 0x54, 0x4c, 0x49, 0x53, 0x54, 0x20, 0x6e,
  0x61, 0x76, 0x4d, 0x61, 0x70, 0x0d, 0x0a, 0x20, 0x20, 0x69, 0x64, 0x20,
  0x20, 0x20, 0x20, 0x49, 0x44, 0x20, 0x20, 0x20, 0x20, 0x23, 0x49, 0x4d,
  0x50, 0x4c, 0x49, 0x45, 0x44, 0x0d, 0x0a, 0x3e, 0x0d, 0x0a, 0x0d, 0x0a,
  0x3c, 0x21, 0x2d, 0x2d, 0x20, 0x4e, 0x61, 0x76, 0x69, 0x67, 0x61, 0x74,
  0x69, 0x6f, 0x6e, 0x20, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x20, 0x2d, 0x20,
  0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x73, 0x20, 0x64, 0x65, 0x73,
  0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x28, 0x73, 0x29, 0x20,
  0x6f, 0x66, 0x20, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x2c, 0x20, 0x61,
  0x73, 0x20, 0x77, 0x65, 0x6c, 0x6c, 0x20, 0x61, 0x73, 0x20, 0x61, 0x20,
  0x70, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x20, 0x74, 0x6f, 0x20, 0x0d,
  0x0a, 0x65, 0x6e, 0x74, 0x69, 0x72, 0x65, 0x20, 0x63, 0x6f, 0x6e, 0x74,
  0x65, 0x6e, 0x74, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x61, 0x72, 0x67, 0x65,
  0x74, 0x2e, 0x0d, 0x0a, 0x48, 0x69, 0x65, 0x72, 0x61, 0x72, 0x63, 0x68,
  0x79, 0x20, 0x69, 0x73, 0x20, 0x72, 0x65, 0x70, 0x72, 0x65, 0x73, 0x65,
  0x6e, 0x74, 0x65, 0x64, 0x20, 0x62, 0x79, 0x20, 0x6e, 0x65, 0x73, 0x74,
  0x69, 0x6e, 0x67, 0x20, 0x6e, 0x61, 0x76, 0x50, 0x6f, 0x69, 0x6e, 0x74,
  0x73, 0x2e, 0x20, 0x20, 0x22, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x22, 0x20,
  0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x20, 0x64, 0x65,
  0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x73, 0x20, 0x74, 0x68, 0x65, 0x20,
  0x6b, 0x69, 0x6e, 0x64, 0x20, 0x0d, 0x0a, 0x6f, 0x66, 0x20, 0x73, 0x74,
  0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x61, 0x6c, 0x20, 0x75, 0x6e, 0x69,
  0x74, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x6f, 0x62, 0x6a, 0x65, 0x63,
  0x74, 0x20, 0x72, 0x65, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x73,
  0x20, 0x28, 0x65, 0x2e, 0x67, 0x2e, 0x2c, 0x20, 0x22, 0x63, 0x68, 0x61,
  0x70, 0x74, 0x65, 0x72, 0x22, 0x2c, 0x20, 0x22, 0x73, 0x65, 0x63, 0x74,
  0x69, 0x6f, 0x6e, 0x22, 0x29, 0x2e, 0x0d, 0x0a, 0x2d, 0x2d, 0x3e, 0x0d,
  0x0a, 0x3c, 0x21, 0x45, 0x4c, 0x45, 0x4d, 0x45, 0x4e, 0x54, 0x20, 0x6e,
  0x61, 0x76, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x20, 0x28, 0x6e, 0x61, 0x76,
  0x4c, 0x61, 0x62, 0x65, 0x6c, 0x2b, 0x2c, 0x20, 0x63, 0x6f, 0x6e, 0x74,
  0x65, 0x6e, 0x74, 0x2c, 0x20, 0x6e, 0x61, 0x76, 0x50, 0x6f, 0x69, 0x6e,
  0x74, 0x2a, 0x29, 0x3e, 0x0d, 0x0a, 0x3c, 0x21, 0x2d, 0x2d, 0x20, 0x52,
  0x65, 0x76, 0x69, 0x73, 0x65, 0x64, 0x2c, 0x20, 0x33, 0x2f, 0x32, 0x39,
  0x2f, 0x32, 0x30, 0x30, 0x34, 0x3a, 0x20, 0x20, 0x52, 0x65, 0x6d, 0x6f,
  0x76, 0x65, 0x64, 0x20, 0x6f, 0x6e, 0x46, 0x6f, 0x63, 0x75, 0x73, 0x2f,
  0x6f, 0x6e, 0x42, 0x6c, 0x75, 0x72, 0x20, 0x2d, 0x2d, 0x3e, 0x0d, 0x0a,
  0x3c, 0x21, 0x2d, 0x2d, 0x20, 0x52, 0x65, 0x76, 0x69, 0x73, 0x65, 0x64,
  0x2c, 0x20, 0x33, 0x2f, 0x32, 0x39, 0x2f, 0x32, 0x30, 0x30, 0x34, 0x3a,
  0x20, 0x20, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x64, 0x20, 0x76, 0x61,
  0x6c, 0x75, 0x65, 0x20, 0x2d, 0x2d, 0x3e, 0x0d, 0x0a, 0x3c, 0x21, 0x2d,
  0x2d, 0x20, 0x52, 0x65, 0x76, 0x69, 0x73, 0x65, 0x64, 0x2c, 0x20, 0x33,
  0x2f, 0x33, 0x31, 0x2f, 0x32, 0x30, 0x30, 0x34, 0x3a, 0x20, 0x20, 0x52,
  0x65, 0x6d, 0x6f, 0x76, 0x65, 0x64, 0x20, 0x70, 0x61, 0x67, 0x65, 0x52,
  0x65, 0x66, 0x20, 0x2d, 0x2d, 0x3e, 0x0d, 0x0a, 0x3c, 0x21, 0x2d, 0x2d,
  0x20, 0x52, 0x65, 0x76, 0x69, 0x73, 0x65, 0x64, 0x2c, 0x20, 0x34, 0x2f,
  0x35, 0x2f, 0x32, 0x30, 0x30, 0x34, 0x3a, 0x20, 0x20, 0x41, 0x64, 0x64,
  0x65, 0x64, 0x20, 0x70, 0x6c, 0x61, 0x79, 0x4f, 0x72, 0x64, 0x65, 0x72,
  0x20, 0x2d, 0x2d, 0x3e, 0x0d, 0x0a, 0x3c, 0x21, 0x41, 0x54, 0x54, 0x4c,
  0x49, 0x53, 0x54, 0x20, 0x6e, 0x61, 0x76, 0x50, 0x6f, 0x69, 0x6e, 0x74,
  0x0d, 0x0a, 0x20, 0x20, 0x69, 0x64, 0x20, 0x20, 0x20, 0x20, 0x49, 0x44,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x23, 0x52, 0x45, 0x51, 0x55, 0x49,
  0x52, 0x45, 0x44, 0x0d, 0x0a, 0x20, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73,
  0x20, 0x20, 0x20, 0x20, 0x43, 0x44, 0x41, 0x54, 0x41, 0x20, 0x20, 0x20,
  0x20, 0x23, 0x49, 0x4d, 0x50, 0x4c, 0x49, 0x45, 0x44, 0x0d, 0x0a, 0x20,
  0x20, 0x70, 0x6c, 0x61, 0x79, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x20, 0x43,
  0x44, 0x41, 0x54, 0x41, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x23,
  0x52, 0x45, 0x51, 0x55, 0x49, 0x52, 0x45, 0x44, 0x0d, 0x0a, 0x3e, 0x0d,
  0x0a, 0x0d, 0x0a, 0x3c, 0x21, 0x2d, 0x2d, 0x20, 0x52, 0x65, 0x76, 0x69,
  0x73, 0x65, 0x64, 0x2c, 0x20, 0x33, 0x2f, 0x33, 0x31, 0x2f, 0x32, 0x30,
  0x30, 0x34, 0x3a, 0x20, 0x20, 0x41, 0x64, 0x64, 0x65, 0x64, 0x20, 0x70,
  0x61, 0x67, 0x65, 0x4c, 0x69, 0x73, 0x74, 0x20, 0x65, 0x6c, 0x65, 0x6d,
  0x65, 0x6e, 0x74, 0x20, 0x2d, 0x2d, 0x3e, 0x0d, 0x0a, 0x3c, 0x21, 0x2d,
  0x2d, 0x20, 0x50, 0x61, 0x67, 0x65, 0x20, 0x4c, 0x69, 0x73, 0x74, 0x20,
  0x2d, 0x20, 0x20, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
  0x20, 0x66, 0x6f, 0x72, 0x20, 0x70, 0x61, 0x67, 0x69, 0x6e, 0x61, 0x74,
  0x69, 0x6f, 0x6e, 0x20, 0x69, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74,
  0x69, 0x6f, 0x6e, 0x2e, 0x0d, 0x0a, 0x20, 0x20, 0x2d, 0x2d, 0x3e, 0x0d,
  0x0a, 0x3c, 0x21, 0x45, 0x4c, 0x45, 0x4d, 0x45, 0x4e, 0x54, 0x20, 0x70,
  0x61, 0x67, 0x65, 0x4c, 0x69, 0x73, 0x74, 0x20, 0x28, 0x6e, 0x61, 0x76,
  0x49, 0x6e, 0x66, 0x6f, 0x2a, 0x2c, 0x20, 0x6e, 0x61, 0x76, 0x4c, 0x61,
  0x62, 0x65, 0x6c, 0x2a, 0x2c, 0x20, 0x70, 0x61, 0x67, 0x65, 0x54, 0x61,
  0x72, 0x67, 0x65, 0x74, 0x2b, 0x29, 0x3e, 0x0d, 0x0a, 0x3c, 0x21, 0x2d,
  0x2d, 0x20, 0x52, 0x65, 0x76, 0x69, 0x73, 0x65, 0x64, 0x2c, 0x20, 0x34,
  0x2f, 0x35, 0x2f, 0x32, 0x30, 0x30, 0x34, 0x3a, 0x20, 0x20, 0x41, 0x64,
  0x64, 0x65, 0x64, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x20, 0x61, 0x74,
  0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x20, 0x2d, 0x2d, 0x3e, 0x0d,
  0x0a, 0x3c, 0x21, 0x41, 0x54, 0x54, 0x4c, 0x49, 0x53, 0x54, 0x20, 0x70,
  0x61, 0x67, 0x65, 0x4c, 0x69, 0x73, 0x74, 0x0d, 0x0a, 0x20, 0x20, 0x20,
  0x69, 0x64, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x49, 0x44, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x23, 0x49, 0x4d,
  0x50, 0x4c, 0x49, 0x45, 0x44, 0x0d, 0x0a, 0x20, 0x20, 0x20, 0x63, 0x6c,
  0x61, 0x73, 0x73, 0x20, 0x20, 0x20, 0x20, 0x43, 0x44, 0x41, 0x54, 0x41,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x23, 0x49, 0x4d, 0x50, 0x4c,
  0x49, 0x45, 0x44, 0x0d, 0x0a, 0x3e, 0x0d, 0x0a, 0x0d, 0x0a, 0x3c, 0x21,
  0x2d, 0x2d, 0x20, 0x52, 0x65, 0x76, 0x69, 0x73, 0x65, 0x64, 0x2c, 0x20,
  0x33, 0x2f, 0x33, 0x31, 0x2f, 0x32, 0x30, 0x30, 0x34, 0x3a, 0x20, 0x20,
  0x41, 0x64, 0x64, 0x65, 0x64, 0x20, 0x70, 0x61, 0x67, 0x65, 0x54, 0x61,
  0x72, 0x67, 0x65, 0x74, 0x20, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74,
  0x20, 0x2d, 0x2d, 0x3e, 0x0d, 0x0a, 0x3c, 0x21, 0x2d, 0x2d, 0x20, 0x52,
  0x65, 0x76, 0x69, 0x73, 0x65, 0x64, 0x2c, 0x20, 0x34, 0x2f, 0x35, 0x2f,
  0x32, 0x30, 0x30, 0x34, 0x3a, 0x20, 0x20, 0x41, 0x64, 0x64, 0x65, 0x64,
  0x20, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
  0x20, 0x6f, 0x66, 0x20, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x61, 0x74,
  0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x20, 0x74, 0x6f, 0x20, 0x63,
  0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x20, 0x2d, 0x2d, 0x3e, 0x0d, 0x0a,
  0x3c, 0x21, 0x2d, 0x2d, 0x20, 0x50, 0x61, 0x67, 0x65, 0x20, 0x54, 0x61,
  0x72, 0x67, 0x65, 0x74, 0x20, 0x2d, 0x20, 0x20, 0x43, 0x6f, 0x6e, 0x74,
  0x61, 0x69, 0x6e, 0x65, 0x72, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x0d, 0x0a,
  0x20, 0x20, 0x74, 0x65, 0x78, 0x74, 0x2c, 0x20, 0x61, 0x75, 0x64, 0x69,
  0x6f, 0x2c, 0x20, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x2c, 0x20, 0x61, 0x6e,
  0x64, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x20, 0x65, 0x6c,
  0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x61,
  0x69, 0x6e, 0x69, 0x6e, 0x67, 0x20, 0x6e, 0x61, 0x76, 0x69, 0x67, 0x61,
  0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x20, 0x0d, 0x0a, 0x20, 0x20, 0x69,
  0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x66,
  0x6f, 0x72, 0x20, 0x70, 0x61, 0x67, 0x65, 0x73, 0x2e, 0x20, 0x20, 0x54,
  0x68, 0x65, 0x20, 0x22, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x20, 0x61,
  0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x20, 0x69, 0x73, 0x20,
  0x61, 0x20, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x20, 0x69,
  0x6e, 0x74, 0x65, 0x67, 0x65, 0x72, 0x20, 0x72, 0x65, 0x70, 0x72, 0x65,
  0x73, 0x65, 0x6e, 0x74, 0x69, 0x6e, 0x67, 0x20, 0x0d, 0x0a, 0x74, 0x68,
  0x65, 0x20, 0x6e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x20, 0x76, 0x61,
  0x6c, 0x75, 0x65, 0x20, 0x61, 0x73, 0x73, 0x6f, 0x63, 0x69, 0x61, 0x74,
  0x65, 0x64, 0x20, 0x77, 0x69, 0x74, 0x68, 0x20, 0x61, 0x20, 0x70, 0x61,
  0x67, 0x65, 0x2e, 0x20, 0x43, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x61, 0x74,
  0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x20, 0x76, 0x61, 0x6c, 0x75, 0x65,
  0x73, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x79, 0x70, 0x65, 0x20, 0x61, 0x6e,
  0x64, 0x20, 0x0d, 0x0a, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x61, 0x74,
  0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x20, 0x6d, 0x75, 0x73,
  0x74, 0x20, 0x62, 0x65, 0x20, 0x75, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x2c,
  0x20, 0x77, 0x68, 0x65, 0x6e, 0x20, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20,
  0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x20, 0x69, 0x73,
  0x20, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x2e, 0x20, 0x0d, 0x0a,
  0x2d, 0x2d, 0x3e, 0x0d, 0x0a, 0x3c, 0x21, 0x45, 0x4c, 0x45, 0x4d, 0x45,
  0x4e, 0x54, 0x20, 0x70, 0x61, 0x67, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65,
  0x74, 0x20, 0x28, 0x6e, 0x61, 0x76, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x2b,
  0x2c, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x29, 0x3e, 0x0d,
  0x0a, 0x3c, 0x21, 0x2d, 0x2d, 0x20, 0x52, 0x65, 0x76, 0x69, 0x73, 0x65,
  0x64, 0x2c, 0x20, 0x34, 0x2f, 0x35, 0x2f, 0x32, 0x30, 0x30, 0x34, 0x3a,
  0x20, 0x20, 0x41, 0x64, 0x64, 0x65, 0x64, 0x20, 0x63, 0x6c, 0x61, 0x73,
  0x73, 0x20, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x20,
  0x2d, 0x2d, 0x3e, 0x0d, 0x0a, 0x3c, 0x21, 0x2d, 0x2d, 0x20, 0x52, 0x65,
  0x76, 0x69, 0x73, 0x65, 0x64, 0x2c, 0x20, 0x34, 0x2f, 0x35, 0x2f, 0x32,
  0x30, 0x30, 0x34, 0x3a, 0x20, 0x20, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65,
  0x64, 0x20, 0x64, 0x65, 0x63, 0x6c, 0x61, 0x72, 0x61, 0x74, 0x69, 0x6f,
  0x6e, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x79, 0x70, 0x65, 0x20, 0x61, 0x74,
  0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x20, 0x74, 0x6f, 0x20, 0x65,
  0x6e, 0x75, 0x6d, 0x65, 0x72, 0x61, 0x74, 0x65, 0x20, 0x76, 0x61, 0x6c,
  0x75, 0x65, 0x73, 0x20, 0x2d, 0x2d, 0x3e, 0x0d, 0x0a, 0x3c, 0x21, 0x2d,
  0x2d, 0x20, 0x52, 0x65, 0x76, 0x69, 0x73, 0x65, 0x64, 0x2c, 0x20, 0x34,
  0x2f, 0x35, 0x2f, 0x32, 0x30, 0x30, 0x34, 0x3a, 0x20, 0x20, 0x41, 0x64,
  0x64, 0x65, 0x64, 0x20, 0x70, 0x6c, 0x61, 0x79, 0x4f, 0x72, 0x64, 0x65,
  0x72, 0x20, 0x2d, 0x2d, 0x3e, 0x0d, 0x0a, 0x3c, 0x21, 0x41, 0x54, 0x54,
  0x4c, 0x49, 0x53, 0x54, 0x20, 0x70, 0x61, 0x67, 0x65, 0x54, 0x61, 0x72,
  0x67, 0x65, 0x74, 0x0d, 0x0a, 0x20, 0x20, 0x20, 0x69, 0x64, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x49, 0x44, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x23, 0x49, 0x4d, 0x50, 0x4c, 0x49, 0x45,
  0x44, 0x0d, 0x0a, 0x20, 0x20, 0x20, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20,
  0x20, 0x20, 0x20, 0x43, 0x44, 0x41, 0x54, 0x41, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x23, 0x49, 0x4d, 0x50, 0x4c, 0x49, 0x45, 0x44, 0x0d,
  0x0a, 0x20, 0x20, 0x20, 0x74, 0x79, 0x70, 0x65, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x28, 0x66, 0x72, 0x6f, 0x6e, 0x74, 0x20, 0x7c, 0x20, 0x6e, 0x6f,
  0x72, 0x6d, 0x61, 0x6c, 0x20, 0x7c, 0x20, 0x73, 0x70, 0x65, 0x63, 0x69,
  0x61, 0x6c, 0x29, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x23, 0x52,
  0x45, 0x51, 0x55, 0x49, 0x52, 0x45, 0x44, 0x0d, 0x0a, 0x20, 0x20, 0x20,
  0x63, 0x6c, 0x61, 0x73, 0x73, 0x20, 0x20, 0x20, 0x20, 0x43, 0x44, 0x41,
  0x54, 0x41, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x23, 0x49, 0x4d,
  0x50, 0x4c, 0x49, 0x45, 0x44, 0x0d, 0x0a, 0x20, 0x20, 0x20, 0x70, 0x6c,
  0x61, 0x79, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x20, 0x43, 0x44, 0x41, 0x54,
  0x41, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x23, 0x52, 0x45, 0x51, 0x55,
  0x49, 0x52, 0x45, 0x44, 0x0d, 0x0a, 0x3e, 0x0d, 0x0a, 0x0d, 0x0a, 0x3c,
  0x21, 0x2d, 0x2d, 0x20, 0x4e, 0x61, 0x76, 0x69, 0x67, 0x61, 0x74, 0x69,
  0x6f, 0x6e, 0x20, 0x4c, 0x69, 0x73, 0x74, 0x20, 0x2d, 0x20, 0x63, 0x6f,
  0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x20, 0x66, 0x6f, 0x72, 0x20,
  0x64, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x63, 0x74, 0x2c, 0x20, 0x66, 0x6c,
  0x61, 0x74, 0x20, 0x73, 0x65, 0x74, 0x73, 0x20, 0x6f, 0x66, 0x20, 0x6e,
  0x61, 0x76, 0x69, 0x67, 0x61, 0x62, 0x6c, 0x65, 0x20, 0x65, 0x6c, 0x65,
  0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2c, 0x20, 0x65, 0x2e, 0x67, 0x2e, 0x20,
  0x20, 0x0d, 0x0a, 0x6e, 0x6f, 0x74, 0x65, 0x73, 0x2c, 0x20, 0x66, 0x69,
  0x67, 0x75, 0x72, 0x65, 0x73, 0x2c, 0x20, 0x74, 0x61, 0x62, 0x6c, 0x65,
  0x73, 0x2c, 0x20, 0x65, 0x74, 0x63, 0x2e, 0x20, 0x20, 0x45, 0x73, 0x73,
  0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x6c, 0x79, 0x20, 0x61, 0x20, 0x66,
  0x6c, 0x61, 0x74, 0x20, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x20,
  0x6f, 0x66, 0x20, 0x6e, 0x61, 0x76, 0x4d, 0x61, 0x70, 0x2e, 0x20, 0x20,
  0x54, 0x68, 0x65, 0x20, 0x22, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x22, 0x20,
  0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x20, 0x0d, 0x0a,
  0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x73, 0x20, 0x74, 0x68,
  0x65, 0x20, 0x74, 0x79, 0x70, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x6f, 0x62,
  0x6a, 0x65, 0x63, 0x74, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
  0x65, 0x64, 0x20, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x6e,
  0x61, 0x76, 0x4c, 0x69, 0x73, 0x74, 0x2c, 0x20, 0x75, 0x73, 0x69, 0x6e,
  0x67, 0x20, 0x64, 0x74, 0x62, 0x6f, 0x6f, 0x6b, 0x20, 0x65, 0x6c, 0x65,
  0x6d, 0x65, 0x6e, 0x74, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x2c, 0x20,
  0x65, 0x2e, 0x67, 0x2e, 0x2c, 0x20, 0x6e, 0x6f, 0x74, 0x65, 0x2e, 0x0d,
  0x0a, 0x2d, 0x2d, 0x3e, 0x0d, 0x0a, 0x0d, 0x0a, 0x3c, 0x21, 0x2d, 0x2d,
  0x20, 0x52, 0x65, 0x76, 0x69, 0x73, 0x65, 0x64, 0x2c, 0x20, 0x33, 0x2f,
  0x33, 0x31, 0x2f, 0x32, 0x30, 0x30, 0x34, 0x3a, 0x20, 0x20, 0x41, 0x64,
  0x64, 0x65, 0x64, 0x20, 0x6e, 0x61, 0x76, 0x49, 0x6e, 0x66, 0x6f, 0x20,
  0x74, 0x6f, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x20, 0x6d,
  0x6f, 0x64, 0x65, 0x6c, 0x20, 0x2d, 0x2d, 0x3e, 0x0d, 0x0a, 0x3c, 0x21,
  0x45, 0x4c, 0x45, 0x4d, 0x45, 0x4e, 0x54, 0x20, 0x6e, 0x61, 0x76, 0x4c,
  0x69, 0x73, 0x74, 0x20, 0x20, 0x20, 0x28, 0x6e, 0x61, 0x76, 0x49, 0x6e,
  0x66, 0x6f, 0x2a, 0x2c, 0x20, 0x6e, 0x61, 0x76, 0x4c, 0x61, 0x62, 0x65,
  0x6c, 0x2b, 0x2c, 0x20, 0x6e, 0x61, 0x76, 0x54, 0x61, 0x72, 0x67, 0x65,
  0x74, 0x2b, 0x29, 0x20, 0x3e, 0x0d, 0x0a, 0x3c, 0x21, 0x41, 0x54, 0x54,
  0x4c, 0x49, 0x53, 0x54, 0x20, 0x6e, 0x61, 0x76, 0x4c, 0x69, 0x73, 0x74,
  0x0d, 0x0a, 0x20, 0x20, 0x69, 0x64, 0x20, 0x20, 0x20, 0x20, 0x49, 0x44,
  0x20, 0x20, 0x20, 0x20, 0x23, 0x49, 0x4d, 0x50, 0x4c, 0x49, 0x45, 0x44,
  0x0d, 0x0a, 0x20, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x20, 0x20, 0x20,
  0x20, 0x43, 0x44, 0x41, 0x54, 0x41, 0x20, 0x20, 0x20, 0x20, 0x23, 0x49,
  0x4d, 0x50, 0x4c, 0x49, 0x45, 0x44, 0x0d, 0x0a, 0x3e, 0x0d, 0x0a, 0x0d,
  0x0a, 0x3c, 0x21, 0x2d, 0x2d, 0x20, 0x52, 0x65, 0x76, 0x69, 0x73, 0x65,
  0x64, 0x2c, 0x20, 0x34, 0x2f, 0x35, 0x2f, 0x32, 0x30, 0x30, 0x34, 0x3a,
  0x20, 0x20, 0x41, 0x64, 0x64, 0x65, 0x64, 0x20, 0x64, 0x65, 0x73, 0x63,
  0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x20, 0x76,
  0x61, 0x6c, 0x75, 0x65, 0x20, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
  0x74, 0x65, 0x20, 0x74, 0x6f, 0x20, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e,
  0x74, 0x20, 0x2d, 0x2d, 0x3e, 0x0d, 0x0a, 0x3c, 0x21, 0x2d, 0x2d, 0x20,
  0x4e, 0x61, 0x76, 0x69, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x54,
  0x61, 0x72, 0x67, 0x65, 0x74, 0x20, 0x2d, 0x20, 0x63, 0x6f, 0x6e, 0x74,
  0x61, 0x69, 0x6e, 0x73, 0x20, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
  0x74, 0x69, 0x6f, 0x6e, 0x28, 0x73, 0x29, 0x20, 0x6f, 0x66, 0x20, 0x74,
  0x61, 0x72, 0x67, 0x65, 0x74, 0x2c, 0x20, 0x61, 0x73, 0x20, 0x77, 0x65,
  0x6c, 0x6c, 0x20, 0x61, 0x73, 0x20, 0x61, 0x20, 0x70, 0x6f, 0x69, 0x6e,
  0x74, 0x65, 0x72, 0x20, 0x74, 0x6f, 0x20, 0x0d, 0x0a, 0x65, 0x6e, 0x74,
  0x69, 0x72, 0x65, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x20,
  0x6f, 0x66, 0x20, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x2e, 0x0d, 0x0a,
  0x6e, 0x61, 0x76, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x20, 0x61,
  0x72, 0x65, 0x20, 0x74, 0x68, 0x65, 0x20, 0x65, 0x71, 0x75, 0x69, 0x76,
  0x61, 0x6c, 0x65, 0x6e, 0x74, 0x20, 0x6f, 0x66, 0x20, 0x6e, 0x61, 0x76,
  0x50, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x75,
  0x73, 0x65, 0x20, 0x69, 0x6e, 0x20, 0x6e, 0x61, 0x76, 0x4c, 0x69, 0x73,
  0x74, 0x73, 0x2e, 0x20, 0x20, 0x22, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x22,
  0x20, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x20, 0x0d,
  0x0a, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x73, 0x20, 0x74,
  0x68, 0x65, 0x20, 0x6b, 0x69, 0x6e, 0x64, 0x20, 0x6f, 0x66, 0x20, 0x73,
  0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x20, 0x74, 0x68, 0x69,
  0x73, 0x20, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x20, 0x72, 0x65, 0x70,
  0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x73, 0x2c, 0x20, 0x75, 0x73, 0x69,
  0x6e, 0x67, 0x20, 0x69, 0x74, 0x73, 0x20, 0x64, 0x74, 0x62, 0x6f, 0x6f,
  0x6b, 0x20, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x20, 0x0d, 0x0a,
  0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x20, 0x65, 0x2e, 0x67, 0x2e, 0x2c, 0x20,
  0x6e, 0x6f, 0x74, 0x65, 0x2e, 0x20, 0x20, 0x54, 0x68, 0x65, 0x20, 0x22,
  0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x20, 0x61, 0x74, 0x74, 0x72, 0x69,
  0x62, 0x75, 0x74, 0x65, 0x20, 0x69, 0x73, 0x20, 0x61, 0x20, 0x70, 0x6f,
  0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x20, 0x69, 0x6e, 0x74, 0x65, 0x67,
  0x65, 0x72, 0x20, 0x72, 0x65, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74,
  0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x65, 0x20, 0x0d, 0x0a, 0x6e, 0x75,
  0x6d, 0x65, 0x72, 0x69, 0x63, 0x20, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20,
  0x61, 0x73, 0x73, 0x6f, 0x63, 0x69, 0x61, 0x74, 0x65, 0x64, 0x20, 0x77,
  0x69, 0x74, 0x68, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6e, 0x61, 0x76, 0x54,
  0x61, 0x72, 0x67, 0x65, 0x74, 0x2e, 0x0d, 0x0a, 0x2d, 0x2d, 0x3e, 0x0d,
  0x0a, 0x0d, 0x0a, 0x3c, 0x21, 0x45, 0x4c, 0x45, 0x4d, 0x45, 0x4e, 0x54,
  0x20, 0x6e, 0x61, 0x76, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x20, 0x20,
  0x28, 0x6e, 0x61, 0x76, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x2b, 0x2c, 0x20,
  0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x29, 0x20, 0x3e, 0x0d, 0x0a,
  0x3c, 0x21, 0x2d, 0x2d, 0x20, 0x52, 0x65, 0x76, 0x69, 0x73, 0x65, 0x64,
  0x2c, 0x20, 0x33, 0x2f, 0x32, 0x39, 0x2f, 0x32, 0x30, 0x30, 0x34, 0x3a,
  0x20, 0x20, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x64, 0x20, 0x6f, 0x6e,
  0x46, 0x6f, 0x63, 0x75, 0x73, 0x2f, 0x6f, 0x6e, 0x42, 0x6c, 0x75, 0x72,
  0x20, 0x2d, 0x2d, 0x3e, 0x0d, 0x0a, 0x3c, 0x21, 0x2d, 0x2d, 0x20, 0x52,
  0x65, 0x76, 0x69, 0x73, 0x65, 0x64, 0x2c, 0x20, 0x33, 0x2f, 0x33, 0x31,
  0x2f, 0x32, 0x30, 0x30, 0x34, 0x3a, 0x20, 0x20, 0x52, 0x65, 0x6d, 0x6f,
  0x76, 0x65, 0x64, 0x20, 0x6d, 0x61, 0x70, 0x52, 0x65, 0x66, 0x20, 0x2d,
  0x2d, 0x3e, 0x0d, 0x0a, 0x3c, 0x21, 0x2d, 0x2d, 0x20, 0x52, 0x65, 0x76,
  0x69, 0x73, 0x65, 0x64, 0x2c, 0x20, 0x34, 0x2f, 0x35, 0x2f, 0x32, 0x30,
  0x30, 0x34, 0x3a, 0x20, 0x20, 0x41, 0x64, 0x64, 0x65, 0x64, 0x20, 0x70,
  0x6c, 0x61, 0x79, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x20, 0x2d, 0x2d, 0x3e,
  0x0d, 0x0a, 0x3c, 0x21, 0x41, 0x54, 0x54, 0x4c, 0x49, 0x53, 0x54, 0x20,
  0x6e, 0x61, 0x76, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x0d, 0x0a, 0x20,
  0x20, 0x69, 0x64, 0x20, 0x20, 0x20, 0x20, 0x49, 0x44, 0x20, 0x20, 0x20,
  0x20, 0x23, 0x52, 0x45, 0x51, 0x55, 0x49, 0x52, 0x45, 0x44, 0x0d, 0x0a,
  0x20, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x20, 0x20, 0x20, 0x20, 0x43,
  0x44, 0x41, 0x54, 0x41, 0x20, 0x20, 0x20, 0x20, 0x23, 0x49, 0x4d, 0x50,
  0x4c, 0x49, 0x45, 0x44, 0x0d, 0x0a, 0x20, 0x20, 0x76, 0x61, 0x6c, 0x75,
  0x65, 0x20, 0x20, 0x20, 0x20, 0x43, 0x44, 0x41, 0x54, 0x41, 0x20, 0x20,
  0x20, 0x20, 0x23, 0x49, 0x4d, 0x50, 0x4c, 0x49, 0x45, 0x44, 0x0d, 0x0a,
  0x20, 0x20, 0x70, 0x6c, 0x61, 0x79, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x20,
  0x43, 0x44, 0x41, 0x54, 0x41, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x23, 0x52, 0x45, 0x51, 0x55, 0x49, 0x52, 0x45, 0x44, 0x0d, 0x0a, 0x3e,
  0x0d, 0x0a, 0x0d, 0x0a, 0x0d, 0x0a, 0x3c, 0x21, 0x2d, 0x2d, 0x20, 0x52,
  0x65, 0x76, 0x69, 0x73, 0x65, 0x64, 0x2c, 0x20, 0x33, 0x2f, 0x33, 0x31,
  0x2f, 0x32, 0x30, 0x30, 0x34, 0x3a, 0x20, 0x20, 0x41, 0x64, 0x64, 0x65,
  0x64, 0x20, 0x6e, 0x61, 0x76, 0x49, 0x6e, 0x66, 0x6f, 0x20, 0x65, 0x6c,
  0x65, 0x6d, 0x65, 0x6e, 0x74, 0x20, 0x2d, 0x2d, 0x3e, 0x0d, 0x0a, 0x3c,
  0x21, 0x2d, 0x2d, 0x20, 0x4e, 0x61, 0x76, 0x69, 0x67, 0x61, 0x74, 0x69,
  0x6f, 0x6e, 0x20, 0x49, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69,
  0x6f, 0x6e, 0x20, 0x2d, 0x20, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
  0x73, 0x20, 0x61, 0x6e, 0x20, 0x69, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61,
  0x74, 0x69, 0x76, 0x65, 0x20, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74,
  0x0d, 0x0a, 0x20, 0x20, 0x61, 0x62, 0x6f, 0x75, 0x74, 0x20, 0x61, 0x20,
  0x6e, 0x61, 0x76, 0x4d, 0x61, 0x70, 0x2c, 0x20, 0x70, 0x61, 0x67, 0x65,
  0x4c, 0x69, 0x73, 0x74, 0x2c, 0x20, 0x6f, 0x72, 0x20, 0x6e, 0x61, 0x76,
  0x4c, 0x69, 0x73, 0x74, 0x20, 0x69, 0x6e, 0x20, 0x76, 0x61, 0x72, 0x69,
  0x6f, 0x75, 0x73, 0x20, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x20, 0x66, 0x6f,
  0x72, 0x20, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69,
  0x6f, 0x6e, 0x20, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x20, 0x75, 0x73,
  0x65, 0x72, 0x2e, 0x0d, 0x0a, 0x2d, 0x2d, 0x3e, 0x0d, 0x0a, 0x3c, 0x21,
  0x45, 0x4c, 0x45, 0x4d, 0x45, 0x4e, 0x54, 0x20, 0x6e, 0x61, 0x76, 0x49,
  0x6e, 0x66, 0x6f, 0x20, 0x28, 0x28, 0x28, 0x74, 0x65, 0x78, 0x74, 0x2c,
  0x20, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x3f, 0x29, 0x20, 0x7c, 0x20, 0x61,
  0x75, 0x64, 0x69, 0x6f, 0x29, 0x2c, 0x20, 0x69, 0x6d, 0x67, 0x3f, 0x29,
  0x3e, 0x0d, 0x0a, 0x3c, 0x21, 0x41, 0x54, 0x54, 0x4c, 0x49, 0x53, 0x54,
  0x20, 0x6e, 0x61, 0x76, 0x49, 0x6e, 0x66, 0x6f, 0x0d, 0x0a, 0x20, 0x20,
  0x25, 0x69, 0x31, 0x38, 0x6e, 0x3b, 0x20, 0x0d, 0x0a, 0x3e, 0x0d, 0x0a,
  0x0d, 0x0a, 0x0d, 0x0a, 0x3c, 0x21, 0x2d, 0x2d, 0x20, 0x4e, 0x61, 0x76,
  0x69, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x4c, 0x61, 0x62, 0x65,
  0x6c, 0x20, 0x2d, 0x20, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x73,
  0x20, 0x61, 0x20, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
  0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x20, 0x61, 0x20, 0x67, 0x69, 0x76, 0x65,
  0x6e, 0x20, 0x3c, 0x6e, 0x61, 0x76, 0x4d, 0x61, 0x70, 0x3e, 0x2c, 0x20,
  0x3c, 0x6e, 0x61, 0x76, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x3e, 0x2c, 0x20,
  0x0d, 0x0a, 0x3c, 0x6e, 0x61, 0x76, 0x4c, 0x69, 0x73, 0x74, 0x3e, 0x2c,
  0x20, 0x6f, 0x72, 0x20, 0x3c, 0x6e, 0x61, 0x76, 0x54, 0x61, 0x72, 0x67,
  0x65, 0x74, 0x3e, 0x20, 0x69, 0x6e, 0x20, 0x76, 0x61, 0x72, 0x69, 0x6f,
  0x75, 0x73, 0x20, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x20, 0x66, 0x6f, 0x72,
  0x20, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f,
  0x6e, 0x20, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x20, 0x75, 0x73, 0x65,
  0x72, 0x2e, 0x20, 0x43, 0x61, 0x6e, 0x20, 0x62, 0x65, 0x20, 0x0d, 0x0a,
  0x72, 0x65, 0x70, 0x65, 0x61, 0x74, 0x65, 0x64, 0x20, 0x73, 0x6f, 0x20,
  0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
  0x20, 0x63, 0x61, 0x6e, 0x20, 0x62, 0x65, 0x20, 0x70, 0x72, 0x6f, 0x76,
  0x69, 0x64, 0x65, 0x64, 0x20, 0x69, 0x6e, 0x20, 0x6d, 0x75, 0x6c, 0x74,
  0x69, 0x70, 0x6c, 0x65, 0x20, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
  0x65, 0x73, 0x2e, 0x20, 0x2d, 0x2d, 0x3e, 0x0d, 0x0a, 0x3c, 0x21, 0x45,
  0x4c, 0x45, 0x4d, 0x45, 0x4e, 0x54, 0x20, 0x6e, 0x61, 0x76, 0x4c, 0x61,
  0x62, 0x65, 0x6c, 0x20, 0x28, 0x28, 0x28, 0x74, 0x65, 0x78, 0x74, 0x2c,
  0x20, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x3f, 0x29, 0x20, 0x7c, 0x20, 0x61,
  0x75, 0x64, 0x69, 0x6f, 0x29, 0x2c, 0x20, 0x69, 0x6d, 0x67, 0x3f, 0x29,
  0x3e, 0x0d, 0x0a, 0x3c, 0x21, 0x41, 0x54, 0x54, 0x4c, 0x49, 0x53, 0x54,
  0x20, 0x6e, 0x61, 0x76, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x0d, 0x0a, 0x20,
  0x20, 0x25, 0x69, 0x31, 0x38, 0x6e, 0x3b, 0x20, 0x0d, 0x0a, 0x3e, 0x0d,
  0x0a, 0x0d, 0x0a, 0x0d, 0x0a, 0x3c, 0x21, 0x2d, 0x2d, 0x20, 0x43, 0x6f,
  0x6e, 0x74, 0x65, 0x6e, 0x74, 0x20, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e,
  0x74, 0x20, 0x2d, 0x20, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x20,
  0x69, 0x6e, 0x74, 0x6f, 0x20, 0x53, 0x4d, 0x49, 0x4c, 0x20, 0x74, 0x6f,
  0x20, 0x62, 0x65, 0x67, 0x69, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x20, 0x6f,
  0x66, 0x20, 0x6e, 0x61, 0x76, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x20,
  0x2d, 0x2d, 0x3e, 0x0d, 0x0a, 0x3c, 0x21, 0x45, 0x4c, 0x45, 0x4d, 0x45,
  0x4e, 0x54, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x20, 0x45,
  0x4d, 0x50, 0x54, 0x59, 0x3e, 0x0d, 0x0a, 0x3c, 0x21, 0x41, 0x54, 0x54,
  0x4c, 0x49, 0x53, 0x54, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
  0x0d, 0x0a, 0x20, 0x20, 0x69, 0x64, 0x20, 0x20, 0x20, 0x20, 0x49, 0x44,
  0x20, 0x20, 0x20, 0x20, 0x23, 0x49, 0x4d, 0x50, 0x4c, 0x49, 0x45, 0x44,
  0x0d, 0x0a, 0x20, 0x20, 0x73, 0x72, 0x63, 0x20, 0x20, 0x20, 0x20, 0x25,
  0x55, 0x52, 0x49, 0x3b, 0x20, 0x20, 0x20, 0x20, 0x23, 0x52, 0x45, 0x51,
  0x55, 0x49, 0x52, 0x45, 0x44, 0x0d, 0x0a, 0x3e, 0x0d, 0x0a, 0x0d, 0x0a,
  0x3c, 0x21, 0x2d, 0x2d, 0x20, 0x54, 0x65, 0x78, 0x74, 0x20, 0x45, 0x6c,
  0x65, 0x6d, 0x65, 0x6e, 0x74, 0x20, 0x2d, 0x20, 0x43, 0x6f, 0x6e, 0x74,
  0x61, 0x69, 0x6e, 0x73, 0x20, 0x74, 0x65, 0x78, 0x74, 0x20, 0x6f, 0x66,
  0x20, 0x64, 0x6f, 0x63, 0x54, 0x69, 0x74, 0x6c, 0x65, 0x2c, 0x20, 0x6e,
  0x61, 0x76, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x20, 0x68, 0x65, 0x61, 0x64,
  0x69, 0x6e, 0x67, 0x2c, 0x20, 0x6e, 0x61, 0x76, 0x54, 0x61, 0x72, 0x67,
  0x65, 0x74, 0x20, 0x28, 0x65, 0x2e, 0x67, 0x2e, 0x2c, 0x20, 0x70, 0x61,
  0x67, 0x65, 0x20, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x29, 0x2c, 0x20,
  0x0d, 0x0a, 0x6f, 0x72, 0x20, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x20, 0x66,
  0x6f, 0x72, 0x20, 0x6e, 0x61, 0x76, 0x4d, 0x61, 0x70, 0x20, 0x6f, 0x72,
  0x20, 0x6e, 0x61, 0x76, 0x4c, 0x69, 0x73, 0x74, 0x2e, 0x20, 0x2d, 0x2d,
  0x3e, 0x0d, 0x0a, 0x3c, 0x21, 0x45, 0x4c, 0x45, 0x4d, 0x45, 0x4e, 0x54,
  0x20, 0x74, 0x65, 0x78, 0x74, 0x20, 0x28, 0x23, 0x50, 0x43, 0x44, 0x41,
  0x54, 0x41, 0x29, 0x3e, 0x0d, 0x0a, 0x3c, 0x21, 0x41, 0x54, 0x54, 0x4c,
  0x49, 0x53, 0x54, 0x20, 0x74, 0x65, 0x78, 0x74, 0x0d, 0x0a, 0x20, 0x20,
  0x69, 0x64, 0x20, 0x20, 0x20, 0x20, 0x49, 0x44, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x23, 0x49, 0x4d, 0x50, 0x4c, 0x49, 0x45, 0x44,
  0x0d, 0x0a, 0x20, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x20, 0x20, 0x43,
  0x44, 0x41, 0x54, 0x41, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x23, 0x49,
  0x4d, 0x50, 0x4c, 0x49, 0x45, 0x44, 0x0d, 0x0a, 0x3e, 0x0d, 0x0a, 0x0d,
  0x0a, 0x3c, 0x21, 0x2d, 0x2d, 0x20, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x20,
  0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x20, 0x2d, 0x20, 0x61, 0x75,
  0x64, 0x69, 0x6f, 0x20, 0x63, 0x6c, 0x69, 0x70, 0x20, 0x6f, 0x66, 0x20,
  0x6e, 0x61, 0x76, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x20, 0x68, 0x65, 0x61,
  0x64, 0x69, 0x6e, 0x67, 0x2e, 0x20, 0x2d, 0x2d, 0x3e, 0x0d, 0x0a, 0x3c,
  0x21, 0x45, 0x4c, 0x45, 0x4d, 0x45, 0x4e, 0x54, 0x20, 0x61, 0x75, 0x64,
  0x69, 0x6f, 0x20, 0x45, 0x4d, 0x50, 0x54, 0x59, 0x3e, 0x0d, 0x0a, 0x3c,
  0x21, 0x2d, 0x2d, 0x20, 0x52, 0x65, 0x76, 0x69, 0x73, 0x65, 0x64, 0x2c,
  0x20, 0x33, 0x2f, 0x32, 0x39, 0x2f, 0x32, 0x30, 0x30, 0x34, 0x3a, 0x20,
  0x20, 0x63, 0x6c, 0x69, 0x70, 0x42, 0x65, 0x67, 0x69, 0x6e, 0x2f, 0x63,
  0x6c, 0x69, 0x70, 0x45, 0x6e, 0x64, 0x20, 0x6e, 0x6f, 0x77, 0x20, 0x52,
  0x45, 0x51, 0x55, 0x49, 0x52, 0x45, 0x44, 0x20, 0x2d, 0x2d, 0x3e, 0x0d,
  0x0a, 0x3c, 0x21, 0x41, 0x54, 0x54, 0x4c, 0x49, 0x53, 0x54, 0x20, 0x61,
  0x75, 0x64, 0x69, 0x6f, 0x0d, 0x0a, 0x20, 0x20, 0x69, 0x64, 0x20, 0x20,
  0x20, 0x20, 0x49, 0x44, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x23, 0x49, 0x4d, 0x50, 0x4c, 0x49, 0x45, 0x44, 0x0d, 0x0a, 0x20, 0x20,
  0x63, 0x6c, 0x61, 0x73, 0x73, 0x20, 0x20, 0x43, 0x44, 0x41, 0x54, 0x41,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x23, 0x49, 0x4d, 0x50, 0x4c, 0x49,
  0x45, 0x44, 0x0d, 0x0a, 0x20, 0x20, 0x73, 0x72, 0x63, 0x20, 0x20, 0x20,
  0x20, 0x25, 0x55, 0x52, 0x49, 0x3b, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x23, 0x52, 0x45, 0x51, 0x55, 0x49, 0x52, 0x45, 0x44, 0x0d, 0x0a, 0x20,
  0x20, 0x63, 0x6c, 0x69, 0x70, 0x42, 0x65, 0x67, 0x69, 0x6e, 0x20, 0x25,
  0x53, 0x4d, 0x49, 0x4c, 0x74, 0x69, 0x6d, 0x65, 0x56, 0x61, 0x6c, 0x3b,
  0x20, 0x20, 0x23, 0x52, 0x45, 0x51, 0x55, 0x49, 0x52, 0x45, 0x44, 0x0d,
  0x0a, 0x20, 0x20, 0x63, 0x6c, 0x69, 0x70, 0x45, 0x6e, 0x64, 0x20, 0x20,
  0x25, 0x53, 0x4d, 0x49, 0x4c, 0x74, 0x69, 0x6d, 0x65, 0x56, 0x61, 0x6c,
  0x3b, 0x20, 0x20, 0x23, 0x52, 0x45, 0x51, 0x55, 0x49, 0x52, 0x45, 0x44,
  0x0d, 0x0a, 0x3e, 0x0d, 0x0a, 0x0d, 0x0a, 0x3c, 0x21, 0x2d, 0x2d, 0x20,
  0x49, 0x6d, 0x61, 0x67, 0x65, 0x20, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e,
  0x74, 0x20, 0x2d, 0x20, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x20, 0x74, 0x68,
  0x61, 0x74, 0x20, 0x6d, 0x61, 0x79, 0x20, 0x61, 0x63, 0x63, 0x6f, 0x6d,
  0x70, 0x61, 0x6e, 0x79, 0x20, 0x68, 0x65, 0x61, 0x64, 0x69, 0x6e, 0x67,
  0x2e, 0x20, 0x2d, 0x2d, 0x3e, 0x0d, 0x0a, 0x3c, 0x21, 0x45, 0x4c, 0x45,
  0x4d, 0x45, 0x4e, 0x54, 0x20, 0x69, 0x6d, 0x67, 0x20, 0x45, 0x4d, 0x50,
  0x54, 0x59, 0x3e, 0x0d, 0x0a, 0x3c, 0x21, 0x41, 0x54, 0x54, 0x4c, 0x49,
  0x53, 0x54, 0x20, 0x69, 0x6d, 0x67, 0x0d, 0x0a, 0x20, 0x20, 0x69, 0x64,
  0x20, 0x20, 0x20, 0x20, 0x49, 0x44, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x23, 0x49, 0x4d, 0x50, 0x4c, 0x49, 0x45, 0x44, 0x0d, 0x0a, 0x20, 0x20,
  0x63, 0x6c, 0x61, 0x73, 0x73, 0x20, 0x20, 0x43, 0x44, 0x41, 0x54, 0x41,
  0x20, 0x20, 0x20, 0x20, 0x23, 0x49, 0x4d, 0x50, 0x4c, 0x49, 0x45, 0x44,
  0x0d, 0x0a, 0x20, 0x20, 0x73, 0x72, 0x63, 0x20, 0x20, 0x20, 0x20, 0x25,
  0x55, 0x52, 0x49, 0x3b, 0x20, 0x20, 0x20, 0x20, 0x23, 0x52, 0x45, 0x51,
  0x55, 0x49, 0x52, 0x45, 0x44, 0x0d, 0x0a, 0x3e, 0x0d, 0x0a
};

} //namespace FlightCrew
