/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2009 Christian Schallhart <christian@schallhart.net>,
 *                    Michael Tautschnig <tautschnig@forsyte.de>
 *               2008 model.in.tum.de group, FORSYTE group
 *               2006-2007 model.in.tum.de group
 *               2002-2005 Christian Schallhart
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/util/dummy_test_suite_traversal.ts.hpp
 *
 * $Id$
 *
 * @author Christian Schallhart
 *
 * @brief [LEVEL: beta] @ref ::diagnostics::unittest::testing::Dummy_Test_Suite_Traversal
 *
 * @test none
 */


#ifndef DIAGNOSTICS__UTIL__DUMMY_TEST_SUITE_TS_HPP__INCLUDE_GUARD
#define DIAGNOSTICS__UTIL__DUMMY_TEST_SUITE_TS_HPP__INCLUDE_GUARD

#include <diagnostics/unittest.hpp>

#include <diagnostics/unittest/test_system/test_suite_traversal.hpp>

#include <iostream>

DIAGNOSTICS_NAMESPACE_BEGIN;
UNITTEST_NAMESPACE_BEGIN;
TEST_NAMESPACE_BEGIN;

class Dummy_Test_Suite_Traversal :
    public ::diagnostics::unittest::Test_Suite_Traversal
{
    typedef ::diagnostics::unittest::Test_Suite_Traversal Super;

    typedef ::diagnostics::unittest::Test_Suite Test_Suite;
    typedef ::diagnostics::unittest::Test_Case Test_Case;
    typedef ::diagnostics::Level_t Level_t;
public:
    Dummy_Test_Suite_Traversal(::std::ostream & stream);
    
    void traverse(Test_Suite const & test_suite,
		  ::std::string mask,
		  Level_t const level);

protected:
    virtual void enter_hook(Test_Suite const & test_suite,
			    ::std::string const & mask,
			    Level_t const level);

    virtual void exit_hook(Test_Suite const & test_suite,
			   ::std::string const & mask,
			   Level_t const level,
			   bool const exception_going_through);

    virtual void visit_hook(Test_Suite const & test_suite,
			    Path_t const & path,
			    Level_t const level);

    virtual void leave_hook(Test_Suite const & test_suite,
			    Path_t const & path,
			    Level_t const level);

    virtual void visit_hook(Test_Case const & test_case,
			    Path_t const & path,
			    Level_t const level);

private:
    ::std::ostream & m_stream;
    int m_indent;
};



TEST_NAMESPACE_END;
UNITTEST_NAMESPACE_END;
DIAGNOSTICS_NAMESPACE_END;


#endif
// vim:ts=4:sw=4
