#!/bin/bash

usage(){
echo "
Written by Brian Bushnell
Last modified May 15, 2018

Description:  Cuts out sequences between primers identified in sam files.
Intended for use with sam files generated by msa.sh; one sam file for the
forward primer, and one for the reverse primer.

Usage:	cutprimers.sh in=<file> out=<file> sam1=<file> sam2=<file>

Parameters:

in=<file>       File containing reads. in=stdin.fa will pipe from stdin.
out=<file>      Output sequences. out=stdout will pipe to stdout.
sam1=<file>     Sam file containing mapped locations of primer sequence 1.
sam2=<file>     Sam file containing mapped locations of primer sequence 2.
fake=t          Output 1bp 'N' reads in cases where there is no primer.
include=f       Include the flanking primer sequences in output.

Java Parameters:

-Xmx            This will set Java's memory usage, overriding automatic
                memory detection. -Xmx20g will specify 
                20 gigs of RAM, and -Xmx200m will specify 200 megs.  
                The max is typically 85% of physical memory.
-eoom           This flag will cause the process to exit if an out-of-memory
                exception occurs.  Requires Java 8u92+.
-da             Disable assertions.

Please contact Brian Bushnell at bbushnell@lbl.gov if you encounter any problems.
"
}

#This block allows symlinked shellscripts to correctly set classpath.
pushd . > /dev/null
DIR="${BASH_SOURCE[0]}"
while [ -h "$DIR" ]; do
  cd "$(dirname "$DIR")"
  DIR="$(readlink "$(basename "$DIR")")"
done
cd "$(dirname "$DIR")"
DIR="$(pwd)/"
popd > /dev/null

#DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )/"
CP="$DIR""current/"

z="-Xmx1g"
z2="-Xms1g"
set=0

if [ -z "$1" ] || [[ $1 == -h ]] || [[ $1 == --help ]]; then
	usage
	exit
fi

calcXmx () {
	source "$DIR""/calcmem.sh"
	setEnvironment
	parseXmx "$@"
	if [[ $set == 1 ]]; then
		return
	fi
	freeRam 2000m 42
	z="-Xmx${RAM}m"
	z2="-Xms${RAM}m"
}
calcXmx "$@"

cutprimers() {
	local CMD="java $EA $EOOM $z -cp $CP jgi.CutPrimers $@"
	echo $CMD >&2
	eval $CMD
}

cutprimers "$@"
